/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.instruct;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.PackageData;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.Actor;
import net.sf.saxon.expr.instruct.GlobalContextRequirement;
import net.sf.saxon.expr.instruct.GlobalParam;
import net.sf.saxon.expr.instruct.GlobalParameterSet;
import net.sf.saxon.expr.instruct.GlobalVariable;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.functions.FunctionLibraryList;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.query.QueryModule;
import net.sf.saxon.serialize.CharacterMapIndex;
import net.sf.saxon.serialize.SerializationProperties;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;

public class Executable {
    private Configuration a;
    private PackageData b;
    private List<PackageData> c = new ArrayList<PackageData>();
    private Properties d;
    private CharacterMapIndex e;
    private HashMap<String, List<QueryModule>> f;
    private HashSet<String> g;
    private FunctionLibraryList h;
    private int i = 50;
    private Map<StructuredQName, GlobalParam> j = new HashMap<StructuredQName, GlobalParam>();
    private HashMap<StructuredQName, Properties> k = null;
    private boolean l = false;
    protected boolean schemaAware = false;
    private GlobalContextRequirement m = null;

    public Executable(Configuration configuration) {
        this.setConfiguration(configuration);
    }

    public void setConfiguration(Configuration configuration) {
        this.a = configuration;
    }

    public Configuration getConfiguration() {
        return this.a;
    }

    public PackageData getTopLevelPackage() {
        return this.b;
    }

    public void setTopLevelPackage(PackageData packageData) {
        this.b = packageData;
    }

    public void addPackage(PackageData packageData) {
        this.c.add(packageData);
    }

    public Iterable<PackageData> getPackages() {
        return this.c;
    }

    public void setHostLanguage(int n2) {
        this.i = n2;
    }

    public int getHostLanguage() {
        return this.i;
    }

    public FunctionLibraryList getFunctionLibrary() {
        return this.h;
    }

    public void setFunctionLibrary(FunctionLibraryList functionLibraryList) {
        this.h = functionLibraryList;
    }

    public void setCharacterMapIndex(CharacterMapIndex characterMapIndex) {
        this.e = characterMapIndex;
    }

    public CharacterMapIndex getCharacterMapIndex() {
        if (this.e == null) {
            this.e = new CharacterMapIndex();
        }
        return this.e;
    }

    public void setDefaultOutputProperties(Properties properties) {
        this.d = properties;
    }

    public SerializationProperties getPrimarySerializationProperties() {
        if (this.d == null) {
            this.d = new Properties();
        }
        Properties properties = this.d;
        return new SerializationProperties(properties, this.getCharacterMapIndex());
    }

    public void setOutputProperties(StructuredQName structuredQName, Properties properties) {
        if (this.k == null) {
            this.k = new HashMap(5);
        }
        this.k.put(structuredQName, properties);
    }

    public Properties getOutputProperties() {
        return new Properties(this.d);
    }

    public Properties getOutputProperties(StructuredQName structuredQName) {
        if (this.k == null) {
            return null;
        }
        return this.k.get(structuredQName);
    }

    public void addQueryLibraryModule(QueryModule queryModule) {
        String string;
        List<QueryModule> list;
        if (this.f == null) {
            this.f = new HashMap(5);
        }
        if ((list = this.f.get(string = queryModule.getModuleNamespace())) == null) {
            list = new ArrayList<QueryModule>(5);
            list.add(queryModule);
            this.f.put(string, list);
            return;
        }
        if (!list.contains(queryModule)) {
            list.add(queryModule);
        }
    }

    public List<QueryModule> getQueryLibraryModules(String string) {
        if (this.f == null) {
            return null;
        }
        return this.f.get(string);
    }

    public QueryModule getQueryModuleWithSystemId(String string, QueryModule object) {
        if (string.equals(((QueryModule)object).getSystemId())) {
            return object;
        }
        object = this.getQueryLibraryModules();
        while (object.hasNext()) {
            QueryModule queryModule = (QueryModule)object.next();
            String string2 = queryModule.getSystemId();
            if (string2 == null || !string2.equals(string)) continue;
            return queryModule;
        }
        return null;
    }

    public Iterator getQueryLibraryModules() {
        if (this.f == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        ArrayList<QueryModule> arrayList = new ArrayList<QueryModule>();
        for (List<QueryModule> list : this.f.values()) {
            arrayList.addAll(list);
        }
        return arrayList.iterator();
    }

    public void addQueryLocationHintProcessed(String string) {
        if (this.g == null) {
            this.g = new HashSet();
        }
        this.g.add(string);
    }

    public boolean isQueryLocationHintProcessed(String string) {
        return this.g != null && this.g.contains(string);
    }

    public void fixupQueryModules(QueryModule queryModule) {
        queryModule.bindUnboundVariables();
        if (this.f != null) {
            for (List object2 : this.f.values()) {
                for (Object object : object2) {
                    ((QueryModule)object).bindUnboundVariables();
                }
            }
        }
        QueryModule queryModule2 = queryModule;
        List<GlobalVariable> list = queryModule2.fixupGlobalVariables(queryModule2.getGlobalStackFrameMap());
        queryModule.bindUnboundFunctionCalls();
        if (this.f != null) {
            for (List<QueryModule> list2 : this.f.values()) {
                for (QueryModule queryModule3 : list2) {
                    queryModule3.bindUnboundFunctionCalls();
                }
            }
        }
        queryModule.checkForCircularities(list, queryModule.getGlobalFunctionLibrary());
        queryModule.fixupGlobalFunctions();
        queryModule.typeCheckGlobalVariables(list);
        queryModule.optimizeGlobalFunctions();
    }

    public void explainGlobalVariables(ExpressionPresenter expressionPresenter) {
        expressionPresenter.startElement("globalVariables");
        for (PackageData packageData : this.getPackages()) {
            for (GlobalVariable globalVariable : packageData.getGlobalVariableList()) {
                ((Actor)globalVariable).export(expressionPresenter);
            }
        }
        expressionPresenter.endElement();
    }

    public void registerGlobalParameter(GlobalParam globalParam) {
        this.j.put(globalParam.getVariableQName(), globalParam);
    }

    public Map<StructuredQName, GlobalParam> getGlobalParameters() {
        return this.j;
    }

    public GlobalParam getGlobalParameter(StructuredQName structuredQName) {
        return this.j.get(structuredQName);
    }

    public void checkSuppliedParameters(GlobalParameterSet globalParameterSet) {
    }

    public void setCreatesSecondaryResult(boolean bl2) {
        this.l = bl2;
    }

    public boolean createsSecondaryResult() {
        return this.l;
    }

    public void setGlobalContextRequirement(GlobalContextRequirement globalContextRequirement) {
        this.m = globalContextRequirement;
    }

    public GlobalContextRequirement getGlobalContextRequirement() {
        return this.m;
    }

    public Item checkInitialContextItem(Item object, XPathContext object2) {
        block10: {
            TypeHierarchy typeHierarchy;
            block9: {
                if (this.m == null) {
                    return object;
                }
                if (object != null && this.m.isAbsentFocus()) {
                    throw new XPathException("The global context item is required to be absent", "XPDY0002");
                }
                typeHierarchy = this.a.getTypeHierarchy();
                if (object != null) break block9;
                if (!this.m.isMayBeOmitted()) {
                    throw new XPathException("A global context item is required, but none has been supplied", "XTDE3086");
                }
                if (this.m.getDefaultValue() == null) break block10;
                try {
                    object = this.m.getDefaultValue().evaluateItem((XPathContext)object2);
                }
                catch (XPathException xPathException) {
                    if ("XPDY0002".equals(xPathException.getErrorCodeLocalPart()) && !xPathException.getMessage().contains("last()") && !xPathException.getMessage().contains("position()")) {
                        xPathException.setErrorCode("XQDY0054");
                    }
                    throw xPathException;
                }
                if (object == null) {
                    throw new XPathException("The context item cannot be initialized to an empty sequence", "XPTY0004");
                }
                object2 = this.m.getRequiredItemTypes().iterator();
                while (object2.hasNext()) {
                    ItemType itemType = object2.next();
                    if (itemType.matches((Item)object, typeHierarchy)) continue;
                    object2 = new RoleDiagnostic(20, "defaulted global context item", 0);
                    object = ((RoleDiagnostic)object2).composeErrorMessage(itemType, (Item)object, typeHierarchy);
                    throw new XPathException((String)object, "XPTY0004");
                }
                break block10;
            }
            object2 = this.m.getRequiredItemTypes().iterator();
            while (object2.hasNext()) {
                ItemType itemType = (ItemType)object2.next();
                if (itemType.matches((Item)object, this.a.getTypeHierarchy())) continue;
                object2 = new RoleDiagnostic(20, "supplied global context item", 0);
                object = ((RoleDiagnostic)object2).composeErrorMessage(itemType, (Item)object, typeHierarchy);
                throw new XPathException((String)object, this.getHostLanguage() == 50 ? "XTTE0590" : "XPTY0004");
            }
        }
        return object;
    }

    public void setSchemaAware(boolean bl2) {
        this.schemaAware = bl2;
    }

    public boolean isSchemaAware() {
        return this.schemaAware;
    }
}

