/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.instruct;

import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.AttributeCreator;
import net.sf.saxon.expr.instruct.DummyNamespaceResolver;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.functions.NormalizeSpace_1;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.lib.ConversionRules;
import net.sf.saxon.lib.Validation;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.om.StandardNames;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.Orphan;
import net.sf.saxon.type.ComplexType;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.ValidationFailure;

public final class FixedAttribute
extends AttributeCreator {
    private NodeName a;

    public FixedAttribute(NodeName nodeName, int n2, SimpleType simpleType) {
        this.a = nodeName;
        this.setSchemaType(simpleType);
        this.setValidationAction(n2);
        this.setOptions(0);
    }

    @Override
    public final int getInstructionNameCode() {
        return 135;
    }

    @Override
    public final String getExpressionName() {
        return "att";
    }

    public final NodeName getAttributeName() {
        return this.a;
    }

    @Override
    public final void localTypeCheck(ExpressionVisitor object, ContextItemStaticInfo object2) {
        CharSequence charSequence;
        int n2;
        if (this.a.equals(StandardNames.XML_ID_NAME) && !this.getSelect().isCallOn(NormalizeSpace_1.class)) {
            object2 = SystemFunction.makeCall("normalize-space", this.getRetainedStaticContext(), this.getSelect());
            this.setSelect((Expression)object2);
        }
        object2 = ((ExpressionVisitor)object).getConfiguration();
        ConversionRules conversionRules = ((Configuration)object2).getConversionRules();
        SimpleType simpleType = this.getSchemaType();
        String string = "XTTE1540";
        if (simpleType == null) {
            n2 = this.getValidationAction();
            if (n2 == 1) {
                if ((object2 = ((Configuration)object2).getAttributeDeclaration(this.a.getStructuredQName())) == null) {
                    object = new XPathException("Strict validation fails: there is no global attribute declaration for " + this.a.getDisplayName());
                    ((XPathException)object).setErrorCode("XTTE1510");
                    ((XPathException)object).setLocation(this.getLocation());
                    throw object;
                }
                simpleType = (SimpleType)object2.getType();
                string = "XTTE1510";
            } else if (n2 == 2) {
                if ((object2 = ((Configuration)object2).getAttributeDeclaration(this.a.getStructuredQName())) != null) {
                    simpleType = (SimpleType)object2.getType();
                    string = "XTTE1515";
                } else {
                    ((ExpressionVisitor)object).getStaticContext().issueWarning("Lax validation has no effect: there is no global attribute declaration for " + this.a.getDisplayName(), this.getLocation());
                }
            }
        }
        if (Literal.isAtomic(this.getSelect()) && simpleType != null && !simpleType.isNamespaceSensitive() && (object2 = simpleType.validateContent(charSequence = ((Literal)this.getSelect()).getValue().getStringValueCS(), DummyNamespaceResolver.getInstance(), conversionRules)) != null) {
            object = new XPathException("Attribute value " + Err.wrap(charSequence, 4) + " does not the match the required type " + simpleType.getDescription() + ". " + ((ValidationFailure)object2).getMessage());
            ((XPathException)object).setErrorCode(string);
            throw object;
        }
        if (this.getSelect() instanceof StringLiteral) {
            n2 = 0;
            object2 = ((StringLiteral)this.getSelect()).getStringValue();
            for (int i2 = 0; i2 < object2.length(); ++i2) {
                char c2 = object2.charAt(i2);
                if (c2 >= '!' && c2 <= '~' && c2 != '<' && c2 != '>' && c2 != '&' && c2 != '\"' && c2 != '\'') continue;
                n2 = 1;
                break;
            }
            if (n2 == 0) {
                this.setNoSpecialChars();
            }
        }
    }

    public final int getAttributeFingerprint() {
        return this.a.getFingerprint();
    }

    @Override
    public final int getCardinality() {
        return 16384;
    }

    @Override
    public final Expression copy(RebindingMap rebindingMap) {
        FixedAttribute fixedAttribute = new FixedAttribute(this.a, this.getValidationAction(), this.getSchemaType());
        ExpressionTool.copyLocationInfo(this, fixedAttribute);
        fixedAttribute.setSelect(this.getSelect().copy(rebindingMap));
        fixedAttribute.setInstruction(((Expression)this).isInstruction());
        return fixedAttribute;
    }

    @Override
    public final NodeName evaluateNodeName(XPathContext xPathContext) {
        return this.a;
    }

    @Override
    public final void checkPermittedContents(SchemaType object, boolean n2) {
        SimpleType simpleType;
        n2 = this.a.getFingerprint();
        if (n2 == 641 || n2 == 643 || n2 == 642 || n2 == 644) {
            return;
        }
        if (object instanceof SimpleType) {
            XPathException xPathException = new XPathException("Attribute " + this.a.getDisplayName() + " is not permitted in the content model of the simple type " + object.getDescription());
            xPathException.setIsTypeError(true);
            xPathException.setLocation(this.getLocation());
            if (this.getPackageData().getHostLanguage() == 50) {
                xPathException.setErrorCode("XTTE1510");
            } else {
                xPathException.setErrorCode("XQDY0027");
            }
            throw xPathException;
        }
        try {
            simpleType = ((ComplexType)object).getAttributeUseType(this.a.getStructuredQName());
        }
        catch (SchemaException schemaException) {
            throw new XPathException(schemaException);
        }
        if (simpleType == null) {
            object = new XPathException("Attribute " + this.a.getDisplayName() + " is not permitted in the content model of the complex type " + object.getDescription());
            ((XPathException)object).setIsTypeError(true);
            ((XPathException)object).setLocation(this.getLocation());
            if (this.getPackageData().getHostLanguage() == 50) {
                ((XPathException)object).setErrorCode("XTTE1510");
            } else {
                ((XPathException)object).setErrorCode("XQDY0027");
            }
            throw object;
        }
        try {
            this.getSelect().checkPermittedContents(simpleType, true);
            return;
        }
        catch (XPathException xPathException) {
            object = xPathException;
            xPathException.maybeSetLocation(this.getLocation());
            throw object;
        }
    }

    public final NodeInfo evaluateItem(XPathContext xPathContext) {
        Orphan orphan = (Orphan)super.evaluateItem(xPathContext);
        assert (orphan != null);
        this.validateOrphanAttribute(orphan, xPathContext);
        return orphan;
    }

    @Override
    public final void export(ExpressionPresenter expressionPresenter) {
        expressionPresenter.startElement("att", this);
        expressionPresenter.emitAttribute("name", this.a.getDisplayName());
        if (!this.a.getStructuredQName().hasURI("")) {
            expressionPresenter.emitAttribute("nsuri", this.a.getStructuredQName().getURI());
        }
        if (this.getValidationAction() != 4 && this.getValidationAction() != 8) {
            expressionPresenter.emitAttribute("validation", Validation.toString(this.getValidationAction()));
        }
        if (this.getSchemaType() != null) {
            expressionPresenter.emitAttribute("type", this.getSchemaType().getStructuredQName());
        }
        String string = "";
        if (this.isLocal()) {
            string = string + "l";
        }
        if (!string.isEmpty()) {
            expressionPresenter.emitAttribute("flags", string);
        }
        this.getSelect().export(expressionPresenter);
        expressionPresenter.endElement();
    }

    @Override
    public final String toShortString() {
        return "attr{" + this.a.getDisplayName() + "=...}";
    }
}

