/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.instruct;

import net.sf.saxon.Configuration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.Block;
import net.sf.saxon.expr.instruct.ElementCreator;
import net.sf.saxon.expr.instruct.FixedAttribute;
import net.sf.saxon.expr.instruct.ParentNodeConstructor;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.CombinedNodeTest;
import net.sf.saxon.pattern.ContentTypeTest;
import net.sf.saxon.pattern.NameTest;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.AnyType;
import net.sf.saxon.type.ComplexType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaDeclaration;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.Untyped;
import net.sf.saxon.type.ValidationFailure;

public class FixedElement
extends ElementCreator {
    private NodeName a;
    protected NamespaceBinding[] namespaceBindings;
    private ItemType b;

    public FixedElement(NodeName nodeName, NamespaceBinding[] namespaceBindingArray, boolean bl2, boolean bl3, SchemaType schemaType, int n2) {
        this.a = nodeName;
        this.namespaceBindings = namespaceBindingArray;
        this.inheritNamespacesToChildren = bl2;
        this.inheritNamespacesFromParent = bl3;
        this.setValidationAction(n2, schemaType);
        this.preservingTypes = schemaType == null && n2 == 3;
    }

    @Override
    public Iterable<Operand> operands() {
        return this.contentOp;
    }

    @Override
    public Expression simplify() {
        this.getConfiguration();
        this.preservingTypes |= !this.getPackageData().isSchemaAware();
        return super.simplify();
    }

    @Override
    protected void checkContentSequence(StaticContext staticContext) {
        super.checkContentSequence(staticContext);
        this.b = FixedElement.a(this, staticContext, this.getValidationAction(), this.getSchemaType(), this.a, this.getContentExpression());
    }

    @Override
    public Expression optimize(ExpressionVisitor expressionVisitor, ContextItemStaticInfo object) {
        if ((object = super.optimize(expressionVisitor, (ContextItemStaticInfo)object)) != this) {
            return object;
        }
        if (!this.inheritNamespacesToChildren) {
            return this;
        }
        if (this.namespaceBindings.length == 0) {
            return this;
        }
        if (this.getContentExpression() instanceof FixedElement) {
            object = (FixedElement)this.getContentExpression();
            if (this.a.isInSameNamespace(((FixedElement)object).getElementName())) {
                super.a(expressionVisitor, this.namespaceBindings);
            }
            return this;
        }
        if (this.getContentExpression() instanceof Block) {
            for (Operand operand : this.getContentExpression().operands()) {
                Expression object2 = operand.getChildExpression();
                if (!(object2 instanceof FixedElement) || !this.a.isInSameNamespace(((FixedElement)object2).getElementName())) continue;
                ((FixedElement)object2).a(expressionVisitor, this.namespaceBindings);
            }
        }
        return this;
    }

    private void a(ExpressionVisitor object, NamespaceBinding[] object2) {
        NamespaceBinding[] namespaceBindingArray;
        Object object3;
        ItemType itemType;
        if (this.namespaceBindings.length == 0) {
            return;
        }
        boolean bl2 = ((TypeHierarchy)(object = ((ExpressionVisitor)object).getConfiguration().getTypeHierarchy())).relationship(itemType = this.getContentExpression().getItemType(), NodeKindTest.ATTRIBUTE) == 4;
        if (!bl2 && this.getContentExpression() instanceof Block) {
            bl2 = true;
            for (Operand operand : this.getContentExpression().operands()) {
                object3 = operand.getChildExpression();
                if (object3 instanceof FixedAttribute) {
                    if (((FixedAttribute)object3).getAttributeName().hasURI("")) continue;
                    bl2 = false;
                    break;
                }
                namespaceBindingArray = ((Expression)object3).getItemType();
                if (((TypeHierarchy)object).relationship((ItemType)namespaceBindingArray, NodeKindTest.ATTRIBUTE) == 4) continue;
                bl2 = false;
                break;
            }
        }
        if (bl2) {
            int n2 = 0;
            block1: for (int i2 = 0; i2 < this.namespaceBindings.length; ++i2) {
                object3 = object2;
                int n3 = ((NamespaceBinding[])object2).length;
                for (int i3 = 0; i3 < n3; ++i3) {
                    NamespaceBinding namespaceBinding = object3[i3];
                    if (this.namespaceBindings[i2] != namespaceBinding) continue;
                    this.namespaceBindings[i2] = null;
                    ++n2;
                    continue block1;
                }
            }
            if (n2 > 0) {
                if (n2 == this.namespaceBindings.length) {
                    this.namespaceBindings = NamespaceBinding.EMPTY_ARRAY;
                    return;
                }
                NamespaceBinding[] namespaceBindingArray2 = new NamespaceBinding[this.namespaceBindings.length - n2];
                int n4 = 0;
                namespaceBindingArray = this.namespaceBindings;
                int n5 = this.namespaceBindings.length;
                for (int i4 = 0; i4 < n5; ++i4) {
                    object2 = namespaceBindingArray[i4];
                    if (object2 == null) continue;
                    namespaceBindingArray2[n4++] = object2;
                }
                this.namespaceBindings = namespaceBindingArray2;
            }
        }
    }

    @Override
    public Expression copy(RebindingMap rebindingMap) {
        Object object = this.namespaceBindings;
        if (this.namespaceBindings.length != 0) {
            object = new NamespaceBinding[this.namespaceBindings.length];
            System.arraycopy(this.namespaceBindings, 0, object, 0, ((NamespaceBinding[])object).length);
        }
        object = new FixedElement(this.a, (NamespaceBinding[])object, this.inheritNamespacesToChildren, this.inheritNamespacesFromParent, this.getSchemaType(), this.getValidationAction());
        object.setContentExpression(this.getContentExpression().copy(rebindingMap));
        ExpressionTool.copyLocationInfo(this, (Expression)object);
        return object;
    }

    private static NodeTest a(FixedElement fixedElement, StaticContext object, int n2, SchemaType object2, NodeName object3, Expression expression) {
        Configuration configuration = object.getConfiguration();
        int n3 = object3.obtainFingerprint(configuration.getNamePool());
        if (object2 == null) {
            if (n2 == 1) {
                SchemaType schemaType;
                Object object5;
                SchemaDeclaration schemaDeclaration;
                block25: {
                    schemaDeclaration = configuration.getElementDeclaration(n3);
                    if (schemaDeclaration == null) {
                        object3 = new XPathException("There is no global element declaration for " + object3.getStructuredQName().getEQName() + ", so strict validation will fail");
                        ((XPathException)object3).setErrorCode(fixedElement.isXSLT() ? "XTTE1512" : "XQDY0084");
                        ((XPathException)object3).setIsTypeError(true);
                        ((XPathException)object3).setLocation(fixedElement.getLocation());
                        throw object3;
                    }
                    if (schemaDeclaration.isAbstract()) {
                        object3 = new XPathException("The element declaration for " + object3.getStructuredQName().getEQName() + " is abstract, so strict validation will fail");
                        ((XPathException)object3).setErrorCode(fixedElement.isXSLT() ? "XTTE1512" : "XQDY0027");
                        ((XPathException)object3).setIsTypeError(true);
                        ((XPathException)object3).setLocation(fixedElement.getLocation());
                        throw object3;
                    }
                    object3 = schemaDeclaration.getType();
                    object5 = object;
                    object2 = fixedElement;
                    if (((ParentNodeConstructor)object2).getContentExpression() instanceof FixedAttribute) {
                        Object object4 = object2;
                        schemaType = super.a((FixedAttribute)((ParentNodeConstructor)object4).getContentExpression(), (StaticContext)object5);
                    } else if (((ParentNodeConstructor)object2).getContentExpression() instanceof Block) {
                        for (Operand operand : ((ParentNodeConstructor)object2).getContentExpression().operands()) {
                            SchemaType schemaType2;
                            Expression expression2 = operand.getChildExpression();
                            if (!(expression2 instanceof FixedAttribute) || (schemaType2 = super.a((FixedAttribute)expression2, (StaticContext)object5)) == null) continue;
                            schemaType = schemaType2;
                            break block25;
                        }
                        schemaType = null;
                    } else {
                        schemaType = null;
                    }
                }
                object5 = schemaType;
                object2 = schemaType != null ? object5 : object3;
                object = new CombinedNodeTest(new NameTest(1, n3, object.getConfiguration().getNamePool()), 23, new ContentTypeTest(1, (SchemaType)object2, configuration, false));
                if (object5 != null || !schemaDeclaration.hasTypeAlternatives()) {
                    fixedElement.getValidationOptions().setTopLevelType((SchemaType)object2);
                    try {
                        object2.analyzeContentExpression(expression, 1);
                    }
                    catch (XPathException xPathException) {
                        object = xPathException;
                        xPathException.setErrorCode(fixedElement.isXSLT() ? "XTTE1510" : "XQDY0027");
                        ((XPathException)object).setLocation(fixedElement.getLocation());
                        throw object;
                    }
                    if (object5 != null) {
                        try {
                            configuration.checkTypeDerivationIsOK((SchemaType)object5, (SchemaType)object3, 0);
                        }
                        catch (SchemaException schemaException) {
                            object = new ValidationFailure("The specified xsi:type " + object5.getDescription() + " is not validly derived from the required type " + object3.getDescription());
                            ((ValidationFailure)object).setConstraintReference(1, "cvc-elt", "4.3");
                            ((ValidationFailure)object).setErrorCode(fixedElement.isXSLT() ? "XTTE1515" : "XQDY0027");
                            ((ValidationFailure)object).setLocator(fixedElement.getLocation());
                            throw ((ValidationFailure)object).makeException();
                        }
                    }
                }
            } else if (n2 == 2) {
                SchemaDeclaration schemaDeclaration = configuration.getElementDeclaration(n3);
                if (schemaDeclaration == null) {
                    object.issueWarning("There is no global element declaration for " + object3.getDisplayName(), fixedElement.getLocation());
                    object = new NameTest(1, n3, configuration.getNamePool());
                } else {
                    object2 = schemaDeclaration.getType();
                    fixedElement.getValidationOptions().setTopLevelType((SchemaType)object2);
                    object = new CombinedNodeTest(new NameTest(1, n3, configuration.getNamePool()), 23, new ContentTypeTest(1, fixedElement.getSchemaType(), configuration, false));
                    try {
                        object2.analyzeContentExpression(expression, 1);
                    }
                    catch (XPathException xPathException) {
                        object3 = xPathException;
                        xPathException.setErrorCode(fixedElement.isXSLT() ? "XTTE1515" : "XQDY0027");
                        ((XPathException)object3).setLocation(fixedElement.getLocation());
                        throw object3;
                    }
                }
            } else {
                object = n2 == 3 ? new CombinedNodeTest(new NameTest(1, n3, configuration.getNamePool()), 23, new ContentTypeTest(1, AnyType.getInstance(), configuration, false)) : new CombinedNodeTest(new NameTest(1, n3, configuration.getNamePool()), 23, new ContentTypeTest(1, Untyped.getInstance(), configuration, false));
            }
        } else {
            object = new CombinedNodeTest(new NameTest(1, n3, configuration.getNamePool()), 23, new ContentTypeTest(1, (SchemaType)object2, configuration, false));
            try {
                object2.analyzeContentExpression(expression, 1);
            }
            catch (XPathException xPathException) {
                XPathException xPathException2 = xPathException;
                xPathException.setErrorCode(fixedElement.isXSLT() ? "XTTE1540" : "XQDY0027");
                xPathException2.setLocation(fixedElement.getLocation());
                throw xPathException2;
            }
        }
        return object;
    }

    @Override
    public ItemType getItemType() {
        if (this.b == null) {
            return super.getItemType();
        }
        return this.b;
    }

    @Override
    public NodeName getElementName(XPathContext xPathContext, NodeInfo nodeInfo) {
        return this.a;
    }

    public NodeName getElementName() {
        return this.a;
    }

    @Override
    public String getNewBaseURI(XPathContext xPathContext, NodeInfo nodeInfo) {
        return this.getStaticBaseURIString();
    }

    private SchemaType a(FixedAttribute stringArray, StaticContext staticContext) {
        int n2 = stringArray.getAttributeFingerprint();
        if (n2 == 641 && (stringArray = stringArray.getSelect()) instanceof StringLiteral) {
            try {
                staticContext.getConfiguration().getNamePool();
                stringArray = NameChecker.getQNameParts(((StringLiteral)stringArray).getStringValue());
                String string = null;
                NamespaceBinding[] namespaceBindingArray = this.namespaceBindings;
                int n3 = this.namespaceBindings.length;
                for (int i2 = 0; i2 < n3; ++i2) {
                    NamespaceBinding namespaceBinding = namespaceBindingArray[i2];
                    String string2 = namespaceBinding.getPrefix();
                    if (!string2.equals(stringArray[0])) continue;
                    string = namespaceBinding.getURI();
                    break;
                }
                if (string == null) {
                    return null;
                }
                return staticContext.getConfiguration().getSchemaType(new StructuredQName("", string, stringArray[1]));
            }
            catch (QNameException qNameException) {
                throw new XPathException(qNameException.getMessage());
            }
        }
        return null;
    }

    @Override
    public void checkPermittedContents(SchemaType schemaType, boolean bl2) {
        SchemaType schemaType2;
        if (schemaType instanceof SimpleType) {
            XPathException xPathException = new XPathException("Element " + this.a.getDisplayName() + " is not permitted here: the containing element is of simple type " + schemaType.getDescription());
            xPathException.setIsTypeError(true);
            xPathException.setLocation(this.getLocation());
            throw xPathException;
        }
        if (((ComplexType)schemaType).isSimpleContent()) {
            XPathException xPathException = new XPathException("Element " + this.a.getDisplayName() + " is not permitted here: the containing element has a complex type with simple content");
            xPathException.setIsTypeError(true);
            xPathException.setLocation(this.getLocation());
            throw xPathException;
        }
        if (bl2) {
            Expression expression = this.getParentExpression();
            Block block = new Block(new Expression[]{this});
            schemaType.analyzeContentExpression(block, 1);
            this.setParentExpression(expression);
        }
        try {
            int n2 = this.a.obtainFingerprint(this.getConfiguration().getNamePool());
            schemaType2 = ((ComplexType)schemaType).getElementParticleType(n2, true);
        }
        catch (SchemaException schemaException) {
            throw new XPathException(schemaException);
        }
        if (schemaType2 == null) {
            XPathException xPathException = new XPathException("Element " + this.a.getDisplayName() + " is not permitted in the content model of the complex type " + schemaType.getDescription());
            xPathException.setIsTypeError(true);
            xPathException.setLocation(this.getLocation());
            xPathException.setErrorCode(this.isXSLT() ? "XTTE1510" : "XQDY0027");
            throw xPathException;
        }
        if (schemaType2 instanceof AnyType) {
            return;
        }
        try {
            this.getContentExpression().checkPermittedContents(schemaType2, true);
            return;
        }
        catch (XPathException xPathException) {
            XPathException xPathException2 = xPathException;
            xPathException.maybeSetLocation(this.getLocation());
            throw xPathException2;
        }
    }

    @Override
    public void outputNamespaceNodes(XPathContext namespaceBindingArray, Receiver receiver, NodeName nodeName, NodeInfo nodeInfo) {
        namespaceBindingArray = this.namespaceBindings;
        int n2 = this.namespaceBindings.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            NamespaceBinding namespaceBinding = namespaceBindingArray[i2];
            receiver.namespace(namespaceBinding, 0);
        }
    }

    @Override
    public NamespaceBinding[] getActiveNamespaces() {
        return this.namespaceBindings;
    }

    @Override
    public void export(ExpressionPresenter expressionPresenter) {
        expressionPresenter.startElement("elem", this);
        expressionPresenter.emitAttribute("name", this.a.getDisplayName());
        expressionPresenter.emitAttribute("nsuri", this.a.getURI());
        CharSequence charSequence = this.getInheritanceFlags();
        if (!this.a.getURI().isEmpty() && this.a.getPrefix().isEmpty()) {
            charSequence = (String)charSequence + "d";
        }
        if (this.isLocal()) {
            charSequence = (String)charSequence + "l";
        }
        if (!((String)charSequence).isEmpty()) {
            expressionPresenter.emitAttribute("flags", (String)charSequence);
        }
        charSequence = new FastStringBuffer(256);
        if (this.namespaceBindings.length > 0) {
            NamespaceBinding[] namespaceBindingArray = this.namespaceBindings;
            int n2 = this.namespaceBindings.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                NamespaceBinding namespaceBinding = namespaceBindingArray[i2];
                String string = namespaceBinding.getPrefix();
                ((FastStringBuffer)charSequence).append(string.isEmpty() ? "#" : string);
                if (!namespaceBinding.getURI().equals(this.getRetainedStaticContext().getURIForPrefix(string, true))) {
                    ((FastStringBuffer)charSequence).append('=');
                    ((FastStringBuffer)charSequence).append(namespaceBinding.getURI());
                }
                ((FastStringBuffer)charSequence).append(' ');
            }
            CharSequence charSequence2 = charSequence;
            ((FastStringBuffer)charSequence2).setLength(((FastStringBuffer)charSequence2).length() - 1);
            expressionPresenter.emitAttribute("namespaces", ((FastStringBuffer)charSequence).toString());
        }
        this.exportValidationAndType(expressionPresenter);
        this.getContentExpression().export(expressionPresenter);
        expressionPresenter.endElement();
    }

    @Override
    public String toString() {
        return "<" + this.a.getStructuredQName().getDisplayName() + " {" + this.getContentExpression().toString() + "}/>";
    }

    @Override
    public String toShortString() {
        return "<" + this.a.getStructuredQName().getDisplayName() + " {" + this.getContentExpression().toShortString() + "}/>";
    }

    @Override
    public String getExpressionName() {
        return "element";
    }
}

