/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.instruct;

import net.sf.saxon.Controller;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.expr.AxisExpression;
import net.sf.saxon.expr.ContextMappingFunction;
import net.sf.saxon.expr.ContextMappingIterator;
import net.sf.saxon.expr.ContextSwitchingExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.PendingUpdateList;
import net.sf.saxon.expr.SimpleStepExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.XPathContextMinor;
import net.sf.saxon.expr.instruct.Instruction;
import net.sf.saxon.expr.instruct.TailCall;
import net.sf.saxon.expr.instruct.TailCallReturner;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.PathMap;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.lib.TraceListener;
import net.sf.saxon.om.FocusIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ErrorType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.UType;
import net.sf.saxon.value.Cardinality;

public class ForEach
extends Instruction
implements ContextMappingFunction<Item<?>>,
ContextSwitchingExpression {
    protected boolean containsTailCall;
    protected Operand selectOp;
    protected Operand actionOp;
    protected Operand threadsOp;
    protected boolean isInstruction;

    public ForEach(Expression expression, Expression expression2) {
        this(expression, expression2, false, null);
    }

    public ForEach(Expression expression, Expression expression2, boolean bl2, Expression expression3) {
        this.selectOp = new Operand(this, expression, OperandRole.FOCUS_CONTROLLING_SELECT);
        this.actionOp = new Operand(this, expression2, OperandRole.FOCUS_CONTROLLED_ACTION);
        if (expression3 != null) {
            this.threadsOp = new Operand(this, expression3, OperandRole.SINGLE_ATOMIC);
        }
        this.containsTailCall = bl2 && expression2 instanceof TailCallReturner;
    }

    public void setInstruction(boolean bl2) {
        this.isInstruction = bl2;
    }

    @Override
    public boolean isInstruction() {
        return this.isInstruction;
    }

    public Expression getSelect() {
        return this.selectOp.getChildExpression();
    }

    public void setSelect(Expression expression) {
        this.selectOp.setChildExpression(expression);
    }

    public Expression getAction() {
        return this.actionOp.getChildExpression();
    }

    public void setAction(Expression expression) {
        this.actionOp.setChildExpression(expression);
    }

    public Expression getThreads() {
        if (this.threadsOp == null) {
            return null;
        }
        return this.threadsOp.getChildExpression();
    }

    public void setThreads(Expression expression) {
        if (expression != null) {
            if (this.threadsOp == null) {
                this.threadsOp = new Operand(this, expression, OperandRole.SINGLE_ATOMIC);
                return;
            }
            this.threadsOp.setChildExpression(expression);
        }
    }

    @Override
    public Iterable<Operand> operands() {
        if (this.threadsOp == null) {
            return this.operandList(this.selectOp, this.actionOp);
        }
        return this.operandList(this.selectOp, this.actionOp, this.threadsOp);
    }

    @Override
    public int getInstructionNameCode() {
        return 155;
    }

    @Override
    public Expression getSelectExpression() {
        return this.getSelect();
    }

    public void setSelectExpression(Expression expression) {
        this.setSelect(expression);
    }

    public void setActionExpression(Expression expression) {
        this.setAction(expression);
    }

    @Override
    public Expression getActionExpression() {
        return this.getAction();
    }

    public Expression getNumberOfThreadsExpression() {
        return this.getThreads();
    }

    @Override
    public final ItemType getItemType() {
        return this.getAction().getItemType();
    }

    @Override
    public UType getStaticUType(UType uType) {
        if (((Expression)this).isInstruction()) {
            return super.getStaticUType(uType);
        }
        return this.getAction().getStaticUType(this.getSelect().getStaticUType(uType));
    }

    @Override
    public final boolean mayCreateNewNodes() {
        int n2 = this.getAction().getSpecialProperties();
        return (n2 & 0x800000) == 0;
    }

    @Override
    public Expression typeCheck(ExpressionVisitor expressionVisitor, ContextItemStaticInfo object) {
        this.selectOp.typeCheck(expressionVisitor, (ContextItemStaticInfo)object);
        object = this.getSelect().getItemType();
        if (object == ErrorType.getInstance()) {
            return Literal.makeEmptySequence();
        }
        object = expressionVisitor.getConfiguration().makeContextItemStaticInfo(this.getSelect().getItemType(), false);
        ((ContextItemStaticInfo)object).setContextSettingExpression(this.getSelect());
        this.actionOp.typeCheck(expressionVisitor, (ContextItemStaticInfo)object);
        if (!Cardinality.allowsMany(this.getSelect().getCardinality())) {
            this.actionOp.setOperandRole(this.actionOp.getOperandRole().modifyProperty(32, true));
        }
        return this;
    }

    @Override
    public Expression optimize(ExpressionVisitor expressionVisitor, ContextItemStaticInfo contextItemStaticInfo) {
        this.selectOp.optimize(expressionVisitor, contextItemStaticInfo);
        contextItemStaticInfo = expressionVisitor.getConfiguration().makeContextItemStaticInfo(this.getSelect().getItemType(), false);
        contextItemStaticInfo.setContextSettingExpression(this.getSelect());
        this.actionOp.optimize(expressionVisitor, contextItemStaticInfo);
        if (!expressionVisitor.isOptimizeForStreaming()) {
            if (Literal.isEmptySequence(this.getSelect())) {
                return this.getSelect();
            }
            if (Literal.isEmptySequence(this.getAction())) {
                return this.getAction();
            }
        }
        if (this.getSelect().getCardinality() == 16384 && this.getAction() instanceof AxisExpression) {
            return new SimpleStepExpression(this.getSelect(), this.getAction());
        }
        if (this.threadsOp != null && !Literal.isEmptySequence(this.getThreads())) {
            return expressionVisitor.obtainOptimizer().generateMultithreadedInstruction(this);
        }
        return this;
    }

    @Override
    public Expression unordered(boolean bl2, boolean bl3) {
        ForEach forEach = this;
        forEach.setSelect(forEach.getSelect().unordered(bl2, bl3));
        ForEach forEach2 = this;
        forEach2.setAction(forEach2.getAction().unordered(bl2, bl3));
        return this;
    }

    @Override
    public PathMap.PathMapNodeSet addToPathMap(PathMap pathMap, PathMap.PathMapNodeSet pathMapNodeSet) {
        pathMapNodeSet = this.getSelect().addToPathMap(pathMap, pathMapNodeSet);
        return this.getAction().addToPathMap(pathMap, pathMapNodeSet);
    }

    @Override
    public Expression copy(RebindingMap object) {
        object = new ForEach(this.getSelect().copy((RebindingMap)object), this.getAction().copy((RebindingMap)object), this.containsTailCall, this.getThreads());
        ExpressionTool.copyLocationInfo(this, (Expression)object);
        ((ForEach)object).setInstruction(((Expression)this).isInstruction());
        return object;
    }

    @Override
    public int computeSpecialProperties() {
        int n2 = super.computeSpecialProperties();
        n2 = this.getSelect().getCardinality() == 16384 ? (n2 |= this.getAction().getSpecialProperties()) : (n2 |= this.getAction().getSpecialProperties() & 0x8000000);
        return n2;
    }

    @Override
    public boolean alwaysCreatesNewNodes() {
        return this.getAction() instanceof Instruction && ((Instruction)this.getAction()).alwaysCreatesNewNodes();
    }

    @Override
    public boolean isUpdatingExpression() {
        return this.getAction().isUpdatingExpression();
    }

    @Override
    public void checkForUpdatingSubexpressions() {
        if (this.getSelect().isUpdatingExpression()) {
            XPathException xPathException = new XPathException("Updating expression appears in a context where it is not permitted", "XUST0001");
            xPathException.setLocation(this.getSelect().getLocation());
            throw xPathException;
        }
    }

    @Override
    public int getImplementationMethod() {
        return 30;
    }

    @Override
    public void checkPermittedContents(SchemaType schemaType, boolean bl2) {
        this.getAction().checkPermittedContents(schemaType, false);
    }

    @Override
    public TailCall processLeavingTail(XPathContext xPathContext) {
        Object object = xPathContext.getController();
        assert (object != null);
        XPathContextMajor xPathContextMajor = xPathContext.newContext();
        xPathContextMajor.setOrigin(this);
        FocusIterator<?> focusIterator = xPathContextMajor.trackFocus(this.getSelect().iterate(xPathContext));
        xPathContextMajor.setCurrentTemplateRule(null);
        Expression expression = this.getAction();
        if (this.containsTailCall) {
            if (((Controller)object).isTracing()) {
                TraceListener traceListener = ((Controller)object).getTraceListener();
                assert (traceListener != null);
                object = focusIterator.next();
                if (object == null) {
                    return null;
                }
                traceListener.startCurrentItem((Item)object);
                TailCall tailCall = ((TailCallReturner)((Object)expression)).processLeavingTail(xPathContextMajor);
                traceListener.endCurrentItem((Item)object);
                return tailCall;
            }
            Object t2 = focusIterator.next();
            if (t2 == null) {
                return null;
            }
            return ((TailCallReturner)((Object)expression)).processLeavingTail(xPathContextMajor);
        }
        PipelineConfiguration pipelineConfiguration = xPathContextMajor.getReceiver().getPipelineConfiguration();
        pipelineConfiguration.setXPathContext(xPathContextMajor);
        if (((Controller)object).isTracing()) {
            Object t3;
            object = ((Controller)object).getTraceListener();
            assert (object != null);
            while ((t3 = focusIterator.next()) != null) {
                object.startCurrentItem((Item)t3);
                expression.process(xPathContextMajor);
                object.endCurrentItem((Item)t3);
            }
        } else {
            focusIterator.forEachOrFail(item -> expression.process(xPathContextMajor));
        }
        pipelineConfiguration.setXPathContext(xPathContext);
        return null;
    }

    @Override
    public SequenceIterator<?> iterate(XPathContext xPathContext) {
        XPathContextMinor xPathContextMinor = xPathContext.newMinorContext();
        xPathContextMinor.trackFocus(this.getSelect().iterate(xPathContext));
        return new ContextMappingIterator(this, xPathContextMinor);
    }

    @Override
    public SequenceIterator<?> map(XPathContext xPathContext) {
        return this.getAction().iterate(xPathContext);
    }

    @Override
    public void evaluatePendingUpdates(XPathContext object, PendingUpdateList pendingUpdateList) {
        XPathContextMinor xPathContextMinor = object.newMinorContext();
        xPathContextMinor.trackFocus(this.getSelect().iterate((XPathContext)object));
        object = xPathContextMinor.getCurrentIterator();
        while (object.next() != null) {
            this.getAction().evaluatePendingUpdates(xPathContextMinor, pendingUpdateList);
        }
    }

    @Override
    public void export(ExpressionPresenter expressionPresenter) {
        expressionPresenter.startElement("forEach", this);
        this.getSelect().export(expressionPresenter);
        this.getAction().export(expressionPresenter);
        this.explainThreads(expressionPresenter);
        expressionPresenter.endElement();
    }

    protected void explainThreads(ExpressionPresenter expressionPresenter) {
    }

    @Override
    public String toString() {
        return ExpressionTool.parenthesize(this.getSelect()) + " ! " + ExpressionTool.parenthesize(this.getAction());
    }

    @Override
    public String toShortString() {
        return this.getSelect().toShortString() + "!" + this.getAction().toShortString();
    }

    @Override
    public String getExpressionName() {
        return "forEach";
    }

    @Override
    public String getStreamerName() {
        return "ForEach";
    }
}

