/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.instruct;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Iterator;
import net.sf.saxon.Controller;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.expr.CardinalityChecker;
import net.sf.saxon.expr.ContextMappingFunction;
import net.sf.saxon.expr.ContextMappingIterator;
import net.sf.saxon.expr.ContextSwitchingExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.FirstItemExpression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.XPathContextMinor;
import net.sf.saxon.expr.instruct.Instruction;
import net.sf.saxon.expr.instruct.TailCall;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.PathMap;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.expr.sort.AtomicComparer;
import net.sf.saxon.expr.sort.CodepointCollator;
import net.sf.saxon.expr.sort.GroupAdjacentIterator;
import net.sf.saxon.expr.sort.GroupByIterator;
import net.sf.saxon.expr.sort.GroupEndingIterator;
import net.sf.saxon.expr.sort.GroupIterator;
import net.sf.saxon.expr.sort.GroupStartingIterator;
import net.sf.saxon.expr.sort.SortKeyDefinition;
import net.sf.saxon.expr.sort.SortKeyDefinitionList;
import net.sf.saxon.expr.sort.SortKeyEvaluator;
import net.sf.saxon.expr.sort.SortedGroupIterator;
import net.sf.saxon.functions.CurrentGroupCall;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.om.FocusIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ErrorType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.StringValue;

public class ForEachGroup
extends Instruction
implements ContextMappingFunction<Item<?>>,
ContextSwitchingExpression,
SortKeyEvaluator {
    public static final int GROUP_BY = 0;
    public static final int GROUP_ADJACENT = 1;
    public static final int GROUP_STARTING = 2;
    public static final int GROUP_ENDING = 3;
    private byte a;
    private int b;
    private StringCollator c = null;
    private transient AtomicComparer[] d = null;
    private boolean e = false;
    private boolean f = false;
    private Operand g;
    private Operand h;
    private Operand i;
    private Operand j;
    private Operand k;

    /*
     * WARNING - void declaration
     */
    public ForEachGroup(Expression iterator, Expression object2, byte by, Expression expression, StringCollator stringCollator, Expression expression2, SortKeyDefinitionList sortKeyDefinitionList) {
        void var5_7;
        void var7_9;
        void var6_8;
        void var4_6;
        void var3_5;
        this.g = new Operand(this, (Expression)((Object)iterator), OperandRole.FOCUS_CONTROLLING_SELECT);
        this.h = new Operand(this, (Expression)object2, OperandRole.FOCUS_CONTROLLED_ACTION);
        iterator = var3_5 == 3 || var3_5 == 2 ? OperandRole.PATTERN : OperandRole.NEW_FOCUS_ATOMIC;
        this.i = new Operand(this, (Expression)var4_6, (OperandRole)((Object)iterator));
        if (var6_8 != null) {
            this.j = new Operand(this, (Expression)var6_8, OperandRole.SINGLE_ATOMIC);
        }
        if (var7_9 != null) {
            this.k = new Operand(this, (Expression)var7_9, OperandRole.SINGLE_ATOMIC);
        }
        this.a = var3_5;
        this.c = var5_7;
        for (Operand operand : ((Expression)this).operands()) {
            this.adoptChildExpression(operand.getChildExpression());
        }
    }

    @Override
    public int getInstructionNameCode() {
        return 157;
    }

    @Override
    public Iterable<Operand> operands() {
        return this.operandSparseList(this.g, this.h, this.i, this.j, this.k);
    }

    @Override
    public Expression getSelectExpression() {
        return this.g.getChildExpression();
    }

    @Override
    public Expression getActionExpression() {
        return this.h.getChildExpression();
    }

    public byte getAlgorithm() {
        return this.a;
    }

    public Expression getGroupingKey() {
        return this.i.getChildExpression();
    }

    public int getKeyItemType() {
        return this.b;
    }

    public SortKeyDefinitionList getSortKeyDefinitions() {
        if (this.k == null) {
            return null;
        }
        return (SortKeyDefinitionList)this.k.getChildExpression();
    }

    public AtomicComparer[] getSortKeyComparators() {
        return this.d;
    }

    public StringCollator getCollation() {
        return this.c;
    }

    public URI getBaseURI() {
        try {
            return this.getRetainedStaticContext().getStaticBaseUri();
        }
        catch (XPathException xPathException) {
            return null;
        }
    }

    public boolean isComposite() {
        return this.e;
    }

    public void setComposite(boolean bl2) {
        this.e = bl2;
    }

    public boolean isInFork() {
        return this.f;
    }

    public void setIsInFork(boolean bl2) {
        this.f = bl2;
    }

    @Override
    public boolean allowExtractingCommonSubexpressions() {
        return false;
    }

    @Override
    public Expression typeCheck(ExpressionVisitor expressionVisitor, ContextItemStaticInfo contextItemStaticInfo) {
        ItemType itemType;
        this.g.typeCheck(expressionVisitor, contextItemStaticInfo);
        if (this.j != null) {
            this.j.typeCheck(expressionVisitor, contextItemStaticInfo);
        }
        if ((itemType = this.getSelectExpression().getItemType()) == ErrorType.getInstance()) {
            return Literal.makeEmptySequence();
        }
        Object object = ((Expression)this).operands().iterator();
        while (object.hasNext()) {
            object.next();
            ForEachGroup forEachGroup = this;
            ForEachGroup.a(forEachGroup, forEachGroup, itemType, false);
        }
        object = expressionVisitor.getConfiguration().makeContextItemStaticInfo(itemType, false);
        ((ContextItemStaticInfo)object).setContextSettingExpression(this.getSelectExpression());
        this.h.typeCheck(expressionVisitor, (ContextItemStaticInfo)object);
        this.i.typeCheck(expressionVisitor, (ContextItemStaticInfo)object);
        if (Literal.isEmptySequence(this.getSelectExpression())) {
            return this.getSelectExpression();
        }
        if (Literal.isEmptySequence(this.getActionExpression())) {
            return this.getActionExpression();
        }
        if (this.getSortKeyDefinitions() != null) {
            boolean bl2 = true;
            for (SortKeyDefinition sortKeyDefinition : this.getSortKeyDefinitions()) {
                Object object2;
                Expression expression = sortKeyDefinition.getSortKey();
                expression = expression.typeCheck(expressionVisitor, (ContextItemStaticInfo)object);
                if (sortKeyDefinition.isBackwardsCompatible()) {
                    expression = FirstItemExpression.makeFirstItemExpression(expression);
                } else {
                    object2 = new RoleDiagnostic(4, "xsl:sort/select", 0);
                    ((RoleDiagnostic)object2).setErrorCode("XTTE1020");
                    expression = CardinalityChecker.makeCardinalityChecker(expression, 24576, (RoleDiagnostic)object2);
                }
                sortKeyDefinition.setSortKey(expression, true);
                sortKeyDefinition.typeCheck(expressionVisitor, contextItemStaticInfo);
                if (sortKeyDefinition.isFixed()) {
                    object2 = sortKeyDefinition.makeComparator(expressionVisitor.getStaticContext().makeEarlyEvaluationContext());
                    sortKeyDefinition.setFinalComparator((AtomicComparer)object2);
                    continue;
                }
                bl2 = false;
            }
            if (bl2) {
                this.d = new AtomicComparer[this.getSortKeyDefinitions().size()];
                for (int i2 = 0; i2 < this.getSortKeyDefinitions().size(); ++i2) {
                    this.d[i2] = this.getSortKeyDefinitions().getSortKeyDefinition(i2).getFinalComparator();
                }
            }
        }
        this.b = this.getGroupingKey().getItemType().getPrimitiveType();
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void a(Expression object, ForEachGroup forEachGroup, ItemType itemType, boolean bl2) {
        if (object == null) return;
        if (object instanceof CurrentGroupCall) {
            ((CurrentGroupCall)object).setControllingInstruction(forEachGroup, itemType, bl2);
            return;
        }
        if (object instanceof ForEachGroup) {
            if ((object = (ForEachGroup)object) == forEachGroup) {
                ForEachGroup.a(((ForEachGroup)object).getActionExpression(), forEachGroup, itemType, false);
                return;
            }
            ForEachGroup.a(((ForEachGroup)object).getSelectExpression(), forEachGroup, itemType, bl2);
            ForEachGroup.a(((ForEachGroup)object).getGroupingKey(), forEachGroup, itemType, bl2);
            if (((ForEachGroup)object).getSortKeyDefinitions() == null) return;
            Iterator<SortKeyDefinition> iterator = ((ForEachGroup)object).getSortKeyDefinitions().iterator();
            while (iterator.hasNext()) {
                object = iterator.next();
                ForEachGroup.a(((SortKeyDefinition)object).getOrder(), forEachGroup, itemType, bl2);
                ForEachGroup.a(((SortKeyDefinition)object).getCaseOrder(), forEachGroup, itemType, bl2);
                ForEachGroup.a(((SortKeyDefinition)object).getDataTypeExpression(), forEachGroup, itemType, bl2);
                ForEachGroup.a(((SortKeyDefinition)object).getLanguage(), forEachGroup, itemType, bl2);
                ForEachGroup.a(((SortKeyDefinition)object).getCollationNameExpression(), forEachGroup, itemType, bl2);
                ForEachGroup.a(((SortKeyDefinition)object).getOrder(), forEachGroup, itemType, bl2);
            }
            return;
        }
        object = ((Expression)object).operands().iterator();
        while (object.hasNext()) {
            Operand operand = object.next();
            ForEachGroup.a(operand.getChildExpression(), forEachGroup, itemType, bl2 || operand.isHigherOrder());
        }
    }

    @Override
    public Expression optimize(ExpressionVisitor object, ContextItemStaticInfo contextItemStaticInfo) {
        Object object2;
        this.g.optimize((ExpressionVisitor)object, contextItemStaticInfo);
        Object object3 = this.getSelectExpression().getItemType();
        object3 = ((ExpressionVisitor)object).getConfiguration().makeContextItemStaticInfo((ItemType)object3, false);
        ((ContextItemStaticInfo)object3).setContextSettingExpression(this.getSelectExpression());
        this.h.optimize((ExpressionVisitor)object, (ContextItemStaticInfo)object3);
        this.i.optimize((ExpressionVisitor)object, (ContextItemStaticInfo)object3);
        if (Literal.isEmptySequence(this.getSelectExpression())) {
            return this.getSelectExpression();
        }
        if (Literal.isEmptySequence(this.getActionExpression())) {
            return this.getActionExpression();
        }
        if (this.getSortKeyDefinitions() != null) {
            for (Object object4 : this.getSortKeyDefinitions()) {
                object2 = ((SortKeyDefinition)object4).getSortKey();
                object2 = ((Expression)object2).optimize((ExpressionVisitor)object, (ContextItemStaticInfo)object3);
                ((SortKeyDefinition)object4).setSortKey((Expression)object2, true);
            }
        }
        if (this.j != null) {
            this.j.optimize((ExpressionVisitor)object, contextItemStaticInfo);
        }
        if (this.c == null && this.getCollationNameExpression() instanceof StringLiteral) {
            String string = ((StringLiteral)this.getCollationNameExpression()).getStringValue();
            try {
                Object object4;
                object4 = new URI(string);
                if (!((URI)object4).isAbsolute()) {
                    object4 = this.getStaticBaseURI().resolve((URI)object4);
                    object2 = ((URI)object4).toString();
                    this.setCollationNameExpression(new StringLiteral((CharSequence)object2));
                    this.c = ((ExpressionVisitor)object).getConfiguration().getCollation((String)object2);
                    if (this.c == null) {
                        object = new XPathException("Unknown collation " + Err.wrap(((URI)object4).toString(), 7));
                        ((XPathException)object).setErrorCode("XTDE1110");
                        ((XPathException)object).setLocation(this.getLocation());
                        throw object;
                    }
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                object = new XPathException("Collation name '" + this.getCollationNameExpression() + "' is not a valid URI");
                ((XPathException)object).setErrorCode("XTDE1110");
                ((XPathException)object).setLocation(this.getLocation());
                throw object;
            }
        }
        return this;
    }

    @Override
    public Expression copy(RebindingMap rebindingMap) {
        SortKeyDefinition[] sortKeyDefinitionArray = null;
        if (this.getSortKeyDefinitions() != null) {
            sortKeyDefinitionArray = new SortKeyDefinition[this.getSortKeyDefinitions().size()];
            for (int i2 = 0; i2 < this.getSortKeyDefinitions().size(); ++i2) {
                sortKeyDefinitionArray[i2] = this.getSortKeyDefinitions().getSortKeyDefinition(i2).copy(rebindingMap);
            }
        }
        ForEachGroup forEachGroup = new ForEachGroup(this.getSelectExpression().copy(rebindingMap), this.getActionExpression().copy(rebindingMap), this.a, this.getGroupingKey().copy(rebindingMap), this.c, this.getCollationNameExpression().copy(rebindingMap), sortKeyDefinitionArray == null ? null : new SortKeyDefinitionList(sortKeyDefinitionArray));
        ExpressionTool.copyLocationInfo(this, forEachGroup);
        forEachGroup.setComposite(this.isComposite());
        ForEachGroup forEachGroup2 = forEachGroup;
        ForEachGroup.a(forEachGroup2, forEachGroup2, this.getSelectExpression().getItemType(), false);
        return forEachGroup;
    }

    @Override
    public ItemType getItemType() {
        return this.getActionExpression().getItemType();
    }

    @Override
    public int computeDependencies() {
        int n2 = 0 | this.getSelectExpression().getDependencies();
        n2 |= this.getGroupingKey().getDependencies() & 0xFFFFFFE1;
        n2 |= this.getActionExpression().getDependencies() & 0xFFFFFFC1;
        if (this.getSortKeyDefinitions() != null) {
            for (SortKeyDefinition sortKeyDefinition : this.getSortKeyDefinitions()) {
                n2 |= sortKeyDefinition.getSortKey().getDependencies() & 0xFFFFFFE1;
                Expression expression = sortKeyDefinition.getCaseOrder();
                if (expression != null && !(expression instanceof Literal)) {
                    n2 |= expression.getDependencies();
                }
                if ((expression = sortKeyDefinition.getDataTypeExpression()) != null && !(expression instanceof Literal)) {
                    n2 |= expression.getDependencies();
                }
                if ((expression = sortKeyDefinition.getLanguage()) == null || expression instanceof Literal) continue;
                n2 |= expression.getDependencies();
            }
        }
        if (this.getCollationNameExpression() != null) {
            n2 |= this.getCollationNameExpression().getDependencies();
        }
        return n2;
    }

    @Override
    public int computeSpecialProperties() {
        int n2 = super.computeSpecialProperties();
        return n2 |= this.getActionExpression().getSpecialProperties() & 0x8000000;
    }

    @Override
    public final boolean mayCreateNewNodes() {
        int n2 = this.getActionExpression().getSpecialProperties();
        return (n2 & 0x800000) == 0;
    }

    @Override
    public String getStreamerName() {
        return "ForEachGroup";
    }

    @Override
    public PathMap.PathMapNodeSet addToPathMap(PathMap pathMap, PathMap.PathMapNodeSet pathMapNodeSet) {
        PathMap.PathMapNodeSet pathMapNodeSet2 = this.getSelectExpression().addToPathMap(pathMap, pathMapNodeSet);
        if (this.getCollationNameExpression() != null) {
            this.getCollationNameExpression().addToPathMap(pathMap, pathMapNodeSet);
        }
        if (this.getSortKeyDefinitions() != null) {
            for (SortKeyDefinition sortKeyDefinition : this.getSortKeyDefinitions()) {
                sortKeyDefinition.getSortKey().addToPathMap(pathMap, pathMapNodeSet2);
                Expression expression = sortKeyDefinition.getOrder();
                if (expression != null) {
                    expression.addToPathMap(pathMap, pathMapNodeSet);
                }
                if ((expression = sortKeyDefinition.getCaseOrder()) != null) {
                    expression.addToPathMap(pathMap, pathMapNodeSet);
                }
                if ((expression = sortKeyDefinition.getDataTypeExpression()) != null) {
                    expression.addToPathMap(pathMap, pathMapNodeSet);
                }
                if ((expression = sortKeyDefinition.getLanguage()) != null) {
                    expression.addToPathMap(pathMap, pathMapNodeSet);
                }
                if ((expression = sortKeyDefinition.getCollationNameExpression()) == null) continue;
                expression.addToPathMap(pathMap, pathMapNodeSet);
            }
        }
        return this.getActionExpression().addToPathMap(pathMap, pathMapNodeSet2);
    }

    @Override
    public void checkPermittedContents(SchemaType schemaType, boolean bl2) {
        this.getActionExpression().checkPermittedContents(schemaType, false);
    }

    @Override
    public TailCall processLeavingTail(XPathContext xPathContext) {
        Object object = xPathContext.getController();
        assert (object != null);
        PipelineConfiguration pipelineConfiguration = xPathContext.getReceiver().getPipelineConfiguration();
        GroupIterator groupIterator = this.b(xPathContext);
        XPathContextMajor xPathContextMajor = xPathContext.newContext();
        xPathContextMajor.setOrigin(this);
        FocusIterator focusIterator = xPathContextMajor.trackFocus(groupIterator);
        xPathContextMajor.setCurrentGroupIterator(groupIterator);
        xPathContextMajor.setCurrentTemplateRule(null);
        pipelineConfiguration.setXPathContext(xPathContextMajor);
        if (((Controller)object).isTracing()) {
            object = ((Controller)object).getTraceListener();
            assert (object != null);
            while ((groupIterator = focusIterator.next()) != null) {
                object.startCurrentItem((Item)((Object)groupIterator));
                this.getActionExpression().process(xPathContextMajor);
                object.endCurrentItem((Item)((Object)groupIterator));
            }
        } else {
            while (focusIterator.next() != null) {
                this.getActionExpression().process(xPathContextMajor);
            }
        }
        pipelineConfiguration.setXPathContext(xPathContext);
        return null;
    }

    public Expression getCollationNameExpression() {
        if (this.j == null) {
            return null;
        }
        return this.j.getChildExpression();
    }

    private StringCollator a(XPathContext object) {
        if (this.getCollationNameExpression() != null) {
            Object object2 = (StringValue)this.getCollationNameExpression().evaluateItem((XPathContext)object);
            assert (object2 != null);
            object2 = ((AtomicValue)object2).getStringValue();
            try {
                return object.getConfiguration().getCollation((String)object2, this.getStaticBaseURIString(), "FOCH0002");
            }
            catch (XPathException xPathException) {
                object = xPathException;
                xPathException.setLocation(this.getLocation());
                throw object;
            }
        }
        return CodepointCollator.getInstance();
    }

    private GroupIterator b(XPathContext xPathContext) {
        ForEachGroup forEachGroup = this;
        return forEachGroup.getGroupIterator(forEachGroup.getSelectExpression(), xPathContext);
    }

    public GroupIterator getGroupIterator(Expression object, XPathContext xPathContext) {
        XPathContextMinor xPathContextMinor;
        AtomicComparer[] atomicComparerArray;
        switch (this.a) {
            case 0: {
                atomicComparerArray = this.c;
                if (this.c == null) {
                    atomicComparerArray = this.a(xPathContext);
                }
                xPathContextMinor = xPathContext.newMinorContext();
                FocusIterator<?> focusIterator = xPathContextMinor.trackFocus(((Expression)object).iterate(xPathContext));
                object = new GroupByIterator(focusIterator, this.getGroupingKey(), xPathContextMinor, (StringCollator)atomicComparerArray, this.e);
                break;
            }
            case 1: {
                atomicComparerArray = this.c;
                if (atomicComparerArray == null) {
                    atomicComparerArray = this.a(xPathContext);
                }
                object = new GroupAdjacentIterator((Expression)object, this.getGroupingKey(), xPathContext, (StringCollator)atomicComparerArray, this.e);
                break;
            }
            case 2: {
                object = new GroupStartingIterator((Expression)object, (Pattern)this.getGroupingKey(), xPathContext);
                break;
            }
            case 3: {
                object = new GroupEndingIterator((Expression)object, (Pattern)this.getGroupingKey(), xPathContext);
                break;
            }
            default: {
                throw new AssertionError((Object)"Unknown grouping algorithm");
            }
        }
        if (this.getSortKeyDefinitions() != null) {
            atomicComparerArray = this.d;
            xPathContextMinor = xPathContext.newMinorContext();
            if (atomicComparerArray == null) {
                atomicComparerArray = new AtomicComparer[this.getSortKeyDefinitions().size()];
                for (int i2 = 0; i2 < this.getSortKeyDefinitions().size(); ++i2) {
                    atomicComparerArray[i2] = this.getSortKeyDefinitions().getSortKeyDefinition(i2).makeComparator(xPathContextMinor);
                }
            }
            object = new SortedGroupIterator(xPathContextMinor, (GroupIterator)object, this, atomicComparerArray);
        }
        return object;
    }

    @Override
    public SequenceIterator<?> iterate(XPathContext xPathContext) {
        GroupIterator groupIterator = this.b(xPathContext);
        xPathContext = xPathContext.newContext();
        ((XPathContextMajor)xPathContext).setOrigin(this);
        ((XPathContextMinor)xPathContext).trackFocus(groupIterator);
        ((XPathContextMajor)xPathContext).setCurrentGroupIterator(groupIterator);
        ((XPathContextMajor)xPathContext).setCurrentTemplateRule(null);
        return new ContextMappingIterator(this, xPathContext);
    }

    @Override
    public SequenceIterator<?> map(XPathContext xPathContext) {
        return this.getActionExpression().iterate(xPathContext);
    }

    @Override
    public AtomicValue evaluateSortKey(int n2, XPathContext xPathContext) {
        return (AtomicValue)this.getSortKeyDefinitions().getSortKeyDefinition(n2).getSortKey().evaluateItem(xPathContext);
    }

    public SortKeyDefinitionList getSortKeyDefinitionList() {
        if (this.k == null) {
            return null;
        }
        return (SortKeyDefinitionList)this.k.getChildExpression();
    }

    @Override
    public void export(ExpressionPresenter expressionPresenter) {
        String string;
        expressionPresenter.startElement("forEachGroup", this);
        byte by = this.a;
        switch (by) {
            case 0: {
                string = "by";
                break;
            }
            case 1: {
                string = "adjacent";
                break;
            }
            case 2: {
                string = "starting";
                break;
            }
            case 3: {
                string = "ending";
                break;
            }
            default: {
                string = "** unknown algorithm **";
            }
        }
        expressionPresenter.emitAttribute("algorithm", string);
        String string2 = "";
        if (this.e) {
            string2 = "c";
        }
        if (this.isInFork()) {
            string2 = string2 + "k";
        }
        if (!string2.isEmpty()) {
            expressionPresenter.emitAttribute("flags", string2);
        }
        expressionPresenter.setChildRole("select");
        this.getSelectExpression().export(expressionPresenter);
        if (this.a == 0 || this.a == 1) {
            expressionPresenter.setChildRole("key");
            this.getGroupingKey().export(expressionPresenter);
        } else {
            expressionPresenter.setChildRole("match");
            this.getGroupingKey().export(expressionPresenter);
        }
        if (this.getSortKeyDefinitions() != null) {
            expressionPresenter.setChildRole("sort");
            ((Expression)this.getSortKeyDefinitionList()).export(expressionPresenter);
        }
        if (this.getCollationNameExpression() != null) {
            expressionPresenter.setChildRole("collation");
            this.getCollationNameExpression().export(expressionPresenter);
        }
        expressionPresenter.setChildRole("content");
        this.getActionExpression().export(expressionPresenter);
        expressionPresenter.endElement();
    }

    public void setSelect(Expression expression) {
        this.g.setChildExpression(expression);
    }

    public void setAction(Expression expression) {
        this.h.setChildExpression(expression);
    }

    public void setKey(Expression expression) {
        this.i.setChildExpression(expression);
    }

    public void setCollationNameExpression(Expression expression) {
        if (this.j == null) {
            this.j = new Operand(this, expression, OperandRole.SINGLE_ATOMIC);
            return;
        }
        this.j.setChildExpression(expression);
    }

    public void setSortKeyDefinitions(SortKeyDefinitionList sortKeyDefinitionList) {
        if (this.k == null) {
            this.k = new Operand(this, sortKeyDefinitionList, OperandRole.SINGLE_ATOMIC);
            return;
        }
        this.k.setChildExpression(sortKeyDefinitionList);
    }
}

