/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.instruct;

import java.util.Arrays;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.Instruction;
import net.sf.saxon.expr.instruct.TailCall;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.ErrorType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;

public class Fork
extends Instruction {
    private Operand[] a;

    public Fork(Operand[] operandArray) {
        this.a = new Operand[operandArray.length];
        for (int i2 = 0; i2 < operandArray.length; ++i2) {
            this.a[i2] = new Operand(this, operandArray[i2].getChildExpression(), OperandRole.SAME_FOCUS_ACTION);
        }
    }

    public Fork(Expression[] expressionArray) {
        this.a = new Operand[expressionArray.length];
        for (int i2 = 0; i2 < expressionArray.length; ++i2) {
            this.a[i2] = new Operand(this, expressionArray[i2], OperandRole.SAME_FOCUS_ACTION);
        }
    }

    @Override
    public Iterable<Operand> operands() {
        return Arrays.asList(this.a);
    }

    @Override
    public int getInstructionNameCode() {
        return 156;
    }

    public int getSize() {
        return this.a.length;
    }

    public Expression getProng(int n2) {
        return this.a[n2].getChildExpression();
    }

    @Override
    public ItemType getItemType() {
        if (this.getSize() == 0) {
            return ErrorType.getInstance();
        }
        ItemType object = null;
        for (Operand operand : ((Expression)this).operands()) {
            ItemType object2 = operand.getChildExpression().getItemType();
            if (!((object = object == null ? object2 : Type.getCommonSuperType(object, object2)) instanceof AnyItemType)) continue;
            return object;
        }
        return object;
    }

    @Override
    public String getStreamerName() {
        return "Fork";
    }

    @Override
    public Expression copy(RebindingMap rebindingMap) {
        Expression[] expressionArray = new Expression[this.getSize()];
        int n2 = 0;
        for (Operand operand : ((Expression)this).operands()) {
            expressionArray[n2++] = operand.getChildExpression().copy(rebindingMap);
        }
        Fork fork = new Fork(expressionArray);
        ExpressionTool.copyLocationInfo(this, fork);
        return fork;
    }

    @Override
    public TailCall processLeavingTail(XPathContext xPathContext) {
        for (Operand operand : ((Expression)this).operands()) {
            operand.getChildExpression().process(xPathContext);
        }
        return null;
    }

    @Override
    public void export(ExpressionPresenter expressionPresenter) {
        expressionPresenter.startElement("fork", this);
        for (Operand operand : ((Expression)this).operands()) {
            operand.getChildExpression().export(expressionPresenter);
        }
        expressionPresenter.endElement();
    }
}

