/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.instruct;

import javax.xml.transform.TransformerException;
import net.sf.saxon.Controller;
import net.sf.saxon.expr.Component;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.Bindery;
import net.sf.saxon.expr.instruct.GlobalVariable;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.trans.XPathException;

public final class GlobalParam
extends GlobalVariable {
    private boolean a;

    public final void setImplicitlyRequiredParam(boolean bl2) {
        this.a = bl2;
    }

    public final boolean isImplicitlyRequiredParam() {
        return this.a;
    }

    @Override
    public final GroundedValue<?> evaluateVariable(XPathContext xPathContext, Component object) {
        Controller controller = xPathContext.getController();
        assert (controller != null);
        Bindery bindery = controller.getBindery(this.getPackageData());
        GroundedValue<?> groundedValue = bindery.getGlobalVariableValue(this);
        if (groundedValue != null) {
            if (groundedValue instanceof Bindery.FailureValue) {
                throw (XPathException)((Bindery.FailureValue)groundedValue).getObject();
            }
            return groundedValue;
        }
        groundedValue = controller.getConvertedParameter(this.getVariableQName(), this.getRequiredType(), xPathContext);
        if (groundedValue != null) {
            return bindery.saveGlobalVariableValue(this, groundedValue);
        }
        if (this.isRequiredParam()) {
            object = new XPathException("No value supplied for required parameter $" + this.getVariableQName().getDisplayName());
            ((XPathException)object).setXPathContext(xPathContext);
            ((TransformerException)object).setLocator(this);
            ((XPathException)object).setErrorCode(this.getPackageData().getHostLanguage() == 50 ? "XTDE0050" : "XPDY0002");
            throw object;
        }
        if (this.isImplicitlyRequiredParam()) {
            object = new XPathException("A value must be supplied for parameter $" + this.getVariableQName().getDisplayName() + " because there is no default value for the required type");
            ((XPathException)object).setXPathContext(xPathContext);
            ((TransformerException)object).setLocator(this);
            ((XPathException)object).setErrorCode("XTDE0700");
            throw object;
        }
        return this.actuallyEvaluate(xPathContext, (Component)object);
    }

    @Override
    public final GroundedValue<?> evaluateVariable(XPathContext xPathContext) {
        return ((GlobalVariable)this).evaluateVariable(xPathContext, null);
    }

    @Override
    protected final String getFlags() {
        String string = super.getFlags();
        if (this.isImplicitlyRequiredParam()) {
            string = string + "i";
        }
        return string;
    }
}

