/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.instruct;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import net.sf.saxon.Controller;
import net.sf.saxon.PreparedStylesheet;
import net.sf.saxon.expr.Binding;
import net.sf.saxon.expr.BindingReference;
import net.sf.saxon.expr.Component;
import net.sf.saxon.expr.ContextOriginator;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.VariableReference;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.XPathContextMinor;
import net.sf.saxon.expr.instruct.Actor;
import net.sf.saxon.expr.instruct.Bindery;
import net.sf.saxon.expr.instruct.Executable;
import net.sf.saxon.expr.instruct.GlobalParam;
import net.sf.saxon.expr.instruct.SlotManager;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.expr.parser.TypeChecker;
import net.sf.saxon.om.FocusIterator;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.query.Declaration;
import net.sf.saxon.query.XQueryFunction;
import net.sf.saxon.query.XQueryFunctionLibrary;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trace.InstructionInfo;
import net.sf.saxon.trans.SymbolicName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.ManualIterator;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.SequenceType;

public class GlobalVariable
extends Actor
implements Binding,
ContextOriginator,
Declaration,
InstructionInfo {
    protected List<BindingReference> references = new ArrayList<BindingReference>(10);
    private Expression a;
    private StructuredQName b;
    private SequenceType c;
    private boolean d;
    private boolean e = false;
    private boolean f = false;
    private GlobalVariable g;
    private int h;
    private boolean i;
    private boolean j;

    public void init(Expression expression, StructuredQName structuredQName) {
        this.a = expression;
        this.b = structuredQName;
        this.setBody(expression);
    }

    @Override
    public SymbolicName getSymbolicName() {
        return new SymbolicName(206, this.b);
    }

    public void setSelectExpression(Expression expression) {
        this.a = expression;
        this.setBody(expression);
    }

    public Expression getSelectExpression() {
        return this.a;
    }

    public void setStatic(boolean bl2) {
        this.j = bl2;
    }

    public boolean isStatic() {
        return this.j;
    }

    public void setRequiredType(SequenceType sequenceType) {
        this.c = sequenceType;
    }

    @Override
    public SequenceType getRequiredType() {
        return this.c;
    }

    public void setOriginalVariable(GlobalVariable globalVariable) {
        this.g = globalVariable;
    }

    public GlobalVariable getOriginalVariable() {
        return this.g;
    }

    public GlobalVariable getUltimateOriginalVariable() {
        if (this.g == null) {
            return this;
        }
        return this.g.getUltimateOriginalVariable();
    }

    public void setUnused(boolean bl2) {
        this.h = -9234;
    }

    public boolean isUnused() {
        return this.h == -9234;
    }

    public boolean isPrivate() {
        return this.e;
    }

    public void setPrivate(boolean bl2) {
        this.e = bl2;
    }

    public void setAssignable(boolean bl2) {
        this.f = bl2;
    }

    @Override
    public final boolean isAssignable() {
        return this.f;
    }

    @Override
    public int getConstructType() {
        return 206;
    }

    @Override
    public StructuredQName getObjectName() {
        return this.getVariableQName();
    }

    @Override
    public Object getProperty(String string) {
        return null;
    }

    @Override
    public Iterator<String> getProperties() {
        List list = Collections.emptyList();
        return list.iterator();
    }

    public int getHostLanguage() {
        return this.getPackageData().getHostLanguage();
    }

    public void setIndexedVariable() {
        this.d = true;
    }

    public boolean isIndexedVariable() {
        return this.d;
    }

    public void setContainsLocals(SlotManager slotManager) {
        this.setStackFrameMap(slotManager);
    }

    @Override
    public boolean isGlobal() {
        return true;
    }

    public void registerReference(BindingReference bindingReference) {
        this.references.add(bindingReference);
    }

    public Iterator iterateReferences() {
        return this.references.iterator();
    }

    public int getBinderySlotNumber() {
        return this.h;
    }

    public void setBinderySlotNumber(int n2) {
        if (!this.isUnused()) {
            this.h = n2;
        }
    }

    public void setRequiredParam(boolean bl2) {
        this.i = bl2;
    }

    public boolean isRequiredParam() {
        return this.i;
    }

    public void compile(Executable executable, int n2) {
        Object object = this;
        object = ((Actor)object).getPackageData().getConfiguration().getTypeHierarchy();
        this.setBinderySlotNumber(n2);
        if (this instanceof GlobalParam) {
            GlobalVariable globalVariable = this;
            globalVariable.setRequiredParam(globalVariable.a == null);
        }
        SequenceType sequenceType = this.getRequiredType();
        for (BindingReference bindingReference : this.references) {
            int n3;
            bindingReference.fixup(this);
            GroundedValue<?> groundedValue = null;
            int n4 = 0;
            Expression expression = this.getSelectExpression();
            if (expression instanceof Literal && !(this instanceof GlobalParam) && ((n3 = ((TypeHierarchy)object).relationship(expression.getItemType(), sequenceType.getPrimaryType())) == 0 || n3 == 2)) {
                groundedValue = ((Literal)expression).getValue();
                sequenceType = SequenceType.makeSequenceType(SequenceTool.getItemType(groundedValue, (TypeHierarchy)object), SequenceTool.getCardinality(groundedValue));
            }
            if (expression != null) {
                n4 = expression.getSpecialProperties();
            }
            bindingReference.setStaticType(sequenceType, groundedValue, n4 |= 0x800000);
        }
        if (this.isRequiredParam()) {
            executable.registerGlobalParameter((GlobalParam)this);
        }
    }

    public void typeCheck(ExpressionVisitor object) {
        Expression expression = this.getSelectExpression();
        if (expression != null) {
            expression.checkForUpdatingSubexpressions();
            if (expression.isUpdatingExpression()) {
                throw new XPathException("Initializing expression for global variable must not be an updating expression", "XUST0001");
            }
            Iterator<BindingReference> iterator = new RoleDiagnostic(3, this.getVariableQName().getDisplayName(), 0);
            Object object2 = this;
            object2 = ((Actor)object2).getPackageData().getConfiguration().makeContextItemStaticInfo(AnyItemType.getInstance(), true);
            iterator = TypeChecker.strictTypeCheck(expression.simplify().typeCheck((ExpressionVisitor)object, (ContextItemStaticInfo)object2), this.getRequiredType(), (RoleDiagnostic)((Object)iterator), ((ExpressionVisitor)object).getStaticContext());
            iterator = ((Expression)((Object)iterator)).optimize((ExpressionVisitor)object, (ContextItemStaticInfo)object2);
            this.setSelectExpression((Expression)((Object)iterator));
            object2 = this;
            object = ((Actor)object2).getPackageData().getConfiguration().makeSlotManager();
            int n2 = ExpressionTool.allocateSlots((Expression)((Object)iterator), 0, (SlotManager)object);
            if (n2 > 0) {
                this.setContainsLocals((SlotManager)object);
            }
            if (this.getRequiredType() == SequenceType.ANY_SEQUENCE && !(this instanceof GlobalParam)) {
                try {
                    object = expression.getItemType();
                    n2 = expression.getCardinality();
                    this.setRequiredType(SequenceType.makeSequenceType((ItemType)object, n2));
                    GroundedValue<?> groundedValue = null;
                    if (iterator instanceof Literal) {
                        groundedValue = ((Literal)((Object)iterator)).getValue();
                    }
                    for (BindingReference bindingReference : this.references) {
                        if (!(bindingReference instanceof VariableReference)) continue;
                        ((VariableReference)bindingReference).refineVariableType((ItemType)object, n2, groundedValue, expression.getSpecialProperties());
                    }
                    return;
                }
                catch (Exception exception) {}
            }
        }
    }

    public void lookForCycles(Stack<Object> stack, XQueryFunctionLibrary xQueryFunctionLibrary) {
        if (stack.contains(this)) {
            Object object;
            int n2 = stack.indexOf(this);
            stack.push(this);
            StringBuilder stringBuilder = new StringBuilder("Circular definition of global variable: $" + this.getVariableQName().getDisplayName());
            for (int i2 = n2; i2 < stack.size() - 1; ++i2) {
                if (i2 != n2) {
                    stringBuilder.append(", which");
                }
                if (stack.get(i2 + 1) instanceof GlobalVariable) {
                    object = (GlobalVariable)stack.get(i2 + 1);
                    stringBuilder.append(" uses $").append(((GlobalVariable)object).getVariableQName().getDisplayName());
                    continue;
                }
                if (!(stack.get(i2 + 1) instanceof XQueryFunction)) continue;
                object = (XQueryFunction)stack.get(i2 + 1);
                stringBuilder.append(" calls ").append(((XQueryFunction)object).getFunctionName().getDisplayName()).append("#").append(((XQueryFunction)object).getNumberOfArguments()).append("()");
            }
            String string = stringBuilder.toString();
            string = string + '.';
            object = new XPathException(string);
            String string2 = this.getPackageData().getHostLanguage() == 50 ? "XTDE0640" : (n2 == 0 && stack.size() == 2 ? "XPST0008" : "XQDY0054");
            ((XPathException)object).setErrorCode(string2);
            ((XPathException)object).setIsStaticError(true);
            ((XPathException)object).setLocation(this.getLocation());
            throw object;
        }
        if (this.a != null) {
            Object object;
            stack.push(this);
            Object object2 = new ArrayList<Binding>(10);
            ExpressionTool.gatherReferencedVariables(this.a, object2);
            Object object3 = object2.iterator();
            while (object3.hasNext()) {
                object = (Binding)object3.next();
                if (!(object instanceof GlobalVariable)) continue;
                ((GlobalVariable)object).lookForCycles(stack, xQueryFunctionLibrary);
            }
            object3 = new ArrayList();
            ExpressionTool.gatherCalledFunctionNames(this.a, (List<SymbolicName>)object3);
            object = object3.iterator();
            while (object.hasNext()) {
                SymbolicName symbolicName = (SymbolicName)object.next();
                object2 = xQueryFunctionLibrary.getDeclarationByKey(symbolicName);
                if (stack.contains(object2)) continue;
                GlobalVariable.a((XQueryFunction)object2, stack, xQueryFunctionLibrary);
            }
            stack.pop();
        }
    }

    private static void a(XQueryFunction object, Stack<Object> stack, XQueryFunctionLibrary xQueryFunctionLibrary) {
        Object object2;
        Expression expression = ((XQueryFunction)object).getBody();
        stack.push(object);
        object = new ArrayList(10);
        ExpressionTool.gatherReferencedVariables(expression, (List<Binding>)object);
        object = object.iterator();
        while (object.hasNext()) {
            object2 = (Binding)object.next();
            if (!(object2 instanceof GlobalVariable)) continue;
            ((GlobalVariable)object2).lookForCycles(stack, xQueryFunctionLibrary);
        }
        object = new ArrayList();
        ExpressionTool.gatherCalledFunctionNames(expression, (List<SymbolicName>)object);
        object2 = object.iterator();
        while (object2.hasNext()) {
            object = (SymbolicName)object2.next();
            if (stack.contains(object = xQueryFunctionLibrary.getDeclarationByKey((SymbolicName)object))) continue;
            GlobalVariable.a((XQueryFunction)object, stack, xQueryFunctionLibrary);
        }
        stack.pop();
    }

    public GroundedValue<?> getSelectValue(XPathContext object, Component groundedValue) {
        if (this.a == null) {
            throw new AssertionError((Object)("*** No select expression for global variable $" + this.getVariableQName().getDisplayName() + "!!"));
        }
        if (this.a instanceof Literal) {
            return ((Literal)this.a).getValue();
        }
        try {
            Object object2 = object.getController();
            object2 = ((Controller)object2).getExecutable();
            boolean bl2 = true;
            if (object2 instanceof PreparedStylesheet) {
                bl2 = groundedValue == null || ((Component)((Object)groundedValue)).getDeclaringPackage() == ((PreparedStylesheet)object2).getTopLevelPackage();
            }
            object2 = object.newCleanContext();
            ((XPathContextMajor)object2).setOrigin(this);
            if (bl2) {
                object = new ManualIterator(object.getController().getGlobalContextItem());
                ((XPathContextMinor)object2).setCurrentIterator((FocusIterator<?>)object);
            } else {
                ((XPathContextMinor)object2).setCurrentIterator(null);
            }
            if (this.getStackFrameMap() != null) {
                ((XPathContextMajor)object2).openStackFrame(this.getStackFrameMap());
            }
            ((XPathContextMajor)object2).setCurrentComponent((Component)((Object)groundedValue));
            int n2 = ((XPathContextMinor)object2).getTemporaryOutputState();
            ((XPathContextMinor)object2).setTemporaryOutputState(206);
            ((XPathContextMinor)object2).setCurrentOutputUri(null);
            groundedValue = this.d ? ((XPathContextMinor)object2).getConfiguration().makeSequenceExtent(this.a, 10000, (XPathContext)object2) : this.a.iterate((XPathContext)object2).materialize();
            ((XPathContextMinor)object2).setTemporaryOutputState(n2);
            return groundedValue;
        }
        catch (XPathException xPathException) {
            if (!this.getVariableQName().hasURI("http://saxon.sf.net/generated-variable")) {
                xPathException.setIsGlobalError(true);
            }
            throw xPathException;
        }
    }

    public GroundedValue<?> evaluateVariable(XPathContext xPathContext) {
        GroundedValue<?> groundedValue = xPathContext.getController();
        assert (groundedValue != null);
        groundedValue = ((Controller)((Object)groundedValue)).getBindery(this.getPackageData());
        if ((groundedValue = ((Bindery)((Object)groundedValue)).getGlobalVariable(this.getBinderySlotNumber())) != null) {
            return groundedValue;
        }
        return this.actuallyEvaluate(xPathContext, null);
    }

    public GroundedValue evaluateVariable(XPathContext xPathContext, Component component) {
        GroundedValue<?> groundedValue = xPathContext.getController();
        assert (groundedValue != null);
        if ((groundedValue = ((Controller)((Object)groundedValue)).getBindery(this.getPackageData())) == null) {
            throw new AssertionError();
        }
        if ((groundedValue = ((Bindery)((Object)groundedValue)).getGlobalVariable(this.getBinderySlotNumber())) != null) {
            if (groundedValue instanceof Bindery.FailureValue) {
                throw (XPathException)((Bindery.FailureValue)groundedValue).getObject();
            }
            return groundedValue;
        }
        return this.actuallyEvaluate(xPathContext, component);
    }

    protected GroundedValue<?> actuallyEvaluate(XPathContext xPathContext, Component object) {
        Controller controller = xPathContext.getController();
        assert (controller != null);
        Bindery bindery = controller.getBindery(this.getPackageData());
        try {
            GlobalVariable.setDependencies(this, xPathContext);
            boolean bl2 = bindery.setExecuting(this);
            if (!bl2) {
                return bindery.getGlobalVariable(this.getBinderySlotNumber());
            }
            object = this.getSelectValue(xPathContext, (Component)object);
            if (this.d) {
                object = controller.getConfiguration().obtainOptimizer().makeIndexedValue(object.iterate());
            }
            return bindery.saveGlobalVariableValue(this, (GroundedValue<?>)object);
        }
        catch (XPathException xPathException) {
            bindery.setNotExecuting(this);
            if (xPathException instanceof XPathException.Circularity) {
                object = this.getPackageData().getHostLanguage() == 50 ? "XTDE0640" : "XQDY0054";
                xPathException.setErrorCode((String)object);
                xPathException.setXPathContext(xPathContext);
                xPathException.setIsGlobalError(true);
                bindery.setGlobalVariable(this, new Bindery.FailureValue(xPathException));
                xPathException.setLocation(this.getLocation());
                throw xPathException;
            }
            throw xPathException;
        }
    }

    protected static void setDependencies(GlobalVariable globalVariable, XPathContext xPathContext) {
        Controller controller = xPathContext.getController();
        if (!(xPathContext instanceof XPathContextMajor)) {
            xPathContext = GlobalVariable.a(xPathContext);
        }
        while (xPathContext != null) {
            do {
                ContextOriginator contextOriginator;
                if (!((contextOriginator = ((XPathContextMajor)xPathContext).getOrigin()) instanceof GlobalVariable)) continue;
                controller.registerGlobalVariableDependency((GlobalVariable)contextOriginator, globalVariable);
                return;
            } while ((xPathContext = GlobalVariable.a(xPathContext)) != null);
        }
    }

    private static XPathContextMajor a(XPathContext xPathContext) {
        for (xPathContext = xPathContext.getCaller(); xPathContext != null && !(xPathContext instanceof XPathContextMajor); xPathContext = xPathContext.getCaller()) {
        }
        return (XPathContextMajor)xPathContext;
    }

    @Override
    public IntegerValue[] getIntegerBoundsForVariable() {
        if (this.a == null) {
            return null;
        }
        return this.a.getIntegerBounds();
    }

    public int getLocalSlotNumber() {
        return 0;
    }

    public void setVariableQName(StructuredQName structuredQName) {
        this.b = structuredQName;
    }

    @Override
    public StructuredQName getVariableQName() {
        return this.b;
    }

    @Override
    public void addReference(VariableReference variableReference, boolean bl2) {
    }

    @Override
    public int getComponentKind() {
        return 206;
    }

    @Override
    public void export(ExpressionPresenter expressionPresenter) {
        boolean bl2 = this instanceof GlobalParam && !this.isStatic();
        expressionPresenter.startElement(bl2 ? "globalParam" : "globalVariable");
        expressionPresenter.emitAttribute("name", this.getVariableQName());
        expressionPresenter.emitAttribute("type", this.getRequiredType().toExportString());
        Object object = (ExpressionPresenter.ExportOptions)expressionPresenter.getOptions();
        if (((ExpressionPresenter.ExportOptions)object).target != null && ((ExpressionPresenter.ExportOptions)object).target.equals("JS") && ((ExpressionPresenter.ExportOptions)object).targetVersion == 2) {
            expressionPresenter.emitAttribute("typeJ", this.getRequiredType().toExportString2());
        }
        expressionPresenter.emitAttribute("line", "" + this.getLineNumber());
        expressionPresenter.emitAttribute("module", this.getSystemId());
        if (this.getStackFrameMap() != null) {
            expressionPresenter.emitAttribute("slots", "" + this.getStackFrameMap().getNumberOfVariables());
        }
        if (this.getDeclaringComponent() != null && (object = this.getDeclaringComponent().getVisibility()) != null) {
            expressionPresenter.emitAttribute("visibility", ((Enum)object).toString());
        }
        if (!((String)(object = this.getFlags())).isEmpty()) {
            expressionPresenter.emitAttribute("flags", (String)object);
        }
        if ("JS".equals(((ExpressionPresenter.ExportOptions)expressionPresenter.getOptions()).target)) {
            int n2 = ((ExpressionPresenter.ExportOptions)expressionPresenter.getOptions()).targetVersion;
            expressionPresenter.emitAttribute("jsAcceptor", this.getRequiredType().getPrimaryType().generateJavaScriptItemTypeAcceptor("XTTE0590", n2));
            expressionPresenter.emitAttribute("jsCardCheck", Cardinality.generateJavaScriptChecker(this.getRequiredType().getCardinality()));
        }
        if (this.getSelectExpression() != null) {
            this.getSelectExpression().export(expressionPresenter);
        }
        expressionPresenter.endElement();
    }

    protected String getFlags() {
        String string = "";
        if (this.f) {
            string = string + "a";
        }
        if (this.d) {
            string = string + "x";
        }
        if (this.i) {
            string = string + "r";
        }
        return string;
    }
}

