/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.instruct;

import javax.xml.transform.SourceLocator;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.ParameterSet;
import net.sf.saxon.expr.instruct.TailCall;
import net.sf.saxon.expr.instruct.TailCallReturner;
import net.sf.saxon.expr.instruct.TerminationException;
import net.sf.saxon.expr.instruct.WithParam;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StandardNames;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.tree.iter.SingletonIterator;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;

public abstract class Instruction
extends Expression
implements TailCallReturner {
    @Override
    public int getImplementationMethod() {
        return 4;
    }

    @Override
    public boolean isInstruction() {
        return true;
    }

    public int getInstructionNameCode() {
        return -1;
    }

    @Override
    public String getExpressionName() {
        int n2 = this.getInstructionNameCode();
        if (n2 >= 0 & n2 < 1024) {
            return StandardNames.getDisplayName(n2);
        }
        return super.getExpressionName();
    }

    @Override
    public ItemType getItemType() {
        return Type.ITEM_TYPE;
    }

    @Override
    public int computeCardinality() {
        return 57344;
    }

    @Override
    public abstract Iterable<Operand> operands();

    @Override
    public abstract TailCall processLeavingTail(XPathContext var1);

    @Override
    public void process(XPathContext xPathContext) {
        try {
            for (TailCall tailCall = this.processLeavingTail(xPathContext); tailCall != null; tailCall = tailCall.processLeavingTail()) {
            }
            return;
        }
        catch (XPathException xPathException) {
            XPathException xPathException2 = xPathException;
            xPathException.maybeSetFailingExpression(this);
            xPathException2.maybeSetContext(xPathContext);
            throw xPathException2;
        }
    }

    public SourceLocator getSourceLocator() {
        return this.getLocation();
    }

    protected static XPathException dynamicError(Location location, XPathException xPathException, XPathContext xPathContext) {
        if (xPathException instanceof TerminationException) {
            return xPathException;
        }
        xPathException.maybeSetLocation(location);
        xPathException.maybeSetContext(xPathContext);
        return xPathException;
    }

    public static ParameterSet assembleParams(XPathContext xPathContext, WithParam[] withParamArray) {
        if (withParamArray == null || withParamArray.length == 0) {
            return null;
        }
        ParameterSet parameterSet = new ParameterSet(withParamArray.length);
        for (WithParam withParam : withParamArray) {
            parameterSet.put(withParam.getVariableQName(), withParam.getSelectValue(xPathContext), withParam.isTypeChecked());
        }
        return parameterSet;
    }

    public static ParameterSet assembleTunnelParams(XPathContext xPathContext, WithParam[] withParamArray) {
        ParameterSet parameterSet = xPathContext.getTunnelParameters();
        if (parameterSet == null) {
            return Instruction.assembleParams(xPathContext, withParamArray);
        }
        if (withParamArray == null || withParamArray.length == 0) {
            return parameterSet;
        }
        parameterSet = new ParameterSet(parameterSet, withParamArray.length);
        for (WithParam withParam : withParamArray) {
            parameterSet.put(withParam.getVariableQName(), withParam.getSelectValue(xPathContext), false);
        }
        return parameterSet;
    }

    @Override
    public int computeSpecialProperties() {
        int n2 = super.computeSpecialProperties();
        if (this.alwaysCreatesNewNodes()) {
            n2 |= 0x400000;
        }
        if (this.mayCreateNewNodes()) {
            return n2;
        }
        return n2 | 0x800000;
    }

    @Override
    public int getNetCost() {
        return 20;
    }

    public boolean mayCreateNewNodes() {
        return false;
    }

    public boolean alwaysCreatesNewNodes() {
        return false;
    }

    protected final boolean someOperandCreatesNewNodes() {
        for (Operand object : ((Expression)this).operands()) {
            Expression expression = object.getChildExpression();
            int n2 = expression.getSpecialProperties();
            if ((n2 & 0x800000) != 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public Item<?> evaluateItem(XPathContext xPathContext) {
        int n2 = ((Expression)this).getImplementationMethod();
        if ((n2 & 1) != 0) {
            throw new AssertionError((Object)("evaluateItem() is not implemented in the subclass " + this.getClass()));
        }
        if ((n2 & 2) != 0) {
            return ((Expression)this).iterate(xPathContext).next();
        }
        return ExpressionTool.getItemFromProcessMethod(this, xPathContext);
    }

    @Override
    public SequenceIterator<?> iterate(XPathContext object) {
        int n2 = ((Expression)this).getImplementationMethod();
        if ((n2 & 1) != 0) {
            if ((object = ((Expression)this).evaluateItem((XPathContext)object)) == null) {
                return EmptyIterator.emptyIterator();
            }
            return SingletonIterator.makeIterator(object);
        }
        if ((n2 & 2) != 0) {
            throw new AssertionError((Object)("iterate() is not implemented in the subclass " + this.getClass()));
        }
        return ExpressionTool.getIteratorFromProcessMethod(this, (XPathContext)object);
    }

    @Override
    public final CharSequence evaluateAsString(XPathContext object) {
        if ((object = ((Expression)this).evaluateItem((XPathContext)object)) == null) {
            return "";
        }
        return object.getStringValue();
    }

    @Override
    public int getConstructType() {
        return this.getInstructionNameCode();
    }

    public boolean isXSLT() {
        return this.getPackageData().getHostLanguage() == 50;
    }
}

