/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.instruct;

import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.expr.Binding;
import net.sf.saxon.expr.ContextSwitchingExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.OperandUsage;
import net.sf.saxon.expr.TryCatch;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.XPathContextMinor;
import net.sf.saxon.expr.instruct.BreakInstr;
import net.sf.saxon.expr.instruct.Instruction;
import net.sf.saxon.expr.instruct.LocalParam;
import net.sf.saxon.expr.instruct.LocalParamBlock;
import net.sf.saxon.expr.instruct.NextIteration;
import net.sf.saxon.expr.instruct.TailCall;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.lib.TraceListener;
import net.sf.saxon.om.FocusIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.ErrorType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.SequenceType;

public final class IterateInstr
extends Instruction
implements ContextSwitchingExpression {
    private Operand a;
    private Operand b;
    private Operand c;
    private Operand d;

    public IterateInstr(Expression expression2, LocalParamBlock localParamBlock, Expression expression3, Expression expression4) {
        if (expression4 == null) {
            expression4 = Literal.makeEmptySequence();
        }
        this.a = new Operand(this, expression2, OperandRole.FOCUS_CONTROLLING_SELECT);
        this.b = new Operand(this, expression3, OperandRole.FOCUS_CONTROLLED_ACTION);
        this.c = new Operand(this, localParamBlock, new OperandRole(16, OperandUsage.NAVIGATION, SequenceType.ANY_SEQUENCE, expression -> expression instanceof LocalParamBlock));
        this.d = new Operand(this, expression4, new OperandRole(2, OperandUsage.TRANSMISSION));
    }

    public final void setSelect(Expression expression) {
        this.a.setChildExpression(expression);
    }

    public final LocalParamBlock getInitiallyExp() {
        return (LocalParamBlock)this.c.getChildExpression();
    }

    public final void setInitiallyExp(LocalParamBlock localParamBlock) {
        this.c.setChildExpression(localParamBlock);
    }

    public final void setAction(Expression expression) {
        this.b.setChildExpression(expression);
    }

    public final Expression getOnCompletion() {
        return this.d.getChildExpression();
    }

    public final void setOnCompletion(Expression expression) {
        this.d.setChildExpression(expression);
    }

    @Override
    public final Iterable<Operand> operands() {
        return this.operandList(this.a, this.b, this.c, this.d);
    }

    @Override
    public final int getInstructionNameCode() {
        return 164;
    }

    @Override
    public final Expression getSelectExpression() {
        return this.a.getChildExpression();
    }

    @Override
    public final Expression getActionExpression() {
        return this.b.getChildExpression();
    }

    @Override
    public final Expression typeCheck(ExpressionVisitor expressionVisitor, ContextItemStaticInfo object) {
        this.a.typeCheck(expressionVisitor, (ContextItemStaticInfo)object);
        this.c.typeCheck(expressionVisitor, (ContextItemStaticInfo)object);
        object = this.getSelectExpression().getItemType();
        if (object == ErrorType.getInstance()) {
            AnyItemType.getInstance();
        }
        object = expressionVisitor.getConfiguration().makeContextItemStaticInfo(this.getSelectExpression().getItemType(), false);
        ((ContextItemStaticInfo)object).setContextSettingExpression(this.getSelectExpression());
        this.b.typeCheck(expressionVisitor, (ContextItemStaticInfo)object);
        this.d.typeCheck(expressionVisitor, ContextItemStaticInfo.ABSENT);
        if (Literal.isEmptySequence(this.getOnCompletion()) && (Literal.isEmptySequence(this.getSelectExpression()) || Literal.isEmptySequence(this.getActionExpression()))) {
            return this.getOnCompletion();
        }
        return this;
    }

    @Override
    public final Expression optimize(ExpressionVisitor expressionVisitor, ContextItemStaticInfo contextItemStaticInfo) {
        this.a.optimize(expressionVisitor, contextItemStaticInfo);
        this.c.optimize(expressionVisitor, contextItemStaticInfo);
        contextItemStaticInfo = expressionVisitor.getConfiguration().makeContextItemStaticInfo(this.getSelectExpression().getItemType(), false);
        contextItemStaticInfo.setContextSettingExpression(this.getSelectExpression());
        this.b.optimize(expressionVisitor, contextItemStaticInfo);
        this.d.optimize(expressionVisitor, ContextItemStaticInfo.ABSENT);
        if (Literal.isEmptySequence(this.getOnCompletion()) && (Literal.isEmptySequence(this.getSelectExpression()) || Literal.isEmptySequence(this.getActionExpression()))) {
            return this.getOnCompletion();
        }
        return this;
    }

    public final boolean isCompilable() {
        return !IterateInstr.a(this, false);
    }

    private static boolean a(Expression object, boolean bl2) {
        if (object instanceof BreakInstr || object instanceof NextIteration) {
            return bl2;
        }
        boolean bl3 = false;
        bl2 = bl2 || object instanceof TryCatch;
        for (Operand operand : ((Expression)object).operands()) {
            if (!IterateInstr.a(operand.getChildExpression(), bl2)) continue;
            bl3 = true;
            break;
        }
        return bl3;
    }

    @Override
    public final ItemType getItemType() {
        if (Literal.isEmptySequence(this.getOnCompletion())) {
            return this.getActionExpression().getItemType();
        }
        TypeHierarchy typeHierarchy = this.getConfiguration().getTypeHierarchy();
        return Type.getCommonSuperType(this.getActionExpression().getItemType(), this.getOnCompletion().getItemType(), typeHierarchy);
    }

    @Override
    public final boolean mayCreateNewNodes() {
        return (this.getActionExpression().getSpecialProperties() & this.getOnCompletion().getSpecialProperties() & 0x800000) == 0;
    }

    @Override
    public final boolean hasVariableBinding(Binding binding) {
        LocalParamBlock localParamBlock = this.getInitiallyExp();
        for (Operand operand : ((Expression)localParamBlock).operands()) {
            LocalParam object = (LocalParam)operand.getChildExpression();
            if (object != binding) continue;
            return true;
        }
        return false;
    }

    @Override
    public final String getStreamerName() {
        return "Iterate";
    }

    @Override
    public final int getImplementationMethod() {
        return 4;
    }

    @Override
    public final void checkPermittedContents(SchemaType schemaType, boolean bl2) {
        this.getActionExpression().checkPermittedContents(schemaType, false);
        this.getOnCompletion().checkPermittedContents(schemaType, false);
    }

    @Override
    public final Expression copy(RebindingMap object) {
        object = new IterateInstr(this.getSelectExpression().copy((RebindingMap)object), (LocalParamBlock)((Expression)this.getInitiallyExp()).copy((RebindingMap)object), this.getActionExpression().copy((RebindingMap)object), this.getOnCompletion().copy((RebindingMap)object));
        ExpressionTool.copyLocationInfo(this, (Expression)object);
        return object;
    }

    @Override
    public final TailCall processLeavingTail(XPathContext xPathContext) {
        Object object;
        XPathContextMajor xPathContextMajor = xPathContext.newContext();
        xPathContextMajor.setOrigin(this);
        FocusIterator<?> focusIterator = xPathContextMajor.trackFocus(this.getSelectExpression().iterate(xPathContext));
        xPathContextMajor.setCurrentTemplateRule(null);
        PipelineConfiguration pipelineConfiguration = xPathContextMajor.getReceiver().getPipelineConfiguration();
        pipelineConfiguration.setXPathContext(xPathContextMajor);
        boolean bl2 = xPathContext.getController().isTracing();
        TraceListener traceListener = bl2 ? xPathContext.getController().getTraceListener() : null;
        ((Expression)this.getInitiallyExp()).process(xPathContext);
        while ((object = focusIterator.next()) != null) {
            if (bl2) {
                traceListener.startCurrentItem((Item)object);
            }
            this.getActionExpression().process(xPathContextMajor);
            if (bl2) {
                traceListener.endCurrentItem((Item)object);
            }
            if ((object = xPathContextMajor.getTailCallInfo()) == null || !(object instanceof BreakInstr)) continue;
            focusIterator.close();
            return null;
        }
        object = xPathContext.newMinorContext();
        ((XPathContextMinor)object).setCurrentIterator(null);
        this.getOnCompletion().process((XPathContext)object);
        pipelineConfiguration.setXPathContext(xPathContext);
        return null;
    }

    @Override
    public final void export(ExpressionPresenter expressionPresenter) {
        expressionPresenter.startElement("iterate", this);
        expressionPresenter.setChildRole("select");
        this.getSelectExpression().export(expressionPresenter);
        expressionPresenter.setChildRole("params");
        ((Expression)this.getInitiallyExp()).export(expressionPresenter);
        if (!Literal.isEmptySequence(this.getOnCompletion())) {
            expressionPresenter.setChildRole("on-completion");
            this.getOnCompletion().export(expressionPresenter);
        }
        expressionPresenter.setChildRole("action");
        this.getActionExpression().export(expressionPresenter);
        expressionPresenter.endElement();
    }
}

