/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.instruct;

import net.sf.saxon.expr.Binding;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.LocalBinding;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.VariableReference;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.Instruction;
import net.sf.saxon.expr.instruct.TailCall;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.Evaluator;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ErrorType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.SequenceType;

public final class LocalParam
extends Instruction
implements LocalBinding {
    private Operand a = null;
    private Evaluator b = null;
    private byte c = 0;
    private Operand d = null;
    protected StructuredQName variableQName;
    private SequenceType e;
    protected int slotNumber = -999;
    protected int referenceCount = 10;
    protected Evaluator evaluator = null;

    public final void setSelectExpression(Expression expression) {
        if (expression != null) {
            if (this.d == null) {
                this.d = new Operand(this, expression, OperandRole.NAVIGATE);
            } else {
                this.d.setChildExpression(expression);
            }
        } else {
            this.d = null;
        }
        this.evaluator = null;
    }

    public final Expression getSelectExpression() {
        if (this.d == null) {
            return null;
        }
        return this.d.getChildExpression();
    }

    public final void setRequiredType(SequenceType sequenceType) {
        this.e = sequenceType;
    }

    @Override
    public final SequenceType getRequiredType() {
        return this.e;
    }

    public final void setRequiredParam(boolean bl2) {
        if (bl2) {
            this.c = (byte)(this.c | 4);
            return;
        }
        this.c = (byte)(this.c & 0xFFFFFFFB);
    }

    public final void setImplicitlyRequiredParam(boolean bl2) {
        if (bl2) {
            this.c = (byte)(this.c | 0x10);
            return;
        }
        this.c = (byte)(this.c & 0xFFFFFFEF);
    }

    public final void setTunnel(boolean bl2) {
        if (bl2) {
            this.c = (byte)(this.c | 8);
            return;
        }
        this.c = (byte)(this.c & 0xFFFFFFF7);
    }

    public final void setReferenceCount(int n2) {
        this.referenceCount = n2;
    }

    @Override
    public final int getCardinality() {
        return 8192;
    }

    @Override
    public final boolean isAssignable() {
        return false;
    }

    @Override
    public final boolean isGlobal() {
        return false;
    }

    @Override
    public final int getLocalSlotNumber() {
        return this.slotNumber;
    }

    public final boolean isRequiredParam() {
        return (this.c & 4) != 0;
    }

    public final boolean isImplicitlyRequiredParam() {
        return (this.c & 0x10) != 0;
    }

    public final boolean isTunnelParam() {
        return (this.c & 8) != 0;
    }

    @Override
    public final Expression typeCheck(ExpressionVisitor expressionVisitor, ContextItemStaticInfo object) {
        if ((object = super.typeCheck(expressionVisitor, (ContextItemStaticInfo)object)) != this) {
            return object;
        }
        this.checkAgainstRequiredType(expressionVisitor);
        return this;
    }

    @Override
    public final Expression optimize(ExpressionVisitor object, ContextItemStaticInfo contextItemStaticInfo) {
        if ((object = super.optimize((ExpressionVisitor)object, contextItemStaticInfo)) != this) {
            return object;
        }
        return this;
    }

    public final void computeEvaluationMode() {
        if (this.getSelectExpression() != null) {
            if (this.referenceCount == 10000) {
                this.evaluator = Evaluator.MAKE_INDEXED_VARIABLE;
                return;
            }
            this.evaluator = ExpressionTool.lazyEvaluator(this.getSelectExpression(), this.referenceCount > 1);
        }
    }

    @Override
    public final LocalParam copy(RebindingMap rebindingMap) {
        LocalParam localParam = new LocalParam();
        if (this.a != null) {
            assert (this.getConversion() != null);
            localParam.setConversion(this.getConversion().copy(rebindingMap));
        }
        localParam.b = this.b;
        localParam.c = this.c;
        if (this.d != null) {
            assert (this.getSelectExpression() != null);
            localParam.setSelectExpression(this.getSelectExpression().copy(rebindingMap));
        }
        localParam.variableQName = this.variableQName;
        localParam.e = this.e;
        localParam.slotNumber = this.slotNumber;
        localParam.referenceCount = this.referenceCount;
        localParam.evaluator = this.evaluator;
        return localParam;
    }

    @Override
    public final void addReference(VariableReference variableReference, boolean bl2) {
    }

    public final void checkAgainstRequiredType(ExpressionVisitor expressionVisitor) {
        RoleDiagnostic roleDiagnostic = new RoleDiagnostic(3, this.variableQName.getDisplayName(), 0);
        SequenceType sequenceType = this.e;
        Expression expression = this.getSelectExpression();
        if (sequenceType != null && expression != null) {
            expressionVisitor.getConfiguration().getTypeChecker(false).staticTypeCheck(expression, this.e, roleDiagnostic, expressionVisitor);
        }
    }

    public final Sequence<?> getSelectValue(XPathContext xPathContext) {
        Object object = this.getSelectExpression();
        if (object == null) {
            throw new AssertionError((Object)"Internal error: No select expression");
        }
        if (object instanceof Literal) {
            return ((Literal)object).getValue();
        }
        int n2 = xPathContext.getTemporaryOutputState();
        xPathContext.setTemporaryOutputState(208);
        object = this.evaluator.evaluate((Expression)object, xPathContext);
        xPathContext.setTemporaryOutputState(n2);
        return object;
    }

    public final int getSlotNumber() {
        return this.slotNumber;
    }

    public final void setSlotNumber(int n2) {
        this.slotNumber = n2;
    }

    public final void setVariableQName(StructuredQName structuredQName) {
        this.variableQName = structuredQName;
    }

    @Override
    public final StructuredQName getVariableQName() {
        return this.variableQName;
    }

    public final void setConversion(Expression expression) {
        if (expression != null) {
            if (this.a == null) {
                this.a = new Operand(this, expression, OperandRole.SINGLE_ATOMIC);
            }
            this.b = ExpressionTool.eagerEvaluator(expression);
            return;
        }
        this.a = null;
    }

    public final Expression getConversion() {
        if (this.a == null) {
            return null;
        }
        return this.a.getChildExpression();
    }

    public final int getConversionEvaluationMode() {
        return this.b.getCode();
    }

    @Override
    public final int getInstructionNameCode() {
        return 189;
    }

    @Override
    public final Iterable<Operand> operands() {
        return this.operandSparseList(this.d, this.a);
    }

    @Override
    public final TailCall processLeavingTail(XPathContext xPathContext) {
        int n2 = xPathContext.useLocalParameter(this.variableQName, this.slotNumber, this.isTunnelParam());
        switch (n2) {
            case 2: {
                break;
            }
            case 1: {
                if (this.a == null) break;
                xPathContext.setLocalVariable(this.slotNumber, this.b.evaluate(this.getConversion(), xPathContext));
                break;
            }
            case 0: {
                if (this.isRequiredParam() || this.isImplicitlyRequiredParam()) {
                    Object object = "$" + this.getVariableQName().getDisplayName();
                    int n3 = xPathContext.useLocalParameter(this.variableQName, this.slotNumber, !this.isTunnelParam());
                    object = "No value supplied for required parameter " + (String)object;
                    if (this.isImplicitlyRequiredParam()) {
                        object = (String)object + ". A value is required because the default value is not a valid instance of the required type";
                    }
                    if (n3 != 0) {
                        object = this.isTunnelParam() ? (String)object + ". A non-tunnel parameter with this name was supplied, but a tunnel parameter is required" : (String)object + ". A tunnel parameter with this name was supplied, but a non-tunnel parameter is required";
                    }
                    object = new XPathException((String)object);
                    ((XPathException)object).setXPathContext(xPathContext);
                    ((XPathException)object).setErrorCode("XTDE0700");
                    throw object;
                }
                xPathContext.setLocalVariable(this.slotNumber, this.getSelectValue(xPathContext));
            }
        }
        return null;
    }

    @Override
    public final IntegerValue[] getIntegerBoundsForVariable() {
        return null;
    }

    @Override
    public final Sequence<?> evaluateVariable(XPathContext xPathContext) {
        return xPathContext.evaluateLocalVariable(this.slotNumber);
    }

    public final boolean isCompatible(LocalParam localParam) {
        return this.getVariableQName().equals(localParam.getVariableQName()) && this.getRequiredType().equals(localParam.getRequiredType()) && this.isTunnelParam() == localParam.isTunnelParam();
    }

    @Override
    public final boolean isLiftable(boolean bl2) {
        return false;
    }

    @Override
    public final boolean hasVariableBinding(Binding binding) {
        return this == binding;
    }

    @Override
    public final ItemType getItemType() {
        return ErrorType.getInstance();
    }

    @Override
    public final int computeCardinality() {
        return 57344;
    }

    @Override
    public final int computeSpecialProperties() {
        return 0x2000000;
    }

    @Override
    public final boolean mayCreateNewNodes() {
        return false;
    }

    @Override
    public final String getExpressionName() {
        return "param";
    }

    @Override
    public final String toShortString() {
        return "$" + this.getVariableQName().getDisplayName();
    }

    @Override
    public final void export(ExpressionPresenter expressionPresenter) {
        expressionPresenter.startElement("param", this);
        expressionPresenter.emitAttribute("name", this.getVariableQName());
        expressionPresenter.emitAttribute("slot", "" + this.getSlotNumber());
        Object object = this;
        String string = "";
        if (((LocalParam)object).isTunnelParam()) {
            string = string + "t";
        }
        if (((LocalParam)object).isRequiredParam()) {
            string = string + "r";
        }
        if (((LocalParam)object).isImplicitlyRequiredParam()) {
            string = string + "i";
        }
        if (!((String)(object = string)).isEmpty()) {
            expressionPresenter.emitAttribute("flags", (String)object);
        }
        object = (ExpressionPresenter.ExportOptions)expressionPresenter.getOptions();
        if (this.getRequiredType() != SequenceType.ANY_SEQUENCE) {
            expressionPresenter.emitAttribute("as", this.getRequiredType().toExportString());
            if (((ExpressionPresenter.ExportOptions)object).target.equals("JS") && ((ExpressionPresenter.ExportOptions)object).targetVersion == 2) {
                expressionPresenter.emitAttribute("asJ", this.getRequiredType().toExportString2());
            }
        }
        if (this.getSelectExpression() != null) {
            expressionPresenter.setChildRole("select");
            this.getSelectExpression().export(expressionPresenter);
        }
        if ((object = this.getConversion()) != null) {
            expressionPresenter.setChildRole("conversion");
            ((Expression)object).export(expressionPresenter);
        }
        expressionPresenter.endElement();
    }

    @Override
    public final void setIndexedVariable() {
    }

    @Override
    public final boolean isIndexedVariable() {
        return false;
    }
}

