/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.instruct;

import java.util.Arrays;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.Instruction;
import net.sf.saxon.expr.instruct.LocalParam;
import net.sf.saxon.expr.instruct.TailCall;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ErrorType;
import net.sf.saxon.type.ItemType;

public class LocalParamBlock
extends Instruction {
    private Operand[] a;

    public LocalParamBlock(LocalParam[] localParamArray) {
        this.a = new Operand[localParamArray.length];
        for (int i2 = 0; i2 < localParamArray.length; ++i2) {
            this.a[i2] = new Operand(this, localParamArray[i2], OperandRole.NAVIGATE);
        }
    }

    @Override
    public String getExpressionName() {
        return "params";
    }

    @Override
    public Iterable<Operand> operands() {
        return Arrays.asList(this.a);
    }

    public int getNumberOfParams() {
        return this.a.length;
    }

    @Override
    public int computeSpecialProperties() {
        return 0;
    }

    @Override
    public Expression copy(RebindingMap rebindingMap) {
        LocalParam[] localParamArray = new LocalParam[this.getNumberOfParams()];
        int n2 = 0;
        for (Operand operand : ((Expression)this).operands()) {
            LocalParam object = (LocalParam)operand.getChildExpression();
            LocalParam localParam = object.copy(rebindingMap);
            rebindingMap.put(object, localParam);
            localParamArray[n2++] = localParam;
        }
        return new LocalParamBlock(localParamArray);
    }

    @Override
    public final ItemType getItemType() {
        return ErrorType.getInstance();
    }

    @Override
    public final int getCardinality() {
        return 8192;
    }

    @Override
    public void export(ExpressionPresenter expressionPresenter) {
        expressionPresenter.startElement("params", this);
        for (Operand operand : ((Expression)this).operands()) {
            operand.getChildExpression().export(expressionPresenter);
        }
        expressionPresenter.endElement();
    }

    @Override
    public TailCall processLeavingTail(XPathContext xPathContext) {
        Object object = ((Expression)this).operands().iterator();
        while (object.hasNext()) {
            Object object2 = object.next();
            object2 = (LocalParam)((Operand)object2).getChildExpression();
            try {
                xPathContext.setLocalVariable(((LocalParam)object2).getSlotNumber(), ((LocalParam)object2).getSelectValue(xPathContext));
            }
            catch (XPathException xPathException) {
                object = xPathException;
                xPathException.maybeSetLocation(((Expression)object2).getLocation());
                ((XPathException)object).maybeSetContext(xPathContext);
                throw object;
            }
        }
        return null;
    }

    @Override
    public int getImplementationMethod() {
        return 4;
    }
}

