/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.instruct;

import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.Actor;
import net.sf.saxon.expr.instruct.TailCall;
import net.sf.saxon.expr.instruct.TailCallReturner;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.SymbolicName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.SequenceType;

public class NamedTemplate
extends Actor {
    private StructuredQName a;
    private boolean b;
    private boolean c;
    private SequenceType d;
    private ItemType e = AnyItemType.getInstance();
    private boolean f = true;
    private boolean g = false;
    private List<LocalParamInfo> h = new ArrayList<LocalParamInfo>(4);

    public NamedTemplate(StructuredQName structuredQName) {
        this.setTemplateName(structuredQName);
    }

    public void setTemplateName(StructuredQName structuredQName) {
        this.a = structuredQName;
    }

    public void setContextItemRequirements(ItemType itemType, boolean bl2, boolean bl3) {
        this.e = itemType;
        this.f = bl2;
        this.g = bl3;
    }

    @Override
    public int getComponentKind() {
        return 200;
    }

    @Override
    public SymbolicName getSymbolicName() {
        if (this.getTemplateName() == null) {
            return null;
        }
        return new SymbolicName(200, this.getTemplateName());
    }

    @Override
    public void setBody(Expression expression) {
        super.setBody(expression);
        this.c = expression instanceof TailCallReturner;
    }

    public StructuredQName getTemplateName() {
        return this.a;
    }

    @Override
    public StructuredQName getObjectName() {
        return this.a;
    }

    public void setHasRequiredParams(boolean bl2) {
        this.b = bl2;
    }

    public boolean hasRequiredParams() {
        return this.b;
    }

    public void setRequiredType(SequenceType sequenceType) {
        this.d = sequenceType;
    }

    public SequenceType getRequiredType() {
        if (this.d == null) {
            return SequenceType.ANY_SEQUENCE;
        }
        return this.d;
    }

    public ItemType getRequiredContextItemType() {
        return this.e;
    }

    public boolean isMayOmitContextItem() {
        return this.f;
    }

    public boolean isAbsentFocus() {
        return this.g;
    }

    public LocalParamInfo getLocalParamInfo(StructuredQName structuredQName) {
        Object object = this.getLocalParamDetails();
        object = object.iterator();
        while (object.hasNext()) {
            LocalParamInfo localParamInfo = (LocalParamInfo)object.next();
            if (!localParamInfo.name.equals(structuredQName)) continue;
            return localParamInfo;
        }
        return null;
    }

    public TailCall expand(XPathContext object) {
        Item<?> item = object.getContextItem();
        if (item == null) {
            if (!this.f) {
                XPathException xPathException = new XPathException("The template requires a context item, but none has been supplied", "XTTE3090");
                xPathException.setLocation(this.getLocation());
                xPathException.setIsTypeError(true);
                throw xPathException;
            }
        } else {
            TypeHierarchy typeHierarchy = object.getConfiguration().getTypeHierarchy();
            if (this.e != AnyItemType.getInstance() && !this.e.matches(item, typeHierarchy)) {
                object = new RoleDiagnostic(20, "context item for the named template", 0);
                object = ((RoleDiagnostic)object).composeErrorMessage(this.e, item, typeHierarchy);
                object = new XPathException((String)object, "XTTE0590");
                ((XPathException)object).setLocation(this.getLocation());
                ((XPathException)object).setIsTypeError(true);
                throw object;
            }
            if (this.g) {
                object = object.newMinorContext();
                object.setCurrentIterator(null);
            }
        }
        if (this.c) {
            return ((TailCallReturner)((Object)this.body)).processLeavingTail((XPathContext)object);
        }
        if (this.body != null) {
            this.body.process((XPathContext)object);
        }
        return null;
    }

    @Override
    public int getConstructType() {
        return 2008;
    }

    @Override
    public void export(ExpressionPresenter expressionPresenter) {
        expressionPresenter.startElement("template");
        expressionPresenter.emitAttribute("name", this.getTemplateName());
        this.explainProperties(expressionPresenter);
        expressionPresenter.emitAttribute("slots", "" + this.getStackFrameMap().getNumberOfVariables());
        if (this.getBody() != null) {
            expressionPresenter.setChildRole("body");
            this.getBody().export(expressionPresenter);
        }
        expressionPresenter.endElement();
    }

    public void explainProperties(ExpressionPresenter expressionPresenter) {
        if (this.getRequiredContextItemType() != AnyItemType.getInstance()) {
            expressionPresenter.emitAttribute("cxt", this.getRequiredContextItemType().toExportString());
            if ("JS".equals(((ExpressionPresenter.ExportOptions)expressionPresenter.getOptions()).target)) {
                try {
                    int n2 = ((ExpressionPresenter.ExportOptions)expressionPresenter.getOptions()).targetVersion;
                    expressionPresenter.emitAttribute("jsTest", this.getRequiredContextItemType().generateJavaScriptItemTypeTest(AnyItemType.getInstance(), n2));
                }
                catch (XPathException xPathException) {
                    XPathException xPathException2 = xPathException;
                    xPathException.maybeSetLocation(this.getLocation());
                    throw xPathException2;
                }
            }
        }
        String string = "";
        if (this.f) {
            string = "o";
        }
        if (!this.g) {
            string = string + "s";
        }
        expressionPresenter.emitAttribute("flags", string);
        if (this.getRequiredType() != SequenceType.ANY_SEQUENCE) {
            expressionPresenter.emitAttribute("as", this.getRequiredType().toExportString());
        }
        expressionPresenter.emitAttribute("line", "" + this.getLineNumber());
        expressionPresenter.emitAttribute("module", this.getSystemId());
    }

    public void setLocalParamDetails(List<LocalParamInfo> list) {
        this.h = list;
    }

    public List<LocalParamInfo> getLocalParamDetails() {
        return this.h;
    }

    public static class LocalParamInfo {
        public StructuredQName name;
        public SequenceType requiredType;
        public boolean isRequired;
        public boolean isTunnel;
    }
}

