/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.instruct;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.SimpleNodeConstructor;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.lib.StandardURIChecker;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NamespaceBindingSet;
import net.sf.saxon.om.NoNamespaceName;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.AnyURIValue;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Whitespace;

public class NamespaceConstructor
extends SimpleNodeConstructor {
    private Operand a;

    public NamespaceConstructor(Expression expression) {
        this.a = new Operand(this, expression, OperandRole.SINGLE_ATOMIC);
    }

    public Expression getNameExp() {
        return this.a.getChildExpression();
    }

    public void setNameExp(Expression expression) {
        this.a.setChildExpression(expression);
    }

    @Override
    public Iterable<Operand> operands() {
        return this.operandList(this.selectOp, this.a);
    }

    @Override
    public int getInstructionNameCode() {
        return 175;
    }

    @Override
    public ItemType getItemType() {
        return NodeKindTest.NAMESPACE;
    }

    @Override
    public int getCardinality() {
        return 16384;
    }

    @Override
    public void localTypeCheck(ExpressionVisitor expressionVisitor, ContextItemStaticInfo object) {
        StaticContext staticContext = expressionVisitor.getStaticContext();
        this.a.typeCheck(expressionVisitor, (ContextItemStaticInfo)object);
        object = new RoleDiagnostic(4, "namespace/name", 0);
        this.setNameExp(staticContext.getConfiguration().getTypeChecker(false).staticTypeCheck(this.getNameExp(), SequenceType.OPTIONAL_ATOMIC, (RoleDiagnostic)object, expressionVisitor));
        NamespaceConstructor namespaceConstructor = this;
        namespaceConstructor.adoptChildExpression(namespaceConstructor.getNameExp());
        if (this.getNameExp() instanceof Literal) {
            this.a(staticContext.makeEarlyEvaluationContext());
        }
    }

    @Override
    public Expression copy(RebindingMap rebindingMap) {
        NamespaceConstructor namespaceConstructor = new NamespaceConstructor(this.getNameExp().copy(rebindingMap));
        namespaceConstructor.setSelect(this.getSelect().copy(rebindingMap));
        ExpressionTool.copyLocationInfo(this, namespaceConstructor);
        return namespaceConstructor;
    }

    @Override
    public NodeName evaluateNodeName(XPathContext object) {
        object = this.a((XPathContext)object);
        return new NoNamespaceName((String)object);
    }

    private String a(XPathContext xPathContext) {
        Object object = (AtomicValue)this.getNameExp().evaluateItem(xPathContext);
        if (object == null) {
            return "";
        }
        if (!(object instanceof StringValue) || object instanceof AnyURIValue) {
            object = new XPathException("Namespace prefix is not an xs:string or xs:untypedAtomic", "XPTY0004", this.getLocation());
            ((XPathException)object).setIsTypeError(true);
            throw NamespaceConstructor.dynamicError(this.getLocation(), (XPathException)object, xPathContext);
        }
        if (!((String)(object = Whitespace.trim(((AtomicValue)object).getStringValueCS()))).isEmpty() && !NameChecker.isValidNCName((CharSequence)object)) {
            String string = this.isXSLT() ? "XTDE0920" : "XQDY0074";
            object = new XPathException("Namespace prefix is invalid: " + (String)object, string, this.getLocation());
            throw NamespaceConstructor.dynamicError(this.getLocation(), (XPathException)object, xPathContext);
        }
        if (((String)object).equals("xmlns")) {
            String string = this.isXSLT() ? "XTDE0920" : "XQDY0101";
            object = new XPathException("Namespace prefix 'xmlns' is not allowed", string, this.getLocation());
            throw NamespaceConstructor.dynamicError(this.getLocation(), (XPathException)object, xPathContext);
        }
        return object;
    }

    @Override
    public void processValue(CharSequence object, XPathContext object2) {
        String string = this.a((XPathContext)object2);
        object = object.toString();
        this.a(string, (String)object, (XPathContext)object2);
        object = new NamespaceBinding(string, (String)object);
        object2 = object2.getReceiver();
        object2.namespace((NamespaceBindingSet)object, 32);
    }

    public NodeInfo evaluateItem(XPathContext xPathContext) {
        NodeInfo nodeInfo = (NodeInfo)super.evaluateItem(xPathContext);
        assert (nodeInfo != null);
        String string = nodeInfo.getLocalPart();
        String string2 = nodeInfo.getStringValue();
        this.a(string, string2, xPathContext);
        return nodeInfo;
    }

    private void a(String object, String string, XPathContext xPathContext) {
        if (((String)object).equals("xml") != string.equals("http://www.w3.org/XML/1998/namespace")) {
            object = this.isXSLT() ? "XTDE0925" : "XQDY0101";
            object = new XPathException("Namespace prefix 'xml' and namespace uri http://www.w3.org/XML/1998/namespace must only be used together", (String)object, this.getLocation());
            throw NamespaceConstructor.dynamicError(this.getLocation(), (XPathException)object, xPathContext);
        }
        if (string.isEmpty()) {
            object = this.isXSLT() ? "XTDE0930" : "XQDY0101";
            object = new XPathException("Namespace URI is an empty string", (String)object, this.getLocation());
            throw NamespaceConstructor.dynamicError(this.getLocation(), (XPathException)object, xPathContext);
        }
        if (string.equals("http://www.w3.org/2000/xmlns/")) {
            object = this.isXSLT() ? "XTDE0905" : "XQDY0101";
            object = new XPathException("A namespace node cannot have the reserved namespace http://www.w3.org/2000/xmlns/", (String)object, this.getLocation());
            throw NamespaceConstructor.dynamicError(this.getLocation(), (XPathException)object, xPathContext);
        }
        if (xPathContext.getConfiguration().getXsdVersion() == 10 && !StandardURIChecker.getInstance().isValidURI(string)) {
            object = new XPathException("The string value of the constructed namespace node must be a valid URI", "XTDE0905", this.getLocation());
            throw NamespaceConstructor.dynamicError(this.getLocation(), (XPathException)object, xPathContext);
        }
    }

    @Override
    public void export(ExpressionPresenter expressionPresenter) {
        expressionPresenter.startElement("namespace", this);
        String string = "";
        if (this.isLocal()) {
            string = string + "l";
        }
        if (!string.isEmpty()) {
            expressionPresenter.emitAttribute("flags", string);
        }
        expressionPresenter.setChildRole("name");
        this.getNameExp().export(expressionPresenter);
        expressionPresenter.setChildRole("select");
        this.getSelect().export(expressionPresenter);
        expressionPresenter.endElement();
    }
}

