/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.instruct;

import java.util.ArrayList;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.OperandUsage;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.tree.iter.ListIterator;
import net.sf.saxon.tree.util.Navigator;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.SequenceType;

public class NumberInstruction
extends Expression {
    public static final int SINGLE = 0;
    public static final int MULTI = 1;
    public static final int ANY = 2;
    public static final int SIMPLE = 3;
    public static final String[] LEVEL_NAMES = new String[]{"single", "multi", "any", "simple"};
    private Operand a;
    private int b;
    private Operand c;
    private Operand d;
    private boolean e = false;

    public NumberInstruction(Expression expression, int n2, Pattern pattern, Pattern pattern2) {
        assert (expression != null);
        this.a = new Operand(this, expression, new OperandRole(0, OperandUsage.NAVIGATION, SequenceType.SINGLE_NODE));
        this.b = n2;
        if (pattern != null) {
            this.c = new Operand(this, pattern, OperandRole.INSPECT);
        }
        if (pattern2 != null) {
            this.d = new Operand(this, pattern2, OperandRole.INSPECT);
        }
        this.e = Pattern.patternContainsVariable(pattern) || Pattern.patternContainsVariable(pattern2);
    }

    @Override
    public boolean isInstruction() {
        return true;
    }

    @Override
    public Iterable<Operand> operands() {
        return this.operandSparseList(this.a, this.c, this.d);
    }

    public int getLevel() {
        return this.b;
    }

    public Pattern getCount() {
        if (this.c == null) {
            return null;
        }
        return (Pattern)this.c.getChildExpression();
    }

    public Pattern getFrom() {
        if (this.d == null) {
            return null;
        }
        return (Pattern)this.d.getChildExpression();
    }

    public Expression getSelect() {
        return this.a.getChildExpression();
    }

    @Override
    public Expression copy(RebindingMap object) {
        RebindingMap rebindingMap = object;
        Operand operand = this.a;
        object = new NumberInstruction(operand == null ? null : operand.getChildExpression().copy(rebindingMap), this.b, NumberInstruction.a(this.getCount(), (RebindingMap)object), NumberInstruction.a(this.getFrom(), (RebindingMap)object));
        ExpressionTool.copyLocationInfo(this, (Expression)object);
        return object;
    }

    private static Pattern a(Pattern pattern, RebindingMap rebindingMap) {
        if (pattern == null) {
            return null;
        }
        return pattern.copy(rebindingMap);
    }

    @Override
    public ItemType getItemType() {
        return BuiltInAtomicType.INTEGER;
    }

    @Override
    public int computeCardinality() {
        switch (this.b) {
            case 0: 
            case 2: 
            case 3: {
                return 24576;
            }
        }
        return 57344;
    }

    @Override
    public int getImplementationMethod() {
        return 2;
    }

    @Override
    public Expression optimize(ExpressionVisitor expressionVisitor, ContextItemStaticInfo contextItemStaticInfo) {
        Expression expression = super.optimize(expressionVisitor, contextItemStaticInfo);
        if (expression != this) {
            return expression;
        }
        if ("EE".equals(this.getPackageData().getTargetEdition()) && (expression = expressionVisitor.obtainOptimizer().optimizeNumberInstruction(this, contextItemStaticInfo)) != null) {
            return expression;
        }
        return this;
    }

    @Override
    public SequenceIterator<?> iterate(XPathContext xPathContext) {
        ArrayList<Int64Value> arrayList = new ArrayList<Int64Value>(1);
        NodeInfo nodeInfo = (NodeInfo)this.a.getChildExpression().evaluateItem(xPathContext);
        switch (this.b) {
            case 3: {
                long l2 = Navigator.getNumberSimple(nodeInfo, xPathContext);
                if (l2 == 0L) break;
                arrayList.add(Int64Value.makeIntegerValue(l2));
                break;
            }
            case 0: {
                long l3 = Navigator.getNumberSingle(nodeInfo, this.getCount(), this.getFrom(), xPathContext);
                if (l3 == 0L) break;
                arrayList.add(Int64Value.makeIntegerValue(l3));
                break;
            }
            case 2: {
                long l4 = Navigator.getNumberAny(this, nodeInfo, this.getCount(), this.getFrom(), xPathContext, this.e);
                if (l4 == 0L) break;
                arrayList.add(Int64Value.makeIntegerValue(l4));
                break;
            }
            case 1: {
                for (long l5 : Navigator.getNumberMulti(nodeInfo, this.getCount(), this.getFrom(), xPathContext)) {
                    arrayList.add(Int64Value.makeIntegerValue(l5));
                }
                break;
            }
        }
        return new ListIterator(arrayList);
    }

    @Override
    public String getExpressionName() {
        return "xsl:number";
    }

    @Override
    public void export(ExpressionPresenter expressionPresenter) {
        expressionPresenter.startElement("nodeNum", this);
        expressionPresenter.emitAttribute("level", LEVEL_NAMES[this.b]);
        expressionPresenter.setChildRole("select");
        this.a.getChildExpression().export(expressionPresenter);
        if (this.c != null) {
            expressionPresenter.setChildRole("count");
            ((Expression)this.getCount()).export(expressionPresenter);
        }
        if (this.d != null) {
            expressionPresenter.setChildRole("from");
            ((Expression)this.getFrom()).export(expressionPresenter);
        }
        expressionPresenter.endElement();
    }
}

