/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.instruct;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.OperandUsage;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.instruct.Block;
import net.sf.saxon.expr.instruct.Instruction;
import net.sf.saxon.expr.instruct.InstructionWithComplexContent;
import net.sf.saxon.expr.instruct.ValidatingInstruction;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.PathMap;
import net.sf.saxon.lib.ParseOptions;
import net.sf.saxon.pattern.MultipleNodeKindTest;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.Untyped;
import net.sf.saxon.value.SequenceType;

public abstract class ParentNodeConstructor
extends Instruction
implements InstructionWithComplexContent,
ValidatingInstruction {
    private static final OperandRole a = new OperandRole(0, OperandUsage.ABSORPTION, SequenceType.ANY_SEQUENCE);
    protected Operand contentOp;
    private boolean b = false;
    private ParseOptions c = null;
    private String d;
    protected boolean preservingTypes = true;

    public void setBaseURI(String string) {
        this.d = string;
    }

    public void setLazyConstruction(boolean bl2) {
        this.b = bl2;
    }

    public final boolean isLazyConstruction() {
        return this.b;
    }

    @Override
    public SchemaType getSchemaType() {
        if (this.c == null) {
            return null;
        }
        return this.c.getTopLevelType();
    }

    public ParseOptions getValidationOptions() {
        return this.c;
    }

    public void setValidationAction(int n2, SchemaType schemaType) {
        boolean bl2 = this.preservingTypes = n2 == 3 && schemaType == null;
        if (!this.preservingTypes) {
            if (this.c == null) {
                this.c = new ParseOptions();
            }
            if (schemaType == Untyped.getInstance()) {
                this.c.setSchemaValidationMode(4);
                return;
            }
            this.c.setSchemaValidationMode(n2);
            this.c.setTopLevelType(schemaType);
        }
    }

    @Override
    public int getValidationAction() {
        if (this.c == null) {
            return 3;
        }
        return this.c.getSchemaValidationMode();
    }

    public void setNoNeedToStrip() {
        this.preservingTypes = true;
    }

    public void setContentExpression(Expression expression) {
        if (this.contentOp == null) {
            this.contentOp = new Operand(this, expression, a);
            return;
        }
        this.contentOp.setChildExpression(expression);
    }

    @Override
    public Expression getContentExpression() {
        if (this.contentOp == null) {
            return null;
        }
        return this.contentOp.getChildExpression();
    }

    public Operand getContentOperand() {
        return this.contentOp;
    }

    @Override
    public int computeCardinality() {
        return 16384;
    }

    @Override
    public Expression typeCheck(ExpressionVisitor expressionVisitor, ContextItemStaticInfo contextItemStaticInfo) {
        this.typeCheckChildren(expressionVisitor, contextItemStaticInfo);
        this.checkContentSequence(expressionVisitor.getStaticContext());
        return this;
    }

    @Override
    public boolean allowExtractingCommonSubexpressions() {
        return false;
    }

    protected abstract void checkContentSequence(StaticContext var1);

    @Override
    public Expression optimize(ExpressionVisitor object, ContextItemStaticInfo contextItemStaticInfo) {
        this.optimizeChildren((ExpressionVisitor)object, contextItemStaticInfo);
        if (!Literal.isEmptySequence(this.getContentExpression())) {
            if (this.getContentExpression() instanceof Block) {
                ParentNodeConstructor parentNodeConstructor = this;
                parentNodeConstructor.setContentExpression(((Block)parentNodeConstructor.getContentExpression()).mergeAdjacentTextInstructions());
            }
            if (((ExpressionVisitor)object).isOptimizeForStreaming()) {
                ParentNodeConstructor parentNodeConstructor = this;
                ((ExpressionVisitor)object).obtainOptimizer().makeCopyOperationsExplicit(parentNodeConstructor, parentNodeConstructor.contentOp);
            }
        }
        if (((ExpressionVisitor)object).getStaticContext().getPackageData().isSchemaAware()) {
            object = ((ExpressionVisitor)object).getConfiguration().getTypeHierarchy();
            if (this.getValidationAction() == 4 && (this.getContentExpression().hasSpecialProperty(0x8000000) || ((TypeHierarchy)object).relationship(this.getContentExpression().getItemType(), MultipleNodeKindTest.DOC_ELEM_ATTR) == 4)) {
                this.setNoNeedToStrip();
            }
        } else {
            this.setNoNeedToStrip();
        }
        return this;
    }

    @Override
    public final boolean mayCreateNewNodes() {
        return true;
    }

    @Override
    public boolean alwaysCreatesNewNodes() {
        return true;
    }

    @Override
    public int getCardinality() {
        return 16384;
    }

    @Override
    public PathMap.PathMapNodeSet addToPathMap(PathMap pathMap, PathMap.PathMapNodeSet pathMapNodeSet) {
        pathMapNodeSet = super.addToPathMap(pathMap, pathMapNodeSet);
        pathMapNodeSet.setReturnable(false);
        TypeHierarchy typeHierarchy = this.getConfiguration().getTypeHierarchy();
        ItemType itemType = ((Expression)this).getItemType();
        if (typeHierarchy.relationship(itemType, NodeKindTest.ELEMENT) != 4 || typeHierarchy.relationship(itemType, NodeKindTest.DOCUMENT) != 4) {
            pathMapNodeSet.addDescendants();
        }
        return new PathMap.PathMapNodeSet(pathMap.makeNewRoot(this));
    }

    public boolean isPreservingTypes() {
        return this.preservingTypes;
    }

    public boolean isLocal() {
        return ExpressionTool.isLocalConstructor(this);
    }
}

