/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.instruct;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.SimpleNodeConstructor;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.NoNamespaceName;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.AnyURIValue;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Whitespace;

public class ProcessingInstruction
extends SimpleNodeConstructor {
    private Operand a;

    public ProcessingInstruction(Expression expression) {
        this.a = new Operand(this, expression, OperandRole.SINGLE_ATOMIC);
    }

    public Expression getNameExp() {
        return this.a.getChildExpression();
    }

    public void setNameExp(Expression expression) {
        this.a.setChildExpression(expression);
    }

    @Override
    public Iterable<Operand> operands() {
        return this.operandList(this.selectOp, this.a);
    }

    @Override
    public int getInstructionNameCode() {
        return 192;
    }

    @Override
    public ItemType getItemType() {
        return NodeKindTest.PROCESSING_INSTRUCTION;
    }

    @Override
    public int getCardinality() {
        return 16384;
    }

    @Override
    public Expression copy(RebindingMap rebindingMap) {
        ProcessingInstruction processingInstruction = new ProcessingInstruction(this.getNameExp().copy(rebindingMap));
        ExpressionTool.copyLocationInfo(this, processingInstruction);
        processingInstruction.setSelect(this.getSelect().copy(rebindingMap));
        return processingInstruction;
    }

    @Override
    public void localTypeCheck(ExpressionVisitor object, ContextItemStaticInfo object2) {
        StaticContext staticContext = ((ExpressionVisitor)object).getStaticContext();
        this.a.typeCheck((ExpressionVisitor)object, (ContextItemStaticInfo)object2);
        object2 = new RoleDiagnostic(4, "processing-instruction/name", 0);
        this.setNameExp(((ExpressionVisitor)object).getConfiguration().getTypeChecker(false).staticTypeCheck(this.getNameExp(), SequenceType.SINGLE_ATOMIC, (RoleDiagnostic)object2, (ExpressionVisitor)object));
        object = this.getNameExp();
        this.adoptChildExpression((Expression)object);
        if (object instanceof Literal && ((Literal)object).getValue() instanceof AtomicValue) {
            object = (AtomicValue)((Literal)object).getValue();
            this.a((AtomicValue)object, staticContext.makeEarlyEvaluationContext());
        }
        if (this.getSelect() instanceof Literal && !((String)(object2 = this.checkContent((String)(object = ((Literal)this.getSelect()).getValue().getStringValue()), staticContext.makeEarlyEvaluationContext()))).equals(object)) {
            this.setSelect(new StringLiteral((CharSequence)object2));
        }
    }

    @Override
    public int getDependencies() {
        return this.getNameExp().getDependencies() | super.getDependencies();
    }

    @Override
    public void processValue(CharSequence charSequence, XPathContext object) {
        String string = this.a((XPathContext)object);
        if (string != null) {
            charSequence = this.checkContent(charSequence.toString(), (XPathContext)object);
            object = object.getReceiver();
            object.processingInstruction(string, charSequence, this.getLocation(), 0);
        }
    }

    @Override
    protected String checkContent(String object, XPathContext xPathContext) {
        if (this.isXSLT()) {
            return ProcessingInstruction.checkContentXSLT((String)object);
        }
        try {
            return ProcessingInstruction.checkContentXQuery((String)object);
        }
        catch (XPathException xPathException) {
            object = xPathException;
            xPathException.setXPathContext(xPathContext);
            ((XPathException)object).setLocation(this.getLocation());
            throw object;
        }
    }

    public static String checkContentXSLT(String string) {
        int n2;
        while ((n2 = string.indexOf("?>")) >= 0) {
            string = string.substring(0, n2 + 1) + ' ' + string.substring(n2 + 1);
        }
        return Whitespace.removeLeadingWhitespace(string).toString();
    }

    public static String checkContentXQuery(String string) {
        if (string.contains("?>")) {
            throw new XPathException("Invalid characters (?>) in processing instruction", "XQDY0026");
        }
        return Whitespace.removeLeadingWhitespace(string).toString();
    }

    @Override
    public NodeName evaluateNodeName(XPathContext object) {
        object = this.a((XPathContext)object);
        return new NoNamespaceName((String)object);
    }

    private String a(XPathContext xPathContext) {
        Object object = (AtomicValue)this.getNameExp().evaluateItem(xPathContext);
        if (object instanceof StringValue && !(object instanceof AnyURIValue)) {
            return this.a((AtomicValue)object, xPathContext);
        }
        object = new XPathException("Processing instruction name is not a string");
        ((XPathException)object).setXPathContext(xPathContext);
        ((XPathException)object).setErrorCode("XPTY0004");
        throw ProcessingInstruction.dynamicError(this.getLocation(), (XPathException)object, xPathContext);
    }

    private String a(AtomicValue object, XPathContext xPathContext) {
        if (object instanceof StringValue && !(object instanceof AnyURIValue)) {
            if (!NameChecker.isValidNCName((CharSequence)(object = Whitespace.trim(((AtomicValue)object).getStringValue())))) {
                object = new XPathException("Processing instruction name " + Err.wrap((CharSequence)object) + " is not a valid NCName");
                ((XPathException)object).setXPathContext(xPathContext);
                ((XPathException)object).setErrorCode(this.isXSLT() ? "XTDE0890" : "XQDY0041");
                throw ProcessingInstruction.dynamicError(this.getLocation(), (XPathException)object, xPathContext);
            }
            if (((String)object).equalsIgnoreCase("xml")) {
                object = new XPathException("Processing instructions cannot be named 'xml' in any combination of upper/lower case");
                ((XPathException)object).setXPathContext(xPathContext);
                ((XPathException)object).setErrorCode(this.isXSLT() ? "XTDE0890" : "XQDY0064");
                throw ProcessingInstruction.dynamicError(this.getLocation(), (XPathException)object, xPathContext);
            }
            return object;
        }
        object = new XPathException("Processing instruction name " + Err.wrap(((AtomicValue)object).getStringValue()) + " is not of type xs:string or xs:untypedAtomic");
        ((XPathException)object).setXPathContext(xPathContext);
        ((XPathException)object).setErrorCode("XPTY0004");
        ((XPathException)object).setIsTypeError(true);
        throw ProcessingInstruction.dynamicError(this.getLocation(), (XPathException)object, xPathContext);
    }

    @Override
    public void export(ExpressionPresenter expressionPresenter) {
        expressionPresenter.startElement("procInst", this);
        String string = "";
        if (this.isLocal()) {
            string = string + "l";
        }
        if (!string.isEmpty()) {
            expressionPresenter.emitAttribute("flags", string);
        }
        expressionPresenter.setChildRole("name");
        this.getNameExp().export(expressionPresenter);
        expressionPresenter.setChildRole("select");
        this.getSelect().export(expressionPresenter);
        expressionPresenter.endElement();
    }
}

