/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.instruct;

import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.xml.transform.Result;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamResult;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.event.ComplexContentOutputter;
import net.sf.saxon.event.NamespaceReducer;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.Binding;
import net.sf.saxon.expr.ContextOriginator;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.LetExpression;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.DocumentInstr;
import net.sf.saxon.expr.instruct.Instruction;
import net.sf.saxon.expr.instruct.InstructionWithComplexContent;
import net.sf.saxon.expr.instruct.TailCall;
import net.sf.saxon.expr.instruct.ValidatingInstruction;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.PathMap;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.expr.parser.RetainedStaticContext;
import net.sf.saxon.functions.IriToUri;
import net.sf.saxon.functions.ResolveURI;
import net.sf.saxon.lib.Feature;
import net.sf.saxon.lib.ParseOptions;
import net.sf.saxon.lib.ResultDocumentResolver;
import net.sf.saxon.lib.SaxonOutputKeys;
import net.sf.saxon.lib.SerializerFactory;
import net.sf.saxon.lib.Validation;
import net.sf.saxon.om.DocumentURI;
import net.sf.saxon.om.InscopeNamespaceResolver;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.serialize.CharacterMapIndex;
import net.sf.saxon.serialize.PrincipalOutputGatekeeper;
import net.sf.saxon.serialize.SerializationProperties;
import net.sf.saxon.style.StylesheetPackage;
import net.sf.saxon.style.XSLResultDocument;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.trans.XsltController;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.type.ErrorType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.value.Whitespace;

public class ResultDocument
extends Instruction
implements ContextOriginator,
InstructionWithComplexContent,
ValidatingInstruction {
    private Operand a;
    private Operand b;
    private Operand c;
    private boolean d = false;
    protected final Properties globalProperties;
    protected final Properties localProperties;
    protected ParseOptions validationOptions;
    protected final Map<StructuredQName, Operand> serializationAttributes;
    protected boolean resolveAgainstStaticBase = false;
    protected final CharacterMapIndex characterMapIndex;

    /*
     * WARNING - void declaration
     */
    public ResultDocument(Properties iterator, Properties object2, Expression expression, Expression expression2, int n2, SchemaType schemaType, Map<StructuredQName, Expression> map, CharacterMapIndex characterMapIndex) {
        void var8_12;
        void var7_11;
        void var6_10;
        void var5_9;
        void var4_8;
        void var3_7;
        this.globalProperties = iterator;
        this.localProperties = object2;
        if (var3_7 != null) {
            this.a = new Operand(this, (Expression)var3_7, OperandRole.SINGLE_ATOMIC);
        }
        if (var4_8 != null) {
            this.b = new Operand(this, (Expression)var4_8, OperandRole.SINGLE_ATOMIC);
        }
        this.setValidationAction((int)var5_9, (SchemaType)var6_10);
        this.serializationAttributes = new HashMap<StructuredQName, Operand>(var7_11.size());
        for (Map.Entry entry : var7_11.entrySet()) {
            this.serializationAttributes.put((StructuredQName)entry.getKey(), new Operand(this, (Expression)entry.getValue(), OperandRole.SINGLE_ATOMIC));
        }
        this.characterMapIndex = var8_12;
        for (Expression expression3 : var7_11.values()) {
            this.adoptChildExpression(expression3);
        }
    }

    public void setContentExpression(Expression expression) {
        this.c = new Operand(this, expression, OperandRole.SINGLE_ATOMIC);
    }

    public void setSchemaType(SchemaType schemaType) {
        if (this.validationOptions == null) {
            this.validationOptions = new ParseOptions();
        }
        this.validationOptions.setSchemaValidationMode(8);
        this.validationOptions.setTopLevelType(schemaType);
    }

    @Override
    public SchemaType getSchemaType() {
        if (this.validationOptions == null) {
            return null;
        }
        return this.validationOptions.getTopLevelType();
    }

    public boolean isResolveAgainstStaticBase() {
        return this.resolveAgainstStaticBase;
    }

    public ParseOptions getValidationOptions() {
        return this.validationOptions;
    }

    public void setValidationAction(int n2, SchemaType schemaType) {
        boolean bl2 = n2 == 3 && schemaType == null;
        if (!bl2 && this.validationOptions == null) {
            this.validationOptions = new ParseOptions();
            this.validationOptions.setSchemaValidationMode(n2);
            this.validationOptions.setTopLevelType(schemaType);
        }
    }

    @Override
    public int getValidationAction() {
        if (this.validationOptions == null) {
            return 3;
        }
        return this.validationOptions.getSchemaValidationMode();
    }

    public Expression getFormatExpression() {
        if (this.b == null) {
            return null;
        }
        return this.b.getChildExpression();
    }

    public void setUseStaticBaseUri(boolean bl2) {
        this.resolveAgainstStaticBase = bl2;
    }

    public void setAsynchronous(boolean bl2) {
        this.d = bl2;
    }

    public boolean isAsynchronous() {
        return this.d;
    }

    @Override
    public boolean isMultiThreaded(Configuration configuration) {
        return this.isAsynchronous() && configuration.isLicensedFeature(1) && configuration.getBooleanProperty(Feature.ALLOW_MULTITHREADING);
    }

    @Override
    public Expression typeCheck(ExpressionVisitor object, ContextItemStaticInfo object2) {
        this.typeCheckChildren((ExpressionVisitor)object, (ContextItemStaticInfo)object2);
        object2 = this.getStaticSerializationProperty(XSLResultDocument.METHOD);
        boolean bl2 = object2 == null && this.b == null && !this.serializationAttributes.containsKey(XSLResultDocument.METHOD);
        boolean bl3 = "yes".equals(this.getStaticSerializationProperty(XSLResultDocument.BUILD_TREE));
        if (bl3 || bl2 || "xml".equals(object2) || "html".equals(object2) || "xhtml".equals(object2) || "text".equals(object2)) {
            try {
                DocumentInstr.checkContentSequence(((ExpressionVisitor)object).getStaticContext(), this.c, this.validationOptions);
            }
            catch (XPathException xPathException) {
                object = xPathException;
                xPathException.maybeSetLocation(this.getLocation());
                throw object;
            }
        }
        return this;
    }

    @Override
    public int getIntrinsicDependencies() {
        return 0x2000000;
    }

    @Override
    public Expression optimize(ExpressionVisitor object, ContextItemStaticInfo contextItemStaticInfo) {
        this.optimizeChildren((ExpressionVisitor)object, contextItemStaticInfo);
        if (this.isAsynchronous()) {
            for (object = this.getParentExpression(); object != null; object = ((Expression)object).getParentExpression()) {
                if (!(object instanceof LetExpression) || !ExpressionTool.dependsOnVariable(this.getContentExpression(), new Binding[]{(LetExpression)object})) continue;
                ((LetExpression)object).setNeedsEagerEvaluation(true);
            }
        }
        return this;
    }

    @Override
    public Expression copy(RebindingMap rebindingMap) {
        HashMap<StructuredQName, Expression> hashMap = new HashMap<StructuredQName, Expression>();
        for (Map.Entry<StructuredQName, Operand> entry : this.serializationAttributes.entrySet()) {
            hashMap.put(entry.getKey(), entry.getValue().getChildExpression().copy(rebindingMap));
        }
        ResultDocument resultDocument = new ResultDocument(this.globalProperties, this.localProperties, this.getHref() == null ? null : this.getHref().copy(rebindingMap), this.getFormatExpression() == null ? null : this.getFormatExpression().copy(rebindingMap), this.getValidationAction(), this.getSchemaType(), hashMap, this.characterMapIndex);
        ExpressionTool.copyLocationInfo(this, resultDocument);
        resultDocument.setContentExpression(this.getContentExpression().copy(rebindingMap));
        resultDocument.resolveAgainstStaticBase = this.resolveAgainstStaticBase;
        resultDocument.d = this.d;
        return resultDocument;
    }

    @Override
    public int getInstructionNameCode() {
        return 193;
    }

    @Override
    public ItemType getItemType() {
        return ErrorType.getInstance();
    }

    @Override
    public Iterable<Operand> operands() {
        ArrayList<Operand> arrayList = new ArrayList<Operand>(6);
        arrayList.add(this.c);
        if (this.a != null) {
            arrayList.add(this.a);
        }
        if (this.b != null) {
            arrayList.add(this.b);
        }
        arrayList.addAll(this.serializationAttributes.values());
        return arrayList;
    }

    @Override
    public PathMap.PathMapNodeSet addToPathMap(PathMap pathMap, PathMap.PathMapNodeSet pathMapNodeSet) {
        pathMapNodeSet = super.addToPathMap(pathMap, pathMapNodeSet);
        pathMapNodeSet.setReturnable(false);
        return new PathMap.PathMapNodeSet(pathMap.makeNewRoot(this));
    }

    @Override
    public TailCall processLeavingTail(XPathContext xPathContext) {
        ResultDocument resultDocument = this;
        resultDocument.process(resultDocument.getContentExpression(), xPathContext);
        return null;
    }

    public void process(Expression expression, XPathContext xPathContext) {
        this.a(xPathContext);
        xPathContext.getConfiguration().processResultDocument(this, expression, xPathContext);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void processInstruction(Expression object, XPathContext xPathContext) {
        Object object2 = (XsltController)xPathContext.getController();
        assert (object2 != null);
        ((Controller)object2).getConfiguration();
        object2 = xPathContext.getReceiver();
        object2.getPipelineConfiguration();
        String string = xPathContext.getCurrentOutputUri();
        Receiver receiver = this.processLeft(xPathContext);
        boolean bl2 = false;
        try {
            ((Expression)object).process(xPathContext);
        }
        catch (XPathException xPathException) {
            try {
                bl2 = true;
                xPathException.maybeSetContext(xPathContext);
                xPathException.maybeSetLocation(this.getLocation());
                throw xPathException;
            }
            catch (Throwable throwable) {
                try {
                    receiver.close();
                    throw throwable;
                }
                catch (XPathException xPathException2) {
                    if (bl2) throw throwable;
                    throw xPathException2;
                }
            }
        }
        try {
            receiver.close();
        }
        catch (XPathException xPathException) {
            object = xPathException;
            throw xPathException;
        }
        xPathContext.setReceiver((Receiver)object2);
        xPathContext.setCurrentOutputUri(string);
    }

    public Receiver processLeft(XPathContext xPathContext) {
        Object object;
        Object object2 = (XsltController)xPathContext.getController();
        Object object3 = ((Controller)object2).getConfiguration();
        this.a(xPathContext);
        Object object4 = this.gatherOutputProperties(xPathContext);
        if (this.localProperties.contains("parameter-document") && this.getStaticBaseURIString() != null) {
            ((Properties)object4).setProperty("{http://saxon.sf.net/}parameter-document-base-uri", this.getStaticBaseURIString());
        }
        object4 = new SerializationProperties((Properties)object4, this.characterMapIndex);
        if (this.validationOptions != null && this.validationOptions.getSchemaValidationMode() != 3) {
            ((SerializationProperties)object4).setValidationFactory(arg_0 -> this.a((Configuration)object3, arg_0));
        }
        object3 = null;
        String string = "";
        if (this.getHref() != null) {
            string = IriToUri.iriToUri(this.getHref().evaluateAsString(xPathContext)).toString();
        }
        if ((string.isEmpty() || string.equals(((Controller)object2).getBaseOutputURI())) && (object = ((XsltController)object2).getGatekeeper()) != null) {
            ((PrincipalOutputGatekeeper)object).useAsSecondary();
            object3 = ((PrincipalOutputGatekeeper)object).makeReceiver((SerializationProperties)object4);
        }
        if (object3 == null) {
            try {
                object3 = ((XsltController)object2).getResultDocumentResolver();
                object3 = ResultDocument.makeReceiver(string, this.getStaticBaseURIString(), xPathContext, (ResultDocumentResolver)object3, (SerializationProperties)object4, this.resolveAgainstStaticBase);
                ResultDocument.traceDestination(xPathContext, (Result)object3);
            }
            catch (XPathException xPathException) {
                object = xPathException;
                xPathException.maybeSetLocation(this.getLocation());
                ((XPathException)object).maybeSetContext(xPathContext);
                throw object;
            }
        }
        object3.getPipelineConfiguration().setController((Controller)object2);
        object = object3.getSystemId();
        object2 = new NamespaceReducer((Receiver)object3);
        object3 = new ComplexContentOutputter((Receiver)object2);
        object3.setSystemId((String)object);
        xPathContext.setReceiver((Receiver)object3);
        xPathContext.setCurrentOutputUri((String)object);
        object3.open();
        return object3;
    }

    public CharacterMapIndex getCharacterMapIndex() {
        return this.characterMapIndex;
    }

    private void a(XPathContext object) {
        if (object.getTemporaryOutputState() != 0) {
            object = new XPathException("Cannot execute xsl:result-document while evaluating xsl:" + object.getNamePool().getLocalName(object.getTemporaryOutputState()));
            ((XPathException)object).setErrorCode("XTDE1480");
            ((XPathException)object).setLocation(this.getLocation());
            throw object;
        }
    }

    public static Receiver makeReceiver(String string, String object, XPathContext xPathContext, ResultDocumentResolver object2, SerializationProperties object3, boolean bl2) {
        Controller controller = xPathContext.getController();
        try {
            if (!bl2) {
                object = controller.getBaseOutputURI();
            }
            try {
                object2 = object2.resolve(xPathContext, string, (String)object, (SerializationProperties)object3);
                object3 = object2.getSystemId();
                if (object3 == null) {
                    object3 = ResolveURI.makeAbsolute(string, (String)object).toASCIIString();
                    object2.setSystemId((String)object3);
                }
                ResultDocument.checkAcceptableUri(xPathContext, (String)object3);
                return object2;
            }
            catch (XPathException xPathException) {
                object2 = xPathException;
                throw xPathException;
            }
            catch (Exception exception) {
                object2 = exception;
                exception.printStackTrace();
                throw new XPathException("Exception thrown by output resolver", (Throwable)object2);
            }
        }
        catch (TransformerException transformerException) {
            object = transformerException;
            throw XPathException.makeXPathException(transformerException);
        }
    }

    public static void traceDestination(XPathContext object, Result result) {
        boolean bl2 = ((Configuration)(object = object.getConfiguration())).isTiming();
        if (bl2) {
            String string = result.getSystemId();
            if (string == null) {
                string = result instanceof StreamResult ? "anonymous output stream" : (result instanceof SAXResult ? "SAX2 ContentHandler" : (result instanceof DOMResult ? "DOM tree" : result.getClass().getName()));
            }
            ((Configuration)object).getStandardErrorOutput().println("Writing to " + string);
        }
    }

    public static void checkAcceptableUri(XPathContext xPathContext, String object) {
        XsltController xsltController = (XsltController)xPathContext.getController();
        assert (xsltController != null);
        if (object != null) {
            if (xsltController.getDocumentPool().find((String)object) != null) {
                XPathException xPathException = new XPathException("Cannot write to a URI that has already been read: " + (String)(((String)object).equals("dummy:/anonymous/principal/result") ? "(implicit output URI)" : object));
                xPathException.setXPathContext(xPathContext);
                xPathException.setErrorCode("XTDE1500");
                throw xPathException;
            }
            DocumentURI documentURI = new DocumentURI((String)object);
            XsltController xsltController2 = xsltController;
            synchronized (xsltController2) {
                if (!xsltController.checkUniqueOutputDestination(documentURI)) {
                    object = new XPathException("Cannot write more than one result document to the same URI: " + (String)(((String)object).equals("dummy:/anonymous/principal/result") ? "(implicit output URI)" : object));
                    ((XPathException)object).setXPathContext(xPathContext);
                    ((XPathException)object).setErrorCode("XTDE1490");
                    throw object;
                }
                xsltController.addUnavailableOutputDestination(documentURI);
                return;
            }
        }
    }

    public Properties gatherOutputProperties(XPathContext xPathContext) {
        Object object;
        String string;
        Controller controller = xPathContext.getController();
        assert (controller != null);
        Configuration configuration = xPathContext.getConfiguration();
        Object object2 = this.globalProperties;
        RetainedStaticContext retainedStaticContext = this.getRetainedStaticContext();
        assert (retainedStaticContext != null);
        if (this.getFormatExpression() != null) {
            String string2 = this.getFormatExpression().evaluateAsString(xPathContext).toString();
            if (string2.startsWith("Q{")) {
                object2 = StructuredQName.fromEQName(string2);
            } else {
                String[] object3;
                try {
                    object3 = NameChecker.getQNameParts(string2);
                }
                catch (QNameException qNameException) {
                    XPathException xPathException = new XPathException("The requested output format " + Err.wrap(string2) + " is not a valid QName");
                    xPathException.maybeSetLocation(this.getFormatExpression().getLocation());
                    xPathException.setErrorCode("XTDE1460");
                    xPathException.setXPathContext(xPathContext);
                    throw xPathException;
                }
                string = retainedStaticContext.getURIForPrefix(object3[0], false);
                if (string == null) {
                    XPathException xPathException = new XPathException("The namespace prefix in the format name " + string2 + " is undeclared");
                    xPathException.maybeSetLocation(this.getFormatExpression().getLocation());
                    xPathException.setErrorCode("XTDE1460");
                    xPathException.setXPathContext(xPathContext);
                    throw xPathException;
                }
                object2 = new StructuredQName(object3[0], string, object3[1]);
            }
            object2 = ((StylesheetPackage)this.getRetainedStaticContext().getPackageData()).getNamedOutputProperties((StructuredQName)object2);
            if (object2 == null) {
                XPathException xPathException = new XPathException("There is no xsl:output format named " + string2);
                xPathException.setErrorCode("XTDE1460");
                xPathException.setXPathContext(xPathContext);
                throw xPathException;
            }
        }
        object2 = new Properties((Properties)object2);
        for (Object e2 : this.localProperties.keySet()) {
            string = (String)e2;
            object = StructuredQName.fromClarkName(string);
            try {
                ResultDocument.setSerializationProperty((Properties)object2, ((StructuredQName)object).getURI(), ((StructuredQName)object).getLocalPart(), this.localProperties.getProperty(string), retainedStaticContext, true, configuration);
            }
            catch (XPathException xPathException) {
                XPathException xPathException2 = xPathException;
                xPathException.setErrorCode("XTDE0030");
                xPathException2.maybeSetLocation(this.getLocation());
                throw xPathException2;
            }
        }
        if (!this.serializationAttributes.isEmpty()) {
            for (Map.Entry<StructuredQName, Operand> entry : this.serializationAttributes.entrySet()) {
                string = entry.getValue().getChildExpression().evaluateAsString(xPathContext).toString();
                object = entry.getKey().getLocalPart();
                String string2 = entry.getKey().getURI();
                try {
                    ResultDocument.setSerializationProperty((Properties)object2, string2, (String)object, string, retainedStaticContext, false, configuration);
                }
                catch (XPathException xPathException) {
                    XPathException xPathException3 = xPathException;
                    xPathException.setErrorCode("XTDE0030");
                    xPathException3.maybeSetLocation(this.getLocation());
                    xPathException3.maybeSetContext(xPathContext);
                    if ("http://saxon.sf.net/".equals(xPathException3.getErrorCodeNamespace()) && "SXWN".equals(xPathException3.getErrorCodeLocalPart().substring(0, 4))) {
                        controller.getErrorListener().warning(xPathException3);
                        continue;
                    }
                    throw xPathException3;
                }
            }
        }
        return object2;
    }

    public String getStaticSerializationProperty(StructuredQName structuredQName) {
        String string = structuredQName.getClarkName();
        String string2 = this.localProperties.getProperty(string);
        if (string2 != null) {
            return string2;
        }
        if (this.serializationAttributes.containsKey(structuredQName)) {
            return null;
        }
        return this.globalProperties.getProperty(string);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void setSerializationProperty(Properties serializable, String object, String string, String object2, NamespaceResolver namespaceResolver, boolean bl2, Configuration object3) {
        object3 = ((Configuration)object3).getSerializerFactory();
        String string2 = string;
        if (!((String)object).isEmpty()) {
            string2 = "{" + (String)object + "}" + string;
        }
        if (((String)object).isEmpty() || "http://saxon.sf.net/".equals(object)) {
            switch (string2) {
                case "method": {
                    object2 = Whitespace.trim((CharSequence)object2);
                    if (((String)object2).startsWith("Q{}") && ((String)object2).length() > 3) {
                        object2 = ((String)object2).substring(3);
                    }
                    if (((String)object2).equals("xml") || ((String)object2).equals("html") || ((String)object2).equals("text") || ((String)object2).equals("xhtml") || ((String)object2).equals("json") || ((String)object2).equals("adaptive") || bl2 || ((String)object2).startsWith("{")) {
                        ((Properties)serializable).setProperty("method", (String)object2);
                        return;
                    }
                    if (((String)object2).startsWith("Q{")) {
                        ((Properties)serializable).setProperty("method", ((String)object2).substring(1));
                        return;
                    }
                    try {
                        object = NameChecker.getQNameParts((CharSequence)object2);
                        String string3 = object[0];
                        if (string3.isEmpty()) {
                            object2 = new XPathException("method must be xml, html, xhtml, text, json, adaptive, or a prefixed name");
                            ((XPathException)object2).setErrorCode("SEPM0016");
                            ((XPathException)object2).setIsStaticError(true);
                            throw object2;
                        }
                        if (namespaceResolver != null) {
                            object2 = namespaceResolver.getURIForPrefix(string3, false);
                            if (object2 == null) {
                                serializable = new XPathException("Namespace prefix '" + string3 + "' has not been declared");
                                ((XPathException)serializable).setErrorCode("SEPM0016");
                                ((XPathException)serializable).setIsStaticError(true);
                                throw serializable;
                            }
                            ((Properties)serializable).setProperty("method", "{" + (String)object2 + '}' + (String)object[1]);
                            return;
                        }
                        ((Properties)serializable).setProperty("method", (String)object2);
                        return;
                    }
                    catch (QNameException qNameException) {
                        object2 = new XPathException("Invalid method name. " + qNameException.getMessage());
                        ((XPathException)object2).setErrorCode("SEPM0016");
                        ((XPathException)object2).setIsStaticError(true);
                        throw object2;
                    }
                }
                case "use-character-maps": {
                    object = ((Properties)serializable).getProperty("use-character-maps");
                    if (object == null) {
                        object = "";
                    }
                    ((Properties)serializable).setProperty("use-character-maps", (String)object + (String)object2);
                    return;
                }
                case "cdata-section-elements": {
                    ResultDocument.a((Properties)serializable, string2, (String)object2, namespaceResolver, true, bl2, false);
                    return;
                }
                case "suppress-indentation": {
                    ResultDocument.a((Properties)serializable, string2, (String)object2, namespaceResolver, true, bl2, false);
                    return;
                }
                case "{http://saxon.sf.net/}double-space": {
                    ResultDocument.a((Properties)serializable, string2, (String)object2, namespaceResolver, true, bl2, false);
                    return;
                }
                case "{http://saxon.sf.net/}attribute-order": {
                    ResultDocument.a((Properties)serializable, string2, (String)object2, namespaceResolver, false, bl2, true);
                    return;
                }
                case "{http://saxon.sf.net/}next-in-chain": {
                    return;
                }
                default: {
                    if (string2.equals("output-version")) {
                        string2 = "version";
                    }
                    if (!bl2) {
                        try {
                            if (!SaxonOutputKeys.isUnstrippedProperty(string2)) {
                                object2 = Whitespace.trim((CharSequence)object2);
                            }
                            object2 = ((SerializerFactory)object3).checkOutputProperty(string2, (String)object2);
                        }
                        catch (XPathException xPathException) {
                            XPathException xPathException2 = xPathException;
                            xPathException.maybeSetErrorCode("SEPM0016");
                            throw xPathException2;
                        }
                    }
                    ((Properties)serializable).setProperty(string2, (String)object2);
                }
            }
            return;
        }
        ((Properties)serializable).setProperty("{" + (String)object + '}' + string, (String)object2);
    }

    private static void a(Properties properties, String string, String string2, NamespaceResolver namespaceResolver, boolean bl2, boolean bl3, boolean bl4) {
        String string3 = properties.getProperty(string);
        if (string3 == null) {
            string3 = "";
        }
        string2 = SaxonOutputKeys.parseListOfNodeNames(string2, namespaceResolver, bl2, bl3, bl4, "SEPM0016");
        properties.setProperty(string, string3 + string2);
    }

    @Override
    public void export(ExpressionPresenter expressionPresenter) {
        Object object;
        expressionPresenter.startElement("resultDoc", this);
        expressionPresenter.emitAttribute("global", ResultDocument.a(this.globalProperties));
        expressionPresenter.emitAttribute("local", ResultDocument.a(this.localProperties));
        if (this.getValidationAction() != 4 && this.getValidationAction() != 8) {
            expressionPresenter.emitAttribute("validation", Validation.toString(this.getValidationAction()));
        }
        if ((object = this.getSchemaType()) != null) {
            expressionPresenter.emitAttribute("type", object.getStructuredQName());
        }
        if (this.getHref() != null) {
            expressionPresenter.setChildRole("href");
            this.getHref().export(expressionPresenter);
        }
        if (this.getFormatExpression() != null) {
            expressionPresenter.setChildRole("format");
            this.getFormatExpression().export(expressionPresenter);
        }
        for (Map.Entry entry : this.serializationAttributes.entrySet()) {
            StructuredQName structuredQName = (StructuredQName)entry.getKey();
            Expression object2 = ((Operand)entry.getValue()).getChildExpression();
            expressionPresenter.setChildRole(structuredQName.getEQName());
            object2.export(expressionPresenter);
        }
        expressionPresenter.setChildRole("content");
        this.getContentExpression().export(expressionPresenter);
        expressionPresenter.endElement();
    }

    private static String a(Properties properties) {
        try {
            StringWriter stringWriter = new StringWriter();
            properties.store(stringWriter, "");
            return stringWriter.toString();
        }
        catch (IOException iOException) {
            throw new AssertionError((Object)iOException);
        }
    }

    public static void processXslOutputElement(NodeInfo object, Properties properties, XPathContext xPathContext) {
        AxisIterator axisIterator = object.iterateAxis((byte)2);
        object = new InscopeNamespaceResolver((NodeInfo)object);
        axisIterator.forEachOrFail(arg_0 -> ResultDocument.a(properties, (NamespaceResolver)object, xPathContext, arg_0));
    }

    @Override
    public String getStreamerName() {
        return "ResultDocument";
    }

    public Expression getHref() {
        if (this.a == null) {
            return null;
        }
        return this.a.getChildExpression();
    }

    public void setHref(Expression expression) {
        this.a.setChildExpression(expression);
    }

    public void setFormatExpression(Expression expression) {
        this.b.setChildExpression(expression);
    }

    @Override
    public Expression getContentExpression() {
        return this.c.getChildExpression();
    }

    private static /* synthetic */ void a(Properties properties, NamespaceResolver namespaceResolver, XPathContext xPathContext, NodeInfo object) {
        String string = object.getURI();
        String string2 = object.getLocalPart();
        object = Whitespace.trim(object.getStringValueCS());
        ResultDocument.setSerializationProperty(properties, string, string2, (String)object, namespaceResolver, false, xPathContext.getConfiguration());
    }

    private /* synthetic */ Receiver a(Configuration configuration, Receiver receiver) {
        NamespaceReducer namespaceReducer = new NamespaceReducer(receiver);
        return configuration.getDocumentValidator(namespaceReducer, receiver.getSystemId(), this.validationOptions, this.getLocation());
    }
}

