/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.instruct;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Predicate;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NamespaceResolver;

public final class SavedNamespaceContext
implements NamespaceResolver {
    private Map<String, String> a = new HashMap<String, String>();

    public SavedNamespaceContext(Iterable<NamespaceBinding> iterable) {
        this(iterable.iterator());
    }

    public SavedNamespaceContext(Iterator<NamespaceBinding> iterator) {
        while (iterator.hasNext()) {
            NamespaceBinding namespaceBinding = iterator.next();
            this.a.put(namespaceBinding.getPrefix(), namespaceBinding.getURI());
        }
    }

    public SavedNamespaceContext(Iterator<NamespaceBinding> iterator, Predicate<NamespaceBinding> predicate) {
        while (iterator.hasNext()) {
            NamespaceBinding namespaceBinding = iterator.next();
            if (predicate.test(namespaceBinding)) continue;
            this.a.put(namespaceBinding.getPrefix(), namespaceBinding.getURI());
        }
    }

    public SavedNamespaceContext(NamespaceResolver namespaceResolver) {
        Iterator<String> iterator = namespaceResolver.iteratePrefixes();
        while (iterator.hasNext()) {
            String string = iterator.next();
            String string2 = namespaceResolver.getURIForPrefix(string, true);
            this.a.put(string, string2);
        }
    }

    @Override
    public final String getURIForPrefix(String string, boolean bl2) {
        if (string.isEmpty() && !bl2) {
            return "";
        }
        if (string.equals("xml")) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        String string2 = this.a.get(string);
        if (string2 == null) {
            if (string.isEmpty()) {
                return "";
            }
            return null;
        }
        return string2;
    }

    @Override
    public final Iterator<String> iteratePrefixes() {
        ArrayList<String> arrayList = new ArrayList<String>(this.a.size() + 1);
        arrayList.addAll(this.a.keySet());
        arrayList.add("xml");
        return arrayList.iterator();
    }

    public final boolean equals(Object object) {
        return object instanceof SavedNamespaceContext && this.a.equals(((SavedNamespaceContext)object).a);
    }

    public final int hashCode() {
        return this.a.hashCode();
    }
}

