/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.instruct;

import java.util.HashSet;
import java.util.Set;
import net.sf.saxon.Controller;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.OperandUsage;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.accum.Accumulator;
import net.sf.saxon.expr.instruct.Instruction;
import net.sf.saxon.expr.instruct.TailCall;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.expr.parser.TypeChecker;
import net.sf.saxon.functions.DocumentFn;
import net.sf.saxon.lib.ParseOptions;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.style.StylesheetPackage;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.QuitParsingException;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.trans.XsltController;
import net.sf.saxon.tree.iter.ManualIterator;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.value.SequenceType;

public class SourceDocument
extends Instruction {
    protected Operand hrefOp;
    protected Operand bodyOp;
    protected ParseOptions parseOptions;
    protected Set<? extends Accumulator> accumulators = new HashSet<Accumulator>();

    public SourceDocument(Expression expression, Expression expression2, ParseOptions parseOptions) {
        this.hrefOp = new Operand(this, expression, OperandRole.SINGLE_ATOMIC);
        this.bodyOp = new Operand(this, expression2, new OperandRole(64, OperandUsage.TRANSMISSION));
        this.parseOptions = parseOptions;
        this.accumulators = parseOptions.getApplicableAccumulators();
    }

    @Override
    public String getExpressionName() {
        return "xsl:source-document";
    }

    public String getExportTag() {
        return "sourceDoc";
    }

    public Expression getHref() {
        return this.hrefOp.getChildExpression();
    }

    public void setHref(Expression expression) {
        this.hrefOp.setChildExpression(expression);
    }

    public Expression getBody() {
        return this.bodyOp.getChildExpression();
    }

    public void setBody(Expression expression) {
        this.bodyOp.setChildExpression(expression);
    }

    public void setUsedAccumulators(Set<? extends Accumulator> set) {
        this.accumulators = set;
    }

    @Override
    public Iterable<Operand> operands() {
        return this.operandList(this.hrefOp, this.bodyOp);
    }

    @Override
    public boolean allowExtractingCommonSubexpressions() {
        return false;
    }

    @Override
    public Expression typeCheck(ExpressionVisitor expressionVisitor, ContextItemStaticInfo object) {
        this.hrefOp.typeCheck(expressionVisitor, (ContextItemStaticInfo)object);
        object = new RoleDiagnostic(4, "xsl:stream/href", 0);
        TypeChecker typeChecker = expressionVisitor.getConfiguration().getTypeChecker(false);
        this.hrefOp.setChildExpression(typeChecker.staticTypeCheck(this.hrefOp.getChildExpression(), SequenceType.SINGLE_STRING, (RoleDiagnostic)object, expressionVisitor));
        object = this.getConfiguration().makeContextItemStaticInfo(NodeKindTest.DOCUMENT, false);
        ((ContextItemStaticInfo)object).setContextPostureStriding();
        this.bodyOp.typeCheck(expressionVisitor, (ContextItemStaticInfo)object);
        return this;
    }

    @Override
    public Expression optimize(ExpressionVisitor expressionVisitor, ContextItemStaticInfo contextItemStaticInfo) {
        ContextItemStaticInfo contextItemStaticInfo2 = this.getConfiguration().makeContextItemStaticInfo(NodeKindTest.DOCUMENT, false);
        contextItemStaticInfo2.setContextPostureStriding();
        this.hrefOp.optimize(expressionVisitor, contextItemStaticInfo);
        this.bodyOp.optimize(expressionVisitor, contextItemStaticInfo2);
        return this;
    }

    @Override
    public boolean mayCreateNewNodes() {
        return !this.getBody().hasSpecialProperty(0x800000);
    }

    @Override
    public int computeDependencies() {
        int n2 = 0 | this.getHref().getDependencies();
        return n2 |= this.getBody().getDependencies() & 0xFFFFFFE1;
    }

    @Override
    public int computeSpecialProperties() {
        Expression expression = this.getBody();
        if ((expression.getSpecialProperties() & 0x400000) != 0) {
            return 655360;
        }
        return super.computeSpecialProperties();
    }

    @Override
    public void export(ExpressionPresenter expressionPresenter) {
        Object object;
        ExpressionPresenter.ExportOptions exportOptions = (ExpressionPresenter.ExportOptions)expressionPresenter.getOptions();
        if ("JS".equals(exportOptions.target) && exportOptions.targetVersion == 1) {
            throw new XPathException("xsl:source-document is not supported in Saxon-JS 1.*", "SXJS0001");
        }
        expressionPresenter.startElement(this.getExportTag(), this);
        int n2 = this.parseOptions.getSchemaValidationMode();
        if (n2 != 4 && n2 != 8) {
            expressionPresenter.emitAttribute("validation", "" + n2);
        }
        if ((object = this.parseOptions.getTopLevelType()) != null) {
            expressionPresenter.emitAttribute("schemaType", object.getStructuredQName());
        }
        Object object2 = object = this.getPackageData() instanceof StylesheetPackage ? ((StylesheetPackage)this.getPackageData()).getSpaceStrippingRule() : null;
        if (this.parseOptions.getSpaceStrippingRule() == object) {
            expressionPresenter.emitAttribute("flags", "s");
        }
        if (this.accumulators != null && !this.accumulators.isEmpty()) {
            object = new FastStringBuffer(256);
            for (Accumulator accumulator : this.accumulators) {
                if (!((FastStringBuffer)object).isEmpty()) {
                    ((FastStringBuffer)object).append(" ");
                }
                ((FastStringBuffer)object).append(accumulator.getAccumulatorName().getEQName());
            }
            expressionPresenter.emitAttribute("accum", ((FastStringBuffer)object).toString());
        }
        expressionPresenter.setChildRole("href");
        this.getHref().export(expressionPresenter);
        expressionPresenter.setChildRole("body");
        this.getBody().export(expressionPresenter);
        expressionPresenter.endElement();
    }

    @Override
    public Expression copy(RebindingMap object) {
        object = new SourceDocument(this.getHref().copy((RebindingMap)object), this.getBody().copy((RebindingMap)object), this.parseOptions);
        ((Expression)object).setRetainedStaticContext(this.getRetainedStaticContext());
        ExpressionTool.copyLocationInfo(this, (Expression)object);
        return object;
    }

    @Override
    public TailCall processLeavingTail(XPathContext object) {
        try {
            this.push((XPathContext)object);
        }
        catch (QuitParsingException quitParsingException) {
        }
        catch (XPathException xPathException) {
            object = xPathException;
            xPathException.maybeSetLocation(this.getLocation());
            if (((XPathException)object).getErrorCodeQName() == null) {
                ((XPathException)object).setErrorCode("FODC0002");
            }
            throw object;
        }
        return null;
    }

    public void push(XPathContext xPathContext) {
        Object object = this.hrefOp.getChildExpression().evaluateAsString(xPathContext).toString();
        object = DocumentFn.makeDoc((String)object, this.getStaticBaseURIString(), this.getPackageData(), this.parseOptions, xPathContext, this.getLocation(), false);
        Controller controller = xPathContext.getController();
        if (this.accumulators != null && controller instanceof XsltController) {
            ((XsltController)controller).getAccumulatorManager().setApplicableAccumulators(object.getTreeInfo(), this.accumulators);
        }
        xPathContext = xPathContext.newMinorContext();
        xPathContext.setCurrentIterator(new ManualIterator<Object>(object));
        this.bodyOp.getChildExpression().process(xPathContext);
    }
}

