/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.instruct;

import java.util.HashMap;
import java.util.Iterator;
import net.sf.saxon.Controller;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.PendingUpdateList;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.Instruction;
import net.sf.saxon.expr.instruct.TailCall;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.lib.TraceListener;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trace.InstructionInfo;
import net.sf.saxon.type.ItemType;

public class TraceExpression
extends Instruction
implements InstructionInfo {
    private Operand a;
    private StructuredQName b;
    private int c;
    private NamespaceResolver d = null;
    private HashMap<String, Object> e = new HashMap(10);

    public TraceExpression(Expression expression) {
        this.a = new Operand(this, expression, OperandRole.SAME_FOCUS_ACTION);
        this.setProperty("expression", expression);
    }

    public Expression getChild() {
        return this.a.getChildExpression();
    }

    public void setChild(Expression expression) {
        this.a.setChildExpression(expression);
    }

    @Override
    public Iterable<Operand> operands() {
        return this.a;
    }

    public void setConstructType(int n2) {
        this.c = n2;
    }

    @Override
    public int getConstructType() {
        return this.c;
    }

    public void setNamespaceResolver(NamespaceResolver namespaceResolver) {
        this.d = namespaceResolver;
    }

    public NamespaceResolver getNamespaceResolver() {
        return this.d;
    }

    public void setObjectName(StructuredQName structuredQName) {
        this.b = structuredQName;
    }

    @Override
    public StructuredQName getObjectName() {
        return this.b;
    }

    public void setProperty(String string, Object object) {
        this.e.put(string, object);
    }

    @Override
    public Object getProperty(String string) {
        return this.e.get(string);
    }

    @Override
    public Iterator<String> getProperties() {
        return this.e.keySet().iterator();
    }

    @Override
    public String getExpressionName() {
        return "trace";
    }

    @Override
    public String getStreamerName() {
        return "TraceExpr";
    }

    public InstructionInfo getInstructionInfo() {
        return this;
    }

    @Override
    public Expression copy(RebindingMap object) {
        object = new TraceExpression(this.getChild().copy((RebindingMap)object));
        ((Expression)object).setLocation(this.getLocation());
        ((TraceExpression)object).b = this.b;
        ((TraceExpression)object).d = this.d;
        ((TraceExpression)object).c = this.c;
        return object;
    }

    @Override
    public boolean isUpdatingExpression() {
        return this.getChild().isUpdatingExpression();
    }

    @Override
    public boolean isVacuousExpression() {
        return this.getChild().isVacuousExpression();
    }

    @Override
    public void checkForUpdatingSubexpressions() {
        this.getChild().checkForUpdatingSubexpressions();
    }

    @Override
    public int getImplementationMethod() {
        return this.getChild().getImplementationMethod();
    }

    @Override
    public TailCall processLeavingTail(XPathContext xPathContext) {
        Controller controller = xPathContext.getController();
        assert (controller != null);
        TraceListener traceListener = controller.getTraceListener();
        if (controller.isTracing()) {
            assert (traceListener != null);
            traceListener.enter(this.getInstructionInfo(), xPathContext);
        }
        this.getChild().process(xPathContext);
        if (controller.isTracing()) {
            assert (traceListener != null);
            traceListener.leave(this.getInstructionInfo());
        }
        return null;
    }

    @Override
    public ItemType getItemType() {
        return this.getChild().getItemType();
    }

    @Override
    public int getCardinality() {
        return this.getChild().getCardinality();
    }

    @Override
    public int getDependencies() {
        return this.getChild().getDependencies();
    }

    @Override
    public final boolean mayCreateNewNodes() {
        return !this.getChild().hasSpecialProperty(0x800000);
    }

    @Override
    public int getNetCost() {
        return 0;
    }

    public Item evaluateItem(XPathContext object) {
        Controller controller = object.getController();
        assert (controller != null);
        if (controller.isTracing()) {
            controller.getTraceListener().enter(this.getInstructionInfo(), (XPathContext)object);
        }
        object = this.getChild().evaluateItem((XPathContext)object);
        if (controller.isTracing()) {
            controller.getTraceListener().leave(this.getInstructionInfo());
        }
        return object;
    }

    @Override
    public SequenceIterator<?> iterate(XPathContext object) {
        Controller controller = object.getController();
        assert (controller != null);
        if (controller.isTracing()) {
            controller.getTraceListener().enter(this.getInstructionInfo(), (XPathContext)object);
        }
        object = this.getChild().iterate((XPathContext)object);
        if (controller.isTracing()) {
            controller.getTraceListener().leave(this.getInstructionInfo());
        }
        return object;
    }

    @Override
    public int getInstructionNameCode() {
        if (this.getChild() instanceof Instruction) {
            return ((Instruction)this.getChild()).getInstructionNameCode();
        }
        return -1;
    }

    @Override
    public void export(ExpressionPresenter expressionPresenter) {
        this.getChild().export(expressionPresenter);
    }

    @Override
    public void evaluatePendingUpdates(XPathContext xPathContext, PendingUpdateList pendingUpdateList) {
        Controller controller = xPathContext.getController();
        assert (controller != null);
        if (controller.isTracing()) {
            controller.getTraceListener().enter(this.getInstructionInfo(), xPathContext);
        }
        this.getChild().evaluatePendingUpdates(xPathContext, pendingUpdateList);
        if (controller.isTracing()) {
            controller.getTraceListener().leave(this.getInstructionInfo());
        }
    }

    @Override
    public String getSystemId() {
        return this.getLocation().getSystemId();
    }

    @Override
    public int getColumnNumber() {
        return this.getLocation().getColumnNumber();
    }

    @Override
    public String getPublicId() {
        return this.getLocation().getPublicId();
    }

    @Override
    public int getLineNumber() {
        return this.getLocation().getLineNumber();
    }

    @Override
    public Location saveLocation() {
        return this;
    }

    @Override
    public String toShortString() {
        return this.getChild().toShortString();
    }
}

