/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.instruct;

import java.util.Objects;
import net.sf.saxon.Controller;
import net.sf.saxon.expr.ContextOriginator;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.OperandUsage;
import net.sf.saxon.expr.PendingUpdateList;
import net.sf.saxon.expr.UserFunctionCall;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.instruct.Actor;
import net.sf.saxon.expr.instruct.UserFunctionParameter;
import net.sf.saxon.expr.instruct.ValueOf;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.Evaluator;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.expr.sort.AtomicComparer;
import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.om.Function;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.query.AnnotationList;
import net.sf.saxon.style.StylesheetPackage;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.FunctionStreamability;
import net.sf.saxon.trans.SymbolicName;
import net.sf.saxon.trans.Visibility;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.SingletonIterator;
import net.sf.saxon.tree.iter.UnfailingIterator;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.FunctionItemType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SpecificFunctionType;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.SequenceType;

public class UserFunction
extends Actor
implements ContextOriginator,
Function {
    private StructuredQName a;
    private boolean b = false;
    private boolean c = false;
    private UserFunctionParameter[] d;
    private SequenceType e;
    private SequenceType f;
    protected Evaluator evaluator = null;
    private boolean g = false;
    private int h = -1;
    private int i = 0;
    private boolean j = true;
    private AnnotationList k = AnnotationList.EMPTY;
    private FunctionStreamability l = FunctionStreamability.UNCLASSIFIED;
    private Determinism m = Determinism.PROACTIVE;
    private int n = 0;

    @Override
    public int getComponentKind() {
        return 158;
    }

    public void setFunctionName(StructuredQName structuredQName) {
        this.a = structuredQName;
    }

    @Override
    public StructuredQName getFunctionName() {
        return this.a;
    }

    @Override
    public String getDescription() {
        return this.getFunctionName().getDisplayName();
    }

    @Override
    public StructuredQName getObjectName() {
        return this.a;
    }

    @Override
    public SymbolicName.F getSymbolicName() {
        return new SymbolicName.F(this.a, this.getArity());
    }

    @Override
    public FunctionItemType getFunctionItemType() {
        SequenceType[] sequenceTypeArray = new SequenceType[this.d.length];
        for (int i2 = 0; i2 < this.d.length; ++i2) {
            UserFunctionParameter userFunctionParameter = this.d[i2];
            sequenceTypeArray[i2] = userFunctionParameter.getRequiredType();
        }
        return new SpecificFunctionType(sequenceTypeArray, this.e, this.k);
    }

    @Override
    public OperandRole[] getOperandRoles() {
        OperandRole[] operandRoleArray = new OperandRole[this.getArity()];
        Object object = null;
        switch (this.l) {
            case UNCLASSIFIED: {
                object = this.getArgumentType(0);
                object = OperandRole.getTypeDeterminedUsage(((SequenceType)object).getPrimaryType());
                break;
            }
            case ABSORBING: {
                object = OperandUsage.ABSORPTION;
                break;
            }
            case INSPECTION: {
                object = OperandUsage.INSPECTION;
                break;
            }
            case FILTER: {
                object = OperandUsage.TRANSMISSION;
                break;
            }
            case SHALLOW_DESCENT: {
                object = OperandUsage.TRANSMISSION;
                break;
            }
            case DEEP_DESCENT: {
                object = OperandUsage.TRANSMISSION;
                break;
            }
            case ASCENT: {
                object = OperandUsage.TRANSMISSION;
            }
        }
        operandRoleArray[0] = new OperandRole(0, (OperandUsage)((Object)object), this.getArgumentType(0));
        for (int i2 = 1; i2 < operandRoleArray.length; ++i2) {
            SequenceType sequenceType = this.getArgumentType(i2);
            operandRoleArray[i2] = new OperandRole(0, OperandRole.getTypeDeterminedUsage(sequenceType.getPrimaryType()), sequenceType);
        }
        return operandRoleArray;
    }

    public boolean acceptsNodesWithoutAtomization() {
        for (int i2 = 0; i2 < this.getArity(); ++i2) {
            ItemType itemType = this.getArgumentType(i2).getPrimaryType();
            if (!(itemType instanceof NodeTest) && itemType != AnyItemType.getInstance()) continue;
            return true;
        }
        return false;
    }

    public boolean isOverrideExtensionFunction() {
        return this.j;
    }

    public void setOverrideExtensionFunction(boolean bl2) {
        this.j = bl2;
    }

    public void setAnnotations(AnnotationList annotationList) {
        this.k = Objects.requireNonNull(annotationList);
    }

    @Override
    public AnnotationList getAnnotations() {
        return this.k;
    }

    public void setDeterminism(Determinism determinism) {
        this.m = determinism;
    }

    public Determinism getDeterminism() {
        return this.m;
    }

    public void computeEvaluationMode() {
        if (this.c) {
            this.evaluator = ExpressionTool.eagerEvaluator(this.getBody());
            return;
        }
        this.evaluator = ExpressionTool.lazyEvaluator(this.getBody(), true);
    }

    public Boolean isInlineable() {
        if (this.h != -1) {
            return this.h > 0 && this.i < 100;
        }
        if (this.body == null) {
            return null;
        }
        if (this.body.hasSpecialProperty(0x2000000) || this.b) {
            return Boolean.FALSE;
        }
        Object object = this.getDeclaringComponent();
        if (object != null) {
            object = this.getDeclaringComponent().getVisibility();
            if (object == Visibility.PRIVATE || object == Visibility.FINAL) {
                if (this.h < 0) {
                    return null;
                }
                return this.h > 0;
            }
            return Boolean.FALSE;
        }
        return null;
    }

    public void setInlineable(boolean bl2) {
        this.h = bl2 ? 1 : 0;
    }

    public void markAsInlined() {
        ++this.i;
    }

    public void setParameterDefinitions(UserFunctionParameter[] userFunctionParameterArray) {
        this.d = userFunctionParameterArray;
    }

    public UserFunctionParameter[] getParameterDefinitions() {
        return this.d;
    }

    public void setResultType(SequenceType sequenceType) {
        this.f = sequenceType;
        this.e = sequenceType;
    }

    public void setTailRecursive(boolean bl2, boolean bl3) {
        this.b = bl2;
        this.c = bl3;
    }

    public boolean containsTailCalls() {
        return this.b;
    }

    public boolean isTailRecursive() {
        return this.c;
    }

    public void setUpdating(boolean bl2) {
        this.g = bl2;
    }

    public boolean isUpdating() {
        return this.g;
    }

    public void setDeclaredStreamability(FunctionStreamability functionStreamability) {
        this.l = functionStreamability == null ? FunctionStreamability.UNCLASSIFIED : functionStreamability;
    }

    public FunctionStreamability getDeclaredStreamability() {
        return this.l;
    }

    public SequenceType getResultType() {
        if (this.e == SequenceType.ANY_SEQUENCE && this.getBody() != null && !UserFunction.a(this.getBody())) {
            this.e = SequenceType.makeSequenceType(this.getBody().getItemType(), this.getBody().getCardinality());
        }
        return this.e;
    }

    public SequenceType getDeclaredResultType() {
        return this.f;
    }

    private static boolean a(Expression object) {
        if (object instanceof UserFunctionCall) {
            return true;
        }
        for (Operand operand : ((Expression)object).operands()) {
            if (!UserFunction.a(operand.getChildExpression())) continue;
            return true;
        }
        return false;
    }

    public SequenceType getArgumentType(int n2) {
        return this.d[n2].getRequiredType();
    }

    public Evaluator getEvaluator() {
        if (this.evaluator == null) {
            this.computeEvaluationMode();
        }
        return this.evaluator;
    }

    public void setEvaluationMode(int n2) {
        this.evaluator = Evaluator.evaluatorForCode(n2);
    }

    @Override
    public int getArity() {
        return this.d.length;
    }

    public boolean isMemoFunction() {
        return false;
    }

    public void typeCheck(ExpressionVisitor expressionVisitor) {
        Object object;
        Expression expression = this.getBody();
        if (expression instanceof ValueOf && ((ValueOf)expression).getSelect().getItemType().isAtomicType() && this.f.getPrimaryType().isAtomicType() && this.f.getPrimaryType() != BuiltInAtomicType.STRING) {
            expressionVisitor.getStaticContext().issueWarning("A function that computes atomic values should use xsl:sequence rather than xsl:value-of", this.getLocation());
        }
        ExpressionTool.resetPropertiesWithinSubtree(expression);
        try {
            object = ContextItemStaticInfo.ABSENT;
            object = expression.typeCheck(expressionVisitor, (ContextItemStaticInfo)object);
            if (this.e != null) {
                RoleDiagnostic roleDiagnostic = new RoleDiagnostic(5, this.a == null ? "" : this.a.getDisplayName() + "#" + this.getArity(), 0);
                roleDiagnostic.setErrorCode(this.getPackageData().getHostLanguage() == 50 && this.getFunctionName() != null ? "XTTE0780" : "XPTY0004");
                object = expressionVisitor.getConfiguration().getTypeChecker(false).staticTypeCheck((Expression)object, this.e, roleDiagnostic, expressionVisitor);
            }
        }
        catch (XPathException xPathException) {
            XPathException xPathException2 = xPathException;
            xPathException.maybeSetLocation(this.getLocation());
            throw xPathException2;
        }
        if (object != expression) {
            this.setBody((Expression)object);
        }
    }

    @Override
    public XPathContextMajor makeNewContext(XPathContext xPathContext, ContextOriginator contextOriginator) {
        XPathContextMajor xPathContextMajor = xPathContext.newCleanContext();
        xPathContextMajor.setReceiver(xPathContext.getReceiver());
        xPathContextMajor.setTemporaryOutputState(158);
        xPathContextMajor.setCurrentOutputUri(null);
        xPathContextMajor.setCurrentComponent(this.getDeclaringComponent());
        xPathContextMajor.setOrigin(contextOriginator);
        return xPathContextMajor;
    }

    @Override
    public Sequence<?> call(XPathContext object, Sequence[] object2) {
        if (this.evaluator == null) {
            this.computeEvaluationMode();
        }
        object = (XPathContextMajor)object;
        ((XPathContextMajor)object).setStackFrame(this.getStackFrameMap(), (Sequence[])object2);
        try {
            object2 = this.evaluator.evaluate(this.getBody(), (XPathContext)object);
        }
        catch (XPathException xPathException) {
            object2 = xPathException;
            xPathException.maybeSetLocation(this.getLocation());
            ((XPathException)object2).maybeSetContext((XPathContext)object);
            throw object2;
        }
        catch (Exception exception) {
            object = "Internal error evaluating function " + (this.a == null ? "(unnamed)" : this.a.getDisplayName()) + (this.getLineNumber() > 0 ? " at line " + this.getLineNumber() : "") + (this.getSystemId() != null ? " in module " + this.getSystemId() : "");
            throw new RuntimeException((String)object, exception);
        }
        return object2;
    }

    public void process(Sequence[] sequenceArray, XPathContextMajor xPathContextMajor) {
        xPathContextMajor.setStackFrame(this.getStackFrameMap(), sequenceArray);
        this.getBody().process(xPathContextMajor);
    }

    public Sequence<?> call(Sequence[] sequenceArray, Controller controller) {
        return this.call((XPathContext)controller.newXPathContext(), sequenceArray);
    }

    public void callUpdating(Sequence[] object, XPathContextMajor xPathContextMajor, PendingUpdateList pendingUpdateList) {
        xPathContextMajor.setStackFrame(this.getStackFrameMap(), (Sequence[])object);
        try {
            this.getBody().evaluatePendingUpdates(xPathContextMajor, pendingUpdateList);
            return;
        }
        catch (XPathException xPathException) {
            object = xPathException;
            xPathException.maybeSetLocation(this.getLocation());
            throw object;
        }
    }

    @Override
    public void export(ExpressionPresenter expressionPresenter) {
        expressionPresenter.startElement("function");
        if (this.getFunctionName() != null) {
            expressionPresenter.emitAttribute("name", this.getFunctionName());
            expressionPresenter.emitAttribute("line", "" + this.getLineNumber());
            expressionPresenter.emitAttribute("module", this.getSystemId());
            expressionPresenter.emitAttribute("eval", "" + this.getEvaluator().getCode());
        }
        Object object = "";
        object = this.m == Determinism.PROACTIVE ? (String)object + "p" : (this.m == Determinism.ELIDABLE ? (String)object + "e" : (String)object + "d");
        if (this.isMemoFunction()) {
            object = (String)object + "m";
        }
        switch (this.l) {
            case UNCLASSIFIED: {
                object = (String)object + "U";
                break;
            }
            case ABSORBING: {
                object = (String)object + "A";
                break;
            }
            case INSPECTION: {
                object = (String)object + "I";
                break;
            }
            case FILTER: {
                object = (String)object + "F";
                break;
            }
            case SHALLOW_DESCENT: {
                object = (String)object + "S";
                break;
            }
            case DEEP_DESCENT: {
                object = (String)object + "D";
                break;
            }
            case ASCENT: {
                object = (String)object + "C";
            }
        }
        expressionPresenter.emitAttribute("flags", (String)object);
        expressionPresenter.emitAttribute("as", this.getDeclaredResultType().toExportString());
        expressionPresenter.emitAttribute("slots", "" + this.getStackFrameMap().getNumberOfVariables());
        object = this.d;
        int n2 = this.d.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            UserFunctionParameter userFunctionParameter = object[i2];
            expressionPresenter.startElement("arg");
            expressionPresenter.emitAttribute("name", userFunctionParameter.getVariableQName());
            expressionPresenter.emitAttribute("as", userFunctionParameter.getRequiredType().toExportString());
            expressionPresenter.endElement();
        }
        expressionPresenter.setChildRole("body");
        this.getBody().export(expressionPresenter);
        expressionPresenter.endElement();
    }

    @Override
    public boolean isExportable() {
        return this.n > 0 || this.getDeclaredVisibility() != null && this.getDeclaredVisibility() != Visibility.PRIVATE || ((StylesheetPackage)this.getPackageData()).isRetainUnusedFunctions();
    }

    @Override
    public boolean isTrustedResultType() {
        return false;
    }

    @Override
    public int getConstructType() {
        return 2065;
    }

    @Override
    public UnfailingIterator<Function> iterate() {
        return SingletonIterator.makeIterator(this);
    }

    @Override
    public boolean isMap() {
        return false;
    }

    @Override
    public boolean isArray() {
        return false;
    }

    @Override
    public boolean deepEquals(Function object, XPathContext xPathContext, AtomicComparer atomicComparer, int n2) {
        object = new XPathException("Cannot compare functions using deep-equal", "FOTY0015");
        ((XPathException)object).setIsTypeError(true);
        ((XPathException)object).setXPathContext(xPathContext);
        throw object;
    }

    @Override
    public Function itemAt(int n2) {
        if (n2 == 0) {
            return this;
        }
        return null;
    }

    @Override
    public GroundedValue<Function> subsequence(int n2, int n3) {
        if (n2 <= 0 && n2 + n3 > 0) {
            return this;
        }
        return EmptySequence.getInstance();
    }

    @Override
    public int getLength() {
        return 1;
    }

    @Override
    public boolean effectiveBooleanValue() {
        return ExpressionTool.effectiveBooleanValue(this);
    }

    public UserFunction reduce() {
        return this;
    }

    @Override
    public UserFunction head() {
        return this;
    }

    @Override
    public String getStringValue() {
        throw new UnsupportedOperationException("A function has no string value");
    }

    @Override
    public CharSequence getStringValueCS() {
        return this.getStringValue();
    }

    @Override
    public AtomicSequence atomize() {
        throw new XPathException("Functions cannot be atomized", "FOTY0013");
    }

    public void incrementReferenceCount() {
        ++this.n;
    }

    public int getReferenceCount() {
        return this.n;
    }

    public void prepareForStreaming() {
    }

    public static enum Determinism {
        DETERMINISTIC,
        PROACTIVE,
        ELIDABLE;

    }
}

