/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.instruct;

import net.sf.saxon.Controller;
import net.sf.saxon.expr.CastExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.SimpleNodeConstructor;
import net.sf.saxon.expr.instruct.TailCall;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.Orphan;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ComplexType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Whitespace;

public final class ValueOf
extends SimpleNodeConstructor {
    private int a;
    private boolean b = false;
    private boolean c;

    public ValueOf(Expression object, boolean bl2, boolean n2) {
        this.setSelect((Expression)object);
        this.a = bl2 ? 1 : 0;
        this.c = n2;
        this.adoptChildExpression((Expression)object);
        if (object instanceof StringLiteral) {
            bl2 = false;
            object = ((StringLiteral)object).getStringValue();
            for (n2 = 0; n2 < object.length(); ++n2) {
                char c2 = object.charAt(n2);
                if (c2 >= '!' && c2 <= '~' && c2 != '<' && c2 != '>' && c2 != '&') continue;
                bl2 = true;
                break;
            }
            if (!bl2) {
                this.a |= 4;
            }
        }
    }

    public final void setIsNumberingInstruction() {
        this.b = true;
    }

    public final boolean isNumberingInstruction() {
        return this.b;
    }

    public final boolean isNoNodeIfEmpty() {
        return this.c;
    }

    @Override
    public final String toShortString() {
        if (this.getSelect() instanceof StringLiteral) {
            return "text{" + Err.depict(((StringLiteral)this.getSelect()).getValue()) + "}";
        }
        return super.toShortString();
    }

    @Override
    public final int getInstructionNameCode() {
        if (this.b) {
            return 180;
        }
        if (this.getSelect() instanceof StringLiteral) {
            return 201;
        }
        return 205;
    }

    public final int getOptions() {
        return this.a;
    }

    public final boolean isDisableOutputEscaping() {
        return (this.a & 1) != 0;
    }

    @Override
    public final ItemType getItemType() {
        return NodeKindTest.TEXT;
    }

    @Override
    public final int computeCardinality() {
        if (this.c) {
            return 24576;
        }
        return 16384;
    }

    @Override
    public final void localTypeCheck(ExpressionVisitor expressionVisitor, ContextItemStaticInfo contextItemStaticInfo) {
    }

    @Override
    public final int getIntrinsicDependencies() {
        int n2 = super.getIntrinsicDependencies();
        if (this.isDisableOutputEscaping()) {
            n2 |= 0x200;
        }
        return n2;
    }

    @Override
    public final Expression copy(RebindingMap object) {
        object = new ValueOf(this.getSelect().copy((RebindingMap)object), (this.a & 1) != 0, this.c);
        ExpressionTool.copyLocationInfo(this, (Expression)object);
        if (this.b) {
            ((ValueOf)object).setIsNumberingInstruction();
        }
        return object;
    }

    @Override
    public final void checkPermittedContents(SchemaType object, boolean bl2) {
        if (this.getSelect() instanceof Literal) {
            GroundedValue<?> groundedValue = ((Literal)this.getSelect()).getValue();
            SimpleType simpleType = null;
            if (object instanceof SimpleType && bl2) {
                simpleType = (SimpleType)object;
            } else if (object instanceof ComplexType && ((ComplexType)object).isSimpleContent()) {
                simpleType = ((ComplexType)object).getSimpleContentType();
            }
            if (bl2 && simpleType != null && !simpleType.isNamespaceSensitive()) {
                object = simpleType.validateContent(groundedValue.getStringValue(), null, this.getConfiguration().getConversionRules());
                if (object != null) {
                    ((ValidationFailure)object).setLocator(this.getLocation());
                    ((ValidationFailure)object).setErrorCode(this.isXSLT() ? "XTTE1540" : "XQDY0027");
                    throw ((ValidationFailure)object).makeException();
                }
                return;
            }
            if (object instanceof ComplexType && !((ComplexType)object).isSimpleContent() && !((ComplexType)object).isMixedContent() && !Whitespace.isWhite(groundedValue.getStringValue())) {
                object = new XPathException("The containing element must be of type " + object.getDescription() + ", which does not allow text content " + Err.wrap(groundedValue.getStringValue()));
                ((XPathException)object).setLocation(this.getLocation());
                ((XPathException)object).setIsTypeError(true);
                throw object;
            }
        }
    }

    public final Expression convertToCastAsString() {
        if (this.c || !Cardinality.allowsZero(this.getSelect().getCardinality())) {
            return new CastExpression(this.getSelect(), BuiltInAtomicType.UNTYPED_ATOMIC, true);
        }
        Expression expression = SystemFunction.makeCall("string", this.getRetainedStaticContext(), this.getSelect());
        return new CastExpression(expression, BuiltInAtomicType.UNTYPED_ATOMIC, false);
    }

    @Override
    public final TailCall processLeavingTail(XPathContext xPathContext) {
        if (this.c) {
            StringValue stringValue = (StringValue)this.getSelect().evaluateItem(xPathContext);
            if (stringValue != null) {
                ((SimpleNodeConstructor)this).processValue(stringValue.getStringValueCS(), xPathContext);
            }
            return null;
        }
        return super.processLeavingTail(xPathContext);
    }

    @Override
    public final void processValue(CharSequence charSequence, XPathContext object) {
        object = object.getReceiver();
        object.characters(charSequence, this.getLocation(), this.a);
    }

    public final NodeInfo evaluateItem(XPathContext object) {
        try {
            Object object2 = this.getSelect().evaluateItem((XPathContext)object);
            if (object2 == null) {
                if (this.c) {
                    return null;
                }
                object2 = "";
            } else {
                object2 = object2.getStringValueCS();
            }
            object = object.getController();
            assert (object != null);
            object = new Orphan(((Controller)object).getConfiguration());
            ((Orphan)object).setNodeKind((short)3);
            ((Orphan)object).setStringValue((CharSequence)object2);
            if ((this.a & 1) != 0) {
                ((Orphan)object).setDisableOutputEscaping(true);
            }
            return object;
        }
        catch (XPathException xPathException) {
            XPathException xPathException2 = xPathException;
            xPathException.maybeSetLocation(this.getLocation());
            throw xPathException2;
        }
    }

    @Override
    public final void export(ExpressionPresenter expressionPresenter) {
        expressionPresenter.startElement("valueOf", this);
        String string = "";
        if ((this.a & 1) != 0) {
            string = string + "d";
        }
        if ((this.a & 4) != 0) {
            string = string + "S";
        }
        if (this.c) {
            string = string + "e";
        }
        if (this.isLocal()) {
            string = string + "l";
        }
        if (!string.isEmpty()) {
            expressionPresenter.emitAttribute("flags", string);
        }
        this.getSelect().export(expressionPresenter);
        expressionPresenter.endElement();
    }
}

