/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.instruct;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ItemMappingFunction;
import net.sf.saxon.expr.ItemMappingIterator;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.OperandUsage;
import net.sf.saxon.expr.UnaryExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.ma.map.MapItem;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.value.Base64BinaryValue;
import net.sf.saxon.value.HexBinaryValue;
import net.sf.saxon.value.StringValue;

public class WherePopulated
extends UnaryExpression
implements ItemMappingFunction<Item<?>, Item<?>> {
    public WherePopulated(Expression expression) {
        super(expression);
    }

    @Override
    public boolean isInstruction() {
        return true;
    }

    @Override
    protected OperandRole getOperandRole() {
        return new OperandRole(0, OperandUsage.TRANSMISSION);
    }

    @Override
    public Expression copy(RebindingMap rebindingMap) {
        return new WherePopulated(this.getBaseExpression().copy(rebindingMap));
    }

    @Override
    public int getImplementationMethod() {
        return 2;
    }

    @Override
    public int computeCardinality() {
        return super.computeCardinality() | 0x2000;
    }

    @Override
    public SequenceIterator<?> iterate(XPathContext xPathContext) {
        return new ItemMappingIterator(this.getBaseExpression().iterate(xPathContext), this);
    }

    @Override
    public Item mapItem(Item item) {
        if (WherePopulated.isDeemedEmpty(item)) {
            return null;
        }
        return item;
    }

    public static boolean isDeemedEmpty(Item item) {
        if (item instanceof NodeInfo) {
            int n2 = ((NodeInfo)item).getNodeKind();
            switch (n2) {
                case 1: 
                case 9: {
                    return !((NodeInfo)item).hasChildNodes();
                }
            }
            return item.getStringValueCS().length() == 0;
        }
        if (item instanceof StringValue || item instanceof HexBinaryValue || item instanceof Base64BinaryValue) {
            return item.getStringValueCS().length() == 0;
        }
        if (item instanceof MapItem) {
            return ((MapItem)item).isEmpty();
        }
        return false;
    }

    @Override
    public String getExpressionName() {
        return "condCont";
    }

    @Override
    public void export(ExpressionPresenter expressionPresenter) {
        expressionPresenter.startElement("condCont", this);
        this.getBaseExpression().export(expressionPresenter);
        expressionPresenter.endElement();
    }

    @Override
    public String getStreamerName() {
        return "WherePopulated";
    }
}

