/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.number;

import java.util.Locale;
import net.sf.saxon.expr.number.Alphanumeric;
import net.sf.saxon.expr.number.NumericGroupFormatter;
import net.sf.saxon.expr.number.RegularGroupFormatter;
import net.sf.saxon.lib.Numberer;
import net.sf.saxon.regex.EmptyString;
import net.sf.saxon.regex.UnicodeString;
import net.sf.saxon.tree.util.FastStringBuffer;

public abstract class AbstractNumberer
implements Numberer {
    private String a;
    private String b;
    public static final int UPPER_CASE = 0;
    public static final int LOWER_CASE = 1;
    public static final int TITLE_CASE = 2;
    protected static final int[] westernDigits = new int[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57};
    protected static final String latinUpper = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    protected static final String latinLower = "abcdefghijklmnopqrstuvwxyz";
    protected static final String greekUpper = "\u0391\u0392\u0393\u0394\u0395\u0396\u0397\u0398\u0399\u039a\u039b\u039c\u039d\u039e\u039f\u03a0\u03a1\u03a2\u03a3\u03a4\u03a5\u03a6\u03a7\u03a8\u03a9";
    protected static final String greekLower = "\u03b1\u03b2\u03b3\u03b4\u03b5\u03b6\u03b7\u03b8\u03b9\u03ba\u03bb\u03bc\u03bd\u03be\u03bf\u03c0\u03c1\u03c2\u03c3\u03c4\u03c5\u03c6\u03c7\u03c8\u03c9";
    protected static final String cyrillicUpper = "\u0410\u0411\u0412\u0413\u0414\u0415\u0416\u0417\u0418\u041a\u041b\u041c\u041d\u041e\u041f\u0420\u0421\u0421\u0423\u0424\u0425\u0426\u0427\u0428\u0429\u042b\u042d\u042e\u042f";
    protected static final String cyrillicLower = "\u0430\u0431\u0432\u0433\u0434\u0435\u0436\u0437\u0438\u043a\u043b\u043c\u043d\u043e\u043f\u0440\u0441\u0441\u0443\u0444\u0445\u0446\u0447\u0448\u0449\u044b\u044d\u044e\u044f";
    protected static final String hebrew = "\u05d0\u05d1\u05d2\u05d3\u05d4\u05d5\u05d6\u05d7\u05d8\u05d9\u05db\u05dc\u05de\u05e0\u05e1\u05e2\u05e4\u05e6\u05e7\u05e8\u05e9\u05ea";
    protected static final String hiraganaA = "\u3042\u3044\u3046\u3048\u304a\u304b\u304d\u304f\u3051\u3053\u3055\u3057\u3059\u305b\u305d\u305f\u3061\u3064\u3066\u3068\u306a\u306b\u306c\u306d\u306e\u306f\u3072\u3075\u3078\u307b\u307e\u307f\u3080\u3081\u3082\u3084\u3086\u3088\u3089\u308a\u308b\u308c\u308d\u308f\u3092\u3093";
    protected static final String katakanaA = "\u30a2\u30a4\u30a6\u30a8\u30aa\u30ab\u30ad\u30af\u30b1\u30b3\u30b5\u30b7\u30b9\u30bb\u30bd\u30bf\u30c1\u30c4\u30c6\u30c8\u30ca\u30cb\u30cc\u30cd\u30ce\u30cf\u30d2\u30d5\u30d8\u30db\u30de\u30df\u30e0\u30e1\u30e2\u30e4\u30e6\u30e8\u30e9\u30ea\u30eb\u30ec\u30ed\u30ef\u30f2\u30f3";
    protected static final String hiraganaI = "\u3044\u308d\u306f\u306b\u307b\u3078\u3068\u3061\u308a\u306c\u308b\u3092\u308f\u304b\u3088\u305f\u308c\u305d\u3064\u306d\u306a\u3089\u3080\u3046\u3090\u306e\u304a\u304f\u3084\u307e\u3051\u3075\u3053\u3048\u3066\u3042\u3055\u304d\u3086\u3081\u307f\u3057\u3091\u3072\u3082\u305b\u3059";
    protected static final String katakanaI = "\u30a4\u30ed\u30cf\u30cb\u30db\u30d8\u30c8\u30c1\u30ea\u30cc\u30eb\u30f2\u30ef\u30ab\u30e8\u30bf\u30ec\u30bd\u30c4\u30cd\u30ca\u30e9\u30e0\u30a6\u30f0\u30ce\u30aa\u30af\u30e4\u30de\u30b1\u30d5\u30b3\u30a8\u30c6\u30a2\u30b5\u30ad\u30e6\u30e1\u30df\u30b7\u30f1\u30d2\u30e2\u30bb\u30b9";
    private static String[] c = new String[]{"", "m", "mm", "mmm", "mmmm", "mmmmm", "mmmmmm", "mmmmmmm", "mmmmmmmm", "mmmmmmmmm"};
    private static String[] d = new String[]{"", "c", "cc", "ccc", "cd", "d", "dc", "dcc", "dccc", "cm"};
    private static String[] e = new String[]{"", "x", "xx", "xxx", "xl", "l", "lx", "lxx", "lxxx", "xc"};
    private static String[] f = new String[]{"", "i", "ii", "iii", "iv", "v", "vi", "vii", "viii", "ix"};
    private static final int[] g = new int[]{12295, 19968, 20108, 19977, 22235, 20116, 20845, 19971, 20843, 20061};

    @Override
    public Locale defaultedLocale() {
        return null;
    }

    @Override
    public void setCountry(String string) {
        this.a = string;
    }

    public void setLanguage(String string) {
        this.b = string;
    }

    public String getLanguage() {
        return this.b;
    }

    @Override
    public String getCountry() {
        return this.a;
    }

    @Override
    public final String format(long l2, UnicodeString unicodeString, int n2, String string, String string2, String string3) {
        return this.format(l2, unicodeString, new RegularGroupFormatter(n2, string, EmptyString.THE_INSTANCE), string2, string3);
    }

    @Override
    public String format(long l2, UnicodeString unicodeString, NumericGroupFormatter numericGroupFormatter, String object, String string) {
        if (l2 < 0L) {
            return "" + l2;
        }
        if (unicodeString == null || unicodeString.uLength() == 0) {
            return "" + l2;
        }
        int n2 = unicodeString.uLength();
        FastStringBuffer fastStringBuffer = new FastStringBuffer(16);
        int n3 = unicodeString.uCharAt(0);
        FastStringBuffer fastStringBuffer2 = new FastStringBuffer(2);
        switch (n3) {
            case 48: 
            case 49: {
                fastStringBuffer.append(AbstractNumberer.a(l2, westernDigits, n2, numericGroupFormatter));
                if (string == null || string.isEmpty()) break;
                fastStringBuffer.append(this.ordinalSuffix(string, l2));
                break;
            }
            case 65: {
                if (l2 == 0L) {
                    return "0";
                }
                return this.toAlphaSequence(l2, latinUpper);
            }
            case 97: {
                if (l2 == 0L) {
                    return "0";
                }
                return this.toAlphaSequence(l2, latinLower);
            }
            case 87: 
            case 119: {
                int n4 = unicodeString.uLength() == 1 ? (n3 == 87 ? 0 : 1) : 2;
                if (string != null && !string.isEmpty()) {
                    return this.toOrdinalWords(string, l2, n4);
                }
                return this.toWords(l2, n4);
            }
            case 105: {
                if (l2 == 0L) {
                    return "0";
                }
                if (object == null || ((String)object).isEmpty() || ((String)object).equals("traditional")) {
                    return AbstractNumberer.toRoman(l2);
                }
                this.alphaDefault(l2, 'i', fastStringBuffer);
                break;
            }
            case 73: {
                if (l2 == 0L) {
                    return "0";
                }
                if (object == null || ((String)object).isEmpty() || ((String)object).equals("traditional")) {
                    return AbstractNumberer.toRoman(l2).toUpperCase();
                }
                this.alphaDefault(l2, 'I', fastStringBuffer);
                break;
            }
            case 9312: {
                if (l2 == 0L) {
                    return "\u24ea";
                }
                if (l2 > 20L && l2 <= 35L) {
                    return "" + (char)(l2 + 12881L - 21L);
                }
                if (l2 > 35L && l2 <= 50L) {
                    return "" + (char)(l2 + 12977L - 36L);
                }
                if (l2 > 50L) {
                    return "" + l2;
                }
                return "" + (char)(l2 + 9312L - 1L);
            }
            case 9332: {
                if (l2 == 0L || l2 > 20L) {
                    return "" + l2;
                }
                return "" + (char)(l2 + 9332L - 1L);
            }
            case 9352: {
                if (l2 == 0L) {
                    return "\ud83c\udd00";
                }
                if (l2 > 20L) {
                    return "" + l2;
                }
                return "" + (char)(l2 + 9352L - 1L);
            }
            case 10102: {
                if (l2 == 0L) {
                    return "\u24ff";
                }
                if (l2 > 10L && l2 <= 20L) {
                    return "" + (char)(l2 + 9451L - 11L);
                }
                if (l2 > 20L) {
                    return "" + l2;
                }
                return "" + (char)(l2 + 10102L - 1L);
            }
            case 10112: {
                if (l2 == 0L) {
                    return "\ud83c\udd0b";
                }
                if (l2 > 10L) {
                    return "" + l2;
                }
                return "" + (char)(l2 + 10112L - 1L);
            }
            case 9461: {
                if (l2 == 0L || l2 > 10L) {
                    return "" + l2;
                }
                return "" + (char)(l2 + 9461L - 1L);
            }
            case 10122: {
                if (l2 == 0L) {
                    return "\ud83c\udd0c";
                }
                if (l2 > 10L) {
                    return "" + l2;
                }
                return "" + (char)(l2 + 10122L - 1L);
            }
            case 12832: {
                if (l2 == 0L || l2 > 10L) {
                    return "" + l2;
                }
                return "" + (char)(l2 + 12832L - 1L);
            }
            case 12928: {
                if (l2 == 0L || l2 > 10L) {
                    return "" + l2;
                }
                return "" + (char)(l2 + 12928L - 1L);
            }
            case 65799: {
                if (l2 == 0L || l2 > 10L) {
                    return "" + l2;
                }
                fastStringBuffer2.appendWideChar(65799 + (int)l2 - 1);
                return fastStringBuffer2.toString();
            }
            case 69216: {
                if (l2 == 0L || l2 > 10L) {
                    return "" + l2;
                }
                fastStringBuffer2.appendWideChar(69216 + (int)l2 - 1);
                return fastStringBuffer2.toString();
            }
            case 69714: {
                if (l2 == 0L || l2 > 10L) {
                    return "" + l2;
                }
                fastStringBuffer2.appendWideChar(69714 + (int)l2 - 1);
                return fastStringBuffer2.toString();
            }
            case 119648: {
                if (l2 == 0L || l2 >= 10L) {
                    return "" + l2;
                }
                fastStringBuffer2.appendWideChar(119648 + (int)l2 - 1);
                return fastStringBuffer2.toString();
            }
            case 127234: {
                if (l2 == 0L) {
                    fastStringBuffer2.appendWideChar(127233);
                    return fastStringBuffer2.toString();
                }
                if (l2 >= 10L) {
                    return "" + l2;
                }
                fastStringBuffer2.appendWideChar(127234 + (int)l2 - 1);
                return fastStringBuffer2.toString();
            }
            case 913: {
                if (l2 == 0L) {
                    return "0";
                }
                return this.toAlphaSequence(l2, greekUpper);
            }
            case 945: {
                if (l2 == 0L) {
                    return "0";
                }
                return this.toAlphaSequence(l2, greekLower);
            }
            case 1040: {
                if (l2 == 0L) {
                    return "0";
                }
                return this.toAlphaSequence(l2, cyrillicUpper);
            }
            case 1072: {
                if (l2 == 0L) {
                    return "0";
                }
                return this.toAlphaSequence(l2, cyrillicLower);
            }
            case 1488: {
                if (l2 == 0L) {
                    return "0";
                }
                return this.toAlphaSequence(l2, hebrew);
            }
            case 12354: {
                if (l2 == 0L) {
                    return "0";
                }
                return this.toAlphaSequence(l2, hiraganaA);
            }
            case 12450: {
                if (l2 == 0L) {
                    return "0";
                }
                return this.toAlphaSequence(l2, katakanaA);
            }
            case 12356: {
                if (l2 == 0L) {
                    return "0";
                }
                return this.toAlphaSequence(l2, hiraganaI);
            }
            case 12452: {
                if (l2 == 0L) {
                    return "0";
                }
                return this.toAlphaSequence(l2, katakanaI);
            }
            case 19968: {
                return this.toJapanese(l2);
            }
            default: {
                int n5 = Alphanumeric.getDigitValue(n3);
                if (n5 >= 0) {
                    n5 = n3 - n5;
                    object = new int[10];
                    for (int i2 = 0; i2 <= 9; ++i2) {
                        object[i2] = n5 + i2;
                    }
                    return AbstractNumberer.a(l2, (int[])object, n2, numericGroupFormatter);
                }
                if (n3 < 4352 && Character.isLetter((char)n3) && l2 > 0L) {
                    this.alphaDefault(l2, (char)n3, fastStringBuffer);
                    break;
                }
                fastStringBuffer.append(AbstractNumberer.a(l2, westernDigits, n2, numericGroupFormatter));
                if (string == null || string.isEmpty()) break;
                fastStringBuffer.append(this.ordinalSuffix(string, l2));
            }
        }
        return fastStringBuffer.toString();
    }

    protected String ordinalSuffix(String string, long l2) {
        return "";
    }

    protected void alphaDefault(long l2, char n2, FastStringBuffer fastStringBuffer) {
        int n3 = n2;
        while (Character.isLetterOrDigit((char)(n3 + '\u0001'))) {
            ++n3;
        }
        fastStringBuffer.append(this.toAlpha(l2, n2, n3));
    }

    protected String toAlpha(long l2, int n2, int n3) {
        if (l2 <= 0L) {
            return "" + l2;
        }
        int n4 = n3 - n2 + 1;
        char c2 = (char)((l2 - 1L) % (long)n4 + (long)n2);
        if (l2 > (long)n4) {
            return this.toAlpha((l2 - 1L) / (long)n4, n2, n3) + c2;
        }
        return "" + c2;
    }

    protected String toAlphaSequence(long l2, String string) {
        if (l2 <= 0L) {
            return "" + l2;
        }
        int n2 = string.length();
        char c2 = string.charAt((int)((l2 - 1L) % (long)n2));
        if (l2 > (long)n2) {
            return this.toAlphaSequence((l2 - 1L) / (long)n2, string) + c2;
        }
        return "" + c2;
    }

    private static String a(long l2, int[] nArray, int n2, NumericGroupFormatter numericGroupFormatter) {
        FastStringBuffer fastStringBuffer = AbstractNumberer.convertDigitSystem(l2, nArray, n2);
        if (numericGroupFormatter == null) {
            return fastStringBuffer.toString();
        }
        return numericGroupFormatter.format(fastStringBuffer);
    }

    public static FastStringBuffer convertDigitSystem(long l2, int[] nArray, int n2) {
        int n3;
        FastStringBuffer fastStringBuffer = new FastStringBuffer(16);
        int n4 = nArray.length;
        FastStringBuffer fastStringBuffer2 = new FastStringBuffer(16);
        int n5 = 0;
        for (long i2 = l2; i2 > 0L; i2 /= (long)n4) {
            n3 = nArray[(int)(i2 % (long)n4)];
            fastStringBuffer2.prependWideChar(n3);
            ++n5;
        }
        for (n3 = 0; n3 < n2 - n5; ++n3) {
            fastStringBuffer.appendWideChar(nArray[0]);
        }
        fastStringBuffer.append(fastStringBuffer2);
        return fastStringBuffer;
    }

    public static String toRoman(long l2) {
        if (l2 <= 0L || l2 > 9999L) {
            return "" + l2;
        }
        return c[(int)l2 / 1000] + d[(int)l2 / 100 % 10] + e[(int)l2 / 10 % 10] + f[(int)l2 % 10];
    }

    public String toJapanese(long l2) {
        FastStringBuffer fastStringBuffer = new FastStringBuffer(16);
        if (l2 == 0L) {
            fastStringBuffer.appendWideChar(12295);
        } else if (l2 <= 9999L) {
            AbstractNumberer.a((int)l2, fastStringBuffer, false);
        } else {
            fastStringBuffer.append("" + l2);
        }
        return fastStringBuffer.toString();
    }

    private static void a(int n2, FastStringBuffer fastStringBuffer, boolean bl2) {
        while (n2 != 0) {
            if (n2 <= 9) {
                if (n2 == 1 && bl2) break;
                fastStringBuffer.appendWideChar(g[n2]);
                return;
            }
            if (n2 == 10) {
                fastStringBuffer.appendWideChar(21313);
                return;
            }
            if (n2 <= 99) {
                AbstractNumberer.a(n2 / 10, fastStringBuffer, true);
                fastStringBuffer.appendWideChar(21313);
                AbstractNumberer.a(n2 % 10, fastStringBuffer, false);
                return;
            }
            if (n2 <= 999) {
                AbstractNumberer.a(n2 / 100, fastStringBuffer, true);
                fastStringBuffer.appendWideChar(30334);
                AbstractNumberer.a(n2 % 100, fastStringBuffer, false);
                return;
            }
            if (n2 > 9999) break;
            AbstractNumberer.a(n2 / 1000, fastStringBuffer, true);
            fastStringBuffer.appendWideChar(21315);
            bl2 = false;
            n2 %= 1000;
        }
    }

    public abstract String toWords(long var1);

    public String toWords(long l2, int n2) {
        String string = l2 == 0L ? "Zero" : this.toWords(l2);
        switch (n2) {
            case 0: {
                return string.toUpperCase();
            }
            case 1: {
                return string.toLowerCase();
            }
        }
        return string;
    }

    public abstract String toOrdinalWords(String var1, long var2, int var4);

    @Override
    public abstract String monthName(int var1, int var2, int var3);

    @Override
    public abstract String dayName(int var1, int var2, int var3);

    @Override
    public String halfDayName(int n2, int n3, int n4) {
        String string;
        if (n2 == 0 && n4 >= 8 && "gb".equals(this.a)) {
            string = "Midnight";
        } else if (n2 < 720) {
            switch (n4) {
                case 1: {
                    string = "A";
                    break;
                }
                case 2: 
                case 3: {
                    string = "Am";
                    break;
                }
                default: {
                    string = "A.M.";
                    break;
                }
            }
        } else if (n2 == 720 && n4 >= 8 && "gb".equals(this.a)) {
            string = "Noon";
        } else {
            switch (n4) {
                case 1: {
                    string = "P";
                    break;
                }
                case 2: 
                case 3: {
                    string = "Pm";
                    break;
                }
                default: {
                    string = "P.M.";
                }
            }
        }
        return string;
    }

    @Override
    public String getOrdinalSuffixForDateTime(String string) {
        return "yes";
    }

    @Override
    public String getEraName(int n2) {
        if (n2 > 0) {
            return "AD";
        }
        return "BC";
    }

    @Override
    public String getCalendarName(String string) {
        if (string.equals("AD")) {
            return "Gregorian";
        }
        return string;
    }
}

