/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.number;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.function.IntPredicate;
import net.sf.saxon.expr.number.Alphanumeric;
import net.sf.saxon.expr.number.NumericGroupFormatter;
import net.sf.saxon.expr.number.RegularGroupFormatter;
import net.sf.saxon.lib.Numberer;
import net.sf.saxon.regex.EmptyString;
import net.sf.saxon.regex.UnicodeString;
import net.sf.saxon.regex.charclass.Categories;
import net.sf.saxon.tree.util.FastStringBuffer;

public class NumberFormatter {
    private ArrayList<UnicodeString> a;
    private ArrayList<UnicodeString> b;
    private boolean c;
    private static IntPredicate d = Categories.getCategory("N").or(Categories.getCategory("L"));

    public void prepare(String charSequence) {
        if (((String)charSequence).isEmpty()) {
            charSequence = "1";
        }
        this.a = new ArrayList(10);
        this.b = new ArrayList(10);
        charSequence = UnicodeString.makeUnicodeString(charSequence);
        int n2 = ((UnicodeString)charSequence).uLength();
        int n3 = 0;
        boolean bl2 = true;
        this.c = true;
        while (n3 < n2) {
            int n4 = ((UnicodeString)charSequence).uCharAt(n3);
            int n5 = n3;
            while (NumberFormatter.isLetterOrDigit(n4) && ++n3 != n2) {
                n4 = ((UnicodeString)charSequence).uCharAt(n3);
            }
            if (n3 > n5) {
                UnicodeString unicodeString = ((UnicodeString)charSequence).uSubstring(n5, n3);
                this.a.add(unicodeString);
                if (bl2) {
                    this.b.add(UnicodeString.makeUnicodeString("."));
                    this.c = false;
                    bl2 = false;
                }
            }
            if (n3 == n2) break;
            n5 = n3;
            n4 = ((UnicodeString)charSequence).uCharAt(n3);
            while (!NumberFormatter.isLetterOrDigit(n4)) {
                bl2 = false;
                if (++n3 == n2) break;
                n4 = ((UnicodeString)charSequence).uCharAt(n3);
            }
            if (n3 <= n5) continue;
            UnicodeString unicodeString = ((UnicodeString)charSequence).uSubstring(n5, n3);
            this.b.add(unicodeString);
        }
        if (this.a.isEmpty()) {
            this.a.add(UnicodeString.makeUnicodeString("1"));
            if (this.b.size() == 1) {
                this.b.add(this.b.get(0));
            }
        }
    }

    public static boolean isLetterOrDigit(int n2) {
        if (n2 <= 127) {
            return n2 >= 48 && n2 <= 57 || n2 >= 65 && n2 <= 90 || n2 >= 97 && n2 <= 122;
        }
        return d.test(n2);
    }

    public CharSequence format(List list, int n2, String string, String string2, String string3, Numberer numberer) {
        FastStringBuffer fastStringBuffer = new FastStringBuffer(16);
        int n3 = 0;
        int n4 = 0;
        if (this.c) {
            fastStringBuffer.append(this.b.get(0));
        }
        while (n3 < list.size()) {
            Object object;
            if (n3 > 0) {
                if (n4 == 0 && this.c) {
                    fastStringBuffer.append(".");
                } else {
                    fastStringBuffer.append(this.b.get(n4));
                }
            }
            if ((object = list.get(n3++)) instanceof Long) {
                long l2 = (Long)object;
                object = new RegularGroupFormatter(n2, string, EmptyString.THE_INSTANCE);
                object = numberer.format(l2, this.a.get(n4), (NumericGroupFormatter)object, string2, string3);
            } else if (object instanceof BigInteger) {
                Object object2;
                int n5;
                int n6;
                FastStringBuffer fastStringBuffer2 = new FastStringBuffer(64);
                fastStringBuffer2.append(object.toString());
                Object object3 = new RegularGroupFormatter(n2, string, EmptyString.THE_INSTANCE);
                object = ((NumericGroupFormatter)object3).format(fastStringBuffer2);
                UnicodeString unicodeString = this.a.get(n4);
                if (unicodeString.length() != 0 && (n6 = Alphanumeric.getDigitValue(n5 = unicodeString.uCharAt(0))) >= 0 && (n5 -= n6) != 48) {
                    int[] nArray = new int[10];
                    for (int i2 = 0; i2 <= 9; ++i2) {
                        nArray[i2] = n5 + i2;
                    }
                    object3 = new FastStringBuffer(128);
                    for (n5 = 0; n5 < ((String)object).length(); ++n5) {
                        char c2 = ((String)object).charAt(n5);
                        if (c2 >= '0' && c2 <= '9') {
                            ((FastStringBuffer)object3).appendWideChar(nArray[c2 - 48]);
                            continue;
                        }
                        ((FastStringBuffer)object3).append(c2);
                    }
                    object2 = ((FastStringBuffer)object3).toString();
                } else {
                    object2 = object;
                }
                object = object2;
            } else {
                object = object.toString();
            }
            fastStringBuffer.append((String)object);
            if (++n4 != this.a.size()) continue;
            --n4;
        }
        if (this.b.size() > this.a.size()) {
            fastStringBuffer.append(this.b.get(this.b.size() - 1));
        }
        return fastStringBuffer.condense();
    }
}

