/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.oper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.function.Predicate;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.OperandRole;

public class OperandArray
implements Iterable<Operand> {
    private Operand[] a;

    public OperandArray(Expression expression, Expression[] expressionArray) {
        this.a = new Operand[expressionArray.length];
        for (int i2 = 0; i2 < expressionArray.length; ++i2) {
            this.a[i2] = new Operand(expression, expressionArray[i2], OperandRole.NAVIGATE);
        }
    }

    public OperandArray(Expression expression, Expression[] expressionArray, OperandRole[] operandRoleArray) {
        this.a = new Operand[expressionArray.length];
        for (int i2 = 0; i2 < expressionArray.length; ++i2) {
            this.a[i2] = new Operand(expression, expressionArray[i2], operandRoleArray[i2]);
        }
    }

    public OperandArray(Expression expression, Expression[] expressionArray, OperandRole operandRole) {
        this.a = new Operand[expressionArray.length];
        for (int i2 = 0; i2 < expressionArray.length; ++i2) {
            this.a[i2] = new Operand(expression, expressionArray[i2], operandRole);
        }
    }

    @Override
    public Iterator<Operand> iterator() {
        return Arrays.asList(this.a).iterator();
    }

    public Operand[] copy() {
        return Arrays.copyOf(this.a, this.a.length);
    }

    public OperandRole[] getRoles() {
        OperandRole[] operandRoleArray = new OperandRole[this.a.length];
        for (int i2 = 0; i2 < operandRoleArray.length; ++i2) {
            operandRoleArray[i2] = this.a[i2].getOperandRole();
        }
        return operandRoleArray;
    }

    public Operand getOperand(int n2) {
        try {
            return this.a[n2];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IllegalArgumentException();
        }
    }

    public Expression getOperandExpression(int n2) {
        try {
            return this.a[n2].getChildExpression();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IllegalArgumentException(arrayIndexOutOfBoundsException);
        }
    }

    public Iterable<Operand> operands() {
        return Arrays.asList(this.a);
    }

    public Iterable<Expression> operandExpressions() {
        ArrayList<Expression> arrayList = new ArrayList<Expression>(this.a.length);
        for (Operand operand : this.operands()) {
            arrayList.add(operand.getChildExpression());
        }
        return arrayList;
    }

    public void setOperand(int n2, Expression expression) {
        try {
            if (this.a[n2].getChildExpression() != expression) {
                this.a[n2].setChildExpression(expression);
            }
            return;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IllegalArgumentException();
        }
    }

    public int getNumberOfOperands() {
        return this.a.length;
    }

    public static <T> boolean every(T[] TArray, Predicate<T> predicate) {
        for (T t2 : TArray) {
            if (predicate.test(t2)) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean some(T[] TArray, Predicate<T> predicate) {
        for (T t2 : TArray) {
            if (!predicate.test(t2)) continue;
            return true;
        }
        return false;
    }
}

