/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.parser;

import java.util.ArrayList;
import net.sf.saxon.Controller;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.SequenceOutputter;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.event.SequenceWriter;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.SuppliedParameterReference;
import net.sf.saxon.expr.TailExpression;
import net.sf.saxon.expr.UnaryExpression;
import net.sf.saxon.expr.VariableReference;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.Block;
import net.sf.saxon.om.Chain;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.LazySequence;
import net.sf.saxon.om.MemoSequence;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.IntegerRange;
import net.sf.saxon.value.MemoClosure;
import net.sf.saxon.value.SingletonClosure;

public abstract class Evaluator {
    public static final Evaluator EMPTY_SEQUENCE = new Evaluator(){

        @Override
        public final Sequence<?> evaluate(Expression expression, XPathContext xPathContext) {
            return EmptySequence.getInstance();
        }

        @Override
        public final int getCode() {
            return 5;
        }
    };
    public static final Evaluator LITERAL = new Evaluator(){

        @Override
        public final Sequence<?> evaluate(Expression expression, XPathContext xPathContext) {
            return ((Literal)expression).getValue();
        }

        @Override
        public final int getCode() {
            return 0;
        }
    };
    public static final Evaluator VARIABLE = new Evaluator(){

        @Override
        public final Sequence<?> evaluate(Expression expression, XPathContext xPathContext) {
            try {
                return ((VariableReference)expression).evaluateVariable(xPathContext);
            }
            catch (ClassCastException classCastException) {
                assert (false);
                return LAZY_SEQUENCE.evaluate(expression, xPathContext);
            }
        }

        @Override
        public final int getCode() {
            return 6;
        }
    };
    public static final Evaluator SUPPLIED_PARAMETER = new Evaluator(){

        @Override
        public final Sequence<?> evaluate(Expression expression, XPathContext xPathContext) {
            try {
                return ((SuppliedParameterReference)expression).evaluateVariable(xPathContext);
            }
            catch (ClassCastException classCastException) {
                assert (false);
                return LAZY_SEQUENCE.evaluate(expression, xPathContext);
            }
        }

        @Override
        public final int getCode() {
            return 14;
        }
    };
    public static final Evaluator SINGLE_ITEM = new Evaluator(){

        @Override
        public final int getCode() {
            return 16;
        }

        public final /* synthetic */ Sequence evaluate(Expression expression, XPathContext xPathContext) {
            return expression.evaluateItem(xPathContext);
        }
    };
    public static final Evaluator OPTIONAL_ITEM = new Evaluator(){

        @Override
        public final Sequence<?> evaluate(Expression object, XPathContext xPathContext) {
            if ((object = ((Expression)object).evaluateItem(xPathContext)) == null) {
                return EmptySequence.getInstance();
            }
            return object;
        }

        @Override
        public final int getCode() {
            return 7;
        }
    };
    public static final Evaluator LAZY_SEQUENCE = new Evaluator(){

        @Override
        public final Sequence<?> evaluate(Expression object, XPathContext xPathContext) {
            object = ((Expression)object).iterate(xPathContext);
            return new LazySequence(object);
        }

        @Override
        public final int getCode() {
            return 3;
        }
    };
    public static final Evaluator MEMO_SEQUENCE = new Evaluator(){

        @Override
        public final Sequence<?> evaluate(Expression object, XPathContext xPathContext) {
            object = ((Expression)object).iterate(xPathContext);
            return new MemoSequence(object);
        }

        @Override
        public final int getCode() {
            return 4;
        }
    };
    public static final Evaluator MEMO_CLOSURE = new Evaluator(){

        @Override
        public final Sequence<?> evaluate(Expression expression, XPathContext xPathContext) {
            return new MemoClosure(expression, xPathContext);
        }

        @Override
        public final int getCode() {
            return 4;
        }
    };
    public static final Evaluator SINGLETON_CLOSURE = new Evaluator(){

        @Override
        public final Sequence<?> evaluate(Expression expression, XPathContext xPathContext) {
            return new SingletonClosure(expression, xPathContext);
        }

        @Override
        public final int getCode() {
            return 13;
        }
    };
    public static final Evaluator EAGER_SEQUENCE = new Evaluator(){

        @Override
        public final Sequence<?> evaluate(Expression object, XPathContext xPathContext) {
            object = ((Expression)object).iterate(xPathContext);
            return object.materialize();
        }

        @Override
        public final int getCode() {
            return 8;
        }
    };
    public static final Evaluator SHARED_APPEND = new Evaluator(){

        @Override
        public final Sequence<?> evaluate(Expression operandArray, XPathContext xPathContext) {
            if (operandArray instanceof Block) {
                operandArray = (Block)operandArray;
                operandArray = operandArray.getOperanda();
                ArrayList arrayList = new ArrayList(((Operand[])operandArray).length);
                for (Operand operand : operandArray) {
                    Expression expression = operand.getChildExpression();
                    if (Cardinality.allowsMany(expression.getCardinality())) {
                        arrayList.add(expression.iterate(xPathContext).materialize());
                        continue;
                    }
                    Item<?> item = expression.evaluateItem(xPathContext);
                    if (item == null) continue;
                    arrayList.add(item);
                }
                return new Chain(arrayList);
            }
            return operandArray.iterate(xPathContext).materialize();
        }

        @Override
        public final int getCode() {
            return 11;
        }
    };
    public static final Evaluator STREAMING_ARGUMENT = new Evaluator(){

        @Override
        public final Sequence<?> evaluate(Expression expression, XPathContext xPathContext) {
            return xPathContext.getConfiguration().obtainOptimizer().evaluateStreamingArgument(expression, xPathContext);
        }

        @Override
        public final int getCode() {
            return 15;
        }
    };
    public static final Evaluator MAKE_INDEXED_VARIABLE = new Evaluator(){

        @Override
        public final Sequence<?> evaluate(Expression expression, XPathContext xPathContext) {
            return xPathContext.getConfiguration().obtainOptimizer().makeIndexedValue(expression.iterate(xPathContext));
        }

        @Override
        public final int getCode() {
            return 12;
        }
    };
    public static final Evaluator PROCESS = new Evaluator(){

        @Override
        public final Sequence<?> evaluate(Expression object, XPathContext xPathContext) {
            Object object2 = xPathContext.getController();
            Receiver receiver = xPathContext.getReceiver();
            object2 = ((Controller)object2).allocateSequenceOutputter(20);
            ((SequenceReceiver)object2).getPipelineConfiguration().setHostLanguage(((Expression)object).getPackageData().getHostLanguage());
            xPathContext.setReceiver((Receiver)object2);
            ((SequenceReceiver)object2).open();
            ((Expression)object).process(xPathContext);
            ((SequenceWriter)object2).close();
            xPathContext.setReceiver(receiver);
            object = ((SequenceOutputter)object2).getSequence();
            ((SequenceOutputter)object2).reset();
            return object;
        }

        @Override
        public final int getCode() {
            return 9;
        }
    };
    public static final Evaluator LAZY_TAIL = new Evaluator(){

        @Override
        public final Sequence<?> evaluate(Expression expression, XPathContext xPathContext) {
            Object object;
            expression = (TailExpression)expression;
            GroundedValue groundedValue = (VariableReference)((UnaryExpression)expression).getBaseExpression();
            if ((groundedValue = VARIABLE.evaluate((Expression)((Object)groundedValue), xPathContext)) instanceof MemoClosure) {
                object = groundedValue.iterate();
                groundedValue = object.materialize();
            }
            if (groundedValue instanceof IntegerRange) {
                long l2;
                long l3 = ((IntegerRange)groundedValue).getStart() + (long)((TailExpression)expression).getStart() - 1L;
                if (l3 == (l2 = ((IntegerRange)groundedValue).getEnd())) {
                    return Int64Value.makeIntegerValue(l2);
                }
                if (l3 > l2) {
                    return EmptySequence.getInstance();
                }
                return new IntegerRange(l3, l2);
            }
            if (groundedValue instanceof GroundedValue) {
                object = groundedValue;
                if (((TailExpression)expression).getStart() > groundedValue.getLength()) {
                    return EmptySequence.getInstance();
                }
                return object.subsequence(((TailExpression)expression).getStart() - 1, object.getLength() - ((TailExpression)expression).getStart() + 1);
            }
            return new MemoClosure(expression, xPathContext);
        }

        @Override
        public final int getCode() {
            return 10;
        }
    };

    public static Evaluator evaluatorForCode(int n2) {
        switch (n2) {
            case 0: {
                return LITERAL;
            }
            case 1: {
                return VARIABLE;
            }
            case 3: {
                return LAZY_SEQUENCE;
            }
            case 4: {
                return MEMO_CLOSURE;
            }
            case 5: {
                return EMPTY_SEQUENCE;
            }
            case 6: {
                return VARIABLE;
            }
            case 16: {
                return SINGLE_ITEM;
            }
            case 7: {
                return OPTIONAL_ITEM;
            }
            case 8: {
                return EAGER_SEQUENCE;
            }
            case 9: {
                return PROCESS;
            }
            case 10: {
                return LAZY_TAIL;
            }
            case 11: {
                return SHARED_APPEND;
            }
            case 12: {
                return MAKE_INDEXED_VARIABLE;
            }
            case 13: {
                return SINGLETON_CLOSURE;
            }
            case 14: {
                return SUPPLIED_PARAMETER;
            }
            case 15: {
                return STREAMING_ARGUMENT;
            }
        }
        return EAGER_SEQUENCE;
    }

    public abstract Sequence<?> evaluate(Expression var1, XPathContext var2);

    public abstract int getCode();
}

