/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.parser;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.function.Predicate;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerException;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.SequenceOutputter;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.event.SequenceWriter;
import net.sf.saxon.expr.Assignation;
import net.sf.saxon.expr.AxisExpression;
import net.sf.saxon.expr.Binding;
import net.sf.saxon.expr.ContextItemExpression;
import net.sf.saxon.expr.ContextSwitchingExpression;
import net.sf.saxon.expr.CurrentItemExpression;
import net.sf.saxon.expr.ErrorExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.FilterExpression;
import net.sf.saxon.expr.FunctionCall;
import net.sf.saxon.expr.GlobalVariableReference;
import net.sf.saxon.expr.LetExpression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.LocalBinding;
import net.sf.saxon.expr.LocalVariableReference;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.OperandUsage;
import net.sf.saxon.expr.RootExpression;
import net.sf.saxon.expr.SingleItemFilter;
import net.sf.saxon.expr.SlashExpression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.StaticFunctionCall;
import net.sf.saxon.expr.SuppliedParameterReference;
import net.sf.saxon.expr.TailExpression;
import net.sf.saxon.expr.TryCatch;
import net.sf.saxon.expr.UnaryExpression;
import net.sf.saxon.expr.UserFunctionCall;
import net.sf.saxon.expr.VariableReference;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.flwor.Clause;
import net.sf.saxon.expr.flwor.FLWORExpression;
import net.sf.saxon.expr.flwor.LocalVariableBinding;
import net.sf.saxon.expr.instruct.ApplyImports;
import net.sf.saxon.expr.instruct.ApplyTemplates;
import net.sf.saxon.expr.instruct.Block;
import net.sf.saxon.expr.instruct.CallTemplate;
import net.sf.saxon.expr.instruct.ForEachGroup;
import net.sf.saxon.expr.instruct.GlobalVariable;
import net.sf.saxon.expr.instruct.LocalParam;
import net.sf.saxon.expr.instruct.NextMatch;
import net.sf.saxon.expr.instruct.ParentNodeConstructor;
import net.sf.saxon.expr.instruct.ResultDocument;
import net.sf.saxon.expr.instruct.SimpleNodeConstructor;
import net.sf.saxon.expr.instruct.SlotManager;
import net.sf.saxon.expr.instruct.UserFunction;
import net.sf.saxon.expr.parser.CodeInjector;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.Evaluator;
import net.sf.saxon.expr.parser.ExplicitLocation;
import net.sf.saxon.expr.parser.ExpressionAction;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.LoopLifter;
import net.sf.saxon.expr.parser.Optimizer;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.expr.parser.RetainedStaticContext;
import net.sf.saxon.expr.parser.XPathParser;
import net.sf.saxon.expr.sort.ConditionalSorter;
import net.sf.saxon.expr.sort.DocumentSorter;
import net.sf.saxon.functions.ApplyFn;
import net.sf.saxon.functions.Current;
import net.sf.saxon.functions.CurrentGroup;
import net.sf.saxon.functions.IriToUri;
import net.sf.saxon.functions.RegexGroup;
import net.sf.saxon.lib.Logger;
import net.sf.saxon.lib.StandardLogger;
import net.sf.saxon.ma.arrays.ArrayItem;
import net.sf.saxon.ma.map.MapItem;
import net.sf.saxon.om.Function;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.query.QueryModule;
import net.sf.saxon.style.Compilation;
import net.sf.saxon.style.ExpressionContext;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.SymbolicName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.Closure;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.ExternalObject;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.IntegerRange;
import net.sf.saxon.value.MemoClosure;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.ObjectValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.SingletonClosure;
import net.sf.saxon.value.StringValue;

public class ExpressionTool {
    public static final int UNDECIDED = -1;
    public static final int EVALUATE_LITERAL = 0;
    public static final int EVALUATE_VARIABLE = 1;
    public static final int MAKE_CLOSURE = 3;
    public static final int MAKE_MEMO_CLOSURE = 4;
    public static final int RETURN_EMPTY_SEQUENCE = 5;
    public static final int EVALUATE_AND_MATERIALIZE_VARIABLE = 6;
    public static final int CALL_EVALUATE_OPTIONAL_ITEM = 7;
    public static final int ITERATE_AND_MATERIALIZE = 8;
    public static final int PROCESS = 9;
    public static final int LAZY_TAIL_EXPRESSION = 10;
    public static final int SHARED_APPEND_EXPRESSION = 11;
    public static final int MAKE_INDEXED_VARIABLE = 12;
    public static final int MAKE_SINGLETON_CLOSURE = 13;
    public static final int EVALUATE_SUPPLIED_PARAMETER = 14;
    public static final int STREAMING_ARGUMENT = 15;
    public static final int CALL_EVALUATE_SINGLE_ITEM = 16;

    private ExpressionTool() {
    }

    public static Expression make(String object, StaticContext staticContext, int n2, int n3, CodeInjector codeInjector) {
        int n4 = staticContext.getXPathVersion();
        XPathParser xPathParser = staticContext.getConfiguration().newExpressionParser("XP", false, n4);
        if (codeInjector != null) {
            xPathParser.setCodeInjector(codeInjector);
        }
        if (n3 == -1) {
            n3 = 0;
        }
        object = xPathParser.parse((String)object, n2, n3, staticContext);
        ExpressionTool.setDeepRetainedStaticContext((Expression)object, staticContext.makeRetainedStaticContext());
        object = ((Expression)object).simplify();
        return object;
    }

    public static void setDeepRetainedStaticContext(Expression object, RetainedStaticContext retainedStaticContext) {
        if (((Expression)object).getLocalRetainedStaticContext() == null) {
            ((Expression)object).setRetainedStaticContextLocally(retainedStaticContext);
        } else {
            retainedStaticContext = ((Expression)object).getLocalRetainedStaticContext();
        }
        for (Operand operand : ((Expression)object).operands()) {
            ExpressionTool.setDeepRetainedStaticContext(operand.getChildExpression(), retainedStaticContext);
        }
    }

    public static void copyLocationInfo(Expression expression, Expression expression2) {
        if (expression != null && expression2 != null) {
            if (expression2.getLocation() == null || expression2.getLocation() == ExplicitLocation.UNKNOWN_LOCATION) {
                expression2.setLocation(expression.getLocation());
            }
            if (expression2.getLocalRetainedStaticContext() == null) {
                expression2.setRetainedStaticContextLocally(expression.getLocalRetainedStaticContext());
            }
        }
    }

    public static Expression unsortedIfHomogeneous(Expression expression, boolean bl2) {
        if (expression instanceof Literal) {
            return expression;
        }
        if (expression.getItemType() instanceof AnyItemType) {
            return expression;
        }
        return expression.unordered(false, bl2);
    }

    public static Evaluator lazyEvaluator(Expression expression, boolean bl2) {
        if (expression instanceof Literal) {
            return Evaluator.LITERAL;
        }
        if (expression instanceof VariableReference) {
            return Evaluator.VARIABLE;
        }
        if (expression instanceof SuppliedParameterReference) {
            return Evaluator.SUPPLIED_PARAMETER;
        }
        if ((expression.getDependencies() & 0x6D) != 0) {
            return ExpressionTool.eagerEvaluator(expression);
        }
        if (expression instanceof ErrorExpression) {
            return Evaluator.SINGLE_ITEM;
        }
        if (!Cardinality.allowsMany(expression.getCardinality())) {
            return ExpressionTool.eagerEvaluator(expression);
        }
        if (expression instanceof TailExpression) {
            expression = (TailExpression)expression;
            if ((expression = ((UnaryExpression)expression).getBaseExpression()) instanceof VariableReference) {
                return Evaluator.LAZY_TAIL;
            }
            if (bl2) {
                return Evaluator.MEMO_CLOSURE;
            }
            return Evaluator.LAZY_SEQUENCE;
        }
        if (expression instanceof Block && ((Block)expression).isCandidateForSharedAppend()) {
            return Evaluator.SHARED_APPEND;
        }
        if (bl2) {
            return Evaluator.MEMO_CLOSURE;
        }
        return Evaluator.LAZY_SEQUENCE;
    }

    public static Evaluator eagerEvaluator(Expression expression) {
        if (expression instanceof Literal && !(((Literal)expression).getValue() instanceof Closure)) {
            return Evaluator.LITERAL;
        }
        if (expression instanceof VariableReference) {
            return Evaluator.VARIABLE;
        }
        int n2 = expression.getImplementationMethod();
        if ((n2 & 1) != 0 && !Cardinality.allowsMany(expression.getCardinality())) {
            if (Cardinality.allowsZero(expression.getCardinality())) {
                return Evaluator.OPTIONAL_ITEM;
            }
            return Evaluator.SINGLE_ITEM;
        }
        if ((n2 & 2) != 0) {
            return Evaluator.EAGER_SEQUENCE;
        }
        return Evaluator.PROCESS;
    }

    public static Sequence<?> evaluate(Expression sequence, int n2, XPathContext xPathContext, int n3) {
        switch (n2) {
            case 0: {
                return ((Literal)((Object)sequence)).getValue();
            }
            case 1: {
                return ((VariableReference)((Object)sequence)).evaluateVariable(xPathContext);
            }
            case 14: {
                return ((SuppliedParameterReference)((Object)sequence)).evaluateVariable(xPathContext);
            }
            case 3: {
                return Closure.make((Expression)((Object)sequence), xPathContext, n3);
            }
            case 4: {
                return Closure.make((Expression)((Object)sequence), xPathContext, n3 == 1 ? 10 : n3);
            }
            case 13: {
                return new SingletonClosure((Expression)((Object)sequence), xPathContext);
            }
            case 5: {
                return EmptySequence.getInstance();
            }
            case 6: {
                sequence = ((VariableReference)((Object)sequence)).evaluateVariable(xPathContext);
                if (sequence instanceof Closure) {
                    return sequence.iterate().materialize();
                }
                return sequence;
            }
            case 7: {
                sequence = ((Expression)((Object)sequence)).evaluateItem(xPathContext);
                if (sequence == null) {
                    return EmptySequence.getInstance();
                }
                return sequence;
            }
            case 16: {
                return ((Expression)((Object)sequence)).evaluateItem(xPathContext);
            }
            case -1: 
            case 8: {
                if (n3 == 10000) {
                    return xPathContext.getConfiguration().makeSequenceExtent((Expression)((Object)sequence), n3, xPathContext);
                }
                return ((Expression)((Object)sequence)).iterate(xPathContext).materialize();
            }
            case 9: {
                return Evaluator.PROCESS.evaluate((Expression)((Object)sequence), xPathContext);
            }
            case 10: {
                sequence = (TailExpression)((Object)sequence);
                GroundedValue groundedValue = (VariableReference)((UnaryExpression)((Object)sequence)).getBaseExpression();
                groundedValue = ExpressionTool.evaluate((Expression)((Object)groundedValue), 1, xPathContext, n3);
                if (groundedValue instanceof MemoClosure) {
                    SequenceIterator sequenceIterator = groundedValue.iterate();
                    groundedValue = sequenceIterator.materialize();
                }
                if (groundedValue instanceof IntegerRange) {
                    long l2;
                    long l3 = ((IntegerRange)groundedValue).getStart() + (long)((TailExpression)((Object)sequence)).getStart() - 1L;
                    if (l3 == (l2 = ((IntegerRange)groundedValue).getEnd())) {
                        return Int64Value.makeIntegerValue(l2);
                    }
                    if (l3 > l2) {
                        return EmptySequence.getInstance();
                    }
                    return new IntegerRange(l3, l2);
                }
                if (groundedValue instanceof GroundedValue) {
                    return groundedValue.subsequence(((TailExpression)((Object)sequence)).getStart() - 1, groundedValue.getLength() - ((TailExpression)((Object)sequence)).getStart() + 1);
                }
                return Closure.make(sequence, xPathContext, n3);
            }
            case 11: {
                return Evaluator.SHARED_APPEND.evaluate((Expression)((Object)sequence), xPathContext);
            }
            case 12: {
                return xPathContext.getConfiguration().obtainOptimizer().makeIndexedValue(((Expression)((Object)sequence)).iterate(xPathContext));
            }
            case 15: {
                return xPathContext.getConfiguration().obtainOptimizer().evaluateStreamingArgument((Expression)((Object)sequence), xPathContext);
            }
        }
        throw new IllegalArgumentException("Unknown evaluation mode " + n2);
    }

    public static Sequence<?> lazyEvaluate(Expression expression, XPathContext xPathContext, boolean bl2) {
        Evaluator evaluator = ExpressionTool.lazyEvaluator(expression, bl2);
        return evaluator.evaluate(expression, xPathContext);
    }

    public static GroundedValue<?> eagerEvaluate(Expression expression, XPathContext xPathContext) {
        Evaluator evaluator = ExpressionTool.eagerEvaluator(expression);
        return evaluator.evaluate(expression, xPathContext).materialize();
    }

    public static int markTailFunctionCalls(Expression expression, StructuredQName structuredQName, int n2) {
        return expression.markTailFunctionCalls(structuredQName, n2);
    }

    public static String indent(int n2) {
        FastStringBuffer fastStringBuffer = new FastStringBuffer(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            fastStringBuffer.append("  ");
        }
        return fastStringBuffer.toString();
    }

    public static boolean contains(Expression expression, Expression expression2) {
        while (expression2 != null) {
            if (expression2 == expression) {
                return true;
            }
            expression2 = expression2.getParentExpression();
        }
        return false;
    }

    public static boolean containsLocalParam(Expression expression2) {
        return ExpressionTool.contains(expression2, true, expression -> expression instanceof LocalParam);
    }

    public static boolean containsLocalVariableReference(Expression expression) {
        return ExpressionTool.contains(expression, false, object -> {
            if (object instanceof LocalVariableReference) {
                object = (LocalVariableReference)object;
                return !((object = ((LocalVariableReference)object).getBinding()) instanceof Expression) || !ExpressionTool.contains(expression, (Expression)object);
            }
            return false;
        });
    }

    public static boolean contains(Expression object, boolean bl2, Predicate<Expression> predicate) {
        if (predicate.test((Expression)object)) {
            return true;
        }
        for (Operand operand : ((Expression)object).operands()) {
            if (!operand.hasSameFocus() && bl2 || !ExpressionTool.contains(operand.getChildExpression(), bl2, predicate)) continue;
            return true;
        }
        return false;
    }

    public static boolean changesXsltContext(Expression object) {
        if ((object = ((Expression)object).getInterpretedExpression()) instanceof ResultDocument || object instanceof CallTemplate || object instanceof ApplyTemplates || object instanceof NextMatch || object instanceof ApplyImports || ((Expression)object).isCallOn(RegexGroup.class) || ((Expression)object).isCallOn(CurrentGroup.class)) {
            return true;
        }
        for (Operand operand : ((Expression)object).operands()) {
            if (!ExpressionTool.changesXsltContext(operand.getChildExpression())) continue;
            return true;
        }
        return false;
    }

    public static boolean isLoopingSubexpression(Expression expression, Expression expression2) {
        Expression expression3;
        while ((expression3 = expression.getParentExpression()) != null) {
            if (ExpressionTool.hasLoopingSubexpression(expression3, expression)) {
                return true;
            }
            if (expression3 == expression2) {
                return false;
            }
            expression = expression3;
        }
        return false;
    }

    public static boolean isLoopingReference(VariableReference expression, Binding binding) {
        Expression expression2 = expression.getParentExpression();
        while (expression2 != null) {
            if (expression2 instanceof FLWORExpression) {
                if (expression2.hasVariableBinding(binding)) {
                    return ((FLWORExpression)expression2).hasLoopingVariableReference(binding);
                }
                if (ExpressionTool.hasLoopingSubexpression(expression2, expression)) {
                    return true;
                }
            } else {
                if (expression2.getExpressionName().equals("tryCatch")) {
                    return true;
                }
                if (expression2 instanceof ForEachGroup && expression2.hasVariableBinding(binding)) {
                    return false;
                }
                if (ExpressionTool.hasLoopingSubexpression(expression2, expression)) {
                    return true;
                }
                if (expression2.hasVariableBinding(binding)) {
                    return false;
                }
            }
            expression = expression2;
            expression2 = expression.getParentExpression();
        }
        return true;
    }

    public static boolean hasLoopingSubexpression(Expression object, Expression expression) {
        for (Operand operand : ((Expression)object).operands()) {
            if (operand.getChildExpression() != expression) continue;
            return operand.isEvaluatedRepeatedly();
        }
        return false;
    }

    public static Expression getFocusSettingContainer(Expression object) {
        Expression expression = ((Expression)object).getParentExpression();
        while (expression != null) {
            if ((object = ExpressionTool.findOperand(expression, (Expression)object)) == null) {
                throw new AssertionError();
            }
            if (!((Operand)object).hasSameFocus()) {
                return expression;
            }
            object = expression;
            expression = ((Expression)object).getParentExpression();
        }
        return null;
    }

    public static Expression getContextDocumentSettingContainer(Expression expression) {
        block0: while (true) {
            Expression expression2 = expression.getParentExpression();
            while (expression2 != null) {
                Object object;
                if (expression2 instanceof ContextSwitchingExpression && expression == (object = (ContextSwitchingExpression)((Object)expression2)).getActionExpression() && object.getSelectExpression().hasSpecialProperty(65536)) {
                    expression2.resetLocalStaticProperties();
                    expression2.getSpecialProperties();
                    expression = expression2;
                    continue block0;
                }
                object = ExpressionTool.findOperand(expression2, expression);
                if (object == null) {
                    throw new AssertionError();
                }
                if (!((Operand)object).hasSameFocus()) {
                    return expression2;
                }
                expression = expression2;
                expression2 = expression.getParentExpression();
            }
            break;
        }
        return null;
    }

    public static void resetStaticProperties(Expression expression) {
        int n2 = 0;
        while (expression != null) {
            expression.resetLocalStaticProperties();
            expression = expression.getParentExpression();
            if (n2++ <= 100000) continue;
            throw new IllegalStateException("Loop in parent expression chain");
        }
    }

    public static boolean equalOrNull(Object object, Object object2) {
        if (object == null) {
            return object2 == null;
        }
        return object.equals(object2);
    }

    public static SequenceIterator<?> getIteratorFromProcessMethod(Expression expression, XPathContext xPathContext) {
        Object object = xPathContext.getController();
        assert (object != null);
        Receiver receiver = xPathContext.getReceiver();
        object = ((Controller)object).allocateSequenceOutputter(20);
        ((SequenceReceiver)object).getPipelineConfiguration().setHostLanguage(expression.getPackageData().getHostLanguage());
        xPathContext.setReceiver((Receiver)object);
        expression.process(xPathContext);
        xPathContext.setReceiver(receiver);
        ((SequenceWriter)object).close();
        return ((SequenceOutputter)object).iterate();
    }

    public static Item getItemFromProcessMethod(Expression object, XPathContext xPathContext) {
        Object object2 = xPathContext.getController();
        assert (object2 != null);
        Receiver receiver = xPathContext.getReceiver();
        object2 = ((Controller)object2).allocateSequenceOutputter(1);
        ((SequenceReceiver)object2).getPipelineConfiguration().setHostLanguage(((Expression)object).getPackageData().getHostLanguage());
        xPathContext.setReceiver((Receiver)object2);
        ((Expression)object).process(xPathContext);
        xPathContext.setReceiver(receiver);
        ((SequenceWriter)object2).close();
        object = ((SequenceOutputter)object2).getFirstItem();
        ((SequenceOutputter)object2).reset();
        return object;
    }

    public static int allocateSlots(Expression expression, int n2, SlotManager slotManager) {
        if (expression instanceof Assignation) {
            ((Assignation)expression).setSlotNumber(n2);
            int n3 = ((Assignation)expression).getRequiredSlots();
            n2 += n3;
            if (slotManager != null) {
                slotManager.allocateSlotNumber(((Assignation)expression).getVariableQName());
            }
        }
        if (expression instanceof LocalParam && ((LocalParam)expression).getSlotNumber() < 0) {
            ((LocalParam)expression).setSlotNumber(n2++);
        }
        if (expression instanceof FLWORExpression) {
            for (Clause clause : ((FLWORExpression)expression).getClauseList()) {
                for (LocalVariableBinding localVariableBinding : clause.getRangeVariables()) {
                    localVariableBinding.setSlotNumber(n2++);
                    slotManager.allocateSlotNumber(localVariableBinding.getVariableQName());
                }
            }
        }
        if (expression instanceof VariableReference) {
            VariableReference variableReference = (VariableReference)expression;
            Binding binding = variableReference.getBinding();
            if (expression instanceof LocalVariableReference) {
                ((LocalVariableReference)variableReference).setSlotNumber(((LocalBinding)binding).getLocalSlotNumber());
            }
            if (binding instanceof Assignation && ((LocalBinding)binding).getLocalSlotNumber() < 0) {
                Logger logger;
                Assignation assignation = (Assignation)binding;
                try {
                    logger = expression.getConfiguration().getLogger();
                }
                catch (Exception exception) {
                    logger = new StandardLogger();
                }
                String string = "*** Internal Saxon error: local variable encountered whose binding has been deleted";
                logger.error(string);
                logger.error("Variable name: " + assignation.getVariableName());
                logger.error("Line number of reference: " + variableReference.getLocation().getLineNumber() + " in " + variableReference.getLocation().getSystemId());
                logger.error("Line number of declaration: " + assignation.getLocation().getLineNumber() + " in " + assignation.getLocation().getSystemId());
                logger.error("DECLARATION:");
                try {
                    assignation.explain(logger);
                }
                catch (Exception exception) {}
                throw new IllegalStateException(string);
            }
        }
        if (expression instanceof Pattern) {
            n2 = ((Pattern)expression).allocateSlots(slotManager, n2);
        } else {
            for (Operand operand : expression.operands()) {
                n2 = ExpressionTool.allocateSlots(operand.getChildExpression(), n2, slotManager);
            }
        }
        return n2;
    }

    public static boolean effectiveBooleanValue(SequenceIterator object) {
        Object t2 = object.next();
        if (t2 == null) {
            return false;
        }
        if (t2 instanceof NodeInfo) {
            object.close();
            return true;
        }
        if (t2 instanceof AtomicValue) {
            if (t2 instanceof BooleanValue) {
                if (object.next() != null) {
                    object.close();
                    ExpressionTool.ebvError("a sequence of two or more items starting with a boolean");
                }
                object.close();
                return ((BooleanValue)t2).getBooleanValue();
            }
            if (t2 instanceof StringValue) {
                if (object.next() != null) {
                    object.close();
                    ExpressionTool.ebvError("a sequence of two or more items starting with a string");
                }
                return !((StringValue)t2).isZeroLength();
            }
            if (t2 instanceof NumericValue) {
                if (object.next() != null) {
                    object.close();
                    ExpressionTool.ebvError("a sequence of two or more items starting with a numeric value");
                }
                return ((NumericValue)(object = (NumericValue)t2)).compareTo(0L) != 0 && !((AtomicValue)object).isNaN();
            }
            object.close();
            ExpressionTool.ebvError("a sequence starting with an atomic value of type " + ((AtomicValue)t2).getItemType().getTypeName().getDisplayName());
            return false;
        }
        if (t2 instanceof Function) {
            object.close();
            if (t2 instanceof ArrayItem) {
                ExpressionTool.ebvError("a sequence starting with an array item (" + t2.toShortString() + ")");
                return false;
            }
            if (t2 instanceof MapItem) {
                ExpressionTool.ebvError("a sequence starting with a map (" + t2.toShortString() + ")");
                return false;
            }
            ExpressionTool.ebvError("a sequence starting with a function (" + t2.toShortString() + ")");
            return false;
        }
        if (t2 instanceof ObjectValue) {
            if (object.next() != null) {
                object.close();
                ExpressionTool.ebvError("a sequence of two or more items starting with an external object value");
            }
            return true;
        }
        ExpressionTool.ebvError("a sequence starting with an item of unknown kind");
        return false;
    }

    public static boolean effectiveBooleanValue(Item item) {
        if (item == null) {
            return false;
        }
        if (item instanceof NodeInfo) {
            return true;
        }
        if (item instanceof BooleanValue) {
            return ((BooleanValue)item).getBooleanValue();
        }
        if (item instanceof StringValue) {
            return !((StringValue)item).isZeroLength();
        }
        if (item instanceof NumericValue) {
            return ((NumericValue)(item = (NumericValue)item)).compareTo(0L) != 0 && !((AtomicValue)item).isNaN();
        }
        if (item instanceof ExternalObject) {
            return true;
        }
        ExpressionTool.ebvError("an atomic value other than a boolean, number, string, or URI");
        return false;
    }

    public static void ebvError(String object) {
        object = new XPathException("Effective boolean value is not defined for " + (String)object);
        ((XPathException)object).setErrorCode("FORG0006");
        ((XPathException)object).setIsTypeError(true);
        throw object;
    }

    public static void ebvError(String object, Expression expression) {
        object = new XPathException("Effective boolean value is not defined for " + (String)object);
        ((XPathException)object).setErrorCode("FORG0006");
        ((XPathException)object).setIsTypeError(true);
        ((XPathException)object).setFailingExpression(expression);
        throw object;
    }

    public static boolean dependsOnFocus(Expression expression) {
        return (expression.getDependencies() & 0x1E) != 0;
    }

    public static boolean dependsOnVariable(Expression expression2, Binding[] bindingArray) {
        return bindingArray != null && bindingArray.length != 0 && ExpressionTool.contains(expression2, false, expression -> {
            if (expression instanceof VariableReference) {
                for (Binding binding : bindingArray) {
                    if (((VariableReference)expression).getBinding() != binding) continue;
                    return true;
                }
            }
            return false;
        });
    }

    public static void gatherReferencedVariables(Expression iterator, List<Binding> list) {
        if (iterator instanceof VariableReference) {
            if (!list.contains(iterator = ((VariableReference)((Object)iterator)).getBinding())) {
                list.add((Binding)((Object)iterator));
            }
            return;
        }
        for (Operand operand : ((Expression)((Object)iterator)).operands()) {
            if (operand.getOperandRole().isInChoiceGroup()) continue;
            ExpressionTool.gatherReferencedVariables(operand.getChildExpression(), list);
        }
    }

    public static boolean refersToVariableOrFunction(Expression expression2) {
        return ExpressionTool.contains(expression2, false, expression -> expression instanceof VariableReference || expression instanceof UserFunctionCall || expression instanceof Binding || expression instanceof CallTemplate || expression instanceof ApplyTemplates || expression instanceof ApplyImports || ExpressionTool.isCallOnSystemFunction(expression, "function-lookup") || expression.isCallOn(ApplyFn.class));
    }

    public static boolean isCallOnSystemFunction(Expression expression, String string) {
        return expression instanceof StaticFunctionCall && string.equals(((FunctionCall)((StaticFunctionCall)expression)).getFunctionName().getLocalPart());
    }

    public static boolean callsFunction(Expression expression2, StructuredQName structuredQName, boolean bl2) {
        return ExpressionTool.contains(expression2, bl2, expression -> expression instanceof FunctionCall && structuredQName.equals(((FunctionCall)expression).getFunctionName()));
    }

    public static boolean containsSubexpression(Expression expression2, Class<? extends Expression> clazz) {
        return ExpressionTool.contains(expression2, false, expression -> clazz.isAssignableFrom(expression.getClass()));
    }

    public static void gatherCalledFunctions(Expression iterator, List<UserFunction> list) {
        if (iterator instanceof UserFunctionCall) {
            if (!list.contains(iterator = ((UserFunctionCall)((Object)iterator)).getFunction())) {
                list.add((UserFunction)((Object)iterator));
            }
            return;
        }
        for (Operand operand : ((Expression)((Object)iterator)).operands()) {
            ExpressionTool.gatherCalledFunctions(operand.getChildExpression(), list);
        }
    }

    public static void gatherCalledFunctionNames(Expression object, List<SymbolicName> list) {
        if (object instanceof UserFunctionCall) {
            list.add(((UserFunctionCall)object).getSymbolicName());
            return;
        }
        for (Operand operand : ((Expression)object).operands()) {
            ExpressionTool.gatherCalledFunctionNames(operand.getChildExpression(), list);
        }
    }

    public static Expression optimizeComponentBody(Expression expression, Compilation object, ExpressionVisitor expressionVisitor, ContextItemStaticInfo contextItemStaticInfo, boolean bl2) {
        Configuration configuration = expressionVisitor.getConfiguration();
        Optimizer optimizer = expressionVisitor.obtainOptimizer();
        StaticContext staticContext = expressionVisitor.getStaticContext();
        boolean bl3 = configuration.isCompileWithTracing();
        if (!bl3) {
            if (object != null) {
                bl3 = ((Compilation)object).getCompilerInfo().isCompileWithTracing();
            } else if (staticContext instanceof QueryModule) {
                bl3 = ((QueryModule)staticContext).getUserQueryContext().isCompileWithTracing();
            } else if (staticContext instanceof ExpressionContext) {
                bl3 = ((ExpressionContext)staticContext).getStyleElement().getCompilation().getCompilerInfo().isCompileWithTracing();
            }
        }
        if (optimizer.isOptionSet(256) && !bl3) {
            ExpressionTool.resetPropertiesWithinSubtree(expression);
            if (optimizer.isOptionSet(256)) {
                expression = expression.optimize(expressionVisitor, contextItemStaticInfo);
            }
            expression.setParentExpression(null);
            if (bl2 && object != null && (object = optimizer.promoteExpressionsToGlobal(expression, ((Compilation)object).getPrincipalStylesheetModule(), expressionVisitor)) != null) {
                ExpressionTool.resetPropertiesWithinSubtree((Expression)object);
                expression = ((Expression)object).optimize(expressionVisitor, contextItemStaticInfo);
            }
            if (optimizer.isOptionSet(1)) {
                expression = LoopLifter.process(expression, expressionVisitor, contextItemStaticInfo);
            }
        } else {
            expression = ExpressionTool.a(expression);
        }
        if (!expressionVisitor.isOptimizeForStreaming()) {
            expression = optimizer.eliminateCommonSubexpressions(expression);
        }
        optimizer.injectByteCodeCandidates(expression);
        optimizer.prepareForStreaming(expression);
        ExpressionTool.computeEvaluationModesForUserFunctionCalls(expression);
        expression.restoreParentPointers();
        return expression;
    }

    private static Expression a(Expression expression) {
        Object object;
        Expression object22;
        if (expression instanceof DocumentSorter) {
            Expression expression2 = ((DocumentSorter)expression).getBaseExpression();
            if (expression2.hasSpecialProperty(131072)) {
                return expression2;
            }
            return expression;
        }
        if (expression instanceof ConditionalSorter && (object22 = ExpressionTool.a((Expression)(object = ((ConditionalSorter)expression).getDocumentSorter()))) != object) {
            return object22;
        }
        for (Operand operand : expression.operands()) {
            operand.setChildExpression(ExpressionTool.a(operand.getChildExpression()));
        }
        return expression;
    }

    public static void computeEvaluationModesForUserFunctionCalls(Expression expression2) {
        ExpressionTool.processExpressionTree(expression2, null, (expression, object) -> {
            if (expression instanceof UserFunctionCall) {
                ((UserFunctionCall)expression).allocateArgumentEvaluators();
            }
            if (expression instanceof LocalParam) {
                ((LocalParam)expression).computeEvaluationMode();
            }
            return false;
        });
    }

    public static void clearStreamabilityData(Expression expression2) {
        ExpressionTool.processExpressionTree(expression2, null, (expression, object) -> {
            expression.setExtraProperty("P+S", null);
            expression.setExtraProperty("inversion", null);
            return false;
        });
    }

    public static void resetPropertiesWithinSubtree(Expression expression) {
        Object object;
        LocalBinding object22;
        expression.resetLocalStaticProperties();
        if (expression instanceof LocalVariableReference && (object22 = ((LocalVariableReference)(object = (LocalVariableReference)expression)).getBinding()) instanceof Assignation) {
            Object object2 = object;
            object22.addReference((VariableReference)object2, ((VariableReference)object2).isInLoop());
        }
        for (Operand operand : expression.operands()) {
            ExpressionTool.resetPropertiesWithinSubtree(operand.getChildExpression());
            operand.getChildExpression().setParentExpression(expression);
        }
    }

    public static Expression resolveCallsToCurrentFunction(Expression expression) {
        if (expression.isCallOn(Current.class)) {
            ContextItemExpression contextItemExpression = new ContextItemExpression();
            ExpressionTool.copyLocationInfo(expression, contextItemExpression);
            return contextItemExpression;
        }
        if (ExpressionTool.callsFunction(expression, Current.FN_CURRENT, true)) {
            ExpressionTool.replaceTrivialCallsToCurrent(expression);
        }
        if (ExpressionTool.callsFunction(expression, Current.FN_CURRENT, false)) {
            LetExpression letExpression = new LetExpression();
            letExpression.setVariableQName(new StructuredQName("vv", "http://saxon.sf.net/generated-variable", "current" + expression.hashCode()));
            letExpression.setRequiredType(SequenceType.SINGLE_ITEM);
            letExpression.setSequence(new CurrentItemExpression());
            ExpressionTool.replaceCallsToCurrent(expression, letExpression);
            letExpression.setAction(expression);
            return letExpression;
        }
        return expression;
    }

    public static void gatherVariableReferences(Expression object, Binding binding, List<VariableReference> list) {
        if (object instanceof VariableReference && ((VariableReference)object).getBinding() == binding) {
            list.add((VariableReference)object);
            return;
        }
        for (Operand operand : ((Expression)object).operands()) {
            ExpressionTool.gatherVariableReferences(operand.getChildExpression(), binding, list);
        }
    }

    public static boolean processExpressionTree(Expression object, Object object2, ExpressionAction expressionAction) {
        boolean bl2 = expressionAction.process((Expression)object, object2);
        if (!bl2) {
            for (Operand operand : ((Expression)object).operands()) {
                bl2 = ExpressionTool.processExpressionTree(operand.getChildExpression(), object2, expressionAction);
                if (!bl2) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean replaceSelectedSubexpressions(Expression object, ExpressionSelector expressionSelector, Expression expression, boolean bl2) {
        boolean bl3 = false;
        for (Operand operand : ((Expression)object).operands()) {
            Expression expression2;
            if (bl3) {
                bl2 = true;
            }
            if (expressionSelector.matches(expression2 = operand.getChildExpression())) {
                expression2 = bl2 ? expression.copy(new RebindingMap()) : expression;
                operand.setChildExpression(expression2);
                bl3 = true;
                continue;
            }
            bl3 = ExpressionTool.replaceSelectedSubexpressions(expression2, expressionSelector, expression, bl2);
        }
        return bl3;
    }

    public static void replaceVariableReferences(Expression expression, Binding object, Expression expression2, boolean bl2) {
        object = arg_0 -> ExpressionTool.a((Binding)object, arg_0);
        ExpressionTool.replaceSelectedSubexpressions(expression, (ExpressionSelector)object, expression2, bl2);
    }

    public static int getReferenceCount(Expression object, Binding binding, boolean bl2) {
        int n2 = 0;
        if (object instanceof VariableReference && ((VariableReference)object).getBinding() == binding) {
            if (((VariableReference)object).isFiltered()) {
                return 10000;
            }
            n2 = 0 + (bl2 ? 10 : 1);
        } else {
            if ((((Expression)object).getDependencies() & 0x80) == 0) {
                return 0;
            }
            for (Operand operand : ((Expression)object).operands()) {
                boolean bl3;
                Expression expression = operand.getChildExpression();
                boolean bl4 = bl3 = bl2 || operand.isEvaluatedRepeatedly();
                if ((n2 += ExpressionTool.getReferenceCount(expression, binding, bl3)) < 10000) continue;
            }
        }
        return n2;
    }

    public static int expressionSize(Expression object) {
        object = ((Expression)object).getInterpretedExpression();
        int n2 = 1;
        for (Operand operand : ((Expression)object).operands()) {
            n2 += ExpressionTool.expressionSize(operand.getChildExpression());
        }
        return n2;
    }

    public static void rebindVariableReferences(Expression object, Binding binding, Binding binding2) {
        if (object instanceof VariableReference) {
            if (((VariableReference)object).getBinding() == binding) {
                ((VariableReference)object).fixup(binding2);
                return;
            }
        } else {
            for (Operand operand : ((Expression)object).operands()) {
                ExpressionTool.rebindVariableReferences(operand.getChildExpression(), binding, binding2);
            }
        }
    }

    public static Expression makePathExpression(Expression expression, Expression expression2) {
        if (expression instanceof RootExpression && expression2 instanceof AxisExpression && ((AxisExpression)expression2).getAxis() == 9) {
            return Literal.makeEmptySequence();
        }
        SlashExpression slashExpression = new SlashExpression(expression, expression2);
        if (expression2 instanceof SlashExpression && ExpressionTool.b(((SlashExpression)(expression2 = (SlashExpression)expression2)).getSelectExpression()) && ExpressionTool.b(((SlashExpression)expression2).getActionExpression())) {
            slashExpression.setStart(ExpressionTool.makePathExpression(expression, ((SlashExpression)expression2).getSelectExpression()));
            slashExpression.setStep(((SlashExpression)expression2).getActionExpression());
        }
        return slashExpression;
    }

    public static Operand findOperand(Expression object, Expression expression) {
        for (Operand operand : ((Expression)object).operands()) {
            if (operand.getChildExpression() != expression) continue;
            return operand;
        }
        return null;
    }

    private static boolean b(Expression expression) {
        return ExpressionTool.unfilteredExpression(expression, true) instanceof AxisExpression;
    }

    public static Expression unfilteredExpression(Expression expression, boolean bl2) {
        while (true) {
            if (expression instanceof FilterExpression && (bl2 || !((FilterExpression)expression).isFilterIsPositional())) {
                expression = ((FilterExpression)expression).getSelectExpression();
                continue;
            }
            if (!(expression instanceof SingleItemFilter) || !bl2) break;
            expression = ((SingleItemFilter)expression).getBaseExpression();
        }
        return expression;
    }

    public static Expression tryToFactorOutDot(Expression expression, ItemType itemType) {
        if (expression instanceof ContextItemExpression) {
            return null;
        }
        if (expression instanceof LetExpression && ((LetExpression)expression).getSequence() instanceof ContextItemExpression) {
            Expression expression2 = ((LetExpression)expression).getAction();
            boolean bl2 = ExpressionTool.factorOutDot(expression2, (LetExpression)expression);
            if (bl2) {
                expression.resetLocalStaticProperties();
            }
            return expression;
        }
        if ((expression.getDependencies() & 0x12) != 0) {
            LetExpression letExpression = new LetExpression();
            letExpression.setVariableQName(new StructuredQName("saxon", "http://saxon.sf.net/", "dot" + expression.hashCode()));
            letExpression.setRequiredType(SequenceType.makeSequenceType(itemType, 16384));
            letExpression.setSequence(new ContextItemExpression());
            letExpression.setAction(expression);
            boolean bl3 = ExpressionTool.factorOutDot(expression, letExpression);
            if (bl3) {
                return letExpression;
            }
            return expression;
        }
        return null;
    }

    public static boolean factorOutDot(Expression expression, Binding binding) {
        boolean bl2 = false;
        if ((expression.getDependencies() & 0x12) != 0) {
            for (Operand operand : expression.operands()) {
                if (!operand.hasSameFocus()) continue;
                Expression expression2 = operand.getChildExpression();
                if (expression2 instanceof ContextItemExpression) {
                    VariableReference variableReference = binding.isGlobal() ? new GlobalVariableReference((GlobalVariable)binding) : new LocalVariableReference((LocalBinding)binding);
                    ExpressionTool.copyLocationInfo(expression2, variableReference);
                    operand.setChildExpression(variableReference);
                    bl2 = true;
                    continue;
                }
                if (expression2 instanceof AxisExpression || expression2 instanceof RootExpression) {
                    Expression expression3 = binding.isGlobal() ? new GlobalVariableReference((GlobalVariable)binding) : new LocalVariableReference((LocalBinding)binding);
                    ExpressionTool.copyLocationInfo(expression2, expression3);
                    expression3 = ExpressionTool.makePathExpression(expression3, expression2);
                    operand.setChildExpression(expression3);
                    bl2 = true;
                    continue;
                }
                bl2 |= ExpressionTool.factorOutDot(expression2, binding);
            }
        }
        if (bl2) {
            expression.resetLocalStaticProperties();
        }
        return bl2;
    }

    public static boolean inlineVariableReferences(Expression expression, Binding binding, Expression expression2) {
        return ExpressionTool.inlineVariableReferencesInternal(expression, binding, expression2);
    }

    public static boolean inlineVariableReferencesInternal(Expression expression, Binding binding, Expression expression2) {
        if (expression instanceof TryCatch && !(expression2 instanceof Literal)) {
            return false;
        }
        boolean bl2 = false;
        for (Operand operand : expression.operands()) {
            Expression expression3 = operand.getChildExpression();
            if (expression3 instanceof VariableReference && ((VariableReference)expression3).getBinding() == binding) {
                Expression expression4;
                try {
                    expression4 = expression2.copy(new RebindingMap());
                    ExpressionTool.copyLocationInfo(expression3, expression4);
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    expression4 = expression2;
                }
                operand.setChildExpression(expression4);
                bl2 = true;
                continue;
            }
            bl2 |= ExpressionTool.inlineVariableReferencesInternal(expression3, binding, expression2);
        }
        if (bl2) {
            expression.resetLocalStaticProperties();
        }
        return bl2;
    }

    public static boolean replaceTrivialCallsToCurrent(Expression expression) {
        boolean bl2 = false;
        for (Operand operand : expression.operands()) {
            if (!operand.hasSameFocus()) continue;
            Expression expression2 = operand.getChildExpression();
            if (expression2.isCallOn(Current.class)) {
                CurrentItemExpression currentItemExpression = new CurrentItemExpression();
                ExpressionTool.copyLocationInfo(expression2, currentItemExpression);
                operand.setChildExpression(currentItemExpression);
                bl2 = true;
                continue;
            }
            bl2 = ExpressionTool.replaceTrivialCallsToCurrent(expression2);
        }
        if (bl2) {
            expression.resetLocalStaticProperties();
        }
        return bl2;
    }

    public static boolean replaceCallsToCurrent(Expression expression, LocalBinding localBinding) {
        boolean bl2 = false;
        for (Operand operand : expression.operands()) {
            Expression expression2 = operand.getChildExpression();
            if (expression2.isCallOn(Current.class)) {
                LocalVariableReference localVariableReference = new LocalVariableReference(localBinding);
                ExpressionTool.copyLocationInfo(expression2, localVariableReference);
                operand.setChildExpression(localVariableReference);
                localBinding.addReference(localVariableReference, true);
                bl2 = true;
                continue;
            }
            bl2 = ExpressionTool.replaceCallsToCurrent(expression2, localBinding);
        }
        if (bl2) {
            expression.resetLocalStaticProperties();
        }
        return bl2;
    }

    public static boolean isNotAllowedInUpdatingContext(Expression expression) {
        return !expression.isUpdatingExpression() && !expression.isVacuousExpression();
    }

    public static String getCurrentDirectory() {
        Object object;
        try {
            object = System.getProperty("user.dir");
        }
        catch (Exception exception) {
            return null;
        }
        if (!((String)object).endsWith("/")) {
            object = (String)object + '/';
        }
        object = new File((String)object).toURI();
        return ((URI)object).toString();
    }

    public static URI getBaseURI(StaticContext object, SourceLocator sourceLocator, boolean bl2) {
        Object object2;
        block6: {
            object2 = null;
            String string = null;
            try {
                string = object.getStaticBaseURI();
                if (string == null) {
                    string = ExpressionTool.getCurrentDirectory();
                }
                if (string != null) {
                    object2 = new URI(string);
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                object2 = IriToUri.iriToUri(string).toString();
                try {
                    object2 = new URI((String)object2);
                }
                catch (URISyntaxException uRISyntaxException2) {
                    object2 = null;
                }
                if (object2 != null || !bl2) break block6;
                object = new XPathException("The base URI " + Err.wrap(object.getStaticBaseURI(), 7) + " is not a valid URI");
                ((TransformerException)object).setLocator(sourceLocator);
                throw object;
            }
        }
        return object2;
    }

    public static String parenthesize(Expression expression) {
        if (expression.operands().iterator().hasNext()) {
            return "(" + expression.toString() + ")";
        }
        return expression.toString();
    }

    public static String parenthesizeShort(Expression expression) {
        boolean bl2;
        Object object = expression;
        if (!(object = ((Expression)object).operands().iterator()).hasNext()) {
            bl2 = false;
        } else {
            object.next();
            bl2 = object.hasNext();
        }
        if (bl2) {
            return "(" + expression.toShortString() + ")";
        }
        return expression.toShortString();
    }

    public static void validateTree(Expression iterator) {
        try {
            for (Operand operand : ((Expression)((Object)iterator)).checkedOperands()) {
                ExpressionTool.validateTree(operand.getChildExpression());
            }
            return;
        }
        catch (IllegalStateException illegalStateException) {
            iterator = illegalStateException;
            illegalStateException.printStackTrace();
            return;
        }
    }

    public static boolean isLocalConstructor(Expression object) {
        if (!(object instanceof ParentNodeConstructor) && !(object instanceof SimpleNodeConstructor)) {
            return false;
        }
        for (Expression expression = ((Expression)object).getParentExpression(); expression != null; expression = expression.getParentExpression()) {
            if (expression instanceof ParentNodeConstructor) {
                return true;
            }
            if (((Operand)(object = ExpressionTool.findOperand(expression, (Expression)object))).getUsage() != OperandUsage.TRANSMISSION) {
                return false;
            }
            object = expression;
        }
        return false;
    }

    private static /* synthetic */ boolean a(Binding binding, Expression expression) {
        return expression instanceof VariableReference && ((VariableReference)expression).getBinding() == binding;
    }

    public static interface ExpressionSelector {
        public boolean matches(Expression var1);
    }

    @FunctionalInterface
    public static interface ExpressionPredicate {
        public boolean test(Expression var1);
    }
}

