/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.parser;

public class OptimizerOptions {
    public static final int LOOP_LIFTING = 1;
    public static final int EXTRACT_GLOBALS = 2;
    public static final int INLINE_VARIABLES = 4;
    public static final int INLINE_FUNCTIONS = 8;
    public static final int INDEX_VARIABLES = 16;
    public static final int CREATE_KEYS = 32;
    public static final int BYTE_CODE = 64;
    public static final int COMMON_SUBEXPRESSIONS = 128;
    public static final int MISCELLANEOUS = 256;
    public static final int SWITCH = 512;
    public static final int JIT = 1024;
    public static final int RULE_SET = 2048;
    public static final int REGEX_CACHE = 4096;
    public static final int VOID_EXPRESSIONS = 8192;
    public static final int TAIL_CALLS = 16384;
    private int a;
    public static final OptimizerOptions FULL_HE_OPTIMIZATION = new OptimizerOptions("lvmt");
    public static final OptimizerOptions FULL_EE_OPTIMIZATION = new OptimizerOptions(-1);

    public OptimizerOptions(int n2) {
        this.a = n2;
    }

    public OptimizerOptions(String string) {
        int n2 = 0;
        if (string.startsWith("-")) {
            n2 = -1;
            for (int i2 = 0; i2 < string.length(); ++i2) {
                char c2 = string.charAt(i2);
                n2 &= ~OptimizerOptions.a(c2);
            }
        } else {
            for (int i3 = 0; i3 < string.length(); ++i3) {
                char c3 = string.charAt(i3);
                n2 |= OptimizerOptions.a(c3);
            }
        }
        this.a = n2;
    }

    private static int a(char c2) {
        switch (c2) {
            case 'c': {
                return 64;
            }
            case 'd': {
                return 8192;
            }
            case 'e': {
                return 4096;
            }
            case 'f': {
                return 8;
            }
            case 'g': {
                return 2;
            }
            case 'j': {
                return 1024;
            }
            case 'k': {
                return 32;
            }
            case 'l': {
                return 1;
            }
            case 'm': {
                return 256;
            }
            case 'r': {
                return 2048;
            }
            case 's': {
                return 128;
            }
            case 't': {
                return 16384;
            }
            case 'v': {
                return 4;
            }
            case 'w': {
                return 512;
            }
            case 'x': {
                return 16;
            }
        }
        return 0;
    }

    public OptimizerOptions intersect(OptimizerOptions optimizerOptions) {
        return new OptimizerOptions(this.a & optimizerOptions.a);
    }

    public OptimizerOptions union(OptimizerOptions optimizerOptions) {
        return new OptimizerOptions(this.a | optimizerOptions.a);
    }

    public OptimizerOptions except(OptimizerOptions optimizerOptions) {
        return new OptimizerOptions(this.a & ~optimizerOptions.a);
    }

    public String toString() {
        String string = "";
        if (this.isSet(64)) {
            string = string + "c";
        }
        if (this.isSet(8192)) {
            string = string + "d";
        }
        if (this.isSet(4096)) {
            string = string + "e";
        }
        if (this.isSet(8)) {
            string = string + "f";
        }
        if (this.isSet(2)) {
            string = string + "g";
        }
        if (this.isSet(1024)) {
            string = string + "j";
        }
        if (this.isSet(32)) {
            string = string + "k";
        }
        if (this.isSet(1)) {
            string = string + "l";
        }
        if (this.isSet(256)) {
            string = string + "m";
        }
        if (this.isSet(2048)) {
            string = string + "r";
        }
        if (this.isSet(128)) {
            string = string + "s";
        }
        if (this.isSet(16384)) {
            string = string + "t";
        }
        if (this.isSet(4)) {
            string = string + "v";
        }
        if (this.isSet(512)) {
            string = string + "w";
        }
        if (this.isSet(16)) {
            string = string + "x";
        }
        return string;
    }

    public boolean isSet(int n2) {
        return (this.a & n2) != 0;
    }

    public int getOptions() {
        return this.a;
    }
}

