/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.parser;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import net.sf.saxon.expr.Binding;
import net.sf.saxon.expr.ContextItemExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.RootExpression;
import net.sf.saxon.expr.SystemFunctionCall;
import net.sf.saxon.functions.Doc;
import net.sf.saxon.functions.DocumentFn;
import net.sf.saxon.functions.ResolveURI;
import net.sf.saxon.lib.Logger;
import net.sf.saxon.om.AxisInfo;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.trans.XPathException;

public class PathMap {
    private List<PathMapRoot> a = new ArrayList<PathMapRoot>();
    private HashMap<Binding, PathMapNodeSet> b = new HashMap();

    public PathMap(Expression iterator) {
        iterator = ((Expression)((Object)iterator)).addToPathMap(this, null);
        if (iterator != null) {
            iterator = ((HashSet)((Object)iterator)).iterator();
            while (iterator.hasNext()) {
                PathMapNode pathMapNode = (PathMapNode)iterator.next();
                pathMapNode.setReturnable(true);
            }
        }
    }

    public PathMapRoot makeNewRoot(Expression expression) {
        for (PathMapRoot pathMapRoot : this.a) {
            if (!expression.isEqual(pathMapRoot.getRootExpression())) continue;
            return pathMapRoot;
        }
        PathMapRoot pathMapRoot = new PathMapRoot(expression, 0);
        this.a.add(pathMapRoot);
        return pathMapRoot;
    }

    public PathMapRoot[] getPathMapRoots() {
        return this.a.toArray(new PathMapRoot[this.a.size()]);
    }

    public void registerPathForVariable(Binding binding, PathMapNodeSet pathMapNodeSet) {
        this.b.put(binding, pathMapNodeSet);
    }

    public PathMapNodeSet getPathForVariable(Binding binding) {
        return this.b.get(binding);
    }

    public PathMapRoot getContextDocumentRoot() {
        PathMapRoot[] pathMapRootArray = this.getPathMapRoots();
        PathMapRoot pathMapRoot = null;
        for (PathMapRoot pathMapRoot2 : pathMapRootArray) {
            if (!((pathMapRoot2 = this.reduceToDownwardsAxes(pathMapRoot2)).getRootExpression() instanceof RootExpression)) continue;
            if (pathMapRoot != null) {
                throw new IllegalStateException("More than one context document root found in path map");
            }
            pathMapRoot = pathMapRoot2;
        }
        return pathMapRoot;
    }

    public PathMapRoot getContextItemRoot() {
        PathMapRoot[] pathMapRootArray = this.getPathMapRoots();
        PathMapRoot pathMapRoot = null;
        for (PathMapRoot pathMapRoot2 : pathMapRootArray) {
            if (!(pathMapRoot2.getRootExpression() instanceof ContextItemExpression)) continue;
            if (pathMapRoot != null) {
                throw new IllegalStateException("More than one context document root found in path map");
            }
            pathMapRoot = pathMapRoot2;
        }
        return pathMapRoot;
    }

    public PathMapRoot getRootForDocument(String string) {
        PathMapRoot[] pathMapRootArray = this.getPathMapRoots();
        PathMapRoot pathMapRoot = null;
        for (PathMapRoot pathMapRoot2 : pathMapRootArray) {
            String string2;
            Object object = (pathMapRoot2 = this.reduceToDownwardsAxes(pathMapRoot2)).getRootExpression();
            if (((Expression)object).isCallOn(Doc.class)) {
                string2 = ((Expression)object).getStaticBaseURIString();
            } else {
                if (!((Expression)object).isCallOn(DocumentFn.class)) continue;
                string2 = ((Expression)object).getStaticBaseURIString();
            }
            object = ((SystemFunctionCall)object).getArg(0);
            Object object2 = null;
            if (object instanceof Literal) {
                try {
                    object = ((Literal)object).getValue().getStringValue();
                    object2 = string2 == null ? (new URI((String)object).isAbsolute() ? object : null) : ResolveURI.makeAbsolute((String)object, string2).toString();
                }
                catch (URISyntaxException uRISyntaxException) {
                    object2 = null;
                }
                catch (XPathException xPathException) {
                    object2 = null;
                }
            }
            if (!string.equals(object2)) continue;
            if (pathMapRoot != null) {
                throw new IllegalStateException("More than one document root found in path map for " + string);
            }
            pathMapRoot = pathMapRoot2;
        }
        return pathMapRoot;
    }

    public PathMapRoot reduceToDownwardsAxes(PathMapRoot pathMapRoot) {
        if (pathMapRoot.c) {
            return pathMapRoot;
        }
        PathMapRoot pathMapRoot2 = pathMapRoot;
        if (pathMapRoot.getRootExpression() instanceof ContextItemExpression) {
            int n2;
            RootExpression rootExpression = new RootExpression();
            pathMapRoot2 = this.makeNewRoot(rootExpression);
            block3: for (n2 = pathMapRoot.a.size() - 1; n2 >= 0; --n2) {
                PathMapArc pathMapArc = pathMapRoot.a.get(n2);
                byte by = pathMapArc.getAxis();
                switch (by) {
                    case 2: 
                    case 8: {
                        PathMapNode pathMapNode = new PathMapNode(0);
                        pathMapNode.a.add(pathMapArc);
                        pathMapRoot2.createArc((byte)4, NodeKindTest.ELEMENT, pathMapNode);
                        continue block3;
                    }
                    default: {
                        pathMapRoot2.createArc((byte)5, pathMapArc.getNodeTest(), pathMapArc.getTarget());
                    }
                }
            }
            for (n2 = 0; n2 < this.a.size(); ++n2) {
                if (this.a.get(n2) != pathMapRoot) continue;
                this.a.remove(n2);
                break;
            }
        }
        Stack<PathMapNode> stack = new Stack<PathMapNode>();
        stack.push(pathMapRoot2);
        this.a(pathMapRoot2, stack);
        PathMapRoot.a(pathMapRoot2, true);
        return pathMapRoot2;
    }

    private void a(PathMapRoot pathMapRoot, Stack<PathMapNode> stack) {
        int n2;
        PathMapNode pathMapNode = stack.peek();
        if (pathMapNode.hasUnknownDependencies()) {
            pathMapRoot.setHasUnknownDependencies();
        }
        for (n2 = 0; n2 < pathMapNode.a.size(); ++n2) {
            stack.push(pathMapNode.a.get(n2).getTarget());
            this.a(pathMapRoot, stack);
            stack.pop();
        }
        block9: for (n2 = pathMapNode.a.size() - 1; n2 >= 0; --n2) {
            PathMapNode pathMapNode2;
            PathMapArc pathMapArc = pathMapNode.a.get(n2);
            if (stack.size() < 2) {
                pathMapNode2 = null;
            } else {
                Stack<PathMapNode> stack2 = stack;
                pathMapNode2 = (PathMapNode)stack2.get(stack2.size() - 2);
            }
            PathMapNode pathMapNode3 = pathMapNode2;
            byte by = -1;
            if (pathMapNode3 != null) {
                for (PathMapArc pathMapArc2 : pathMapNode3.a) {
                    PathMapArc pathMapArc3 = pathMapArc2;
                    pathMapArc3 = pathMapArc2;
                    if (pathMapArc2.getTarget() != pathMapNode) continue;
                    by = pathMapArc3.getAxis();
                }
            }
            switch (pathMapArc.getAxis()) {
                case 1: 
                case 5: {
                    if (pathMapArc.getNodeTest() == NodeKindTest.DOCUMENT) {
                        pathMapNode.a.remove(n2);
                        for (PathMapArc pathMapArc3 : pathMapArc.getTarget().a) {
                            pathMapRoot.a.add(pathMapArc3);
                        }
                        continue block9;
                    }
                }
                case 0: 
                case 6: 
                case 10: {
                    if (pathMapArc.getAxis() == 5) continue block9;
                    pathMapRoot.createArc((byte)5, pathMapArc.getNodeTest(), pathMapArc.getTarget());
                    pathMapNode.a.remove(n2);
                    continue block9;
                }
                case 2: 
                case 3: 
                case 4: 
                case 8: {
                    continue block9;
                }
                case 7: 
                case 11: {
                    if (pathMapNode3 != null) {
                        pathMapNode3.createArc(by, pathMapArc.getNodeTest(), pathMapArc.getTarget());
                        pathMapNode.a.remove(n2);
                        continue block9;
                    }
                    pathMapRoot.createArc((byte)3, pathMapArc.getNodeTest(), pathMapArc.getTarget());
                    pathMapNode.a.remove(n2);
                    continue block9;
                }
                case 9: {
                    if (by == 3 || by == 2 || by == 8) {
                        if (pathMapNode.isReturnable()) {
                            pathMapNode3.setReturnable(true);
                        }
                        Iterator<PathMapArc> iterator = pathMapArc.getTarget();
                        for (int i2 = 0; i2 < ((PathMapNode)((Object)iterator)).a.size(); ++i2) {
                            pathMapNode3.a.add(((PathMapNode)((Object)iterator)).a.get(i2));
                        }
                        pathMapNode.a.remove(n2);
                        continue block9;
                    }
                    if (by == 4) {
                        if (pathMapArc.getTarget().a.isEmpty()) {
                            pathMapNode3.createArc((byte)5, pathMapArc.getNodeTest());
                        } else {
                            pathMapNode3.createArc((byte)5, pathMapArc.getNodeTest(), pathMapArc.getTarget());
                        }
                        pathMapNode.a.remove(n2);
                        continue block9;
                    }
                    if (pathMapArc.getTarget().a.isEmpty()) {
                        pathMapRoot.createArc((byte)5, pathMapArc.getNodeTest());
                    } else {
                        pathMapRoot.createArc((byte)5, pathMapArc.getNodeTest(), pathMapArc.getTarget());
                    }
                    pathMapNode.a.remove(n2);
                    continue block9;
                }
                case 12: {
                    pathMapNode.a.remove(n2);
                }
            }
        }
    }

    public void diagnosticDump(Logger logger) {
        for (int i2 = 0; i2 < this.a.size(); ++i2) {
            logger.info("\nROOT EXPRESSION " + i2);
            PathMapRoot pathMapRoot = this.a.get(i2);
            if (pathMapRoot.hasUnknownDependencies()) {
                logger.info("  -- has unknown dependencies --");
            }
            Expression expression = pathMapRoot.b;
            expression.explain(logger);
            logger.info("\nTREE FOR EXPRESSION " + i2);
            this.a(logger, pathMapRoot, 2);
        }
    }

    private void a(Logger logger, PathMapNode iterator, int n2) {
        String string = "                                           ".substring(0, n2);
        iterator = ((PathMapNode)((Object)iterator)).a;
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            PathMapArc pathMapArc = iterator.next();
            logger.info(string + AxisInfo.axisName[pathMapArc.b] + "::" + pathMapArc.c.toString() + (pathMapArc.a.isAtomized() ? " @" : "") + (pathMapArc.a.isReturnable() ? " #" : "") + (pathMapArc.a.hasUnknownDependencies() ? " ...??" : ""));
            this.a(logger, pathMapArc.a, n2 + 2);
        }
    }

    public static class PathMapNodeSet
    extends HashSet<PathMapNode> {
        public PathMapNodeSet() {
        }

        public PathMapNodeSet(PathMapNode pathMapNode) {
            this.add(pathMapNode);
        }

        public PathMapNodeSet createArc(byte by, NodeTest nodeTest) {
            PathMapNodeSet pathMapNodeSet = new PathMapNodeSet();
            for (PathMapNode pathMapNode : this) {
                pathMapNodeSet.add(pathMapNode.createArc(by, nodeTest));
            }
            return pathMapNodeSet;
        }

        public void addNodeSet(PathMapNodeSet object) {
            if (object != null) {
                object = ((HashSet)object).iterator();
                while (object.hasNext()) {
                    PathMapNode pathMapNode = (PathMapNode)object.next();
                    this.add(pathMapNode);
                }
            }
        }

        public void setAtomized() {
            for (PathMapNode pathMapNode : this) {
                pathMapNode.setAtomized();
            }
        }

        public void setReturnable(boolean bl2) {
            for (PathMapNode pathMapNode : this) {
                pathMapNode.setReturnable(bl2);
            }
        }

        public boolean hasReachableReturnables() {
            for (PathMapNode pathMapNode : this) {
                if (!pathMapNode.hasReachableReturnables()) continue;
                return true;
            }
            return false;
        }

        public boolean allPathsAreWithinStreamableSnapshot() {
            for (PathMapNode pathMapNode : this) {
                if (pathMapNode.allPathsAreWithinStreamableSnapshot()) continue;
                return false;
            }
            return true;
        }

        public void addDescendants() {
            for (PathMapNode pathMapNode : this) {
                pathMapNode.createArc((byte)4, AnyNodeTest.getInstance());
            }
        }

        public void setHasUnknownDependencies() {
            for (PathMapNode pathMapNode : this) {
                pathMapNode.setHasUnknownDependencies();
            }
        }
    }

    public static class PathMapArc {
        private PathMapNode a;
        private byte b;
        private NodeTest c;

        private PathMapArc(byte by, NodeTest nodeTest, PathMapNode pathMapNode) {
            this.b = by;
            this.c = nodeTest;
            this.a = pathMapNode;
        }

        public byte getAxis() {
            return this.b;
        }

        public NodeTest getNodeTest() {
            return this.c;
        }

        public PathMapNode getTarget() {
            return this.a;
        }

        /* synthetic */ PathMapArc(byte by, NodeTest nodeTest, PathMapNode pathMapNode, byte by2) {
            this(by, nodeTest, pathMapNode);
        }
    }

    public static class PathMapRoot
    extends PathMapNode {
        private Expression b;
        private boolean c;

        private PathMapRoot(Expression expression) {
            super((byte)0);
            this.b = expression;
        }

        public Expression getRootExpression() {
            return this.b;
        }

        /* synthetic */ PathMapRoot(Expression expression, byte by) {
            this(expression);
        }

        static /* synthetic */ boolean a(PathMapRoot pathMapRoot, boolean bl2) {
            pathMapRoot.c = true;
            return true;
        }
    }

    public static class PathMapNode {
        List<PathMapArc> a = new ArrayList<PathMapArc>();
        private boolean b;
        private boolean c;
        private boolean d;

        private PathMapNode() {
        }

        public PathMapNode createArc(byte by, NodeTest nodeTest) {
            PathMapArc pathMapArc2;
            for (PathMapArc pathMapArc2 : this.a) {
                if (pathMapArc2.getAxis() != by || !pathMapArc2.getNodeTest().equals(nodeTest)) continue;
                return pathMapArc2.getTarget();
            }
            PathMapNode pathMapNode = new PathMapNode();
            pathMapArc2 = new PathMapArc(by, nodeTest, pathMapNode, 0);
            this.a.add(pathMapArc2);
            return pathMapNode;
        }

        public void createArc(byte by, NodeTest nodeTest, PathMapNode pathMapNode) {
            for (PathMapArc pathMapArc : this.a) {
                if (pathMapArc.getAxis() != by || !pathMapArc.getNodeTest().equals(nodeTest) || pathMapArc.getTarget() != pathMapNode) continue;
                pathMapArc.getTarget().setReturnable(pathMapArc.getTarget().isReturnable() || pathMapNode.isReturnable());
                if (pathMapNode.isAtomized()) {
                    pathMapArc.getTarget().setAtomized();
                }
                return;
            }
            PathMapArc pathMapArc = new PathMapArc(by, nodeTest, pathMapNode, 0);
            this.a.add(pathMapArc);
        }

        public PathMapArc[] getArcs() {
            return this.a.toArray(new PathMapArc[this.a.size()]);
        }

        public void setReturnable(boolean bl2) {
            this.b = bl2;
        }

        public boolean isReturnable() {
            return this.b;
        }

        public boolean hasReachableReturnables() {
            if (this.isReturnable()) {
                return true;
            }
            for (PathMapArc pathMapArc : this.a) {
                if (!pathMapArc.getTarget().hasReachableReturnables()) continue;
                return true;
            }
            return false;
        }

        public void setAtomized() {
            this.c = true;
        }

        public boolean isAtomized() {
            return this.c;
        }

        public void setHasUnknownDependencies() {
            this.d = true;
        }

        public boolean hasUnknownDependencies() {
            return this.d;
        }

        public boolean allPathsAreWithinStreamableSnapshot() {
            if (this.hasUnknownDependencies() || this.isReturnable() || this.isAtomized()) {
                return false;
            }
            for (PathMapArc pathMapArc : this.a) {
                byte by = pathMapArc.getAxis();
                if (by == 2) {
                    PathMapNode pathMapNode = pathMapArc.getTarget();
                    if (pathMapNode.isReturnable()) {
                        return false;
                    }
                    if (pathMapNode.getArcs().length == 0 || pathMapNode.allPathsAreWithinStreamableSnapshot()) continue;
                    return false;
                }
                if (by == 12 || by == 0 || by == 1 || by == 9) {
                    PathMapNode pathMapNode = pathMapArc.getTarget();
                    if (pathMapNode.isAtomized()) {
                        return false;
                    }
                    if (pathMapNode.allPathsAreWithinStreamableSnapshot()) continue;
                    return false;
                }
                return false;
            }
            return true;
        }

        /* synthetic */ PathMapNode(byte by) {
            this();
        }
    }
}

