/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.parser;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.sf.saxon.Configuration;
import net.sf.saxon.Version;
import net.sf.saxon.expr.PackageData;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.trans.DecimalFormatManager;
import net.sf.saxon.trans.XPathException;

public class RetainedStaticContext
implements NamespaceResolver {
    private Configuration a;
    private PackageData b;
    private URI c;
    private String d;
    private String e;
    private Map<String, String> f;
    private String g = "http://www.w3.org/2005/xpath-functions";
    private String h;
    private DecimalFormatManager i;
    private boolean j;

    public RetainedStaticContext(Configuration configuration) {
        this.a = configuration;
        this.b = new PackageData(configuration);
        this.f = new HashMap<String, String>();
        this.e = "http://www.w3.org/2005/xpath-functions/collation/codepoint";
    }

    public RetainedStaticContext(StaticContext object) {
        this.a = object.getConfiguration();
        this.b = object.getPackageData();
        if (object.getStaticBaseURI() != null) {
            this.d = object.getStaticBaseURI();
            try {
                this.c = ExpressionTool.getBaseURI((StaticContext)object, null, true);
            }
            catch (XPathException xPathException) {
                this.c = null;
            }
        }
        this.e = object.getDefaultCollationName();
        this.i = object.getDecimalFormatManager();
        this.h = object.getDefaultElementNamespace();
        this.g = object.getDefaultFunctionNamespace();
        this.j = object.isInBackwardsCompatibleMode();
        if (!Version.platform.JAXPStaticContextCheck(this, (StaticContext)object)) {
            this.f = new HashMap<String, String>(4);
            object = object.getNamespaceResolver();
            Iterator<String> iterator = object.iteratePrefixes();
            while (iterator.hasNext()) {
                String string = iterator.next();
                if (string.equals("xml")) continue;
                this.f.put(string, object.getURIForPrefix(string, true));
            }
        }
    }

    public Configuration getConfiguration() {
        return this.a;
    }

    public void setPackageData(PackageData packageData) {
        this.b = packageData;
    }

    public PackageData getPackageData() {
        return this.b;
    }

    public void setStaticBaseUriString(String string) {
        if (string != null) {
            this.d = string;
            try {
                this.c = new URI(string);
                return;
            }
            catch (URISyntaxException uRISyntaxException) {
                this.c = null;
            }
        }
    }

    public URI getStaticBaseUri() {
        if (this.c == null) {
            if (this.d == null) {
                return null;
            }
            throw new XPathException("Supplied static base URI " + this.d + " is not a valid URI");
        }
        return this.c;
    }

    public String getStaticBaseUriString() {
        return this.d;
    }

    public String getDefaultCollationName() {
        return this.e;
    }

    public void setDefaultCollationName(String string) {
        this.e = string;
    }

    public String getDefaultFunctionNamespace() {
        return this.g;
    }

    public void setDefaultFunctionNamespace(String string) {
        this.g = string;
    }

    public String getDefaultElementNamespace() {
        if (this.h == null) {
            return "";
        }
        return this.h;
    }

    public void setDefaultElementNamespace(String string) {
        this.h = string;
    }

    public DecimalFormatManager getDecimalFormatManager() {
        return this.i;
    }

    public void setDecimalFormatManager(DecimalFormatManager decimalFormatManager) {
        this.i = decimalFormatManager;
    }

    public boolean isBackwardsCompatibility() {
        return this.j;
    }

    public void setBackwardsCompatibility(boolean bl2) {
        this.j = bl2;
    }

    public void declareNamespace(String string, String string2) {
        this.f.put(string, string2);
    }

    @Override
    public String getURIForPrefix(String string, boolean bl2) {
        if (string.isEmpty()) {
            if (bl2) {
                if ((string = this.f.get(string)) == null) {
                    return "";
                }
                return string;
            }
            return "";
        }
        if (string.equals("xml")) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        return this.f.get(string);
    }

    @Override
    public Iterator<String> iteratePrefixes() {
        return this.f.keySet().iterator();
    }

    public boolean declaresSameNamespaces(RetainedStaticContext retainedStaticContext) {
        return this.f.equals(retainedStaticContext.f);
    }

    public int hashCode() {
        int n2 = -2074620978;
        if (this.d != null) {
            n2 = 0x8457CBCE ^ this.d.hashCode();
        }
        n2 ^= this.e.hashCode();
        n2 ^= this.g.hashCode();
        return n2 ^= this.f.hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof RetainedStaticContext)) {
            return false;
        }
        object = (RetainedStaticContext)object;
        return ExpressionTool.equalOrNull(this.d, ((RetainedStaticContext)object).d) && this.e.equals(((RetainedStaticContext)object).e) && this.g.equals(((RetainedStaticContext)object).g) && this.f.equals(((RetainedStaticContext)object).f);
    }

    public void setNamespaces(Map<String, String> map) {
        this.f = map;
    }
}

