/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.parser;

import java.util.Optional;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.om.AxisInfo;
import net.sf.saxon.om.Item;
import net.sf.saxon.trans.Err;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.UType;
import net.sf.saxon.value.SequenceType;

public class RoleDiagnostic {
    private int a;
    private String b;
    private int c;
    private String d = "XPTY0004";
    public static final int FUNCTION = 0;
    public static final int BINARY_EXPR = 1;
    public static final int TYPE_OP = 2;
    public static final int VARIABLE = 3;
    public static final int INSTRUCTION = 4;
    public static final int FUNCTION_RESULT = 5;
    public static final int ORDER_BY = 6;
    public static final int TEMPLATE_RESULT = 7;
    public static final int PARAM = 8;
    public static final int UNARY_EXPR = 9;
    public static final int UPDATING_EXPR = 10;
    public static final int EVALUATE_RESULT = 12;
    public static final int CONTEXT_ITEM = 13;
    public static final int AXIS_STEP = 14;
    public static final int OPTION = 15;
    public static final int CHARACTER_MAP_EXPANSION = 16;
    public static final int MATCH_PATTERN = 19;
    public static final int MISC = 20;

    public RoleDiagnostic(int n2, String string, int n3) {
        this.a = n2;
        this.b = string;
        this.c = n3;
    }

    public void setErrorCode(String string) {
        if (string != null) {
            this.d = string;
        }
    }

    public String getErrorCode() {
        return this.d;
    }

    public boolean isTypeError() {
        return !this.d.startsWith("FORG") && !this.d.equals("XPDY0050");
    }

    public String getMessage() {
        String string = this.b;
        switch (this.a) {
            case 0: {
                if (string.equals("saxon:call") || string.equals("saxon:apply")) {
                    if (this.c == 0) {
                        return "target of the dynamic function call";
                    }
                    return RoleDiagnostic.ordinal(this.c) + " argument of the dynamic function call";
                }
                return RoleDiagnostic.ordinal(this.c + 1) + " argument of " + (string.isEmpty() ? "the anonymous function" : string + "()");
            }
            case 1: {
                return RoleDiagnostic.ordinal(this.c + 1) + " operand of '" + string + '\'';
            }
            case 9: {
                return "operand of '-'";
            }
            case 2: {
                return "value in '" + string + "' expression";
            }
            case 3: {
                if (string.equals("saxon:context-item")) {
                    return "context item";
                }
                return "value of variable $" + string;
            }
            case 4: {
                int n2 = string.indexOf(47);
                String string2 = "";
                if (n2 >= 0) {
                    string2 = string.substring(n2 + 1);
                    string = string.substring(0, n2);
                }
                return "@" + string2 + " attribute of " + (string.equals("LRE") ? "a literal result element" : string);
            }
            case 5: {
                if (string.isEmpty()) {
                    return "result of the anonymous function";
                }
                return "result of a call to " + string;
            }
            case 7: {
                return "result of template " + string;
            }
            case 6: {
                return RoleDiagnostic.ordinal(this.c + 1) + " sort key";
            }
            case 8: {
                return "value of parameter $" + string;
            }
            case 10: {
                return "value of the " + RoleDiagnostic.ordinal(this.c + 1) + " operand of " + string + " expression";
            }
            case 12: {
                return "result of the expression {" + string + "} evaluated by xsl:evaluate";
            }
            case 13: {
                return "context item";
            }
            case 14: {
                return "context item for the " + AxisInfo.axisName[this.c] + " axis";
            }
            case 15: {
                return "value of the " + string + " option";
            }
            case 16: {
                return "substitute value for character '" + string + "' in the character map";
            }
            case 19: {
                return "match pattern";
            }
            case 20: {
                return this.b;
            }
        }
        return "";
    }

    public String composeRequiredMessage(ItemType itemType) {
        return "The required item type of the " + this.getMessage() + " is " + itemType;
    }

    public String composeErrorMessage(ItemType itemType, ItemType itemType2) {
        return this.composeRequiredMessage(itemType) + "; supplied value has item type " + itemType2;
    }

    public String composeErrorMessage(ItemType object, Expression expression, TypeHierarchy typeHierarchy) {
        if (expression instanceof Literal) {
            String string = this.composeRequiredMessage((ItemType)object);
            if (((Optional)(object = SequenceType.makeSequenceType((ItemType)object, 57344).explainMismatch(((Literal)expression).getValue(), typeHierarchy))).isPresent()) {
                string = string + ". " + (String)((Optional)object).get();
            }
            return string;
        }
        return this.composeRequiredMessage((ItemType)object) + "; supplied expression (" + expression.toShortString() + ") has item type " + expression.getItemType();
    }

    public String composeErrorMessage(ItemType object, Item item, TypeHierarchy typeHierarchy) {
        FastStringBuffer fastStringBuffer = new FastStringBuffer(256);
        fastStringBuffer.append(this.composeRequiredMessage((ItemType)object));
        fastStringBuffer.append("; the supplied value ");
        fastStringBuffer.append(Err.depict(item));
        if (object.getGenre() != item.getGenre()) {
            fastStringBuffer.append(" is ");
            fastStringBuffer.append(item.getGenre().getDescription());
        } else {
            fastStringBuffer.append(" does not match. ");
            if (typeHierarchy != null) {
                object = object.explainMismatch(item, typeHierarchy);
                ((Optional)object).ifPresent(fastStringBuffer::append);
            }
        }
        return fastStringBuffer.toString();
    }

    public String composeErrorMessage(ItemType itemType, UType uType) {
        return this.composeRequiredMessage(itemType) + "; supplied value has item type " + uType;
    }

    public String save() {
        FastStringBuffer fastStringBuffer = new FastStringBuffer(256);
        fastStringBuffer.append(this.a + "|");
        fastStringBuffer.append(this.c + "|");
        fastStringBuffer.append(this.d.equals("XPTY0004") ? "" : this.d);
        fastStringBuffer.append("|");
        fastStringBuffer.append(this.b);
        return fastStringBuffer.toString();
    }

    public static RoleDiagnostic reconstruct(String object) {
        int n2 = ((String)object).indexOf(124);
        int n3 = Integer.parseInt(((String)object).substring(0, n2));
        int n4 = ((String)object).indexOf(124, n2 + 1);
        n2 = Integer.parseInt(((String)object).substring(n2 + 1, n4));
        int n5 = ((String)object).indexOf(124, n4 + 1);
        String string = ((String)object).substring(n4 + 1, n5);
        object = ((String)object).substring(n5 + 1);
        object = new RoleDiagnostic(n3, (String)object, n2);
        if (!string.isEmpty()) {
            ((RoleDiagnostic)object).setErrorCode(string);
        }
        return object;
    }

    public static String ordinal(int n2) {
        switch (n2) {
            case 1: {
                return "first";
            }
            case 2: {
                return "second";
            }
            case 3: {
                return "third";
            }
        }
        if (n2 >= 21) {
            switch (n2 % 10) {
                case 1: {
                    return n2 + "st";
                }
                case 2: {
                    return n2 + "nd";
                }
                case 3: {
                    return n2 + "rd";
                }
            }
        }
        return n2 + "th";
    }
}

