/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.parser;

import net.sf.saxon.Configuration;
import net.sf.saxon.expr.ArithmeticExpression;
import net.sf.saxon.expr.AtomicSequenceConverter;
import net.sf.saxon.expr.Atomizer;
import net.sf.saxon.expr.CardinalityChecker;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.FunctionCall;
import net.sf.saxon.expr.GeneralComparison20;
import net.sf.saxon.expr.ItemChecker;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.UntypedSequenceConverter;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.lib.ConversionRules;
import net.sf.saxon.ma.map.MapType;
import net.sf.saxon.ma.map.TupleType;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.Converter;
import net.sf.saxon.type.ErrorType;
import net.sf.saxon.type.FunctionItemType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.JavaExternalObjectType;
import net.sf.saxon.type.NumericType;
import net.sf.saxon.type.PlainType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.UType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.SequenceType;

public class TypeChecker {
    public Expression staticTypeCheck(Expression expression, SequenceType object, RoleDiagnostic roleDiagnostic, ExpressionVisitor expressionVisitor) {
        int n2;
        if (expression.implementsStaticTypeCheck()) {
            return expression.staticTypeCheck((SequenceType)object, false, roleDiagnostic, expressionVisitor);
        }
        Object object2 = expression;
        Object object3 = expressionVisitor.getStaticContext();
        Object object4 = object3.getConfiguration();
        TypeHierarchy typeHierarchy = ((Configuration)object4).getTypeHierarchy();
        ContextItemStaticInfo contextItemStaticInfo = ((Configuration)object4).getDefaultContextItemStaticInfo();
        ItemType itemType = ((SequenceType)object).getPrimaryType();
        int n3 = ((SequenceType)object).getCardinality();
        Cardinality.allowsMany(n3);
        ItemType itemType2 = null;
        int n4 = -1;
        boolean bl2 = n3 == 57344;
        if (!bl2) {
            n4 = ((Expression)object2).getCardinality();
            bl2 = Cardinality.subsumes(n3, n4);
        }
        boolean bl3 = itemType instanceof AnyItemType;
        if (n3 == 8192) {
            bl3 = true;
        }
        if (!bl3) {
            itemType2 = ((Expression)object2).getItemType();
            if (itemType == null || itemType2 == null) {
                throw new NullPointerException();
            }
            n2 = typeHierarchy.relationship(itemType, itemType2);
            boolean bl4 = bl3 = n2 == 0 || n2 == 1;
        }
        if (!bl3) {
            if (itemType.isPlainType()) {
                if (!itemType2.isPlainType() && n4 != 8192) {
                    if (!itemType2.isAtomizable(typeHierarchy)) {
                        String string = itemType2 instanceof TupleType ? "a tuple type" : (itemType2 instanceof MapType ? "a map type" : (itemType2 instanceof FunctionItemType ? "a function type" : (itemType2 instanceof NodeTest ? "an element type with element-only content" : itemType2.toString())));
                        object3 = new XPathException("An atomic value is required for the " + roleDiagnostic.getMessage() + ", but the supplied type is " + string + ", which cannot be atomized", "FOTY0013", expression.getLocation());
                        ((XPathException)object3).setIsTypeError(true);
                        ((XPathException)object3).setFailingExpression(expression);
                        throw object3;
                    }
                    if (((Expression)object2).getRetainedStaticContext() == null) {
                        ((Expression)object2).setRetainedStaticContextLocally(object3.makeRetainedStaticContext());
                    }
                    Expression expression2 = Atomizer.makeAtomizer((Expression)object2, roleDiagnostic);
                    ExpressionTool.copyLocationInfo((Expression)object2, expression2);
                    object2 = expression2;
                    expression2 = ((Expression)object2).simplify();
                    ExpressionTool.copyLocationInfo((Expression)object2, expression2);
                    object2 = expression2;
                    itemType2 = ((Expression)object2).getItemType();
                    n4 = ((Expression)object2).getCardinality();
                    bl2 = Cardinality.subsumes(n3, n4);
                }
                if (itemType2.equals(BuiltInAtomicType.UNTYPED_ATOMIC) && !itemType.equals(BuiltInAtomicType.UNTYPED_ATOMIC) && !itemType.equals(BuiltInAtomicType.ANY_ATOMIC)) {
                    if (((SimpleType)((Object)itemType)).isNamespaceSensitive()) {
                        XPathException xPathException = new XPathException("An untyped atomic value cannot be converted to a QName or NOTATION as required for the " + roleDiagnostic.getMessage(), "XPTY0117", expression.getLocation());
                        xPathException.setIsTypeError(true);
                        throw xPathException;
                    }
                    UntypedSequenceConverter untypedSequenceConverter = UntypedSequenceConverter.makeUntypedSequenceConverter((Configuration)object4, (Expression)object2, (PlainType)itemType);
                    untypedSequenceConverter.setRoleDiagnostic(roleDiagnostic);
                    ExpressionTool.copyLocationInfo((Expression)object2, untypedSequenceConverter);
                    try {
                        if (object2 instanceof Literal) {
                            object2 = Literal.makeLiteral(((Expression)untypedSequenceConverter).iterate(expressionVisitor.makeDynamicContext()).materialize(), (Expression)object2);
                            ExpressionTool.copyLocationInfo(untypedSequenceConverter, (Expression)object2);
                        } else {
                            object2 = untypedSequenceConverter;
                        }
                    }
                    catch (XPathException xPathException) {
                        object3 = xPathException;
                        xPathException.maybeSetLocation(((Expression)object2).getLocation());
                        ((XPathException)object3).setFailingExpression(expression);
                        ((XPathException)object3).setErrorCode(roleDiagnostic.getErrorCode());
                        ((XPathException)object3).setIsStaticError(true);
                        throw object3;
                    }
                    bl3 = true;
                    itemType2 = itemType;
                }
                if (itemType2.equals(BuiltInAtomicType.ANY_ATOMIC) && !itemType.equals(BuiltInAtomicType.UNTYPED_ATOMIC) && !itemType.equals(BuiltInAtomicType.ANY_ATOMIC) && !((Expression)object2).hasSpecialProperty(0x4000000)) {
                    Object object5;
                    if (((SimpleType)((Object)itemType)).isNamespaceSensitive()) {
                        object5 = UntypedSequenceConverter.makeUntypedSequenceRejector((Configuration)object4, (Expression)object2, (PlainType)itemType);
                    } else {
                        object3 = UntypedSequenceConverter.makeUntypedSequenceConverter((Configuration)object4, (Expression)object2, (PlainType)itemType);
                        ((AtomicSequenceConverter)object3).setRoleDiagnostic(roleDiagnostic);
                        object5 = object3;
                    }
                    ExpressionTool.copyLocationInfo((Expression)object2, (Expression)object5);
                    try {
                        if (object2 instanceof Literal) {
                            object2 = Literal.makeLiteral(((Expression)object5).iterate(expressionVisitor.makeDynamicContext()).materialize(), (Expression)object2);
                            ExpressionTool.copyLocationInfo(expression, (Expression)object2);
                        } else {
                            object2 = object5;
                        }
                        itemType2 = ((Expression)object2).getItemType();
                    }
                    catch (XPathException xPathException) {
                        object3 = xPathException;
                        xPathException.maybeSetLocation(((Expression)object2).getLocation());
                        ((XPathException)object3).setIsStaticError(true);
                        throw object3;
                    }
                }
                if (itemType instanceof AtomicType) {
                    n2 = ((AtomicType)itemType).getFingerprint();
                    if (n2 == 517 && typeHierarchy.relationship(itemType2, NumericType.getInstance()) != 4) {
                        object3 = object2;
                        if ((object3 = TypeChecker.a((Expression)object3, new Converter.PromoterToDouble(), BuiltInAtomicType.DOUBLE)) instanceof AtomicSequenceConverter) {
                            ((AtomicSequenceConverter)object3).setRoleDiagnostic(roleDiagnostic);
                        }
                        ExpressionTool.copyLocationInfo((Expression)object2, (Expression)object3);
                        object2 = object3;
                        try {
                            object2 = ((Expression)object2).simplify().typeCheck(expressionVisitor, contextItemStaticInfo);
                        }
                        catch (XPathException xPathException) {
                            object = xPathException;
                            xPathException.maybeSetLocation(((Expression)object2).getLocation());
                            ((XPathException)object).setIsStaticError(true);
                            throw object;
                        }
                        itemType2 = BuiltInAtomicType.DOUBLE;
                        n4 = -1;
                    } else if (n2 == 516 && typeHierarchy.relationship(itemType2, NumericType.getInstance()) != 4 && !typeHierarchy.isSubType(itemType2, BuiltInAtomicType.DOUBLE)) {
                        object3 = object2;
                        if ((object3 = TypeChecker.a((Expression)object3, new Converter.PromoterToFloat(), BuiltInAtomicType.FLOAT)) instanceof AtomicSequenceConverter) {
                            ((AtomicSequenceConverter)object3).setRoleDiagnostic(roleDiagnostic);
                        }
                        ExpressionTool.copyLocationInfo((Expression)object2, (Expression)object3);
                        object2 = object3;
                        try {
                            object2 = ((Expression)object2).simplify().typeCheck(expressionVisitor, contextItemStaticInfo);
                        }
                        catch (XPathException xPathException) {
                            object = xPathException;
                            xPathException.maybeSetLocation(((Expression)object2).getLocation());
                            ((XPathException)object).setFailingExpression(expression);
                            ((XPathException)object).setIsStaticError(true);
                            throw object;
                        }
                        itemType2 = BuiltInAtomicType.FLOAT;
                        n4 = -1;
                    }
                    if (n2 == 513 && typeHierarchy.isSubType(itemType2, BuiltInAtomicType.ANY_URI)) {
                        bl3 = true;
                        object3 = object2;
                        if ((object3 = TypeChecker.a((Expression)object3, new Converter.ToStringConverter(), BuiltInAtomicType.STRING)) instanceof AtomicSequenceConverter) {
                            ((AtomicSequenceConverter)object3).setRoleDiagnostic(roleDiagnostic);
                        }
                        ExpressionTool.copyLocationInfo((Expression)object2, (Expression)object3);
                        object2 = object3;
                        try {
                            object2 = ((Expression)object2).simplify().typeCheck(expressionVisitor, contextItemStaticInfo);
                        }
                        catch (XPathException xPathException) {
                            object = xPathException;
                            xPathException.maybeSetLocation(((Expression)object2).getLocation());
                            ((XPathException)object).setFailingExpression(expression);
                            ((XPathException)object).setIsStaticError(true);
                            throw object;
                        }
                        itemType2 = BuiltInAtomicType.STRING;
                        n4 = -1;
                    }
                }
            } else if (itemType instanceof FunctionItemType && !((FunctionItemType)itemType).isMapType() && !((FunctionItemType)itemType).isArrayType()) {
                n2 = typeHierarchy.relationship(itemType2, typeHierarchy.getGenericFunctionItemType());
                if (n2 != 4) {
                    if (!(itemType2 instanceof FunctionItemType)) {
                        object2 = new ItemChecker((Expression)object2, typeHierarchy.getGenericFunctionItemType(), roleDiagnostic);
                        itemType2 = typeHierarchy.getGenericFunctionItemType();
                    }
                    Expression expression3 = object2;
                    object4 = roleDiagnostic;
                    object2 = (FunctionItemType)itemType;
                    object3 = expression3;
                    object2 = object2.makeFunctionSequenceCoercer((Expression)object3, (RoleDiagnostic)object4);
                    bl3 = true;
                }
            } else if (itemType instanceof JavaExternalObjectType && n3 == 16384) {
                if (Sequence.class.isAssignableFrom(((JavaExternalObjectType)itemType).getJavaClass())) {
                    bl3 = true;
                } else if (expression instanceof FunctionCall && ((FunctionCall)expression).adjustRequiredType((JavaExternalObjectType)itemType)) {
                    bl3 = true;
                    bl2 = true;
                }
            }
        }
        if (bl3 && bl2) {
            return object2;
        }
        if (n4 == -1) {
            n4 = ((Expression)object2).getCardinality();
            if (!bl2) {
                bl2 = Cardinality.subsumes(n3, n4);
            }
        }
        if (bl2 && n4 == 8192) {
            return object2;
        }
        if (n4 == 8192 && (n3 & 0x2000) == 0) {
            XPathException xPathException = new XPathException("An empty sequence is not allowed as the " + roleDiagnostic.getMessage(), roleDiagnostic.getErrorCode(), expression.getLocation());
            xPathException.setIsTypeError(roleDiagnostic.isTypeError());
            xPathException.setFailingExpression(expression);
            throw xPathException;
        }
        int n5 = n2 = bl3 ? 2 : typeHierarchy.relationship(itemType2, itemType);
        if (n3 == 8192) {
            n2 = 0;
        }
        if (n2 == 4) {
            if (Cardinality.allowsZero(n4) && Cardinality.allowsZero(n3)) {
                if (n4 != 8192) {
                    object3 = roleDiagnostic.composeErrorMessage(itemType, expression, typeHierarchy);
                    object3 = (String)object3 + ". The expression can succeed only if the supplied value is an empty sequence.";
                    expressionVisitor.issueWarning((String)object3, expression.getLocation());
                }
            } else {
                object3 = roleDiagnostic.composeErrorMessage(itemType, expression, typeHierarchy);
                object = new XPathException((String)object3, roleDiagnostic.getErrorCode(), expression.getLocation());
                ((XPathException)object).setIsTypeError(roleDiagnostic.isTypeError());
                ((XPathException)object).setFailingExpression(expression);
                throw object;
            }
        }
        if (n2 != 0 && n2 != 2) {
            if (object2 instanceof Literal) {
                if (((SequenceType)object).matches(((Literal)object2).getValue(), typeHierarchy)) {
                    return object2;
                }
                object3 = roleDiagnostic.composeErrorMessage(itemType, expression, typeHierarchy);
                object = new XPathException((String)object3, roleDiagnostic.getErrorCode(), expression.getLocation());
                ((XPathException)object).setIsTypeError(roleDiagnostic.isTypeError());
                throw object;
            }
            object3 = new ItemChecker((Expression)object2, itemType, roleDiagnostic);
            ExpressionTool.copyLocationInfo((Expression)object2, (Expression)object3);
            object2 = object3;
        }
        if (!bl2) {
            if (object2 instanceof Literal) {
                object3 = new XPathException("Required cardinality of " + roleDiagnostic.getMessage() + " is " + Cardinality.toString(n3) + "; supplied value has cardinality " + Cardinality.toString(n4), roleDiagnostic.getErrorCode(), expression.getLocation());
                ((XPathException)object3).setIsTypeError(roleDiagnostic.isTypeError());
                throw object3;
            }
            object3 = CardinalityChecker.makeCardinalityChecker((Expression)object2, n3, roleDiagnostic);
            ExpressionTool.copyLocationInfo((Expression)object2, (Expression)object3);
            object2 = object3;
        }
        return object2;
    }

    public Expression makeArithmeticExpression(Expression expression, int n2, Expression expression2) {
        return new ArithmeticExpression(expression, n2, expression2);
    }

    public Expression makeGeneralComparison(Expression expression, int n2, Expression expression2) {
        return new GeneralComparison20(expression, n2, expression2);
    }

    public Expression processValueOf(Expression expression, Configuration configuration) {
        return expression;
    }

    public static Expression strictTypeCheck(Expression object, SequenceType sequenceType, RoleDiagnostic roleDiagnostic, StaticContext staticContext) {
        int n2;
        Object object2 = object;
        Object object3 = staticContext.getConfiguration().getTypeHierarchy();
        ItemType itemType = sequenceType.getPrimaryType();
        int n3 = sequenceType.getCardinality();
        ItemType itemType2 = null;
        int n4 = -1;
        boolean bl2 = n3 == 57344;
        if (!bl2) {
            n4 = ((Expression)object2).getCardinality();
            bl2 = Cardinality.subsumes(n3, n4);
        }
        if ((n2 = sequenceType.getPrimaryType() instanceof AnyItemType) == 0) {
            itemType2 = ((Expression)object2).getItemType();
            n2 = ((TypeHierarchy)object3).relationship(itemType, itemType2);
            int n5 = n2 = n2 == 0 || n2 == 1 ? 1 : 0;
        }
        if (n2 != 0 && bl2) {
            return object2;
        }
        if (n4 == -1) {
            n4 = itemType2 instanceof ErrorType ? 8192 : ((Expression)object2).getCardinality();
            if (!bl2) {
                bl2 = Cardinality.subsumes(n3, n4);
            }
        }
        if (bl2 && n4 == 8192) {
            return object2;
        }
        if (itemType2 == null) {
            itemType2 = ((Expression)object2).getItemType();
        }
        if (n4 == 8192 && (n3 & 0x2000) == 0) {
            XPathException xPathException = new XPathException("An empty sequence is not allowed as the " + roleDiagnostic.getMessage(), roleDiagnostic.getErrorCode(), ((Expression)object).getLocation());
            xPathException.setIsTypeError(roleDiagnostic.isTypeError());
            throw xPathException;
        }
        n2 = ((TypeHierarchy)object3).relationship(itemType2, itemType);
        if (n2 == 4) {
            if (Cardinality.allowsZero(n4) && Cardinality.allowsZero(n3)) {
                if (n4 != 8192) {
                    object3 = "Required item type of " + roleDiagnostic.getMessage() + " is " + itemType + "; supplied value (" + ((Expression)object).toShortString() + ") has item type " + itemType2 + ". The expression can succeed only if the supplied value is an empty sequence.";
                    staticContext.issueWarning((String)object3, ((Expression)object).getLocation());
                }
            } else {
                object3 = roleDiagnostic.composeErrorMessage(itemType, (Expression)object, (TypeHierarchy)object3);
                object = new XPathException((String)object3, roleDiagnostic.getErrorCode(), ((Expression)object).getLocation());
                ((XPathException)object).setIsTypeError(roleDiagnostic.isTypeError());
                throw object;
            }
        }
        if (n2 != 0 && n2 != 2) {
            object3 = new ItemChecker((Expression)object2, itemType, roleDiagnostic);
            ((Expression)object3).adoptChildExpression((Expression)object2);
            object2 = object3;
        }
        if (!bl2) {
            if (object2 instanceof Literal) {
                object3 = new XPathException("Required cardinality of " + roleDiagnostic.getMessage() + " is " + Cardinality.toString(n3) + "; supplied value has cardinality " + Cardinality.toString(n4), roleDiagnostic.getErrorCode(), ((Expression)object).getLocation());
                ((XPathException)object3).setIsTypeError(roleDiagnostic.isTypeError());
                throw object3;
            }
            object3 = CardinalityChecker.makeCardinalityChecker((Expression)object2, n3, roleDiagnostic);
            ((Expression)object3).adoptChildExpression((Expression)object2);
            object2 = object3;
        }
        return object2;
    }

    public static XPathException testConformance(Sequence<?> object, SequenceType sequenceType, XPathContext xPathContext) {
        Object obj;
        ItemType itemType = sequenceType.getPrimaryType();
        SequenceIterator<?> sequenceIterator = object.iterate();
        int n2 = 0;
        while ((obj = sequenceIterator.next()) != null) {
            ++n2;
            if (itemType.matches((Item)obj, xPathContext.getConfiguration().getTypeHierarchy())) continue;
            object = new XPathException("Required type is " + itemType + "; supplied value has type " + UType.getUType(object.materialize()));
            ((XPathException)object).setIsTypeError(true);
            ((XPathException)object).setErrorCode("XPTY0004");
            return object;
        }
        int n3 = sequenceType.getCardinality();
        if (n2 == 0 && !Cardinality.allowsZero(n3)) {
            XPathException xPathException = new XPathException("Required type does not allow empty sequence, but supplied value is empty");
            xPathException.setIsTypeError(true);
            xPathException.setErrorCode("XPTY0004");
            return xPathException;
        }
        if (n2 > 1 && !Cardinality.allowsMany(n3)) {
            XPathException xPathException = new XPathException("Required type requires a singleton sequence; supplied value contains " + n2 + " items");
            xPathException.setIsTypeError(true);
            xPathException.setErrorCode("XPTY0004");
            return xPathException;
        }
        if (n2 > 0 && n3 == 8192) {
            XPathException xPathException = new XPathException("Required type requires an empty sequence, but supplied value is non-empty");
            xPathException.setIsTypeError(true);
            xPathException.setErrorCode("XPTY0004");
            return xPathException;
        }
        return null;
    }

    public static XPathException ebvError(Expression object, TypeHierarchy typeHierarchy) {
        if (Cardinality.allowsZero(((Expression)object).getCardinality())) {
            return null;
        }
        if (typeHierarchy.relationship((ItemType)(object = ((Expression)object).getItemType()), Type.NODE_TYPE) == 4 && typeHierarchy.relationship((ItemType)object, BuiltInAtomicType.BOOLEAN) == 4 && typeHierarchy.relationship((ItemType)object, BuiltInAtomicType.STRING) == 4 && typeHierarchy.relationship((ItemType)object, BuiltInAtomicType.ANY_URI) == 4 && typeHierarchy.relationship((ItemType)object, BuiltInAtomicType.UNTYPED_ATOMIC) == 4 && typeHierarchy.relationship((ItemType)object, NumericType.getInstance()) == 4 && !(object instanceof JavaExternalObjectType)) {
            object = new XPathException("Effective boolean value is defined only for sequences containing booleans, strings, numbers, URIs, or nodes");
            ((XPathException)object).setErrorCode("FORG0006");
            ((XPathException)object).setIsTypeError(true);
            return object;
        }
        return null;
    }

    private static Expression a(Expression expression, Converter object, BuiltInAtomicType builtInAtomicType) {
        Object object2 = expression.getConfiguration().getConversionRules();
        ((Converter)object).setConversionRules((ConversionRules)object2);
        if (expression instanceof Literal && ((Literal)expression).getValue() instanceof AtomicValue && (object2 = ((Converter)object).convert((AtomicValue)((Literal)expression).getValue())) instanceof AtomicValue) {
            object = Literal.makeLiteral((AtomicValue)object2, expression);
            ExpressionTool.copyLocationInfo(expression, (Expression)object);
            return object;
        }
        object2 = new AtomicSequenceConverter(expression, builtInAtomicType);
        ((AtomicSequenceConverter)object2).setConverter((Converter)object);
        ExpressionTool.copyLocationInfo(expression, (Expression)object2);
        return object2;
    }
}

