/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.parser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Stack;
import java.util.function.IntPredicate;
import net.sf.saxon.Configuration;
import net.sf.saxon.Version;
import net.sf.saxon.expr.AndExpression;
import net.sf.saxon.expr.Assignation;
import net.sf.saxon.expr.AxisExpression;
import net.sf.saxon.expr.CastExpression;
import net.sf.saxon.expr.CastableExpression;
import net.sf.saxon.expr.ContextItemExpression;
import net.sf.saxon.expr.ErrorExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.FilterExpression;
import net.sf.saxon.expr.ForExpression;
import net.sf.saxon.expr.HomogeneityChecker;
import net.sf.saxon.expr.IdentityComparison;
import net.sf.saxon.expr.InstanceOfExpression;
import net.sf.saxon.expr.LetExpression;
import net.sf.saxon.expr.ListCastableFunction;
import net.sf.saxon.expr.ListConstructorFunction;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.LocalBinding;
import net.sf.saxon.expr.LocalVariableReference;
import net.sf.saxon.expr.LookupAllExpression;
import net.sf.saxon.expr.LookupExpression;
import net.sf.saxon.expr.OrExpression;
import net.sf.saxon.expr.PackageData;
import net.sf.saxon.expr.QuantifiedExpression;
import net.sf.saxon.expr.RangeExpression;
import net.sf.saxon.expr.RootExpression;
import net.sf.saxon.expr.SlashExpression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.StaticFunctionCall;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.SystemFunctionCall;
import net.sf.saxon.expr.TreatExpression;
import net.sf.saxon.expr.UnionCastableFunction;
import net.sf.saxon.expr.UnionConstructorFunction;
import net.sf.saxon.expr.ValueComparison;
import net.sf.saxon.expr.VennExpression;
import net.sf.saxon.expr.flwor.Clause;
import net.sf.saxon.expr.instruct.Block;
import net.sf.saxon.expr.instruct.Choose;
import net.sf.saxon.expr.instruct.ForEach;
import net.sf.saxon.expr.parser.CodeInjector;
import net.sf.saxon.expr.parser.ExplicitLocation;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.expr.parser.ParserExtension;
import net.sf.saxon.expr.parser.RetainedStaticContext;
import net.sf.saxon.expr.parser.Token;
import net.sf.saxon.expr.parser.Tokenizer;
import net.sf.saxon.functions.ApplyFn;
import net.sf.saxon.functions.Concat;
import net.sf.saxon.functions.CurrentGroupCall;
import net.sf.saxon.functions.CurrentGroupingKeyCall;
import net.sf.saxon.functions.CurrentMergeGroup;
import net.sf.saxon.functions.CurrentMergeKey;
import net.sf.saxon.functions.RegexGroup;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.functions.registry.VendorFunctionSetHE;
import net.sf.saxon.lib.Feature;
import net.sf.saxon.lib.NamespaceConstant;
import net.sf.saxon.ma.arrays.ArrayFunctionSet;
import net.sf.saxon.ma.arrays.ArrayItemType;
import net.sf.saxon.ma.arrays.SimpleArrayItem;
import net.sf.saxon.ma.arrays.SquareArrayConstructor;
import net.sf.saxon.ma.map.DictionaryMap;
import net.sf.saxon.ma.map.HashTrieMap;
import net.sf.saxon.ma.map.MapFunctionSet;
import net.sf.saxon.ma.map.MapType;
import net.sf.saxon.ma.map.SingleEntryMap;
import net.sf.saxon.om.AxisInfo;
import net.sf.saxon.om.FingerprintedQName;
import net.sf.saxon.om.Function;
import net.sf.saxon.om.IdentityComparable;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NoNamespaceName;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.om.QNameParser;
import net.sf.saxon.om.StandardNames;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.AnyChildNodeTest;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.CombinedNodeTest;
import net.sf.saxon.pattern.ContentTypeTest;
import net.sf.saxon.pattern.DocumentNodeTest;
import net.sf.saxon.pattern.LocalNameTest;
import net.sf.saxon.pattern.NameTest;
import net.sf.saxon.pattern.NamespaceTest;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.query.AnnotationList;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.SymbolicName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.AnySimpleType;
import net.sf.saxon.type.AnyType;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ErrorType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.JavaExternalObjectType;
import net.sf.saxon.type.ListType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.UnionType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Whitespace;
import net.sf.saxon.z.IntArraySet;
import net.sf.saxon.z.IntSet;

public class XPathParser {
    protected Tokenizer t;
    protected StaticContext env;
    protected Stack<LocalBinding> rangeVariables = new Stack();
    protected QNameParser qNameParser;
    protected ParserExtension parserExtension = new ParserExtension();
    protected IntPredicate charChecker;
    protected boolean allowXPath30Syntax = false;
    protected boolean allowXPath30XSLTExtensions = false;
    protected boolean allowXPath31Syntax = false;
    protected boolean allowSaxonExtensions = false;
    protected boolean scanOnly = false;
    private boolean a = false;
    protected CodeInjector codeInjector = null;
    private Accelerator b = null;
    protected int language = 0;
    public static final int XPATH = 0;
    public static final int XSLT_PATTERN = 1;
    public static final int SEQUENCE_TYPE = 2;
    public static final int XQUERY = 3;
    public static final int EXTENDED_ITEM_TYPE = 4;
    protected int languageVersion = 20;
    protected int catchDepth = 0;
    private static final String[] c = new String[]{"attribute", "comment", "document-node", "element", "empty-sequence", "function", "if", "item", "namespace-node", "node", "processing-instruction", "schema-attribute", "schema-element", "switch", "text", "typeswitch"};
    private static final String[] d = new String[]{"array", "attribute", "comment", "document-node", "element", "empty-sequence", "function", "if", "item", "map", "namespace-node", "node", "processing-instruction", "schema-attribute", "schema-element", "switch", "text", "typeswitch"};
    private Location e = ExplicitLocation.UNKNOWN_LOCATION;

    public void setCodeInjector(CodeInjector codeInjector) {
        this.codeInjector = codeInjector;
    }

    public CodeInjector getCodeInjector() {
        return this.codeInjector;
    }

    public void setAccelerator(Accelerator accelerator) {
        this.b = accelerator;
    }

    public Tokenizer getTokenizer() {
        return this.t;
    }

    public StaticContext getStaticContext() {
        return this.env;
    }

    public void setParserExtension(ParserExtension parserExtension) {
        this.parserExtension = parserExtension;
    }

    public void setCatchDepth(int n2) {
        this.catchDepth = n2;
    }

    public void nextToken() {
        try {
            this.t.next();
            return;
        }
        catch (XPathException xPathException) {
            this.grumble(xPathException.getMessage());
            return;
        }
    }

    public void expect(int n2) {
        if (this.t.currentToken != n2) {
            this.grumble("expected \"" + Token.tokens[n2] + "\", found " + this.currentTokenDisplay());
        }
    }

    public void grumble(String string) {
        this.grumble(string, this.language == 1 ? "XTSE0340" : "XPST0003");
    }

    public void grumble(String string, String string2) {
        this.grumble(string, new StructuredQName("", "http://www.w3.org/2005/xqt-errors", string2), -1);
    }

    public void grumble(String string, String string2, int n2) {
        this.grumble(string, new StructuredQName("", "http://www.w3.org/2005/xqt-errors", string2), n2);
    }

    protected void grumble(String object, StructuredQName structuredQName, int n2) {
        int n3;
        if (structuredQName == null) {
            structuredQName = new StructuredQName("err", "http://www.w3.org/2005/xqt-errors", "XPST0003");
        }
        String string = this.t.recentText(-1);
        if (n2 == -1) {
            n3 = this.t.getLineNumber();
            n2 = this.t.getColumnNumber();
        } else {
            n3 = this.t.getLineNumber(n2);
            n2 = this.t.getColumnNumber(n2);
        }
        XPathParser xPathParser = this;
        Location location = xPathParser.makeNestedLocation(xPathParser.env.getContainingLocation(), n3, n2, string);
        object = new XPathException((String)object);
        ((XPathException)object).setLocation(location);
        ((XPathException)object).setIsSyntaxError("XPST0003".equals(structuredQName.getLocalPart()));
        ((XPathException)object).setIsStaticError(true);
        ((XPathException)object).setHostLanguage(this.getLanguage());
        ((XPathException)object).setErrorCodeQName(structuredQName);
        throw object;
    }

    protected void warning(String string) {
        if (!this.env.getConfiguration().getBooleanProperty(Feature.SUPPRESS_XPATH_WARNINGS)) {
            String string2 = this.t.recentText(-1);
            string2 = (string.startsWith("...") ? "near" : "in") + ' ' + Err.wrap(string2) + ":\n    ";
            this.env.issueWarning(string2 + string, this.makeLocation());
        }
    }

    public void setLanguage(int n2, int n3) {
        if (n3 == 0) {
            n3 = 30;
        }
        if (n3 == 305) {
            n3 = 30;
            this.allowXPath30XSLTExtensions = true;
        }
        switch (n2) {
            case 0: {
                if (n3 == 20 || n3 == 30 || n3 == 31) break;
                throw new IllegalArgumentException("Unsupported language version " + n3);
            }
            case 1: 
            case 2: {
                if (n3 == 20 || n3 == 30 || n3 == 31) break;
                throw new IllegalArgumentException("Unsupported language version " + n3);
            }
            case 3: {
                if (n3 == 10 || n3 == 30 || n3 == 31) break;
                throw new IllegalArgumentException("Unsupported language version " + n3);
            }
            default: {
                throw new IllegalArgumentException("Unknown language " + n2);
            }
        }
        this.language = n2;
        this.languageVersion = n3;
        this.allowXPath30Syntax = this.languageVersion >= 30;
        this.allowXPath31Syntax = this.languageVersion >= 31;
    }

    protected String getLanguage() {
        switch (this.language) {
            case 0: {
                return "XPath";
            }
            case 1: {
                return "XSLT Pattern";
            }
            case 2: {
                return "SequenceType";
            }
            case 3: {
                return "XQuery";
            }
            case 4: {
                return "Extended ItemType";
            }
        }
        return "XPath";
    }

    public boolean isAllowXPath31Syntax() {
        return this.allowXPath31Syntax;
    }

    public void setQNameParser(QNameParser qNameParser) {
        this.qNameParser = qNameParser;
    }

    public QNameParser getQNameParser() {
        return this.qNameParser;
    }

    protected String currentTokenDisplay() {
        if (this.t.currentToken == 201) {
            return "name \"" + this.t.currentTokenValue + '\"';
        }
        if (this.t.currentToken == -1) {
            return "(unknown token)";
        }
        return "\"" + Token.tokens[this.t.currentToken] + '\"';
    }

    public Expression parse(String object, int n2, int n3, StaticContext staticContext) {
        this.env = staticContext;
        int n4 = staticContext.getXPathVersion();
        if (n4 == 20 && this.language == 3) {
            n4 = 10;
        }
        XPathParser xPathParser = this;
        xPathParser.setLanguage(xPathParser.language, n4);
        Expression expression = null;
        if (this.b != null && (((String)object).length() - n2 < 30 || n3 == 215)) {
            this.t = new Tokenizer();
            this.t.languageLevel = staticContext.getXPathVersion();
            expression = this.b.parse(this.t, staticContext, (String)object, n2, n3);
        }
        if (expression == null) {
            this.qNameParser = new QNameParser(staticContext.getNamespaceResolver());
            this.qNameParser.setAcceptEQName(this.allowXPath30Syntax);
            this.qNameParser.setDefaultNamespace("");
            this.qNameParser.setErrorOnBadSyntax(this.language == 1 ? "XTSE0340" : "XPST0003");
            this.qNameParser.setErrorOnUnresolvedPrefix("XPST0081");
            this.charChecker = staticContext.getConfiguration().getValidCharacterChecker();
            this.t = new Tokenizer();
            this.t.languageLevel = staticContext.getXPathVersion();
            XPathParser xPathParser2 = this;
            xPathParser2.allowSaxonExtensions = xPathParser2.t.allowSaxonExtensions = staticContext.getConfiguration().getBooleanProperty(Feature.ALLOW_SYNTAX_EXTENSIONS);
            int n5 = this.t.currentTokenStartOffset;
            XPathParser xPathParser3 = this;
            xPathParser3.customizeTokenizer(xPathParser3.t);
            try {
                this.t.tokenize((String)object, n2, -1);
            }
            catch (XPathException xPathException) {
                this.grumble(xPathException.getMessage());
            }
            if (this.t.currentToken == n3) {
                if (this.a) {
                    object = Literal.makeEmptySequence();
                    ((Expression)object).setRetainedStaticContext(staticContext.makeRetainedStaticContext());
                    this.setLocation((Expression)object);
                    return object;
                }
                this.grumble("The expression is empty");
            }
            expression = this.parseExpression();
            if (this.t.currentToken != n3) {
                if (this.t.currentToken == 0 && n3 == 215) {
                    this.grumble("Missing curly brace after expression in value template", "XTSE0350");
                } else {
                    this.grumble("Unexpected token " + this.currentTokenDisplay() + " beyond end of expression");
                }
            }
            this.setLocation(expression, n5);
        }
        expression.setRetainedStaticContextThoroughly(staticContext.makeRetainedStaticContext());
        return expression;
    }

    protected void customizeTokenizer(Tokenizer tokenizer) {
    }

    public SequenceType parseSequenceType(String object, StaticContext staticContext) {
        this.env = staticContext;
        if (this.qNameParser == null) {
            this.qNameParser = new QNameParser(staticContext.getNamespaceResolver());
            if (this.languageVersion >= 30) {
                this.qNameParser.setAcceptEQName(true);
            }
        }
        this.language = 2;
        this.t = new Tokenizer();
        this.t.languageLevel = staticContext.getXPathVersion();
        XPathParser xPathParser = this;
        xPathParser.allowSaxonExtensions = xPathParser.t.allowSaxonExtensions = staticContext.getConfiguration().getBooleanProperty(Feature.ALLOW_SYNTAX_EXTENSIONS);
        try {
            this.t.tokenize((String)object, 0, -1);
        }
        catch (XPathException xPathException) {
            this.grumble(xPathException.getMessage());
        }
        object = this.parseSequenceType();
        if (this.t.currentToken != 0) {
            this.grumble("Unexpected token " + this.currentTokenDisplay() + " beyond end of SequenceType");
        }
        return object;
    }

    public ItemType parseExtendedItemType(String object, StaticContext staticContext) {
        this.env = staticContext;
        this.language = 4;
        this.t = new Tokenizer();
        this.t.languageLevel = staticContext.getXPathVersion();
        XPathParser xPathParser = this;
        xPathParser.t.allowSaxonExtensions = true;
        xPathParser.allowSaxonExtensions = true;
        try {
            this.t.tokenize((String)object, 0, -1);
        }
        catch (XPathException xPathException) {
            this.grumble(xPathException.getMessage());
        }
        object = this.parseItemType();
        if (this.t.currentToken != 0) {
            this.grumble("Unexpected token " + this.currentTokenDisplay() + " beyond end of ItemType");
        }
        return object;
    }

    public SequenceType parseExtendedSequenceType(String object, StaticContext staticContext) {
        this.env = staticContext;
        this.language = 4;
        this.t = new Tokenizer();
        this.t.languageLevel = staticContext.getXPathVersion();
        XPathParser xPathParser = this;
        xPathParser.t.allowSaxonExtensions = true;
        xPathParser.allowSaxonExtensions = true;
        try {
            this.t.tokenize((String)object, 0, -1);
        }
        catch (XPathException xPathException) {
            this.grumble(xPathException.getMessage());
        }
        object = this.parseSequenceType();
        if (this.t.currentToken != 0) {
            this.grumble("Unexpected token " + this.currentTokenDisplay() + " beyond end of SequenceType");
        }
        return object;
    }

    public Expression parseExpression() {
        int n2 = this.t.currentTokenStartOffset;
        Expression expression = this.parseExprSingle();
        ArrayList<Expression> arrayList = null;
        while (this.t.currentToken == 7) {
            if (arrayList == null) {
                arrayList = new ArrayList<Expression>(10);
                arrayList.add(expression);
            }
            this.nextToken();
            Expression expression2 = this.parseExprSingle();
            this.setLocation(expression2);
            arrayList.add(expression2);
        }
        if (arrayList != null) {
            expression = Block.makeBlock(arrayList);
            this.setLocation(expression, n2);
        }
        return expression;
    }

    public Expression parseExprSingle() {
        Expression expression = this.parserExtension.parseExtendedExprSingle(this);
        if (expression != null) {
            return expression;
        }
        int n2 = this.t.peekAhead();
        if (n2 == 0 || n2 == 7 || n2 == 204 || n2 == 203) {
            switch (this.t.currentToken) {
                case 202: {
                    return this.parseStringLiteral(true);
                }
                case 209: {
                    return this.parseNumericLiteral(true);
                }
                case 70: 
                case 201: 
                case 207: 
                case 208: {
                    return this.parseBasicStep(true);
                }
                case 205: {
                    this.nextToken();
                    ContextItemExpression contextItemExpression = new ContextItemExpression();
                    this.setLocation(contextItemExpression);
                    return contextItemExpression;
                }
                case 206: {
                    this.nextToken();
                    AxisExpression axisExpression = new AxisExpression(9, null);
                    this.setLocation(axisExpression);
                    return axisExpression;
                }
            }
        }
        switch (this.t.currentToken) {
            case 0: {
                this.grumble("Expected an expression, but reached the end of the input");
            }
            case 73: 
            case 74: 
            case 211: 
            case 216: {
                return this.parseFLWORExpression();
            }
            case 32: 
            case 33: {
                int n3;
                XPathParser xPathParser = this;
                int n4 = 0;
                int n5 = xPathParser.t.currentToken;
                QuantifiedExpression quantifiedExpression = null;
                Assignation assignation = null;
                int n6 = xPathParser.t.currentTokenStartOffset;
                do {
                    n3 = xPathParser.t.currentTokenStartOffset;
                    xPathParser.nextToken();
                    xPathParser.expect(21);
                    xPathParser.nextToken();
                    xPathParser.expect(201);
                    String string = xPathParser.t.currentTokenValue;
                    ++n4;
                    QuantifiedExpression quantifiedExpression2 = new QuantifiedExpression();
                    quantifiedExpression2.setRequiredType(SequenceType.SINGLE_ITEM);
                    quantifiedExpression2.setOperator(n5);
                    xPathParser.setLocation(quantifiedExpression2, n3);
                    quantifiedExpression2.setVariableQName(xPathParser.makeStructuredQName(string, ""));
                    xPathParser.nextToken();
                    if (xPathParser.t.currentToken == 71 && xPathParser.language == 3) {
                        xPathParser.nextToken();
                        SequenceType sequenceType = xPathParser.parseSequenceType();
                        if (sequenceType.getCardinality() != 16384) {
                            xPathParser.warning("Occurrence indicator on singleton range variable has no effect");
                            sequenceType = SequenceType.makeSequenceType(sequenceType.getPrimaryType(), 16384);
                        }
                        quantifiedExpression2.setRequiredType(sequenceType);
                    }
                    xPathParser.expect(31);
                    xPathParser.nextToken();
                    quantifiedExpression2.setSequence(xPathParser.parseExprSingle());
                    xPathParser.declareRangeVariable(quantifiedExpression2);
                    if (assignation != null) {
                        assignation.setAction(quantifiedExpression2);
                    } else {
                        quantifiedExpression = quantifiedExpression2;
                    }
                    assignation = quantifiedExpression2;
                } while (xPathParser.t.currentToken == 7);
                xPathParser.expect(34);
                xPathParser.nextToken();
                assignation.setAction(xPathParser.parseExprSingle());
                for (n3 = 0; n3 < n4; ++n3) {
                    xPathParser.undeclareRangeVariable();
                }
                return xPathParser.makeTracer(n6, quantifiedExpression, 2012, quantifiedExpression.getVariableQName());
            }
            case 37: {
                XPathParser xPathParser = this;
                int n7 = xPathParser.t.currentTokenStartOffset;
                xPathParser.nextToken();
                Expression expression2 = xPathParser.parseExpression();
                xPathParser.expect(204);
                xPathParser.nextToken();
                int n8 = xPathParser.t.currentTokenStartOffset;
                xPathParser.expect(26);
                xPathParser.nextToken();
                Expression expression3 = xPathParser.makeTracer(n8, xPathParser.parseExprSingle(), 2016, null);
                int n9 = xPathParser.t.currentTokenStartOffset;
                xPathParser.expect(27);
                xPathParser.nextToken();
                Expression expression4 = xPathParser.makeTracer(n9, xPathParser.parseExprSingle(), 2017, null);
                Expression expression5 = Choose.makeConditional(expression2, expression3, expression4);
                xPathParser.setLocation(expression5, n7);
                return xPathParser.makeTracer(n7, expression5, 2015, null);
            }
            case 66: {
                return this.parseSwitchExpression();
            }
            case 65: {
                return this.parseTypeswitchExpression();
            }
            case 102: 
            case 103: 
            case 104: 
            case 105: {
                return this.parseValidateExpression();
            }
            case 218: {
                return this.parseExtensionExpression();
            }
            case 60: {
                if (!this.t.currentTokenValue.equals("try")) break;
                return this.parseTryCatchExpression();
            }
        }
        XPathParser xPathParser = this;
        return xPathParser.parseBinaryExpression(xPathParser.b(), 4);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public Expression parseBinaryExpression(Expression var1_1, int var2_3) {
        block33: while (this.a() >= var2_3) {
            var3_4 = this.t.currentTokenStartOffset;
            var4_5 = this.t.currentToken;
            var5_13 = this.a();
            switch (var4_5) {
                case 45: 
                case 47: {
                    this.nextToken();
                    var4_6 = var6_15 = this.parseSequenceType();
                    var1_2 = var4_5;
                    var7_16 = var1_1;
                    switch (var1_2) {
                        case 45: {
                            v0 /* !! */  = new InstanceOfExpression((Expression)var7_16, (SequenceType)var4_6);
                            break;
                        }
                        case 47: {
                            v0 /* !! */  = TreatExpression.make((Expression)var7_16, (SequenceType)var4_6);
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException();
                        }
                    }
                    var1_1 = v0 /* !! */ ;
                    this.setLocation((Expression)var1_1, var3_4);
                    if (this.a() < var5_13) continue block33;
                    this.grumble("Left operand of '" + Token.tokens[this.t.currentToken] + "' needs parentheses");
                    continue block33;
                }
                case 46: 
                case 57: {
                    this.nextToken();
                    if (this.allowSaxonExtensions && this.t.currentToken == 69 && this.t.currentTokenValue.equals("union")) {
                        var6_15 = (SimpleType)this.parseItemType();
                    } else {
                        this.expect(201);
                        v1 = this;
                        var6_15 = v1.b(v1.t.currentTokenValue);
                        if (var6_15 == BuiltInAtomicType.ANY_ATOMIC) {
                            this.grumble("No value is castable to xs:anyAtomicType", "XPST0080");
                        }
                        if (var6_15 == BuiltInAtomicType.NOTATION) {
                            this.grumble("No value is castable to xs:NOTATION", "XPST0080");
                        }
                        this.nextToken();
                    }
                    if (var7_17 = this.t.currentToken == 213) {
                        this.nextToken();
                    }
                    var8_18 = var7_17;
                    var7_16 = this;
                    if (!(var6_15 instanceof AtomicType) || var6_15 == ErrorType.getInstance()) ** GOTO lbl58
                    switch (var4_5) {
                        case 57: {
                            var4_7 = new CastableExpression((Expression)var1_1, (AtomicType)var6_15, var8_18);
                            if (var1_1 instanceof StringLiteral) {
                                var4_7.setOperandIsStringLiteral(true);
                            }
                            v2 = var4_7;
                            ** GOTO lbl88
                        }
                        case 46: {
                            var7_16 = new CastExpression((Expression)var1_1, (AtomicType)var6_15, var8_18);
                            if (var1_1 instanceof StringLiteral) {
                                var7_16.setOperandIsStringLiteral(true);
                            }
                            v2 = var7_16;
                            ** GOTO lbl88
                        }
                        default: {
                            throw new IllegalArgumentException();
                        }
                    }
lbl58:
                    // 1 sources

                    if (!var7_16.allowXPath30Syntax) ** GOTO lbl87
                    switch (var4_5) {
                        case 57: {
                            if (var6_15.isUnionType()) {
                                var4_8 = var7_16.env.getNamespaceResolver();
                                var7_16 = new UnionCastableFunction((UnionType)var6_15, var4_8, var8_18);
                                v2 = new StaticFunctionCall((Function)var7_16, new Expression[]{var1_1});
                            } else {
                                if (!var6_15.isListType()) break;
                                var4_9 = var7_16.env.getNamespaceResolver();
                                var7_16 = new ListCastableFunction((ListType)var6_15, var4_9, var8_18);
                                v2 = new StaticFunctionCall((Function)var7_16, new Expression[]{var1_1});
                            }
                            ** GOTO lbl88
                        }
                        case 46: {
                            if (var6_15.isUnionType()) {
                                var4_10 = var7_16.env.getNamespaceResolver();
                                var7_16 = new UnionConstructorFunction((UnionType)var6_15, var4_10, var8_18);
                                v2 = new StaticFunctionCall((Function)var7_16, new Expression[]{var1_1});
                            } else {
                                if (!var6_15.isListType()) break;
                                var4_11 = var7_16.env.getNamespaceResolver();
                                var7_16 = new ListConstructorFunction((ListType)var6_15, var4_11, var8_18);
                                v2 = new StaticFunctionCall((Function)var7_16, new Expression[]{var1_1});
                            }
                            ** GOTO lbl88
                        }
                        default: {
                            throw new IllegalArgumentException();
                        }
                    }
                    if (var6_15 == AnySimpleType.getInstance()) {
                        throw new XPathException("Cannot cast to xs:anySimpleType", "XPST0080");
                    }
                    throw new XPathException("Cannot cast to " + var6_15.getDescription(), "XPST0051");
lbl87:
                    // 1 sources

                    throw new XPathException("Casting to list or union types requires XPath 3.0 to be enabled", "XPST0051");
lbl88:
                    // 6 sources

                    var1_1 = v2;
                    this.setLocation((Expression)var1_1, var3_4);
                    if (this.a() < var5_13) continue block33;
                    this.grumble("Left operand of '" + Token.tokens[this.t.currentToken] + "' needs parentheses");
                    continue block33;
                }
                case 76: {
                    var1_1 = this.parseArrowPostfix((Expression)var1_1);
                    continue block33;
                }
            }
            this.nextToken();
            var6_15 = this.b();
            while (this.a() > var5_13) {
                var6_15 = this.parseBinaryExpression((Expression)var6_15, this.a());
            }
            if (this.a() == var5_13) {
                var7_16 = this;
                switch (var7_16.t.currentToken) {
                    case 6: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: 
                    case 20: 
                    case 22: 
                    case 29: 
                    case 38: 
                    case 39: 
                    case 50: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 55: {
                        v3 = false;
                        break;
                    }
                    default: {
                        v3 = true;
                    }
                }
                if (!v3) {
                    var5_14 = Token.tokens[this.t.currentToken];
                    var7_16 = "Left operand of '" + Token.tokens[this.t.currentToken] + "' needs parentheses";
                    if (var5_14.equals("<") || var5_14.equals(">")) {
                        var7_16 = (String)var7_16 + ". Or perhaps an XQuery element constructor appears where it is not allowed";
                    }
                    this.grumble((String)var7_16);
                }
            }
            var7_16 = this;
            switch (var4_5) {
                case 9: {
                    v4 /* !! */  = new OrExpression((Expression)var1_1, (Expression)var6_15);
                    break;
                }
                case 10: {
                    v4 /* !! */  = new AndExpression((Expression)var1_1, (Expression)var6_15);
                    break;
                }
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: {
                    v4 /* !! */  = new ValueComparison((Expression)var1_1, var4_5, (Expression)var6_15);
                    break;
                }
                case 6: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 22: {
                    v4 /* !! */  = var7_16.env.getConfiguration().getTypeChecker(var7_16.env.isInBackwardsCompatibleMode()).makeGeneralComparison((Expression)var1_1, var4_5, (Expression)var6_15);
                    break;
                }
                case 20: 
                case 38: 
                case 39: {
                    v4 /* !! */  = new IdentityComparison((Expression)var1_1, var4_5, (Expression)var6_15);
                    break;
                }
                case 29: {
                    v4 /* !! */  = new RangeExpression((Expression)var1_1, (Expression)var6_15);
                    break;
                }
                case 30: {
                    if (!var7_16.allowXPath30Syntax) {
                        var7_16.grumble("Concatenation operator ('||') requires XPath 3.0 to be enabled");
                    }
                    var8_19 = new RetainedStaticContext(var7_16.env);
                    if (var1_1.isCallOn(Concat.class)) {
                        var4_12 = ((SystemFunctionCall)var1_1).getArguments();
                        var7_16 = new Expression[var4_12.length + 1];
                        System.arraycopy(var4_12, 0, var7_16, 0, var4_12.length);
                        var7_16[var4_12.length] = var6_15;
                        v4 /* !! */  = SystemFunction.makeCall("concat", var8_19, (Expression[])var7_16);
                        break;
                    }
                    v4 /* !! */  = SystemFunction.makeCall("concat", var8_19, new Expression[]{var1_1, var6_15});
                    break;
                }
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 56: {
                    v4 /* !! */  = var7_16.env.getConfiguration().getTypeChecker(var7_16.env.isInBackwardsCompatibleMode()).makeArithmeticExpression((Expression)var1_1, var4_5, (Expression)var6_15);
                    break;
                }
                case 1: 
                case 23: 
                case 24: {
                    v4 /* !! */  = new VennExpression((Expression)var1_1, var4_5, (Expression)var6_15);
                    break;
                }
                case 80: {
                    var8_20 = new RetainedStaticContext(var7_16.env);
                    var6_15 = SystemFunction.makeCall("boolean", var8_20, new Expression[]{var6_15});
                    v4 /* !! */  = Choose.makeConditional((Expression)var1_1, Literal.makeLiteral(BooleanValue.TRUE), (Expression)var6_15);
                    break;
                }
                case 79: {
                    var8_21 = new RetainedStaticContext(var7_16.env);
                    var6_15 = SystemFunction.makeCall("boolean", var8_21, new Expression[]{var6_15});
                    v4 /* !! */  = Choose.makeConditional((Expression)var1_1, (Expression)var6_15, Literal.makeLiteral(BooleanValue.FALSE));
                    break;
                }
                default: {
                    throw new IllegalArgumentException(Token.tokens[var4_5]);
                }
            }
            var1_1 = v4 /* !! */ ;
            this.setLocation((Expression)var1_1, var3_4);
        }
        return var1_1;
    }

    private int a() {
        return XPathParser.operatorPrecedence(this.t.currentToken);
    }

    public static int operatorPrecedence(int n2) {
        switch (n2) {
            case 9: 
            case 80: {
                return 4;
            }
            case 10: 
            case 79: {
                return 5;
            }
            case 6: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 20: 
            case 22: 
            case 38: 
            case 39: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                return 6;
            }
            case 30: {
                return 7;
            }
            case 29: {
                return 8;
            }
            case 15: 
            case 16: {
                return 9;
            }
            case 17: 
            case 18: 
            case 19: 
            case 56: {
                return 10;
            }
            case 1: {
                return 11;
            }
            case 23: 
            case 24: {
                return 12;
            }
            case 45: {
                return 13;
            }
            case 47: {
                return 14;
            }
            case 57: {
                return 15;
            }
            case 46: {
                return 16;
            }
            case 76: {
                return 17;
            }
        }
        return -1;
    }

    protected Expression parseTypeswitchExpression() {
        this.grumble("typeswitch is not allowed in XPath");
        return new ErrorExpression();
    }

    protected Expression parseSwitchExpression() {
        this.grumble("switch is not allowed in XPath");
        return new ErrorExpression();
    }

    protected Expression parseValidateExpression() {
        this.grumble("validate{} expressions are not allowed in XPath");
        return new ErrorExpression();
    }

    protected Expression parseExtensionExpression() {
        this.grumble("extension expressions (#...#) are not allowed in XPath");
        return new ErrorExpression();
    }

    protected Expression parseTryCatchExpression() {
        this.grumble("try/catch expressions are not allowed in XPath");
        return new ErrorExpression();
    }

    protected Expression parseFLWORExpression() {
        int n2;
        if (this.t.currentToken == 216 && !this.allowXPath30Syntax) {
            this.grumble("'let' is not permitted in XPath 2.0");
        }
        if (this.t.currentToken == 74 || this.t.currentToken == 73) {
            this.grumble("sliding/tumbling windows can only be used in XQuery");
        }
        int n3 = 0;
        int n4 = this.t.currentToken;
        Assignation assignation = null;
        Assignation assignation2 = null;
        do {
            Assignation assignation3;
            n2 = this.t.currentTokenStartOffset;
            this.nextToken();
            this.expect(21);
            this.nextToken();
            this.expect(201);
            String string = this.t.currentTokenValue;
            if (n4 == 211) {
                assignation3 = new ForExpression();
                assignation3.setRequiredType(SequenceType.SINGLE_ITEM);
            } else {
                assignation3 = new LetExpression();
                assignation3.setRequiredType(SequenceType.ANY_SEQUENCE);
            }
            ++n3;
            this.setLocation(assignation3, n2);
            assignation3.setVariableQName(this.makeStructuredQName(string, ""));
            this.nextToken();
            this.expect(n4 == 216 ? 58 : 31);
            this.nextToken();
            assignation3.setSequence(this.parseExprSingle());
            this.declareRangeVariable(assignation3);
            if (assignation2 == null) {
                assignation = assignation3;
            } else {
                assignation2.setAction(assignation3);
            }
            assignation2 = assignation3;
        } while (this.t.currentToken == 7);
        this.expect(25);
        this.nextToken();
        assignation2.setAction(this.parseExprSingle());
        for (int i2 = 0; i2 < n3; ++i2) {
            this.undeclareRangeVariable();
        }
        return this.makeTracer(n2, assignation, 2012, assignation.getVariableQName());
    }

    private ItemType a(String string) {
        if (this.scanOnly) {
            return BuiltInAtomicType.STRING;
        }
        this.qNameParser.setDefaultNamespace(this.env.getDefaultElementNamespace());
        StructuredQName structuredQName = null;
        try {
            structuredQName = this.qNameParser.parse(string);
        }
        catch (XPathException xPathException) {
            this.grumble(xPathException.getMessage(), xPathException.getErrorCodeLocalPart());
        }
        return this.getPlainType(structuredQName);
    }

    public ItemType getPlainType(StructuredQName object) {
        Configuration configuration = this.env.getConfiguration();
        String string = ((StructuredQName)object).getURI();
        if (string.isEmpty()) {
            string = this.env.getDefaultElementNamespace();
        }
        String string2 = ((StructuredQName)object).getLocalPart();
        String string3 = ((StructuredQName)object).getDisplayName();
        boolean bl2 = string.equals("http://www.w3.org/2001/XMLSchema");
        if (bl2) {
            object = Type.getBuiltInItemType(string, string2);
            if (object == null) {
                this.grumble("Unknown atomic type " + string3, "XPST0051");
                assert (false);
            }
            if (object instanceof BuiltInAtomicType) {
                XPathParser xPathParser = this;
                xPathParser.a(xPathParser.env, (BuiltInAtomicType)object);
                return object;
            }
            if (object.isPlainType()) {
                return object;
            }
            this.grumble("The type " + string3 + " is not atomic", "XPST0051");
            assert (false);
        } else {
            if (string.equals("http://saxon.sf.net/java-type")) {
                try {
                    object = JavaExternalObjectType.localNameToClassName(string2);
                    object = configuration.getClass((String)object, false, null);
                }
                catch (XPathException xPathException) {
                    this.grumble("Unknown Java class " + string2, "XPST0051");
                    return AnyItemType.getInstance();
                }
                return configuration.getJavaExternalObjectType((Class)object);
            }
            if (string.equals("http://saxon.sf.net/clitype")) {
                return Version.platform.getExternalObjectType(configuration, string, string2);
            }
            if ((object = configuration.getSchemaType((StructuredQName)object)) == null) {
                this.grumble("Unknown simple type " + string3, "XPST0051");
            } else {
                if (object.isAtomicType()) {
                    if (!this.env.isImportedSchema(string)) {
                        this.grumble("Atomic type " + string3 + " exists, but its schema definition has not been imported", "XPST0051");
                    }
                    return (AtomicType)object;
                }
                if (object instanceof ItemType && ((ItemType)object).isPlainType() && this.allowXPath30Syntax) {
                    if (!this.env.isImportedSchema(string)) {
                        this.grumble("Type " + string3 + " exists, but its schema definition has not been imported", "XPST0051");
                    }
                    return (ItemType)object;
                }
                if (object.isComplexType()) {
                    this.grumble("Type (" + string3 + ") is a complex type", "XPST0051");
                    return BuiltInAtomicType.ANY_ATOMIC;
                }
                if (((SimpleType)object).isListType()) {
                    this.grumble("Type (" + string3 + ") is a list type", "XPST0051");
                    return BuiltInAtomicType.ANY_ATOMIC;
                }
                if (this.allowXPath30Syntax) {
                    this.grumble("Type (" + string3 + ") is a union type that cannot be used as an item type", "XPST0051");
                    return BuiltInAtomicType.ANY_ATOMIC;
                }
                this.grumble("The union type (" + string3 + ") cannot be used as an item type unless XPath 3.0 is enabled", "XPST0051");
                return BuiltInAtomicType.ANY_ATOMIC;
            }
        }
        this.grumble("Unknown atomic type " + string3, "XPST0051");
        return BuiltInAtomicType.ANY_ATOMIC;
    }

    private void a(StaticContext object, BuiltInAtomicType builtInAtomicType) {
        if ((object = XPathParser.whyDisallowedType(object.getPackageData(), builtInAtomicType)) != null) {
            this.grumble((String)object, "XPST0080");
        }
    }

    public static String whyDisallowedType(PackageData packageData, BuiltInAtomicType builtInAtomicType) {
        if (!builtInAtomicType.isAllowedInXSD10() && packageData.getConfiguration().getXsdVersion() == 10) {
            return "The built-in atomic type " + builtInAtomicType.getDisplayName() + " is not recognized unless XSD 1.1 is enabled";
        }
        return null;
    }

    private SimpleType b(String string) {
        Object object;
        block18: {
            if (this.scanOnly) {
                return BuiltInAtomicType.STRING;
            }
            this.qNameParser.setDefaultNamespace(this.env.getDefaultElementNamespace());
            object = null;
            try {
                object = this.qNameParser.parse(string);
            }
            catch (XPathException xPathException) {
                this.grumble(xPathException.getMessage(), xPathException.getErrorCodeLocalPart());
                if (f) break block18;
                throw new AssertionError();
            }
        }
        String string2 = ((StructuredQName)object).getURI();
        object = ((StructuredQName)object).getLocalPart();
        boolean bl2 = string2.equals("http://www.w3.org/2001/XMLSchema");
        if (bl2) {
            if ((object = Type.getBuiltInSimpleType(string2, (String)object)) == null) {
                if (this.allowXPath30Syntax) {
                    this.grumble("Unknown simple type " + string, "XQST0052");
                } else {
                    this.grumble("Unknown simple type " + string, "XPST0051");
                }
            }
            if (object instanceof BuiltInAtomicType) {
                XPathParser xPathParser = this;
                xPathParser.a(xPathParser.env, (BuiltInAtomicType)object);
            }
            return object;
        }
        if (string2.equals("http://saxon.sf.net/clitype")) {
            return (AtomicType)((Object)Version.platform.getExternalObjectType(this.env.getConfiguration(), string2, (String)object));
        }
        object = this.env.getConfiguration().getSchemaType(new StructuredQName("", string2, (String)object));
        if (object == null) {
            if (this.allowXPath30Syntax) {
                this.grumble("Unknown simple type " + string, "XQST0052");
            } else {
                this.grumble("Unknown simple type " + string, "XPST0051");
            }
            return BuiltInAtomicType.ANY_ATOMIC;
        }
        if (this.allowXPath30Syntax) {
            if (!this.env.isImportedSchema(string2)) {
                this.grumble("Simple type " + string + " exists, but its target namespace has not been imported in the static context");
            }
            return (SimpleType)object;
        }
        if (object.isAtomicType()) {
            if (!this.env.isImportedSchema(string2)) {
                this.grumble("Atomic type " + string + " exists, but its target namespace has not been imported in the static context");
            }
            return (AtomicType)object;
        }
        if (object.isComplexType()) {
            this.grumble("Cannot cast to a complex type (" + string + ")", "XPST0051");
            return BuiltInAtomicType.ANY_ATOMIC;
        }
        if (((SimpleType)object).isListType()) {
            this.grumble("Casting to a list type (" + string + ") requires XPath 3.0", "XPST0051");
            return BuiltInAtomicType.ANY_ATOMIC;
        }
        this.grumble("casting to a union type (" + string + ") requires XPath 3.0", "XPST0051");
        return BuiltInAtomicType.ANY_ATOMIC;
    }

    public SequenceType parseSequenceType() {
        int n2 = this.t.currentTokenValue.equals("empty-sequence");
        ItemType itemType = this.parseItemType();
        if (n2 != 0) {
            return SequenceType.makeSequenceType(itemType, 8192);
        }
        switch (this.t.currentToken) {
            case 17: 
            case 207: {
                n2 = 57344;
                this.t.currentToken = 204;
                this.nextToken();
                break;
            }
            case 15: {
                n2 = 49152;
                this.t.currentToken = 204;
                this.nextToken();
                break;
            }
            case 213: {
                n2 = 24576;
                this.t.currentToken = 204;
                this.nextToken();
                break;
            }
            default: {
                n2 = 16384;
            }
        }
        return SequenceType.makeSequenceType(itemType, n2);
    }

    public ItemType parseItemType() {
        ItemType itemType;
        block36: {
            Object object;
            block29: {
                Object object2;
                block31: {
                    block34: {
                        block35: {
                            block33: {
                                block32: {
                                    block30: {
                                        object = this.parserExtension.parseExtendedItemType(this);
                                        if (object != null) break block29;
                                        object = this;
                                        if (((XPathParser)object).t.currentToken != 5) break block30;
                                        if (!((XPathParser)object).allowXPath30Syntax) {
                                            ((XPathParser)object).grumble("Parenthesized item types require 3.0 to be enabled");
                                        }
                                        ((XPathParser)object).nextToken();
                                        object2 = ((XPathParser)object).parseItemType();
                                        while (object2 instanceof NodeTest && ((XPathParser)object).language == 4 && ((XPathParser)object).t.currentToken != 204) {
                                            switch (((XPathParser)object).t.currentToken) {
                                                case 1: 
                                                case 23: 
                                                case 24: {
                                                    int n2 = ((XPathParser)object).t.currentToken;
                                                    ((XPathParser)object).nextToken();
                                                    object2 = new CombinedNodeTest((NodeTest)object2, n2, (NodeTest)((XPathParser)object).parseItemType());
                                                }
                                            }
                                        }
                                        ((XPathParser)object).expect(204);
                                        ((XPathParser)object).nextToken();
                                        break block31;
                                    }
                                    if (((XPathParser)object).t.currentToken != 201) break block32;
                                    Object object3 = object;
                                    object2 = super.a(((XPathParser)object3).t.currentTokenValue);
                                    ((XPathParser)object).nextToken();
                                    break block31;
                                }
                                if (((XPathParser)object).t.currentToken != 69) break block33;
                                switch (((XPathParser)object).t.currentTokenValue) {
                                    case "item": {
                                        ((XPathParser)object).nextToken();
                                        ((XPathParser)object).expect(204);
                                        ((XPathParser)object).nextToken();
                                        object2 = AnyItemType.getInstance();
                                        break;
                                    }
                                    case "function": {
                                        ((XPathParser)object).checkLanguageVersion30();
                                        object2 = AnnotationList.EMPTY;
                                        object2 = ((XPathParser)object).parseFunctionItemType((AnnotationList)object2);
                                        break;
                                    }
                                    case "map": {
                                        object2 = ((XPathParser)object).parseMapItemType();
                                        break;
                                    }
                                    case "array": {
                                        object2 = ((XPathParser)object).parseArrayItemType();
                                        break;
                                    }
                                    case "empty-sequence": {
                                        ((XPathParser)object).nextToken();
                                        ((XPathParser)object).expect(204);
                                        ((XPathParser)object).nextToken();
                                        object2 = ErrorType.getInstance();
                                        break;
                                    }
                                    default: {
                                        object2 = super.c();
                                        break;
                                    }
                                }
                                break block31;
                            }
                            if (((XPathParser)object).t.currentToken != 106) break block34;
                            object2 = ((XPathParser)object).parseAnnotationsList();
                            if (!((XPathParser)object).t.currentTokenValue.equals("function")) break block35;
                            object2 = ((XPathParser)object).parseFunctionItemType((AnnotationList)object2);
                            break block31;
                        }
                        ((XPathParser)object).grumble("Expected 'function' to follow annotation assertions, found " + Token.tokens[((XPathParser)object).t.currentToken]);
                        itemType = null;
                        break block36;
                    }
                    if (((XPathParser)object).language == 4 && ((XPathParser)object).t.currentToken == 208) {
                        String string = ((XPathParser)object).t.currentTokenValue;
                        ((XPathParser)object).nextToken();
                        itemType = ((XPathParser)object).makeNamespaceTest((short)1, string);
                    } else if (((XPathParser)object).language == 4 && ((XPathParser)object).t.currentToken == 70) {
                        ((XPathParser)object).nextToken();
                        ((XPathParser)object).expect(201);
                        String string = ((XPathParser)object).t.currentTokenValue;
                        ((XPathParser)object).nextToken();
                        itemType = ((XPathParser)object).makeLocalNameTest((short)1, string);
                    } else if (((XPathParser)object).language == 4 && ((XPathParser)object).t.currentToken == 3) {
                        ((XPathParser)object).nextToken();
                        if (((XPathParser)object).t.currentToken == 208) {
                            String string = ((XPathParser)object).t.currentTokenValue;
                            ((XPathParser)object).nextToken();
                            itemType = ((XPathParser)object).makeNamespaceTest((short)2, string);
                        } else if (((XPathParser)object).t.currentToken == 70) {
                            ((XPathParser)object).nextToken();
                            ((XPathParser)object).expect(201);
                            String string = ((XPathParser)object).t.currentTokenValue;
                            ((XPathParser)object).nextToken();
                            itemType = ((XPathParser)object).makeLocalNameTest((short)2, string);
                        } else {
                            ((XPathParser)object).grumble("Expected NodeTest after '@'");
                            itemType = BuiltInAtomicType.ANY_ATOMIC;
                        }
                    } else {
                        ((XPathParser)object).grumble("Expected type name in SequenceType, found " + Token.tokens[((XPathParser)object).t.currentToken]);
                        itemType = BuiltInAtomicType.ANY_ATOMIC;
                    }
                    break block36;
                }
                return object2;
            }
            itemType = object;
        }
        return itemType;
    }

    protected ItemType parseFunctionItemType(AnnotationList annotationList) {
        return this.parserExtension.parseFunctionItemType(this, annotationList);
    }

    protected ItemType parseMapItemType() {
        this.checkMapExtensions();
        Object object = this.getTokenizer();
        this.nextToken();
        if (((Tokenizer)object).currentToken == 207 || ((Tokenizer)object).currentToken == 17) {
            this.nextToken();
            this.expect(204);
            this.nextToken();
            return MapType.ANY_MAP_TYPE;
        }
        object = this.parseItemType();
        this.expect(7);
        this.nextToken();
        SequenceType sequenceType = this.parseSequenceType();
        this.expect(204);
        this.nextToken();
        if (!(object instanceof AtomicType)) {
            this.grumble("Key type of a map must be atomic");
            return null;
        }
        return new MapType((AtomicType)object, sequenceType);
    }

    protected ItemType parseArrayItemType() {
        this.checkLanguageVersion31();
        Object object = this.getTokenizer();
        this.nextToken();
        if (((Tokenizer)object).currentToken == 207 || ((Tokenizer)object).currentToken == 17) {
            this.nextToken();
            this.expect(204);
            this.nextToken();
            return ArrayItemType.ANY_ARRAY_TYPE;
        }
        object = this.parseSequenceType();
        this.expect(204);
        this.nextToken();
        return new ArrayItemType((SequenceType)object);
    }

    private Expression b() {
        Expression expression;
        switch (this.t.currentToken) {
            case 16: {
                this.nextToken();
                expression = this.b();
                expression = this.a(299, expression);
                break;
            }
            case 15: {
                this.nextToken();
                expression = this.b();
                expression = this.a(15, expression);
                break;
            }
            case 102: 
            case 103: 
            case 104: 
            case 105: {
                expression = this.parseValidateExpression();
                break;
            }
            case 218: {
                expression = this.parseExtensionExpression();
                break;
            }
            case 60: {
                if (this.t.currentTokenValue.equals("validate")) {
                    expression = this.parseValidateExpression();
                    break;
                }
            }
            default: {
                expression = this.parseSimpleMappingExpression();
            }
        }
        this.setLocation(expression);
        return expression;
    }

    private Expression a(int n2, Expression expression) {
        AtomicValue atomicValue;
        if (Literal.isAtomic(expression) && (atomicValue = (AtomicValue)((Literal)expression).getValue()) instanceof NumericValue) {
            if (this.env.isInBackwardsCompatibleMode()) {
                atomicValue = new DoubleValue(((NumericValue)atomicValue).getDoubleValue());
            }
            NumericValue numericValue = n2 == 299 ? ((NumericValue)atomicValue).negate() : (NumericValue)atomicValue;
            return Literal.makeLiteral(numericValue);
        }
        return this.env.getConfiguration().getTypeChecker(this.env.isInBackwardsCompatibleMode()).makeArithmeticExpression(Literal.makeLiteral(Int64Value.ZERO), n2, expression);
    }

    protected boolean atStartOfRelativePath() {
        switch (this.t.currentToken) {
            case 3: 
            case 5: 
            case 21: 
            case 35: 
            case 36: 
            case 43: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 69: 
            case 70: 
            case 201: 
            case 202: 
            case 205: 
            case 206: 
            case 207: 
            case 208: 
            case 209: 
            case 218: {
                return true;
            }
            case 60: {
                return this.t.currentTokenValue.equals("ordered") || this.t.currentTokenValue.equals("unordered");
            }
        }
        return false;
    }

    protected boolean disallowedAtStartOfRelativePath() {
        switch (this.t.currentToken) {
            case 45: 
            case 46: 
            case 47: 
            case 57: {
                return true;
            }
        }
        return false;
    }

    protected Expression parsePathExpression() {
        int n2 = this.t.currentTokenStartOffset;
        switch (this.t.currentToken) {
            case 2: {
                this.nextToken();
                Expression expression = new RootExpression();
                this.setLocation(expression);
                if (this.disallowedAtStartOfRelativePath()) {
                    this.grumble("Operator '" + Token.tokens[this.t.currentToken] + "' is not allowed after '/'");
                }
                if (this.atStartOfRelativePath()) {
                    expression = this.parseRemainingPath(expression);
                    this.setLocation(expression, n2);
                    return expression;
                }
                return expression;
            }
            case 8: {
                this.nextToken();
                Expression expression = new RootExpression();
                this.setLocation(expression, n2);
                AxisExpression axisExpression = new AxisExpression(5, null);
                this.setLocation(axisExpression, n2);
                expression = ExpressionTool.makePathExpression(expression, axisExpression);
                this.setLocation(expression, n2);
                expression = this.parseRemainingPath(expression);
                this.setLocation(expression, n2);
                return expression;
            }
        }
        if (this.t.currentToken == 201 && (this.t.currentTokenValue.equals("true") || this.t.currentTokenValue.equals("false"))) {
            this.warning("The expression is looking for a child element named '" + this.t.currentTokenValue + "' - perhaps " + this.t.currentTokenValue + "() was intended? To avoid this warning, use child::" + this.t.currentTokenValue + " or ./" + this.t.currentTokenValue + ".");
        }
        if (this.t.currentToken == 201 && this.t.getBinaryOp(this.t.currentTokenValue) != -1 && this.language != 1 && (n2 > 0 || this.t.peekAhead() != 0)) {
            String string = this.t.currentTokenValue;
            this.warning("The keyword '" + string + "' in this context means 'child::" + string + "'. If this was intended, use 'child::" + string + "' or './" + string + "' to avoid this warning.");
        }
        return this.parseRelativePath();
    }

    protected Expression parseSimpleMappingExpression() {
        int n2 = this.t.currentTokenStartOffset;
        Expression expression = this.parsePathExpression();
        while (this.t.currentToken == 40) {
            if (!this.allowXPath30Syntax) {
                this.grumble("XPath '!' operator requires XPath 3.0 to be enabled");
            }
            this.nextToken();
            Expression expression2 = this.parsePathExpression();
            expression = new ForEach(expression, expression2);
            this.setLocation(expression, n2);
        }
        return expression;
    }

    protected Expression parseRelativePath() {
        int n2 = this.t.currentTokenStartOffset;
        XPathParser xPathParser = this;
        Expression expression = xPathParser.parseStepExpression(xPathParser.language == 1);
        while (this.t.currentToken == 2 || this.t.currentToken == 8) {
            int n3 = this.t.currentToken;
            this.nextToken();
            Expression expression2 = this.parseStepExpression(false);
            if (n3 == 2) {
                expression = new HomogeneityChecker(new SlashExpression(expression, expression2));
            } else {
                AxisExpression axisExpression = new AxisExpression(5, null);
                this.setLocation(axisExpression, n2);
                expression = ExpressionTool.makePathExpression(expression, axisExpression);
                this.setLocation(expression, n2);
                expression = ExpressionTool.makePathExpression(expression, expression2);
                expression = new HomogeneityChecker(expression);
            }
            this.setLocation(expression, n2);
        }
        return expression;
    }

    protected Expression parseRemainingPath(Expression expression) {
        int n2 = this.t.currentTokenStartOffset;
        int n3 = 2;
        while (true) {
            Expression expression2 = this.parseStepExpression(false);
            if (n3 == 2) {
                expression = new HomogeneityChecker(new SlashExpression(expression, expression2));
            } else if (n3 == 8) {
                Expression expression3 = new AxisExpression(5, null);
                this.setLocation(expression3);
                expression3 = ExpressionTool.makePathExpression(expression3, expression2);
                this.setLocation(expression3);
                expression = ExpressionTool.makePathExpression(expression, expression3);
                expression = new HomogeneityChecker(expression);
            } else {
                if (!this.allowXPath30Syntax) {
                    this.grumble("XPath '!' operator requires XPath 3.0 to be enabled");
                }
                expression = new ForEach(expression, expression2);
            }
            this.setLocation(expression, n2);
            n3 = this.t.currentToken;
            if (n3 != 2 && n3 != 8 && n3 != 40) break;
            this.nextToken();
        }
        return expression;
    }

    protected Expression parseStepExpression(boolean bl2) {
        boolean bl3;
        Expression expression = this.parseBasicStep(bl2);
        boolean bl4 = bl3 = expression instanceof AxisExpression && !AxisInfo.isForwards[((AxisExpression)expression).getAxis()];
        while (true) {
            if (this.t.currentToken == 4) {
                expression = this.parsePredicate(expression);
                continue;
            }
            if (this.t.currentToken == 5) {
                expression = this.parseDynamicFunctionCall(expression, null);
                this.setLocation(expression);
                continue;
            }
            if (this.t.currentToken != 213) break;
            expression = this.parseLookup(expression);
            this.setLocation(expression);
        }
        if (bl3) {
            RetainedStaticContext retainedStaticContext = this.env.makeRetainedStaticContext();
            expression = SystemFunction.makeCall("reverse", retainedStaticContext, expression);
            assert (expression != null);
            return expression;
        }
        return expression;
    }

    protected Expression parsePredicate(Expression expression) {
        this.nextToken();
        Expression expression2 = this.parsePredicate();
        this.expect(203);
        this.nextToken();
        expression = new FilterExpression(expression, expression2);
        this.setLocation(expression);
        return expression;
    }

    protected Expression parseArrowPostfix(Expression expression) {
        this.checkLanguageVersion31();
        this.nextToken();
        int n2 = this.getTokenizer().currentToken;
        if (n2 == 201 || n2 == 35) {
            return this.parseFunctionCall(expression);
        }
        if (n2 == 21) {
            Expression expression2 = this.parseVariableReference();
            this.expect(5);
            return this.parseDynamicFunctionCall(expression2, expression);
        }
        if (n2 == 5) {
            Expression expression3 = this.parseParenthesizedExpression();
            this.expect(5);
            return this.parseDynamicFunctionCall(expression3, expression);
        }
        this.grumble("Unexpected " + Token.tokens[n2] + " after '=>'");
        return null;
    }

    protected Expression parsePredicate() {
        return this.parseExpression();
    }

    protected boolean isReservedInQuery(String string) {
        if (this.allowXPath31Syntax) {
            return NamespaceConstant.isReservedInQuery31(string);
        }
        if (this.allowXPath30Syntax) {
            return NamespaceConstant.isReservedInQuery30(string);
        }
        return NamespaceConstant.isReservedInQuery(string);
    }

    /*
     * WARNING - void declaration
     */
    protected Expression parseBasicStep(boolean bl2) {
        switch (this.t.currentToken) {
            case 21: {
                return this.parseVariableReference();
            }
            case 5: {
                return this.parseParenthesizedExpression();
            }
            case 4: {
                return this.parseArraySquareConstructor();
            }
            case 202: {
                return this.parseStringLiteral(true);
            }
            case 222: {
                return this.parseStringTemplate(true);
            }
            case 77: {
                return this.parseStringTemplate(false);
            }
            case 209: {
                return this.parseNumericLiteral(true);
            }
            case 35: {
                return this.parseFunctionCall(null);
            }
            case 213: {
                return this.parseLookup(new ContextItemExpression());
            }
            case 205: {
                this.nextToken();
                ContextItemExpression contextItemExpression = new ContextItemExpression();
                this.setLocation(contextItemExpression);
                return contextItemExpression;
            }
            case 206: {
                this.nextToken();
                AxisExpression axisExpression = new AxisExpression(9, null);
                this.setLocation(axisExpression);
                return axisExpression;
            }
            case 106: {
                AnnotationList annotationList = this.parseAnnotationsList();
                if (!this.t.currentTokenValue.equals("function")) {
                    this.grumble("Expected 'function' to follow the annotation assertion");
                }
                annotationList.check(this.env.getConfiguration(), "IF");
                return this.parseInlineFunction(annotationList);
            }
            case 69: {
                if (this.t.currentTokenValue.equals("function")) {
                    AnnotationList annotationList = AnnotationList.EMPTY;
                    return this.parseInlineFunction(annotationList);
                }
            }
            case 70: 
            case 201: 
            case 207: 
            case 208: {
                void axisExpression;
                int n2 = 3;
                if (this.t.currentToken == 69 && (this.t.currentTokenValue.equals("attribute") || this.t.currentTokenValue.equals("schema-attribute"))) {
                    n2 = 2;
                } else if (this.t.currentToken == 69 && this.t.currentTokenValue.equals("namespace-node")) {
                    n2 = 8;
                    this.testPermittedAxis((byte)8, "XQST0134");
                } else if (bl2 && this.t.currentToken == 69 && this.t.currentTokenValue.equals("document-node")) {
                    n2 = 12;
                }
                NodeTest object = this.parseNodeTest((short)1);
                if (object instanceof AnyNodeTest) {
                    NodeTest axisExpression2 = n2 == 3 ? AnyChildNodeTest.getInstance() : NodeKindTest.ATTRIBUTE;
                }
                AxisExpression axisExpression3 = new AxisExpression((byte)n2, (NodeTest)axisExpression);
                this.setLocation(axisExpression3);
                return axisExpression3;
            }
            case 3: {
                this.nextToken();
                switch (this.t.currentToken) {
                    case 69: 
                    case 70: 
                    case 201: 
                    case 207: 
                    case 208: {
                        AxisExpression axisExpression = new AxisExpression(2, this.parseNodeTest((short)2));
                        this.setLocation(axisExpression);
                        return axisExpression;
                    }
                }
                this.grumble("@ must be followed by a NodeTest");
                break;
            }
            case 36: {
                void var1_11;
                try {
                    byte by = AxisInfo.getAxisNumber(this.t.currentTokenValue);
                }
                catch (XPathException xPathException) {
                    this.grumble(xPathException.getMessage());
                    int n3 = 3;
                }
                this.testPermittedAxis((byte)var1_11, "XPST0003");
                short s2 = AxisInfo.principalNodeType[var1_11];
                this.nextToken();
                switch (this.t.currentToken) {
                    case 69: 
                    case 70: 
                    case 201: 
                    case 207: 
                    case 208: {
                        AxisExpression axisExpression = new AxisExpression((byte)var1_11, this.parseNodeTest(s2));
                        this.setLocation(axisExpression);
                        return axisExpression;
                    }
                }
                this.grumble("Unexpected token " + this.currentTokenDisplay() + " after axis name");
                break;
            }
            case 60: {
                switch (this.t.currentTokenValue) {
                    case "map": {
                        return this.parseMapExpression();
                    }
                    case "array": {
                        return this.parseArrayCurlyConstructor();
                    }
                    case "fn": {
                        return this.parserExtension.parseSimpleInlineFunction(this);
                    }
                }
            }
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 217: {
                return this.parseConstructor();
            }
            case 43: {
                return this.parseNamedFunctionReference();
            }
            default: {
                this.grumble("Unexpected token " + this.currentTokenDisplay() + " at start of expression");
            }
        }
        return new ErrorExpression();
    }

    public Expression parseParenthesizedExpression() {
        this.nextToken();
        if (this.t.currentToken == 204) {
            this.nextToken();
            return Literal.makeEmptySequence();
        }
        Expression expression = this.parseExpression();
        this.expect(204);
        this.nextToken();
        return expression;
    }

    protected void testPermittedAxis(byte by, String string) {
    }

    public Expression parseNumericLiteral(boolean bl2) {
        int n2 = this.t.currentTokenStartOffset;
        IdentityComparable identityComparable = NumericValue.parseNumber(this.t.currentTokenValue);
        if (identityComparable.isNaN()) {
            this.grumble("Invalid numeric literal " + Err.wrap(this.t.currentTokenValue, 4));
        }
        this.nextToken();
        identityComparable = Literal.makeLiteral(identityComparable);
        this.setLocation((Expression)identityComparable, n2);
        if (bl2) {
            return this.makeTracer(n2, (Expression)identityComparable, 0, null);
        }
        return identityComparable;
    }

    protected Expression parseStringLiteral(boolean bl2) {
        int n2 = this.t.currentTokenStartOffset;
        XPathParser xPathParser = this;
        Literal literal = xPathParser.makeStringLiteral(xPathParser.t.currentTokenValue);
        this.nextToken();
        if (bl2) {
            return this.makeTracer(n2, literal, 0, null);
        }
        return literal;
    }

    protected Expression parseStringTemplate(boolean bl2) {
        this.grumble("String constructor expressions are allowed only in XQuery");
        return null;
    }

    public Expression parseVariableReference() {
        int n2 = this.t.currentTokenStartOffset;
        this.nextToken();
        this.expect(201);
        Expression[] expressionArray = this.t.currentTokenValue;
        this.nextToken();
        if (this.scanOnly) {
            return new ContextItemExpression();
        }
        expressionArray = this.makeStructuredQName((String)expressionArray, "");
        assert (expressionArray != null);
        Object object = this.findRangeVariable((StructuredQName)expressionArray);
        if (object != null) {
            expressionArray = new LocalVariableReference((LocalBinding)object);
        } else {
            if (this.catchDepth > 0) {
                object = StandardNames.errorVariables;
                int n3 = StandardNames.errorVariables.length;
                for (int i2 = 0; i2 < n3; ++i2) {
                    StructuredQName structuredQName = object[i2];
                    if (!structuredQName.getLocalPart().equals(expressionArray.getLocalPart())) continue;
                    Object object2 = new StructuredQName("saxon", "http://saxon.sf.net/", "dynamic-error-info");
                    object2 = new SymbolicName.F((StructuredQName)object2, 1);
                    expressionArray = new Expression[]{new StringLiteral(expressionArray.getLocalPart())};
                    return VendorFunctionSetHE.getInstance().bind((SymbolicName.F)object2, expressionArray, this.env, new ArrayList<String>());
                }
            }
            try {
                expressionArray = this.env.bindVariable((StructuredQName)expressionArray);
            }
            catch (XPathException xPathException) {
                object = xPathException;
                xPathException.maybeSetLocation(this.makeLocation());
                throw object;
            }
        }
        this.setLocation((Expression)expressionArray, n2);
        return expressionArray;
    }

    protected Literal makeStringLiteral(String object) {
        object = new StringLiteral((CharSequence)object);
        this.setLocation((Expression)object);
        return object;
    }

    protected CharSequence unescape(String string) {
        return string;
    }

    protected Expression parseConstructor() {
        this.grumble("Node constructor expressions are allowed only in XQuery, not in XPath");
        return new ErrorExpression();
    }

    public Expression parseDynamicFunctionCall(Expression expression, Expression object) {
        this.checkLanguageVersion30();
        ArrayList<Expression> arrayList = new ArrayList<Expression>(10);
        if (object != null) {
            arrayList.add((Expression)object);
        }
        object = null;
        this.nextToken();
        if (this.t.currentToken != 204) {
            while (true) {
                Expression expression2;
                if ((expression2 = this.parseFunctionArgument()) == null) {
                    if (object == null) {
                        object = new IntArraySet();
                    }
                    object.add(arrayList.size());
                    expression2 = Literal.makeEmptySequence();
                    this.checkHofFeature();
                }
                arrayList.add(expression2);
                if (this.t.currentToken != 7) break;
                this.nextToken();
            }
            this.expect(204);
        }
        this.nextToken();
        if (object == null) {
            return this.generateApplyCall(expression, arrayList);
        }
        return this.parserExtension.createDynamicCurriedFunction(this, expression, arrayList, (IntSet)object);
    }

    protected Expression generateApplyCall(Expression expression, ArrayList<Expression> object) {
        object = new SquareArrayConstructor((List<Expression>)object);
        RetainedStaticContext retainedStaticContext = new RetainedStaticContext(this.getStaticContext());
        SystemFunction systemFunction = VendorFunctionSetHE.getInstance().makeFunction("apply", 2);
        systemFunction.setRetainedStaticContext(retainedStaticContext);
        object = systemFunction.makeFunctionCall(new Expression[]{expression, object});
        ((ApplyFn)systemFunction).setDynamicFunctionCall(expression.toShortString());
        this.setLocation((Expression)object, this.t.currentTokenStartOffset);
        return object;
    }

    protected Expression parseLookup(Expression expression) {
        this.checkLanguageVersion31();
        Object object = this.getTokenizer();
        int n2 = ((Tokenizer)object).currentTokenStartOffset;
        ((Tokenizer)object).setState(1);
        ((Tokenizer)object).currentToken = 5;
        this.nextToken();
        int n3 = ((Tokenizer)object).currentToken;
        ((Tokenizer)object).setState(3);
        if (n3 == 201) {
            object = ((Tokenizer)object).currentTokenValue;
            if (!NameChecker.isValidNCName((CharSequence)object)) {
                this.grumble("The name following '?' must be a valid NCName");
            }
            this.nextToken();
            expression = new LookupExpression(expression, new StringLiteral((CharSequence)object));
        } else if (n3 == 209) {
            object = NumericValue.parseNumber(((Tokenizer)object).currentTokenValue);
            if (!(object instanceof IntegerValue)) {
                this.grumble("Number following '?' must be an integer");
            }
            this.nextToken();
            expression = XPathParser.a(expression, Literal.makeLiteral(object));
        } else if (n3 == 17 || n3 == 207) {
            this.nextToken();
            expression = new LookupAllExpression(expression);
        } else if (n3 == 5) {
            expression = XPathParser.a(expression, this.parseParenthesizedExpression());
        } else {
            this.grumble("Unexpected " + Token.tokens[n3] + " after '?'");
            return null;
        }
        this.setLocation(expression, n2);
        return expression;
    }

    private static LookupExpression a(Expression expression, Expression expression2) {
        return new LookupExpression(expression, expression2);
    }

    protected NodeTest parseNodeTest(short s2) {
        int n2 = this.t.currentToken;
        String string = this.t.currentTokenValue;
        switch (n2) {
            case 201: {
                this.nextToken();
                return this.makeNameTest(s2, string, s2 == 1);
            }
            case 208: {
                this.nextToken();
                return this.makeNamespaceTest(s2, string);
            }
            case 70: {
                this.nextToken();
                string = this.t.currentTokenValue;
                this.expect(201);
                this.nextToken();
                return this.makeLocalNameTest(s2, string);
            }
            case 207: {
                this.nextToken();
                return NodeKindTest.makeNodeKindTest(s2);
            }
            case 69: {
                return this.c();
            }
        }
        this.grumble("Unrecognized node test");
        throw new XPathException("");
    }

    /*
     * Unable to fully structure code
     */
    private NodeTest c() {
        var1_1 = this.env.getConfiguration().getNamePool();
        var2_2 = this.t.currentTokenValue;
        var3_4 = var2_2.startsWith("schema-");
        var2_3 = this.c(var2_2);
        var4_8 = -1;
        var5_9 = false;
        this.nextToken();
        if (this.t.currentToken == 204) {
            if (var3_4) {
                this.grumble("schema-element() and schema-attribute() require a name to be supplied");
                return null;
            }
            var5_9 = true;
            this.nextToken();
        }
        switch (var2_3) {
            case 88: {
                this.grumble("item() is not allowed in a path expression");
                return null;
            }
            case 0: {
                if (var5_9) {
                    return AnyNodeTest.getInstance();
                }
                this.grumble("Expected ')': no arguments are allowed in node()");
                return null;
            }
            case 3: {
                if (var5_9) {
                    return NodeKindTest.TEXT;
                }
                this.grumble("Expected ')': no arguments are allowed in text()");
                return null;
            }
            case 8: {
                if (var5_9) {
                    return NodeKindTest.COMMENT;
                }
                this.grumble("Expected ')': no arguments are allowed in comment()");
                return null;
            }
            case 13: {
                if (var5_9) {
                    if (!this.isNamespaceTestAllowed()) {
                        this.grumble("namespace-node() test is not allowed in XPath 2.0/XQuery 1.0");
                    }
                    return NodeKindTest.NAMESPACE;
                }
                if (this.language == 4 && this.t.currentToken == 201) {
                    var6_12 = this.t.currentTokenValue;
                    this.nextToken();
                    this.expect(204);
                    this.nextToken();
                    return new NameTest(13, "", var6_12, (NamePool)var1_1);
                }
                this.grumble("No arguments are allowed in namespace-node()");
                return null;
            }
            case 9: {
                if (var5_9) {
                    return NodeKindTest.DOCUMENT;
                }
                try {
                    v0 = this;
                    var6_13 = v0.c(v0.t.currentTokenValue);
                }
                catch (XPathException v1) {
                    var6_13 = 88;
                }
                if (var6_13 != 1) {
                    this.grumble("Argument to document-node() must be an element type descriptor");
                    return null;
                }
                var5_10 = this.c();
                this.expect(204);
                this.nextToken();
                return new DocumentNodeTest(var5_10);
            }
            case 7: {
                if (var5_9) {
                    return NodeKindTest.PROCESSING_INSTRUCTION;
                }
                if (this.t.currentToken != 202) ** GOTO lbl73
                v2 = this;
                var6_14 = Whitespace.trim(v2.unescape(v2.t.currentTokenValue));
                if (!NameChecker.isValidNCName(var6_14)) {
                    this.grumble("Processing instruction name must be a valid NCName", "XPTY0004");
                } else {
                    var4_8 = var1_1.allocateFingerprint("", var6_14);
                }
                ** GOTO lbl85
lbl73:
                // 1 sources

                if (this.t.currentToken != 201) ** GOTO lbl84
                try {
                    var6_15 = NameChecker.getQNameParts(this.t.currentTokenValue);
                    if (!var6_15[0].isEmpty()) ** GOTO lbl79
                    var4_8 = var1_1.allocateFingerprint("", var6_15[1]);
                    ** GOTO lbl85
lbl79:
                    // 1 sources

                    this.grumble("Processing instruction name must not contain a colon");
                }
                catch (QNameException var6_16) {
                    this.grumble("Invalid processing instruction name. " + var6_16.getMessage());
                }
                ** GOTO lbl85
lbl84:
                // 1 sources

                this.grumble("Processing instruction name must be a QName or a string literal");
lbl85:
                // 6 sources

                this.nextToken();
                this.expect(204);
                this.nextToken();
                return new NameTest(7, var4_8, (NamePool)var1_1);
            }
            case 1: 
            case 2: {
                var6_17 = "";
                if (var5_9) {
                    return NodeKindTest.makeNodeKindTest(var2_3);
                }
                if (this.t.currentToken == 207 || this.t.currentToken == 17) {
                    if (var3_4) {
                        this.grumble("schema-element() and schema-attribute() must specify an actual name, not '*'");
                        return null;
                    }
                    var4_8 = -1;
                } else if (this.t.currentToken == 201) {
                    var6_17 = this.t.currentTokenValue;
                    v3 = this;
                    var4_8 = v3.makeFingerprint(v3.t.currentTokenValue, var2_3 == 1);
                } else {
                    this.grumble("Unexpected " + Token.tokens[this.t.currentToken] + " after '(' in SequenceType");
                }
                var5_11 = null;
                if (var4_8 != -1) {
                    var5_11 = var1_1.getURI(var4_8);
                }
                this.nextToken();
                if (this.t.currentToken == 204) {
                    this.nextToken();
                    if (var4_8 == -1) {
                        return NodeKindTest.makeNodeKindTest(var2_3);
                    }
                    if (var2_3 == 2) {
                        if (var3_4) {
                            var3_5 = this.env.getConfiguration().getAttributeDeclaration(var4_8 & 1048575);
                            if (!this.env.isImportedSchema((String)var5_11)) {
                                this.grumble("No schema has been imported for namespace '" + (String)var5_11 + '\'', "XPST0008");
                            }
                            if (var3_5 == null) {
                                this.grumble("There is no declaration for attribute @" + var6_17 + " in an imported schema", "XPST0008");
                                return null;
                            }
                            return var3_5.makeSchemaNodeTest();
                        }
                        var1_1 = new NameTest(2, var4_8, (NamePool)var1_1);
                        return var1_1;
                    }
                    if (var3_4) {
                        if (!this.env.isImportedSchema((String)var5_11)) {
                            this.grumble("No schema has been imported for namespace '" + (String)var5_11 + '\'', "XPST0008");
                        }
                        if ((var3_6 = this.env.getConfiguration().getElementDeclaration(var4_8 & 1048575)) == null) {
                            this.grumble("There is no declaration for element <" + var6_17 + "> in an imported schema", "XPST0008");
                            return null;
                        }
                        return var3_6.makeSchemaNodeTest();
                    }
                    var1_1 = new NameTest(1, var4_8, (NamePool)var1_1);
                    return var1_1;
                }
                if (this.t.currentToken == 7) {
                    if (var3_4) {
                        this.grumble("schema-element() and schema-attribute() must have one argument only");
                        return null;
                    }
                    this.nextToken();
                    if (this.t.currentToken == 207) {
                        this.grumble("'*' is no longer permitted as the second argument of element() and attribute()");
                        return null;
                    }
                    if (this.t.currentToken == 201) {
                        v4 = this;
                        var5_11 = v4.makeStructuredQName(v4.t.currentTokenValue, this.env.getDefaultElementNamespace());
                        if (!XPathParser.f && var5_11 == null) {
                            throw new AssertionError();
                        }
                        var3_7 = var5_11.getURI();
                        var5_11.getLocalPart();
                        if (!var3_7.equals("http://www.w3.org/2001/XMLSchema") && !this.env.isImportedSchema((String)var3_7)) {
                            this.grumble("No schema has been imported for namespace '" + (String)var3_7 + '\'', "XPST0008");
                        }
                        if ((var3_7 = this.env.getConfiguration().getSchemaType((StructuredQName)var5_11)) == null) {
                            this.grumble("Unknown type name " + var5_11.getEQName(), "XPST0008");
                            return null;
                        }
                        if (var2_3 == 2 && var3_7.isComplexType()) {
                            this.warning("An attribute cannot have a complex type");
                        }
                        var5_11 = new ContentTypeTest(var2_3, (SchemaType)var3_7, this.env.getConfiguration(), false);
                        if (var4_8 == -1) {
                            var1_1 = var5_11;
                            if (var2_3 == 2) {
                                this.nextToken();
                            } else {
                                this.nextToken();
                                if (this.t.currentToken == 213) {
                                    var5_11.setNillable(true);
                                    this.nextToken();
                                }
                            }
                        } else if (var2_3 == 2) {
                            var1_1 = new NameTest(2, var4_8, (NamePool)var1_1);
                            if (var3_7 != AnyType.getInstance() && var3_7 != AnySimpleType.getInstance()) {
                                var1_1 = new CombinedNodeTest((NodeTest)var1_1, 23, (NodeTest)var5_11);
                            }
                            this.nextToken();
                        } else {
                            var1_1 = new NameTest(1, var4_8, (NamePool)var1_1);
                            var1_1 = new CombinedNodeTest((NodeTest)var1_1, 23, (NodeTest)var5_11);
                            this.nextToken();
                            if (this.t.currentToken == 213) {
                                var5_11.setNillable(true);
                                this.nextToken();
                            }
                        }
                    } else {
                        this.grumble("Unexpected " + Token.tokens[this.t.currentToken] + " after ',' in SequenceType");
                        return null;
                    }
                    this.expect(204);
                    this.nextToken();
                    return var1_1;
                }
                this.grumble("Expected ')' or ',' in SequenceType");
                return null;
            }
        }
        this.grumble("Unknown node kind");
        return null;
    }

    protected boolean isNamespaceTestAllowed() {
        return this.allowXPath30Syntax;
    }

    private int c(String string) {
        if ("item".equals(string)) {
            return 88;
        }
        if ("document-node".equals(string)) {
            return 9;
        }
        if ("element".equals(string)) {
            return 1;
        }
        if ("schema-element".equals(string)) {
            return 1;
        }
        if ("attribute".equals(string)) {
            return 2;
        }
        if ("schema-attribute".equals(string)) {
            return 2;
        }
        if ("text".equals(string)) {
            return 3;
        }
        if ("comment".equals(string)) {
            return 8;
        }
        if ("processing-instruction".equals(string)) {
            return 7;
        }
        if ("namespace-node".equals(string)) {
            return 13;
        }
        if ("node".equals(string)) {
            return 0;
        }
        this.grumble("Unknown type " + string);
        return -1;
    }

    protected void checkLanguageVersion30() {
        if (!this.allowXPath30Syntax) {
            this.grumble("To use XPath 3.0 syntax, you must configure the XPath parser to handle it");
        }
    }

    protected void checkLanguageVersion31() {
        if (!this.allowXPath31Syntax) {
            this.grumble("The XPath parser is not configured to allow use of XPath 3.1 syntax");
        }
    }

    protected void checkMapExtensions() {
        if (!this.allowXPath31Syntax && !this.allowXPath30XSLTExtensions) {
            this.grumble("The XPath parser is not configured to allow use of the map syntax from XSLT 3.0 or XPath 3.1");
        }
    }

    public void checkSyntaxExtensions(String string) {
        if (!this.allowSaxonExtensions) {
            this.grumble("Saxon XPath syntax extensions have not been enabled: " + string + " is not allowed");
        }
    }

    protected Expression parseMapExpression() {
        Object object;
        Expression expression;
        this.checkMapExtensions();
        Object object2 = this.getTokenizer();
        int n2 = ((Tokenizer)object2).currentTokenStartOffset;
        ArrayList<Expression> arrayList = new ArrayList<Expression>();
        this.nextToken();
        if (((Tokenizer)object2).currentToken != 215) {
            while (true) {
                expression = this.parseExprSingle();
                if (((Tokenizer)object2).currentToken == 58) {
                    this.grumble("The ':=' notation is no longer accepted in map expressions: use ':' instead");
                }
                this.expect(75);
                this.nextToken();
                object = this.parseExprSingle();
                expression = expression instanceof Literal && ((Literal)expression).getValue() instanceof AtomicValue && object instanceof Literal ? Literal.makeLiteral(new SingleEntryMap((AtomicValue)((Literal)expression).getValue(), ((Literal)object).getValue())) : MapFunctionSet.getInstance().makeFunction("entry", 2).makeFunctionCall(new Expression[]{expression, object});
                arrayList.add(expression);
                if (((Tokenizer)object2).currentToken == 215) break;
                this.expect(7);
                this.nextToken();
            }
        }
        ((Tokenizer)object2).lookAhead();
        this.nextToken();
        switch (arrayList.size()) {
            case 0: {
                expression = Literal.makeLiteral(new HashTrieMap());
                break;
            }
            case 1: {
                expression = (Expression)arrayList.get(0);
                break;
            }
            default: {
                object = new Expression[arrayList.size()];
                expression = new Block(arrayList.toArray((T[])object));
                object2 = new DictionaryMap();
                ((DictionaryMap)object2).initialPut("duplicates", new StringValue("reject"));
                ((DictionaryMap)object2).initialPut("duplicates-error-code", new StringValue("XQDY0137"));
                expression = MapFunctionSet.getInstance().makeFunction("merge", 2).makeFunctionCall(expression, Literal.makeLiteral(object2));
            }
        }
        this.setLocation(expression, n2);
        return expression;
    }

    protected Expression parseArraySquareConstructor() {
        Expression expression;
        this.checkLanguageVersion31();
        Tokenizer tokenizer = this.getTokenizer();
        int n2 = tokenizer.currentTokenStartOffset;
        ArrayList<Expression> arrayList = new ArrayList<Expression>();
        this.nextToken();
        if (tokenizer.currentToken == 203) {
            this.nextToken();
            SquareArrayConstructor squareArrayConstructor = new SquareArrayConstructor(arrayList);
            this.setLocation(squareArrayConstructor, n2);
            return squareArrayConstructor;
        }
        while (true) {
            expression = this.parseExprSingle();
            arrayList.add(expression);
            if (tokenizer.currentToken != 7) break;
            this.nextToken();
        }
        if (tokenizer.currentToken != 203) {
            this.grumble("Expected ',' or ']', found " + Token.tokens[tokenizer.currentToken]);
            return new ErrorExpression();
        }
        this.nextToken();
        expression = new SquareArrayConstructor(arrayList);
        this.setLocation(expression, n2);
        return expression;
    }

    protected Expression parseArrayCurlyConstructor() {
        this.checkLanguageVersion31();
        Object object = this.getTokenizer();
        int n2 = ((Tokenizer)object).currentTokenStartOffset;
        this.nextToken();
        if (((Tokenizer)object).currentToken == 215) {
            ((Tokenizer)object).lookAhead();
            this.nextToken();
            return Literal.makeLiteral(SimpleArrayItem.EMPTY_ARRAY);
        }
        Expression expression = this.parseExpression();
        this.expect(215);
        ((Tokenizer)object).lookAhead();
        this.nextToken();
        object = ArrayFunctionSet.getInstance().makeFunction("_from-sequence", 1);
        object = ((SystemFunction)object).makeFunctionCall(expression);
        this.setLocation((Expression)object, n2);
        return object;
    }

    public Expression parseFunctionCall(Expression identityComparable) {
        Expression[] expressionArray;
        Object object = this.t.currentTokenValue;
        int n2 = this.t.currentTokenStartOffset;
        Expression[] expressionArray2 = new ArrayList(10);
        if (identityComparable != null) {
            expressionArray2.add(identityComparable);
        }
        identityComparable = this.resolveFunctionName((String)object);
        object = null;
        this.nextToken();
        if (this.t.currentToken != 204) {
            while (true) {
                if ((expressionArray = this.parseFunctionArgument()) == null) {
                    if (object == null) {
                        object = new IntArraySet();
                    }
                    object.add(expressionArray2.size());
                    expressionArray = Literal.makeEmptySequence();
                }
                expressionArray2.add(expressionArray);
                if (this.t.currentToken != 7) break;
                this.nextToken();
            }
            this.expect(204);
        }
        this.nextToken();
        if (this.scanOnly) {
            return new StringLiteral(StringValue.EMPTY_STRING);
        }
        expressionArray = new Expression[expressionArray2.size()];
        expressionArray2.toArray(expressionArray);
        if (object != null) {
            return this.parserExtension.makeCurriedFunction(this, n2, (StructuredQName)identityComparable, expressionArray, (IntSet)object);
        }
        object = new SymbolicName.F((StructuredQName)identityComparable, expressionArray2.size());
        expressionArray2 = new ArrayList();
        object = this.env.getFunctionLibrary().bind((SymbolicName.F)object, expressionArray, this.env, (List<String>)expressionArray2);
        if (object == null) {
            return this.reportMissingFunction(n2, (StructuredQName)identityComparable, expressionArray, (List<String>)expressionArray2);
        }
        if (this.language == 1) {
            if (((Expression)object).isCallOn(RegexGroup.class)) {
                return Literal.makeEmptySequence();
            }
            if (object instanceof CurrentGroupCall) {
                this.grumble("The current-group() function cannot be used in a pattern", "XTSE1060", n2);
                return new ErrorExpression();
            }
            if (object instanceof CurrentGroupingKeyCall) {
                this.grumble("The current-grouping-key() function cannot be used in a pattern", "XTSE1070", n2);
                return new ErrorExpression();
            }
            if (((Expression)object).isCallOn(CurrentMergeGroup.class)) {
                this.grumble("The current-merge-group() function cannot be used in a pattern", "XTSE3470", n2);
                return new ErrorExpression();
            }
            if (((Expression)object).isCallOn(CurrentMergeKey.class)) {
                this.grumble("The current-merge-key() function cannot be used in a pattern", "XTSE3500", n2);
                return new ErrorExpression();
            }
        }
        this.setLocation((Expression)object, n2);
        expressionArray2 = expressionArray;
        int n3 = expressionArray.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            Expression expression = expressionArray2[i2];
            if (object == expression || ((StructuredQName)identityComparable).hasURI("http://saxonica.com/ns/globalJS")) continue;
            ((Expression)object).adoptChildExpression(expression);
        }
        return this.makeTracer(n2, (Expression)object, 2009, (StructuredQName)identityComparable);
    }

    public Expression reportMissingFunction(int n2, StructuredQName structuredQName, Expression[] expressionArray, List<String> object) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Cannot find a ").append(expressionArray.length).append("-argument function named ").append(structuredQName.getEQName()).append("()");
        Configuration configuration = this.env.getConfiguration();
        object = object.iterator();
        while (object.hasNext()) {
            String string = (String)object.next();
            stringBuilder.append(". ").append(string);
        }
        if (configuration.getBooleanProperty(Feature.ALLOW_EXTERNAL_FUNCTIONS)) {
            boolean bl2 = false;
            for (int i2 = 0; i2 < expressionArray.length + 5; ++i2) {
                if (i2 == expressionArray.length) continue;
                SymbolicName.F f2 = new SymbolicName.F(structuredQName, i2);
                if (!this.env.getFunctionLibrary().isAvailable(f2)) continue;
                bl2 = true;
                break;
            }
            if (bl2) {
                stringBuilder.append(". The namespace URI and local name are recognized, but the number of arguments is wrong");
            } else {
                String string = XPathParser.getMissingFunctionExplanation(structuredQName, configuration);
                if (string != null) {
                    stringBuilder.append(". ").append(string);
                }
            }
        } else {
            stringBuilder.append(". External function calls have been disabled");
        }
        if (this.env.isInBackwardsCompatibleMode()) {
            return new ErrorExpression(stringBuilder.toString(), "XTDE1425", false);
        }
        this.grumble(stringBuilder.toString(), "XPST0017", n2);
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getMissingFunctionExplanation(StructuredQName structuredQName, Configuration objectArray) {
        String string = structuredQName.getURI();
        String string2 = NamespaceConstant.findSimilarNamespace(string);
        if (string2 != null) {
            if (!string2.equals(string)) return "Perhaps the intended namespace was '" + string2 + "'";
            switch (string2) {
                case "http://www.w3.org/2005/xpath-functions": {
                    objectArray = new String[]{"apply", "filter", "fold-left", "fold-right", "for-each", "for-each-pair", "function-arity", "function-lookup", "function-name", "load-xquery-module", "random-number-generator"};
                    if (Arrays.binarySearch(objectArray, structuredQName.getLocalPart()) < 0) return null;
                    return "Higher-order functions are not available in this Configuration";
                }
                case "http://saxon.sf.net/": {
                    if (objectArray.getEditionCode().equals("HE")) {
                        return "Saxon extension functions are not available under Saxon-HE";
                    }
                    if (objectArray.isLicensedFeature(8)) return null;
                    return "Saxon extension functions require a Saxon-PE or Saxon-EE license";
                }
                case "http://www.w3.org/1999/XSL/Transform": {
                    if (!structuredQName.getLocalPart().equals("original")) return "There are no functions defined in the XSLT namespace";
                    return "Function name xsl:original is only available within an overriding function";
                }
            }
            return null;
        } else {
            if (string.contains("java")) {
                if (objectArray.getEditionCode().equals("HE")) {
                    return "Reflexive calls to Java methods are not available under Saxon-HE";
                }
                if (objectArray.isLicensedFeature(8)) return "For diagnostics on calls to Java methods, use the -TJ command line option or set the Configuration property FeatureKeys.TRACE_EXTERNAL_FUNCTIONS";
                return "Reflexive calls to Java methods require a Saxon-PE or Saxon-EE license, and none was found";
            }
            if (!string.startsWith("clitype:")) return null;
            if (objectArray.getEditionCode().equals("HE")) {
                return "Reflexive calls to external .NET methods are not available under Saxon-HE";
            }
            if (objectArray.isLicensedFeature(8)) return "For diagnostics on calls to .NET methods, use the -TJ command line option or call processor.SetProperty(\"http://saxon.sf.net/feature/trace-external-functions\", \"true\")";
            return "Reflexive calls to external .NET methods require a Saxon-PE or Saxon-EE license, and none was found";
        }
    }

    protected StructuredQName resolveFunctionName(String object) {
        StructuredQName structuredQName;
        block4: {
            if (this.scanOnly) {
                return new StructuredQName("", "http://saxon.sf.net/", "dummy");
            }
            structuredQName = null;
            this.qNameParser.setDefaultNamespace(this.env.getDefaultFunctionNamespace());
            try {
                structuredQName = this.qNameParser.parse((CharSequence)object);
            }
            catch (XPathException xPathException) {
                this.grumble(xPathException.getMessage(), xPathException.getErrorCodeLocalPart());
                if (f) break block4;
                throw new AssertionError();
            }
        }
        if (structuredQName.hasURI("http://www.w3.org/2001/XMLSchema") && (object = Type.getBuiltInItemType(structuredQName.getURI(), structuredQName.getLocalPart())) instanceof BuiltInAtomicType) {
            XPathParser xPathParser = this;
            xPathParser.a(xPathParser.env, (BuiltInAtomicType)object);
        }
        return structuredQName;
    }

    public Expression parseFunctionArgument() {
        int n2;
        if (this.t.currentToken == 213 && ((n2 = this.t.peekAhead()) == 7 || n2 == 204)) {
            this.nextToken();
            return this.parserExtension.makeArgumentPlaceMarker(this);
        }
        return this.parseExprSingle();
    }

    protected Expression parseNamedFunctionReference() {
        return this.parserExtension.parseNamedFunctionReference(this);
    }

    protected AnnotationList parseAnnotationsList() {
        this.grumble("Inline functions are not allowed in Saxon-HE");
        return null;
    }

    protected Expression parseInlineFunction(AnnotationList annotationList) {
        return this.parserExtension.parseInlineFunction(this, annotationList);
    }

    protected Expression makeCurriedFunction(int n2, StructuredQName structuredQName, Expression[] expressionArray, IntSet intSet) {
        this.grumble("Partial function application is not allowed in Saxon-HE");
        return new ErrorExpression();
    }

    protected static boolean isReservedFunctionName30(String string) {
        int n2 = Arrays.binarySearch(c, string);
        return n2 >= 0;
    }

    public static boolean isReservedFunctionName31(String string) {
        int n2 = Arrays.binarySearch(d, string);
        return n2 >= 0;
    }

    public Stack<LocalBinding> getRangeVariables() {
        return this.rangeVariables;
    }

    public void setRangeVariables(Stack<LocalBinding> stack) {
        this.rangeVariables = stack;
    }

    public void declareRangeVariable(LocalBinding localBinding) {
        this.rangeVariables.push(localBinding);
    }

    public void undeclareRangeVariable() {
        this.rangeVariables.pop();
    }

    protected LocalBinding findRangeVariable(StructuredQName structuredQName) {
        for (int i2 = this.rangeVariables.size() - 1; i2 >= 0; --i2) {
            LocalBinding localBinding = (LocalBinding)this.rangeVariables.elementAt(i2);
            if (!localBinding.getVariableQName().equals(structuredQName)) continue;
            return localBinding;
        }
        return this.parserExtension.findOuterRangeVariable(this, structuredQName);
    }

    public void setRangeVariableStack(Stack<LocalBinding> stack) {
        this.rangeVariables = stack;
    }

    public final int makeFingerprint(String object, boolean bl2) {
        if (this.scanOnly) {
            return 386;
        }
        try {
            this.qNameParser.setDefaultNamespace(bl2 ? this.env.getDefaultElementNamespace() : "");
            object = this.qNameParser.parse((CharSequence)object);
            return this.env.getConfiguration().getNamePool().allocateFingerprint(((StructuredQName)object).getURI(), ((StructuredQName)object).getLocalPart());
        }
        catch (XPathException xPathException) {
            this.grumble(xPathException.getMessage(), xPathException.getErrorCodeLocalPart());
            return -1;
        }
    }

    public final StructuredQName makeStructuredQNameSilently(String string, String string2) {
        if (this.scanOnly) {
            return new StructuredQName("", "http://saxon.sf.net/", "dummy");
        }
        this.qNameParser.setDefaultNamespace(string2);
        return this.qNameParser.parse(string);
    }

    public final StructuredQName makeStructuredQName(String string, String string2) {
        try {
            return this.makeStructuredQNameSilently(string, string2);
        }
        catch (XPathException xPathException) {
            this.grumble(xPathException.getMessage(), xPathException.getErrorCodeLocalPart());
            return new StructuredQName("", "", "error");
        }
    }

    public final NodeName makeNodeName(String string, boolean bl2) {
        Object object = this.makeStructuredQNameSilently(string, bl2 ? this.env.getDefaultElementNamespace() : "");
        String string2 = ((StructuredQName)object).getPrefix();
        String string3 = ((StructuredQName)object).getURI();
        object = ((StructuredQName)object).getLocalPart();
        if (string3.isEmpty()) {
            int n2 = this.env.getConfiguration().getNamePool().allocateFingerprint("", string);
            return new NoNamespaceName(string, n2);
        }
        int n3 = this.env.getConfiguration().getNamePool().allocateFingerprint(string3, (String)object);
        return new FingerprintedQName(string2, string3, (String)object, n3);
    }

    public NameTest makeNameTest(short s2, String object, boolean bl2) {
        NamePool namePool = this.env.getConfiguration().getNamePool();
        object = this.makeStructuredQName((String)object, bl2 ? this.env.getDefaultElementNamespace() : "");
        assert (object != null);
        int n2 = namePool.allocateFingerprint(((StructuredQName)object).getURI(), ((StructuredQName)object).getLocalPart());
        return new NameTest((int)s2, n2, namePool);
    }

    public NamespaceTest makeNamespaceTest(short s2, String object) {
        NamePool namePool = this.env.getConfiguration().getNamePool();
        if (this.scanOnly) {
            return new NamespaceTest(namePool, s2, "http://saxon.sf.net/");
        }
        if (((String)object).startsWith("Q{")) {
            object = ((String)object).substring(2, ((String)object).length() - 2);
            return new NamespaceTest(namePool, s2, (String)object);
        }
        try {
            object = this.qNameParser.parse((String)object + ":dummy");
            return new NamespaceTest(namePool, s2, ((StructuredQName)object).getURI());
        }
        catch (XPathException xPathException) {
            this.grumble(xPathException.getMessage(), xPathException.getErrorCodeLocalPart());
            return null;
        }
    }

    public LocalNameTest makeLocalNameTest(short s2, String string) {
        if (!NameChecker.isValidNCName(string)) {
            this.grumble("Local name [" + string + "] contains invalid characters");
        }
        return new LocalNameTest(this.env.getConfiguration().getNamePool(), s2, string);
    }

    protected void setLocation(Expression expression) {
        this.setLocation(expression, this.t.currentTokenStartOffset);
    }

    public void setLocation(Expression expression, int n2) {
        if (expression != null) {
            int n3 = this.t.getLineNumber(n2);
            n2 = this.t.getColumnNumber(n2);
            if (expression.getLocation() == null || expression.getLocation() == ExplicitLocation.UNKNOWN_LOCATION) {
                XPathParser xPathParser = this;
                Location location = xPathParser.makeNestedLocation(xPathParser.env.getContainingLocation(), n3, n2, null);
                expression.setLocation(location);
            }
        }
    }

    public void setLocation(Clause clause, int n2) {
        int n3 = this.t.getLineNumber(n2);
        n2 = this.t.getColumnNumber(n2);
        XPathParser xPathParser = this;
        Location location = xPathParser.makeNestedLocation(xPathParser.env.getContainingLocation(), n3, n2, null);
        clause.setLocation(location);
        clause.setPackageData(this.env.getPackageData());
    }

    public Location makeLocation() {
        if (this.t.getLineNumber() == this.e.getLineNumber() && this.t.getColumnNumber() == this.e.getColumnNumber() && (this.env.getSystemId() == null && this.e.getSystemId() == null || this.env.getSystemId().equals(this.e.getSystemId()))) {
            return this.e;
        }
        int n2 = this.t.getLineNumber();
        int n3 = this.t.getColumnNumber();
        this.e = this.makeNestedLocation(this.env.getContainingLocation(), n2, n3, null);
        return this.e;
    }

    public Location makeNestedLocation(Location location, int n2, int n3, String string) {
        if (location instanceof ExplicitLocation && location.getLineNumber() <= 1 && location.getColumnNumber() == -1 && string == null) {
            return new ExplicitLocation(this.env.getSystemId(), n2 + 1, n3 + 1);
        }
        return new NestedLocation(location, n2, n3, string);
    }

    public Expression makeTracer(int n2, Expression expression, int n3, StructuredQName structuredQName) {
        expression.setRetainedStaticContextLocally(this.env.makeRetainedStaticContext());
        if (this.codeInjector != null) {
            return this.codeInjector.inject(expression, this.env, n3, structuredQName);
        }
        return expression;
    }

    protected boolean isKeyword(String string) {
        return this.t.currentToken == 201 && this.t.currentTokenValue.equals(string);
    }

    public void setScanOnly(boolean bl2) {
        this.scanOnly = bl2;
    }

    public void setAllowAbsentExpression(boolean bl2) {
        this.a = bl2;
    }

    public boolean isAllowAbsentExpression(boolean bl2) {
        return this.a;
    }

    public void checkHofFeature() {
        this.env.getConfiguration().checkLicensedFeature(8, "higher-order functions", -1);
    }

    public static class NestedLocation
    implements Location {
        private final Location a;
        private final int b;
        private final int c;
        private String d;

        public NestedLocation(Location location, int n2, int n3) {
            this.a = location.saveLocation();
            this.b = n2;
            this.c = n3;
        }

        public NestedLocation(Location location, int n2, int n3, String string) {
            this.a = location.saveLocation();
            this.b = n2;
            this.c = n3;
            this.d = string;
        }

        public Location getContainingLocation() {
            return this.a;
        }

        @Override
        public int getColumnNumber() {
            return this.c;
        }

        @Override
        public String getSystemId() {
            return this.a.getSystemId();
        }

        @Override
        public String getPublicId() {
            return this.a.getPublicId();
        }

        public int getLocalLineNumber() {
            return this.b;
        }

        @Override
        public int getLineNumber() {
            return this.a.getLineNumber() + this.b;
        }

        public String getNearbyText() {
            return this.d;
        }

        @Override
        public Location saveLocation() {
            return this;
        }
    }

    public static interface Accelerator {
        public Expression parse(Tokenizer var1, StaticContext var2, String var3, int var4, int var5);
    }
}

