/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.sort;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.saxon.expr.sort.AtomicMatchKey;
import net.sf.saxon.expr.sort.CodepointMatchKey;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.tree.util.FastStringBuffer;

public class AlphanumericCollator
implements Serializable,
StringCollator {
    private StringCollator a;
    private static Pattern b = Pattern.compile("\\d+");
    public static final String PREFIX = "http://saxon.sf.net/collation/alphaNumeric?base=";

    public AlphanumericCollator(StringCollator stringCollator) {
        this.a = stringCollator;
    }

    @Override
    public String getCollationURI() {
        return PREFIX + this.a.getCollationURI();
    }

    @Override
    public int compareStrings(CharSequence charSequence, CharSequence charSequence2) {
        charSequence = charSequence.toString();
        charSequence2 = charSequence2.toString();
        int n2 = 0;
        int n3 = 0;
        Matcher matcher = b.matcher(charSequence);
        Matcher matcher2 = b.matcher(charSequence2);
        while (true) {
            BigInteger bigInteger;
            boolean bl2 = matcher.find(n2);
            boolean bl3 = matcher2.find(n3);
            int n4 = bl2 ? matcher.start() : ((String)charSequence).length();
            int n5 = bl3 ? matcher2.start() : ((String)charSequence2).length();
            if ((n2 = this.a.compareStrings(((String)charSequence).substring(n2, n4), ((String)charSequence2).substring(n3, n5))) != 0) {
                return n2;
            }
            if (bl2 && !bl3) {
                return 1;
            }
            if (bl3 && !bl2) {
                return -1;
            }
            if (!bl2) {
                return 0;
            }
            BigInteger bigInteger2 = new BigInteger(((String)charSequence).substring(n4, matcher.end()));
            n2 = bigInteger2.compareTo(bigInteger = new BigInteger(((String)charSequence2).substring(n5, matcher2.end())));
            if (n2 != 0) {
                return n2;
            }
            n2 = matcher.end();
            n3 = matcher2.end();
        }
    }

    @Override
    public boolean comparesEqual(CharSequence charSequence, CharSequence charSequence2) {
        return this.compareStrings(charSequence, charSequence2) == 0;
    }

    @Override
    public AtomicMatchKey getCollationKey(CharSequence charSequence) {
        charSequence = charSequence.toString();
        FastStringBuffer fastStringBuffer = new FastStringBuffer(((String)charSequence).length() << 1);
        int n2 = 0;
        Matcher matcher = b.matcher(charSequence);
        while (true) {
            boolean bl2;
            int n3 = (bl2 = matcher.find(n2)) ? matcher.start() : ((String)charSequence).length();
            fastStringBuffer.append(this.a.getCollationKey(((String)charSequence).substring(n2, n3)).toString());
            if (!bl2) {
                return new CodepointMatchKey(fastStringBuffer);
            }
            n2 = Integer.parseInt(((String)charSequence).substring(n3, matcher.end()));
            fastStringBuffer.append("" + n2);
            n2 = matcher.end();
        }
    }
}

