/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.sort;

import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.sort.AtomicComparer;
import net.sf.saxon.expr.sort.AtomicMatchKey;
import net.sf.saxon.expr.sort.CalendarValueComparer;
import net.sf.saxon.expr.sort.CodepointCollatingComparer;
import net.sf.saxon.expr.sort.CodepointCollator;
import net.sf.saxon.expr.sort.CollatingAtomicComparer;
import net.sf.saxon.expr.sort.ComparisonException;
import net.sf.saxon.expr.sort.DecimalSortComparer;
import net.sf.saxon.expr.sort.DoubleSortComparer;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.om.Item;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.QNameValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.UntypedAtomicValue;

public class AtomicSortComparer
implements AtomicComparer {
    private StringCollator a;
    private transient XPathContext b;
    private int c;
    public static AtomicMatchKey COLLATION_KEY_NaN = new AtomicMatchKey(){

        @Override
        public final AtomicValue asAtomic() {
            return new QNameValue("saxon", "http://saxon.sf.net/collation-key", "NaN");
        }
    };

    public static AtomicComparer makeSortComparer(StringCollator stringCollator, int n2, XPathContext xPathContext) {
        switch (n2) {
            case 513: 
            case 529: 
            case 631: {
                if (stringCollator instanceof CodepointCollator) {
                    return CodepointCollatingComparer.getInstance();
                }
                return new CollatingAtomicComparer(stringCollator);
            }
            case 515: 
            case 533: {
                return DecimalSortComparer.getDecimalSortComparerInstance();
            }
            case 516: 
            case 517: 
            case 635: {
                return DoubleSortComparer.getInstance();
            }
            case 519: 
            case 520: 
            case 521: {
                return new CalendarValueComparer(xPathContext);
            }
        }
        return new AtomicSortComparer(stringCollator, n2, xPathContext);
    }

    protected AtomicSortComparer(StringCollator stringCollator, int n2, XPathContext xPathContext) {
        this.a = stringCollator;
        if (stringCollator == null) {
            this.a = CodepointCollator.getInstance();
        }
        this.b = xPathContext;
        this.c = n2;
    }

    @Override
    public StringCollator getCollator() {
        return this.a;
    }

    @Override
    public AtomicComparer provideContext(XPathContext xPathContext) {
        return new AtomicSortComparer(this.a, this.c, xPathContext);
    }

    public StringCollator getStringCollator() {
        return this.a;
    }

    public int getItemType() {
        return this.c;
    }

    @Override
    public int compareAtomicValues(AtomicValue atomicValue, AtomicValue atomicValue2) {
        if (atomicValue == null) {
            if (atomicValue2 == null) {
                return 0;
            }
            return -1;
        }
        if (atomicValue2 == null) {
            return 1;
        }
        if (atomicValue.isNaN()) {
            if (atomicValue2.isNaN()) {
                return 0;
            }
            return -1;
        }
        if (atomicValue2.isNaN()) {
            return 1;
        }
        if (atomicValue instanceof StringValue && atomicValue2 instanceof StringValue) {
            if (this.a instanceof CodepointCollator) {
                return CodepointCollator.compareCS(atomicValue.getStringValueCS(), atomicValue2.getStringValueCS());
            }
            return this.a.compareStrings(atomicValue.getStringValue(), atomicValue2.getStringValue());
        }
        int n2 = this.b.getImplicitTimezone();
        Comparable comparable = (Comparable)((Object)atomicValue.getXPathComparable(true, this.a, n2));
        Object object = (Comparable)((Object)atomicValue2.getXPathComparable(true, this.a, n2));
        if (comparable == null || object == null) {
            return this.compareNonComparables(atomicValue, atomicValue2);
        }
        try {
            return comparable.compareTo(object);
        }
        catch (ClassCastException classCastException) {
            object = "Cannot compare " + atomicValue.getPrimitiveType().getDisplayName() + " with " + atomicValue2.getPrimitiveType().getDisplayName();
            if (atomicValue instanceof UntypedAtomicValue || atomicValue2 instanceof UntypedAtomicValue) {
                object = (String)object + ". Further information: see http://saxonica.plan.io/issues/3450";
            }
            throw new ClassCastException((String)object);
        }
    }

    protected int compareNonComparables(AtomicValue object, AtomicValue atomicValue) {
        object = new XPathException("Values are not comparable (" + Type.displayTypeName((Item)object) + ", " + Type.displayTypeName(atomicValue) + ')', "XPTY0004");
        throw new ComparisonException((XPathException)object);
    }

    @Override
    public boolean comparesEqual(AtomicValue atomicValue, AtomicValue atomicValue2) {
        return this.compareAtomicValues(atomicValue, atomicValue2) == 0;
    }

    @Override
    public String save() {
        return "AtSC|" + this.c + "|" + this.getCollator().getCollationURI();
    }
}

