/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.sort;

import net.sf.saxon.expr.sort.AtomicMatchKey;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.trans.XPathException;

public class CaseFirstCollator
implements StringCollator {
    private StringCollator a;
    private boolean b;
    private String c;

    public CaseFirstCollator(StringCollator stringCollator, boolean bl2, String string) {
        this.a = stringCollator;
        this.b = bl2;
        this.c = string;
    }

    public static StringCollator makeCaseOrderedCollator(String string, StringCollator stringCollator, String string2) {
        int n2 = -1;
        switch (string2.hashCode()) {
            case -2061955868: {
                if (!string2.equals("lower-first")) break;
                n2 = 0;
                break;
            }
            case -1483883067: {
                if (!string2.equals("upper-first")) break;
                n2 = 1;
            }
        }
        switch (n2) {
            case 0: {
                stringCollator = new CaseFirstCollator(stringCollator, false, string);
                break;
            }
            case 1: {
                stringCollator = new CaseFirstCollator(stringCollator, true, string);
                break;
            }
            default: {
                throw new XPathException("case-order must be lower-first, upper-first, or #default");
            }
        }
        return stringCollator;
    }

    @Override
    public String getCollationURI() {
        return this.c;
    }

    @Override
    public int compareStrings(CharSequence charSequence, CharSequence charSequence2) {
        int n2 = this.a.compareStrings(charSequence, charSequence2);
        if (n2 != 0) {
            return n2;
        }
        n2 = 0;
        int n3 = 0;
        while (true) {
            boolean bl2;
            if (n2 < charSequence.length() && n3 < charSequence2.length() && charSequence.charAt(n2) == charSequence2.charAt(n3)) {
                ++n2;
                ++n3;
                continue;
            }
            while (n2 < charSequence.length() && !Character.isLetter(charSequence.charAt(n2))) {
                ++n2;
            }
            while (n3 < charSequence2.length() && !Character.isLetter(charSequence2.charAt(n3))) {
                ++n3;
            }
            if (n2 >= charSequence.length()) {
                return 0;
            }
            if (n3 >= charSequence2.length()) {
                return 0;
            }
            boolean bl3 = this.b ? Character.isUpperCase(charSequence.charAt(n2++)) : Character.isLowerCase(charSequence.charAt(n2++));
            boolean bl4 = bl2 = this.b ? Character.isUpperCase(charSequence2.charAt(n3++)) : Character.isLowerCase(charSequence2.charAt(n3++));
            if (bl3 && !bl2) {
                return -1;
            }
            if (bl2 && !bl3) break;
        }
        return 1;
    }

    @Override
    public boolean comparesEqual(CharSequence charSequence, CharSequence charSequence2) {
        return this.compareStrings(charSequence, charSequence2) == 0;
    }

    @Override
    public AtomicMatchKey getCollationKey(CharSequence charSequence) {
        return this.a.getCollationKey(charSequence);
    }
}

