/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.sort;

import net.sf.saxon.expr.sort.AtomicMatchKey;
import net.sf.saxon.expr.sort.CodepointMatchKey;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.lib.SubstringMatcher;
import net.sf.saxon.regex.UnicodeString;

public class CodepointCollator
implements StringCollator,
SubstringMatcher {
    private static CodepointCollator a = new CodepointCollator();

    public static CodepointCollator getInstance() {
        return a;
    }

    @Override
    public String getCollationURI() {
        return "http://www.w3.org/2005/xpath-functions/collation/codepoint";
    }

    @Override
    public int compareStrings(CharSequence charSequence, CharSequence charSequence2) {
        return CodepointCollator.compareCS(charSequence, charSequence2);
    }

    public static int compareCS(CharSequence charSequence, CharSequence charSequence2) {
        int n2;
        int n3;
        if (charSequence instanceof UnicodeString && charSequence2 instanceof UnicodeString) {
            return ((UnicodeString)charSequence).compareTo((UnicodeString)charSequence2);
        }
        int n4 = charSequence.length();
        int n5 = charSequence2.length();
        int n6 = 0;
        int n7 = 0;
        do {
            if (n6 == n4) {
                if (n7 == n5) {
                    return 0;
                }
                return -1;
            }
            if (n7 == n5) {
                return 1;
            }
            if ((n2 = charSequence.charAt(n6++)) >= 55296 && n2 <= 56319) {
                n2 = (n2 - 55296 << 10) + (charSequence.charAt(n6++) - 56320) + 65536;
            }
            if ((n3 = charSequence2.charAt(n7++)) < 55296 || n3 > 56319) continue;
            n3 = (n3 - 55296 << 10) + (charSequence2.charAt(n7++) - 56320) + 65536;
        } while ((n2 -= n3) == 0);
        return n2;
    }

    @Override
    public boolean comparesEqual(CharSequence charSequence, CharSequence charSequence2) {
        if (charSequence instanceof String) {
            return ((String)charSequence).contentEquals(charSequence2);
        }
        if (charSequence instanceof UnicodeString) {
            return charSequence.equals(UnicodeString.makeUnicodeString(charSequence2));
        }
        return charSequence.length() == charSequence2.length() && charSequence.toString().equals(charSequence2.toString());
    }

    @Override
    public boolean contains(String string, String string2) {
        return string.contains(string2);
    }

    @Override
    public boolean endsWith(String string, String string2) {
        return string.endsWith(string2);
    }

    @Override
    public boolean startsWith(String string, String string2) {
        return string.startsWith(string2);
    }

    @Override
    public String substringAfter(String string, String string2) {
        int n2 = string.indexOf(string2);
        if (n2 < 0) {
            return "";
        }
        return string.substring(n2 + string2.length());
    }

    @Override
    public String substringBefore(String string, String string2) {
        int n2 = string.indexOf(string2);
        if (n2 < 0) {
            return "";
        }
        return string.substring(0, n2);
    }

    @Override
    public AtomicMatchKey getCollationKey(CharSequence charSequence) {
        return new CodepointMatchKey(charSequence);
    }
}

