/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.sort;

import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.sort.AtomicComparer;
import net.sf.saxon.expr.sort.CodepointCollator;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.value.AtomicValue;

public class CollatingAtomicComparer
implements AtomicComparer {
    private StringCollator a;

    public CollatingAtomicComparer(StringCollator stringCollator) {
        if (stringCollator == null) {
            this.a = CodepointCollator.getInstance();
            return;
        }
        this.a = stringCollator;
    }

    @Override
    public StringCollator getCollator() {
        return this.a;
    }

    @Override
    public AtomicComparer provideContext(XPathContext xPathContext) {
        return this;
    }

    @Override
    public int compareAtomicValues(AtomicValue atomicValue, AtomicValue atomicValue2) {
        if (atomicValue == null) {
            if (atomicValue2 == null) {
                return 0;
            }
            return -1;
        }
        if (atomicValue2 == null) {
            return 1;
        }
        return this.a.compareStrings(atomicValue.getStringValue(), atomicValue2.getStringValue());
    }

    @Override
    public boolean comparesEqual(AtomicValue atomicValue, AtomicValue atomicValue2) {
        return this.compareAtomicValues(atomicValue, atomicValue2) == 0;
    }

    @Override
    public String save() {
        return "CAC|" + this.getCollator().getCollationURI();
    }

    public int hashCode() {
        return this.a.hashCode();
    }

    public boolean equals(Object object) {
        return object instanceof CollatingAtomicComparer && this.a.equals(((CollatingAtomicComparer)object).a);
    }
}

