/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.sort;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.OperandUsage;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.expr.sort.DocumentSorter;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.SequenceType;

public class ConditionalSorter
extends Expression {
    private Operand a;
    private Operand b;
    private static final OperandRole c = new OperandRole(16, OperandUsage.TRANSMISSION, SequenceType.ANY_SEQUENCE, expression -> expression instanceof DocumentSorter);

    public ConditionalSorter(Expression expression, DocumentSorter documentSorter) {
        this.a = new Operand(this, expression, OperandRole.SINGLE_ATOMIC);
        this.b = new Operand(this, documentSorter, c);
        this.adoptChildExpression(expression);
        this.adoptChildExpression(documentSorter);
    }

    @Override
    public Iterable<Operand> operands() {
        return this.operandList(this.a, this.b);
    }

    public void setCondition(Expression expression) {
        this.a.setChildExpression(expression);
    }

    public void setDocumentSorter(DocumentSorter documentSorter) {
        this.b.setChildExpression(documentSorter);
    }

    public Expression getCondition() {
        return this.a.getChildExpression();
    }

    public DocumentSorter getDocumentSorter() {
        return (DocumentSorter)this.b.getChildExpression();
    }

    @Override
    public Expression simplify() {
        return this.a(Expression::simplify);
    }

    @Override
    public Expression typeCheck(ExpressionVisitor expressionVisitor, ContextItemStaticInfo contextItemStaticInfo) {
        return this.a(expression -> expression.typeCheck(expressionVisitor, contextItemStaticInfo));
    }

    @Override
    public int getCardinality() {
        return this.getDocumentSorter().getCardinality();
    }

    @Override
    protected int computeSpecialProperties() {
        return this.getCondition().getSpecialProperties() | 0x20000;
    }

    @Override
    public int getImplementationMethod() {
        return 2;
    }

    @Override
    public Expression optimize(ExpressionVisitor expressionVisitor, ContextItemStaticInfo contextItemStaticInfo) {
        return this.a(expression -> expression.optimize(expressionVisitor, contextItemStaticInfo));
    }

    private Expression a(a object) {
        Expression expression = object.rewrite(this.getDocumentSorter());
        if (!(expression instanceof DocumentSorter)) {
            return expression;
        }
        this.b.setChildExpression(expression);
        object = object.rewrite(this.getCondition());
        if (object instanceof Literal) {
            boolean bl2 = ((Literal)object).getValue().effectiveBooleanValue();
            if (bl2) {
                return expression;
            }
            return ((DocumentSorter)expression).getBaseExpression();
        }
        this.a.setChildExpression((Expression)object);
        return this;
    }

    @Override
    public Expression unordered(boolean bl2, boolean bl3) {
        Expression expression = ((Expression)this.getDocumentSorter()).unordered(bl2, bl3);
        if (expression instanceof DocumentSorter) {
            return this;
        }
        return expression;
    }

    @Override
    protected int computeCardinality() {
        return 57344;
    }

    @Override
    public Expression copy(RebindingMap object) {
        object = new ConditionalSorter(this.getCondition().copy((RebindingMap)object), (DocumentSorter)((Expression)this.getDocumentSorter()).copy((RebindingMap)object));
        ExpressionTool.copyLocationInfo(this, (Expression)object);
        return object;
    }

    @Override
    public void export(ExpressionPresenter expressionPresenter) {
        expressionPresenter.startElement("conditionalSort", this);
        this.getCondition().export(expressionPresenter);
        ((Expression)this.getDocumentSorter()).export(expressionPresenter);
        expressionPresenter.endElement();
    }

    @Override
    public ItemType getItemType() {
        return ((Expression)this.getDocumentSorter()).getItemType();
    }

    @Override
    public SequenceIterator<?> iterate(XPathContext xPathContext) {
        boolean bl2 = this.getCondition().effectiveBooleanValue(xPathContext);
        if (bl2) {
            return ((Expression)this.getDocumentSorter()).iterate(xPathContext);
        }
        return this.getDocumentSorter().getBaseExpression().iterate(xPathContext);
    }

    @Override
    public String getExpressionName() {
        return "conditionalSort";
    }

    @FunctionalInterface
    private static interface a {
        public Expression rewrite(Expression var1);
    }
}

