/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.sort;

import net.sf.saxon.Configuration;
import net.sf.saxon.expr.AxisExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.FirstItemExpression;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.SlashExpression;
import net.sf.saxon.expr.UnaryExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.expr.sort.ConditionalSorter;
import net.sf.saxon.expr.sort.DocumentOrderIterator;
import net.sf.saxon.expr.sort.GlobalOrderComparer;
import net.sf.saxon.expr.sort.ItemOrderComparer;
import net.sf.saxon.expr.sort.LocalOrderComparer;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.SequenceType;

public class DocumentSorter
extends UnaryExpression {
    private ItemOrderComparer a;

    public DocumentSorter(Expression expression) {
        super(expression);
        int n2 = expression.getSpecialProperties();
        if ((n2 & 0x10000) != 0 || (n2 & 0x1000000) != 0) {
            this.a = LocalOrderComparer.getInstance();
            return;
        }
        this.a = GlobalOrderComparer.getInstance();
    }

    public DocumentSorter(Expression expression, boolean bl2) {
        super(expression);
        if (bl2) {
            this.a = LocalOrderComparer.getInstance();
            return;
        }
        this.a = GlobalOrderComparer.getInstance();
    }

    @Override
    protected OperandRole getOperandRole() {
        return OperandRole.SAME_FOCUS_ACTION;
    }

    @Override
    public String getExpressionName() {
        return "docOrder";
    }

    public ItemOrderComparer getComparer() {
        return this.a;
    }

    @Override
    public Expression simplify() {
        Expression expression = this.getBaseExpression().simplify();
        if (expression.hasSpecialProperty(131072)) {
            return expression;
        }
        return this;
    }

    @Override
    public Expression typeCheck(ExpressionVisitor object, ContextItemStaticInfo object2) {
        if ((object2 = super.typeCheck((ExpressionVisitor)object, (ContextItemStaticInfo)object2)) != this) {
            return object2;
        }
        object2 = ((ExpressionVisitor)object).getConfiguration().getTypeHierarchy();
        if (((TypeHierarchy)object2).relationship(this.getBaseExpression().getItemType(), AnyNodeTest.getInstance()) == 4) {
            return this.getBaseExpression();
        }
        object2 = new RoleDiagnostic(20, "document-order sorter", 0);
        object = ((ExpressionVisitor)object).getConfiguration().getTypeChecker(false).staticTypeCheck(this.getBaseExpression(), SequenceType.NODE_SEQUENCE, (RoleDiagnostic)object2, (ExpressionVisitor)object);
        this.setBaseExpression((Expression)object);
        return this;
    }

    @Override
    public Expression optimize(ExpressionVisitor expressionVisitor, ContextItemStaticInfo contextItemStaticInfo) {
        this.getOperand().optimize(expressionVisitor, contextItemStaticInfo);
        Expression expression = this.getBaseExpression();
        boolean bl2 = expression.isStaticPropertiesKnown();
        while (true) {
            if (expression.hasSpecialProperty(131072)) {
                return expression;
            }
            if (!Cardinality.allowsMany(expression.getCardinality())) {
                return expression;
            }
            if (expression instanceof SlashExpression) {
                SlashExpression slashExpression = (SlashExpression)expression;
                Expression expression2 = slashExpression.getLhsExpression();
                Expression expression3 = slashExpression.getRhsExpression();
                if (expression2 instanceof ConditionalSorter && slashExpression.getRhsExpression().hasSpecialProperty(524288)) {
                    expression = (ConditionalSorter)expression2;
                    Expression expression4 = ((ConditionalSorter)expression).getDocumentSorter();
                    expression = ((ConditionalSorter)expression).getCondition();
                    expression4 = new SlashExpression(expression4.getBaseExpression(), expression3);
                    expression4 = ((Expression)expression4).optimize(expressionVisitor, contextItemStaticInfo);
                    return new ConditionalSorter(expression, new DocumentSorter(expression4));
                }
                if (expression2 instanceof DocumentSorter && expression3 instanceof AxisExpression && ((AxisExpression)expression3).getAxis() == 3) {
                    expression = new SlashExpression(((DocumentSorter)expression2).getBaseExpression(), expression3);
                    ExpressionTool.copyLocationInfo(this, expression);
                    return ((Expression)new DocumentSorter(expression)).optimize(expressionVisitor, contextItemStaticInfo);
                }
                if (!ExpressionTool.dependsOnFocus(expression3) && !expression3.hasSpecialProperty(0x2000000) && expression3.hasSpecialProperty(0x800000)) {
                    expression = FirstItemExpression.makeFirstItemExpression(slashExpression.getLhsExpression());
                    DocumentSorter documentSorter = new DocumentSorter(slashExpression.getRhsExpression());
                    expression = new SlashExpression(expression, documentSorter);
                    ExpressionTool.copyLocationInfo(this, expression);
                    return expression.optimize(expressionVisitor, contextItemStaticInfo);
                }
            }
            if (!bl2) break;
            expression.resetLocalStaticProperties();
            bl2 = false;
        }
        if (expression instanceof SlashExpression && !expressionVisitor.isOptimizeForStreaming() && !(this.getParentExpression() instanceof ConditionalSorter)) {
            return expressionVisitor.obtainOptimizer().makeConditionalDocumentSorter(this, (SlashExpression)expression);
        }
        return this;
    }

    @Override
    public int getNetCost() {
        return 30;
    }

    @Override
    public Expression unordered(boolean bl2, boolean bl3) {
        Expression expression = this.getBaseExpression().unordered(bl2, bl3);
        if (expression.hasSpecialProperty(131072)) {
            return expression;
        }
        if (!bl2) {
            return expression;
        }
        if (expression instanceof SlashExpression) {
            Expression expression2 = (SlashExpression)expression;
            Expression expression3 = expression2.getSelectExpression();
            expression2 = expression2.getActionExpression();
            expression3 = ExpressionTool.unfilteredExpression(expression3, false);
            expression2 = ExpressionTool.unfilteredExpression(expression2, false);
            if (expression3 instanceof AxisExpression && (((AxisExpression)expression3).getAxis() == 4 || ((AxisExpression)expression3).getAxis() == 5) && expression2 instanceof AxisExpression && ((AxisExpression)expression2).getAxis() == 3) {
                return expression.unordered(bl2, false);
            }
        }
        this.setBaseExpression(expression);
        return this;
    }

    @Override
    public int computeSpecialProperties() {
        return this.getBaseExpression().getSpecialProperties() | 0x20000;
    }

    @Override
    public Expression copy(RebindingMap object) {
        object = new DocumentSorter(this.getBaseExpression().copy((RebindingMap)object));
        ExpressionTool.copyLocationInfo(this, (Expression)object);
        return object;
    }

    @Override
    public Pattern toPattern(Configuration configuration) {
        return this.getBaseExpression().toPattern(configuration);
    }

    @Override
    public int getImplementationMethod() {
        return 2;
    }

    @Override
    public SequenceIterator<?> iterate(XPathContext xPathContext) {
        return new DocumentOrderIterator(this.getBaseExpression().iterate(xPathContext), this.a);
    }

    @Override
    public boolean effectiveBooleanValue(XPathContext xPathContext) {
        return this.getBaseExpression().effectiveBooleanValue(xPathContext);
    }

    @Override
    public void export(ExpressionPresenter expressionPresenter) {
        expressionPresenter.startElement("docOrder", this);
        expressionPresenter.emitAttribute("intra", this.a instanceof LocalOrderComparer ? "1" : "0");
        this.getBaseExpression().export(expressionPresenter);
        expressionPresenter.endElement();
    }

    @Override
    public String getStreamerName() {
        return "DocumentSorterAdjunct";
    }
}

