/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.sort;

import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.sort.AtomicComparer;
import net.sf.saxon.expr.sort.CalendarValueComparer;
import net.sf.saxon.expr.sort.CodepointCollatingComparer;
import net.sf.saxon.expr.sort.CodepointCollator;
import net.sf.saxon.expr.sort.CollatingAtomicComparer;
import net.sf.saxon.expr.sort.ComparableAtomicValueComparer;
import net.sf.saxon.expr.sort.ComparisonException;
import net.sf.saxon.expr.sort.EqualityComparer;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.om.Item;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.CalendarValue;
import net.sf.saxon.value.StringValue;

public class GenericAtomicComparer
implements AtomicComparer {
    private StringCollator a;
    private transient XPathContext b;

    public GenericAtomicComparer(StringCollator stringCollator, XPathContext xPathContext) {
        this.a = stringCollator;
        if (stringCollator == null) {
            this.a = CodepointCollator.getInstance();
        }
        this.b = xPathContext;
    }

    public static AtomicComparer makeAtomicComparer(BuiltInAtomicType builtInAtomicType, BuiltInAtomicType builtInAtomicType2, StringCollator stringCollator, XPathContext xPathContext) {
        int n2;
        int n3 = builtInAtomicType.getFingerprint();
        if (n3 == (n2 = builtInAtomicType2.getFingerprint())) {
            switch (n3) {
                case 519: 
                case 520: 
                case 521: 
                case 522: 
                case 523: 
                case 524: 
                case 525: 
                case 526: {
                    return new CalendarValueComparer(xPathContext);
                }
                case 514: 
                case 633: 
                case 634: {
                    return ComparableAtomicValueComparer.getInstance();
                }
                case 527: 
                case 528: {
                    return ComparableAtomicValueComparer.getInstance();
                }
                case 530: 
                case 531: {
                    return EqualityComparer.getInstance();
                }
            }
        }
        if (builtInAtomicType.isPrimitiveNumeric() && builtInAtomicType2.isPrimitiveNumeric()) {
            return ComparableAtomicValueComparer.getInstance();
        }
        if (!(n3 != 513 && n3 != 631 && n3 != 529 || n2 != 513 && n2 != 631 && n2 != 529)) {
            if (stringCollator instanceof CodepointCollator) {
                return CodepointCollatingComparer.getInstance();
            }
            return new CollatingAtomicComparer(stringCollator);
        }
        return new GenericAtomicComparer(stringCollator, xPathContext);
    }

    @Override
    public StringCollator getCollator() {
        return this.a;
    }

    @Override
    public GenericAtomicComparer provideContext(XPathContext xPathContext) {
        return new GenericAtomicComparer(this.a, xPathContext);
    }

    public StringCollator getStringCollator() {
        return this.a;
    }

    @Override
    public int compareAtomicValues(AtomicValue object, AtomicValue atomicValue) {
        if (object == null) {
            if (atomicValue == null) {
                return 0;
            }
            return -1;
        }
        if (atomicValue == null) {
            return 1;
        }
        if (object instanceof StringValue && atomicValue instanceof StringValue) {
            if (this.a instanceof CodepointCollator) {
                return CodepointCollator.compareCS(((AtomicValue)object).getStringValueCS(), atomicValue.getStringValueCS());
            }
            return this.a.compareStrings(((AtomicValue)object).getStringValue(), atomicValue.getStringValue());
        }
        int n2 = this.b.getImplicitTimezone();
        Comparable comparable = (Comparable)((Object)((AtomicValue)object).getXPathComparable(true, this.a, n2));
        Comparable comparable2 = (Comparable)((Object)atomicValue.getXPathComparable(true, this.a, n2));
        if (comparable == null || comparable2 == null) {
            object = new XPathException("Objects are not comparable (" + Type.displayTypeName((Item)object) + ", " + Type.displayTypeName(atomicValue) + ')', "XPTY0004");
            throw new ComparisonException((XPathException)object);
        }
        return comparable.compareTo(comparable2);
    }

    @Override
    public boolean comparesEqual(AtomicValue object, AtomicValue object2) {
        if (object instanceof StringValue && object2 instanceof StringValue) {
            return this.a.comparesEqual(((AtomicValue)object).getStringValue(), ((AtomicValue)object2).getStringValue());
        }
        if (object instanceof CalendarValue && object2 instanceof CalendarValue) {
            return ((CalendarValue)object).compareTo((CalendarValue)object2, this.b.getImplicitTimezone()) == 0;
        }
        int n2 = this.b.getImplicitTimezone();
        object = ((AtomicValue)object).getXPathComparable(false, this.a, n2);
        object2 = ((AtomicValue)object2).getXPathComparable(false, this.a, n2);
        return object.equals(object2);
    }

    public XPathContext getContext() {
        return this.b;
    }

    @Override
    public String save() {
        return "GAC|" + this.a.getCollationURI();
    }

    public int hashCode() {
        return this.a.hashCode();
    }

    public boolean equals(Object object) {
        return object instanceof GenericAtomicComparer && this.a.equals(((GenericAtomicComparer)object).a);
    }
}

