/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.sort;

import java.util.ArrayList;
import java.util.Set;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.CardinalityChecker;
import net.sf.saxon.expr.ContextMappingFunction;
import net.sf.saxon.expr.ContextMappingIterator;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ItemMappingIterator;
import net.sf.saxon.expr.LastPositionFinder;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.OperandUsage;
import net.sf.saxon.expr.SystemFunctionCall;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.XPathContextMinor;
import net.sf.saxon.expr.accum.Accumulator;
import net.sf.saxon.expr.accum.AccumulatorManager;
import net.sf.saxon.expr.instruct.Instruction;
import net.sf.saxon.expr.instruct.TailCall;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.expr.parser.TypeChecker;
import net.sf.saxon.expr.sort.AtomicComparer;
import net.sf.saxon.expr.sort.GroupIterator;
import net.sf.saxon.expr.sort.ItemOrderComparer;
import net.sf.saxon.expr.sort.ItemWithMergeKeys;
import net.sf.saxon.expr.sort.MergeGroupingIterator;
import net.sf.saxon.expr.sort.MergeIterator;
import net.sf.saxon.expr.sort.SortKeyDefinition;
import net.sf.saxon.expr.sort.SortKeyDefinitionList;
import net.sf.saxon.functions.Count;
import net.sf.saxon.functions.CurrentMergeGroup;
import net.sf.saxon.functions.CurrentMergeKey;
import net.sf.saxon.functions.DocumentFn;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.lib.Feature;
import net.sf.saxon.lib.ParseOptions;
import net.sf.saxon.lib.Validation;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.NoDynamicContextException;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.trans.XsltController;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.tree.iter.ManualIterator;
import net.sf.saxon.tree.iter.SingletonIterator;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.ExternalObject;
import net.sf.saxon.value.ObjectValue;
import net.sf.saxon.value.SequenceType;

public class MergeInstr
extends Instruction {
    protected MergeSource[] mergeSources;
    private Operand a;
    protected AtomicComparer[] comparators;
    private static final OperandRole b = new OperandRole(6, OperandUsage.INSPECTION, SequenceType.ANY_SEQUENCE);

    public MergeInstr init(MergeSource[] mergeSourceArray, Expression expression) {
        this.a = new Operand(this, expression, OperandRole.FOCUS_CONTROLLED_ACTION);
        this.mergeSources = mergeSourceArray;
        for (MergeSource mergeSource : mergeSourceArray) {
            this.adoptChildExpression(mergeSource.getForEachItem());
            this.adoptChildExpression(mergeSource.getForEachSource());
            this.adoptChildExpression(mergeSource.getRowSelect());
        }
        this.adoptChildExpression(expression);
        return this;
    }

    public MergeSource[] getMergeSources() {
        return this.mergeSources;
    }

    public void setAction(Expression expression) {
        this.a.setChildExpression(expression);
    }

    public Expression getAction() {
        return this.a.getChildExpression();
    }

    @Override
    public int getInstructionNameCode() {
        return 169;
    }

    @Override
    public void checkPermittedContents(SchemaType schemaType, boolean bl2) {
        this.getAction().checkPermittedContents(schemaType, false);
    }

    @Override
    public boolean allowExtractingCommonSubexpressions() {
        return false;
    }

    @Override
    public ItemType getItemType() {
        return this.getAction().getItemType();
    }

    @Override
    public Expression typeCheck(ExpressionVisitor expressionVisitor, ContextItemStaticInfo contextItemStaticInfo) {
        Configuration configuration = expressionVisitor.getConfiguration();
        TypeHierarchy typeHierarchy = configuration.getTypeHierarchy();
        TypeChecker typeChecker = configuration.getTypeChecker(false);
        Object object = null;
        MergeSource[] mergeSourceArray = this.mergeSources;
        int n2 = this.mergeSources.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            MergeSource mergeSource = mergeSourceArray[i2];
            Object object2 = contextItemStaticInfo;
            if (mergeSource.getForEachItem() != null) {
                mergeSource.b.typeCheck(expressionVisitor, contextItemStaticInfo);
                object2 = configuration.makeContextItemStaticInfo(mergeSource.getForEachItem().getItemType(), false);
            } else if (mergeSource.getForEachSource() != null) {
                mergeSource.c.typeCheck(expressionVisitor, contextItemStaticInfo);
                object2 = new RoleDiagnostic(4, "xsl:merge/for-each-source", 0);
                mergeSource.setForEachStream(typeChecker.staticTypeCheck(mergeSource.getForEachSource(), SequenceType.STRING_SEQUENCE, (RoleDiagnostic)object2, expressionVisitor));
                object2 = configuration.makeContextItemStaticInfo(NodeKindTest.DOCUMENT, false);
            }
            mergeSource.d.typeCheck(expressionVisitor, (ContextItemStaticInfo)object2);
            object2 = mergeSource.getRowSelect().getItemType();
            object = object == null ? object2 : Type.getCommonSuperType((ItemType)object, (ItemType)object2, typeHierarchy);
            object2 = configuration.makeContextItemStaticInfo((ItemType)object, false);
            if (mergeSource.mergeKeyDefinitions == null) continue;
            for (SortKeyDefinition sortKeyDefinition : mergeSource.mergeKeyDefinitions) {
                Object object3;
                Expression expression = sortKeyDefinition.getSortKey();
                if ((expression = expression.typeCheck(expressionVisitor, (ContextItemStaticInfo)object2)) != null) {
                    object3 = new RoleDiagnostic(4, "xsl:merge-key/select", 0);
                    ((RoleDiagnostic)object3).setErrorCode("XTTE1020");
                    expression = CardinalityChecker.makeCardinalityChecker(expression, 24576, (RoleDiagnostic)object3);
                    sortKeyDefinition.setSortKey(expression, true);
                }
                object3 = sortKeyDefinition.getLanguage().typeCheck(expressionVisitor, configuration.makeContextItemStaticInfo((ItemType)object, false));
                sortKeyDefinition.setLanguage((Expression)object3);
                object3 = sortKeyDefinition.getOrder().typeCheck(expressionVisitor, (ContextItemStaticInfo)object2);
                sortKeyDefinition.setOrder((Expression)object3);
                object3 = sortKeyDefinition.getCollationNameExpression();
                if (object3 != null) {
                    object3 = ((Expression)object3).typeCheck(expressionVisitor, (ContextItemStaticInfo)object2);
                    sortKeyDefinition.setCollationNameExpression((Expression)object3);
                }
                object3 = sortKeyDefinition.getCaseOrder().typeCheck(expressionVisitor, (ContextItemStaticInfo)object2);
                sortKeyDefinition.setCaseOrder((Expression)object3);
                object3 = sortKeyDefinition.getDataTypeExpression();
                if (object3 == null) continue;
                object3 = ((Expression)object3).typeCheck(expressionVisitor, (ContextItemStaticInfo)object2);
                sortKeyDefinition.setDataTypeExpression((Expression)object3);
            }
        }
        this.a.typeCheck(expressionVisitor, configuration.makeContextItemStaticInfo((ItemType)object, false));
        if (Literal.isEmptySequence(this.getAction())) {
            return this.getAction();
        }
        if (this.mergeSources.length == 1 && Literal.isEmptySequence(this.mergeSources[0].getRowSelect())) {
            return this.mergeSources[0].getRowSelect();
        }
        this.fixupGroupReferences();
        return this;
    }

    public void fixupGroupReferences() {
        MergeInstr mergeInstr = this;
        MergeInstr.a(mergeInstr, mergeInstr, false);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void a(Expression iterator, MergeInstr mergeInstr, boolean bl2) {
        if (iterator == null) return;
        if (((Expression)((Object)iterator)).isCallOn(CurrentMergeGroup.class)) {
            iterator = (CurrentMergeGroup)((SystemFunctionCall)((Object)iterator)).getTargetFunction();
            ((CurrentMergeGroup)((Object)iterator)).setControllingInstruction(mergeInstr, bl2);
            return;
        }
        if (((Expression)((Object)iterator)).isCallOn(CurrentMergeKey.class)) {
            iterator = (CurrentMergeKey)((SystemFunctionCall)((Object)iterator)).getTargetFunction();
            ((CurrentMergeKey)((Object)iterator)).setControllingInstruction(mergeInstr);
            return;
        }
        if (iterator instanceof MergeInstr) {
            if ((iterator = (MergeInstr)((Object)iterator)) == mergeInstr) {
                MergeInstr.a(((MergeInstr)((Object)iterator)).getAction(), mergeInstr, false);
                return;
            }
            MergeSource[] mergeSourceArray = ((MergeInstr)((Object)iterator)).getMergeSources();
            int n2 = mergeSourceArray.length;
            int n3 = 0;
            while (n3 < n2) {
                MergeSource mergeSource = mergeSourceArray[n3];
                for (SortKeyDefinition sortKeyDefinition : mergeSource.mergeKeyDefinitions) {
                    MergeInstr.a(sortKeyDefinition.getOrder(), mergeInstr, bl2);
                    MergeInstr.a(sortKeyDefinition.getCaseOrder(), mergeInstr, bl2);
                    MergeInstr.a(sortKeyDefinition.getDataTypeExpression(), mergeInstr, bl2);
                    MergeInstr.a(sortKeyDefinition.getLanguage(), mergeInstr, bl2);
                    MergeInstr.a(sortKeyDefinition.getCollationNameExpression(), mergeInstr, bl2);
                    MergeInstr.a(sortKeyDefinition.getOrder(), mergeInstr, bl2);
                }
                if (mergeSource.b != null) {
                    MergeInstr.a(mergeSource.getForEachItem(), mergeInstr, bl2);
                }
                if (mergeSource.c != null) {
                    MergeInstr.a(mergeSource.getForEachSource(), mergeInstr, bl2);
                }
                if (mergeSource.d != null) {
                    MergeInstr.a(mergeSource.getRowSelect(), mergeInstr, bl2);
                }
                ++n3;
            }
            return;
        }
        iterator = ((Expression)((Object)iterator)).operands().iterator();
        while (iterator.hasNext()) {
            Operand operand = iterator.next();
            MergeInstr.a(operand.getChildExpression(), mergeInstr, bl2 || operand.isEvaluatedRepeatedly());
        }
    }

    @Override
    public final boolean mayCreateNewNodes() {
        int n2 = this.getAction().getSpecialProperties();
        return (n2 & 0x800000) == 0;
    }

    @Override
    public Expression optimize(ExpressionVisitor expressionVisitor, ContextItemStaticInfo contextItemStaticInfo) {
        Configuration configuration = expressionVisitor.getConfiguration();
        TypeHierarchy typeHierarchy = configuration.getTypeHierarchy();
        Object object = null;
        Object object2 = this.mergeSources;
        int n2 = this.mergeSources.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Object object3 = object2[i2];
            ContextItemStaticInfo contextItemStaticInfo2 = contextItemStaticInfo;
            if (((MergeSource)object3).getForEachItem() != null) {
                ((MergeSource)object3).b.optimize(expressionVisitor, contextItemStaticInfo);
                contextItemStaticInfo2 = configuration.makeContextItemStaticInfo(((MergeSource)object3).getForEachItem().getItemType(), false);
            } else if (((MergeSource)object3).getForEachSource() != null) {
                ((MergeSource)object3).c.optimize(expressionVisitor, contextItemStaticInfo);
                contextItemStaticInfo2 = configuration.makeContextItemStaticInfo(NodeKindTest.DOCUMENT, false);
            }
            ((MergeSource)object3).d.optimize(expressionVisitor, contextItemStaticInfo2);
            object3 = ((MergeSource)object3).getRowSelect().getItemType();
            object = object == null ? object3 : Type.getCommonSuperType((ItemType)object, (ItemType)object3, typeHierarchy);
        }
        object2 = configuration.makeContextItemStaticInfo((ItemType)object, false);
        MergeInstr mergeInstr = this;
        mergeInstr.setAction(mergeInstr.getAction().optimize(expressionVisitor, (ContextItemStaticInfo)object2));
        if (Literal.isEmptySequence(this.getAction())) {
            return this.getAction();
        }
        if (this.mergeSources.length == 1 && Literal.isEmptySequence(this.mergeSources[0].getRowSelect())) {
            return this.mergeSources[0].getRowSelect();
        }
        return this;
    }

    @Override
    public void prepareForStreaming() {
        MergeSource[] mergeSourceArray = this.mergeSources;
        int n2 = this.mergeSources.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            MergeSource mergeSource = mergeSourceArray[i2];
            mergeSource.prepareForStreaming();
        }
    }

    private static void a(SortKeyDefinition[] sortKeyDefinitionArray) {
        for (int i2 = 1; i2 < sortKeyDefinitionArray.length; ++i2) {
            if (sortKeyDefinitionArray[0].isEqual(sortKeyDefinitionArray[i2])) continue;
            throw new XPathException("Corresponding xsl:merge-key attributes in different xsl:merge-source elements do not have the same effective values", "XTDE2210");
        }
    }

    @Override
    public SequenceIterator<?> iterate(XPathContext object) {
        try {
            Object object2 = this.a((XPathContext)object);
            SequenceIterator<Item<?>> sequenceIterator = object.getCurrentMergeGroupIterator();
            XPathContextMajor xPathContextMajor = object.newContext();
            xPathContextMajor.setCurrentMergeGroupIterator((GroupIterator)sequenceIterator);
            sequenceIterator = this.a((XPathContext)object, (AtomicComparer[])object2, xPathContextMajor);
            MergeInstr mergeInstr = this;
            ItemOrderComparer itemOrderComparer = mergeInstr.getComparer(mergeInstr.mergeSources[0].mergeKeyDefinitions, (AtomicComparer[])object2);
            object2 = object;
            object = this;
            sequenceIterator = new MergeGroupingIterator(sequenceIterator, itemOrderComparer, new LastPositionFinder((MergeInstr)object, (XPathContext)object2){
                private int a = -1;
                private /* synthetic */ XPathContext b;
                private /* synthetic */ MergeInstr c;
                {
                    this.c = mergeInstr;
                    this.b = xPathContext;
                }

                @Override
                public final int getLength() {
                    if (this.a >= 0) {
                        return this.a;
                    }
                    AtomicComparer[] atomicComparerArray = this.c.a(this.b);
                    SequenceIterator<Item<?>> sequenceIterator = this.b.getCurrentMergeGroupIterator();
                    XPathContextMajor xPathContextMajor = this.b.newContext();
                    xPathContextMajor.setCurrentMergeGroupIterator((GroupIterator)sequenceIterator);
                    sequenceIterator = this.c.a(this.b, atomicComparerArray, xPathContextMajor);
                    sequenceIterator = new MergeGroupingIterator(sequenceIterator, this.c.getComparer(this.c.mergeSources[0].mergeKeyDefinitions, atomicComparerArray), null);
                    this.a = Count.steppingCount(sequenceIterator);
                    return this.a;
                }
            });
            xPathContextMajor.setCurrentMergeGroupIterator((GroupIterator)sequenceIterator);
            object = xPathContextMajor.newMinorContext();
            object.trackFocus(sequenceIterator);
            return new ContextMappingIterator(xPathContext -> this.getAction().iterate(xPathContext), (XPathContext)object);
        }
        catch (XPathException xPathException) {
            XPathException xPathException2 = xPathException;
            xPathException.maybeSetLocation(this.getLocation());
            throw xPathException2;
        }
    }

    private SequenceIterator<?> a(XPathContext xPathContext, AtomicComparer[] atomicComparerArray, XPathContextMajor xPathContextMajor) {
        SequenceIterator sequenceIterator = EmptyIterator.getInstance();
        MergeSource[] mergeSourceArray = this.mergeSources;
        int n2 = this.mergeSources.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            SequenceIterator<?> sequenceIterator2;
            Object object;
            MergeSource mergeSource = mergeSourceArray[i2];
            if (mergeSource.streamable && mergeSource.getForEachSource() != null) continue;
            if (mergeSource.getForEachSource() != null) {
                object = new ParseOptions(xPathContext.getConfiguration().getParseOptions());
                ((ParseOptions)object).setSchemaValidationMode(mergeSource.validation);
                ((ParseOptions)object).setTopLevelType(mergeSource.schemaType);
                ((ParseOptions)object).setApplicableAccumulators(mergeSource.accumulators);
                sequenceIterator2 = mergeSource.getForEachSource().iterate(xPathContextMajor);
                ContextMappingIterator<ExternalObject<ItemWithMergeKeys>> contextMappingIterator = (XsltController)xPathContext.getController();
                contextMappingIterator = ((XsltController)((Object)contextMappingIterator)).getAccumulatorManager();
                sequenceIterator2 = new ItemMappingIterator<Item, NodeInfo>(sequenceIterator2, arg_0 -> this.a((ParseOptions)object, xPathContextMajor, (AccumulatorManager)((Object)contextMappingIterator), mergeSource, arg_0));
                object = xPathContextMajor.newMinorContext();
                sequenceIterator2 = object.trackFocus(sequenceIterator2);
                while (sequenceIterator2.next() != null) {
                    contextMappingIterator = object.newMinorContext();
                    contextMappingIterator.trackFocus(mergeSource.getRowSelect().iterate((XPathContext)object));
                    MergeKeyMappingFunction mergeKeyMappingFunction = new MergeKeyMappingFunction((XPathContext)((Object)contextMappingIterator), mergeSource);
                    contextMappingIterator = new ContextMappingIterator<ExternalObject<ItemWithMergeKeys>>(mergeKeyMappingFunction, (XPathContext)((Object)contextMappingIterator));
                    sequenceIterator = this.a(sequenceIterator, atomicComparerArray, mergeSource, contextMappingIterator);
                }
                continue;
            }
            if (mergeSource.getForEachItem() != null) {
                sequenceIterator2 = mergeSource.getForEachItem().iterate(xPathContextMajor);
                object = xPathContextMajor.newMinorContext();
                sequenceIterator2 = object.trackFocus(sequenceIterator2);
                while (sequenceIterator2.next() != null) {
                    sequenceIterator = this.a(atomicComparerArray, sequenceIterator, mergeSource, (XPathContextMinor)object);
                }
                continue;
            }
            sequenceIterator = this.a(atomicComparerArray, sequenceIterator, mergeSource, xPathContextMajor);
        }
        return sequenceIterator;
    }

    private SequenceIterator a(AtomicComparer[] atomicComparerArray, SequenceIterator sequenceIterator, MergeSource mergeSource, XPathContextMinor contextMappingIterator) {
        XPathContextMinor xPathContextMinor = contextMappingIterator.newMinorContext();
        xPathContextMinor.setTemporaryOutputState(171);
        xPathContextMinor.trackFocus(mergeSource.getRowSelect().iterate((XPathContext)((Object)contextMappingIterator)));
        contextMappingIterator = new MergeKeyMappingFunction(xPathContextMinor, mergeSource);
        contextMappingIterator = new ContextMappingIterator<ExternalObject<ItemWithMergeKeys>>((ContextMappingFunction<ExternalObject<ItemWithMergeKeys>>)((Object)contextMappingIterator), xPathContextMinor);
        sequenceIterator = this.a(sequenceIterator, atomicComparerArray, mergeSource, contextMappingIterator);
        return sequenceIterator;
    }

    private AtomicComparer[] a(XPathContext xPathContext) {
        Object[] objectArray = this.comparators;
        if (this.comparators == null) {
            int n2;
            objectArray = new SortKeyDefinition[this.mergeSources.length];
            for (n2 = 0; n2 < this.mergeSources[0].mergeKeyDefinitions.size(); ++n2) {
                for (int i2 = 0; i2 < this.mergeSources.length; ++i2) {
                    objectArray[i2] = this.mergeSources[i2].mergeKeyDefinitions.getSortKeyDefinition(n2).fix(xPathContext);
                }
                MergeInstr.a((SortKeyDefinition[])objectArray);
            }
            objectArray = new AtomicComparer[this.mergeSources[0].mergeKeyDefinitions.size()];
            for (n2 = 0; n2 < this.mergeSources[0].mergeKeyDefinitions.size(); ++n2) {
                AtomicComparer atomicComparer = this.mergeSources[0].mergeKeyDefinitions.getSortKeyDefinition(n2).getFinalComparator();
                if (atomicComparer == null) {
                    atomicComparer = this.mergeSources[0].mergeKeyDefinitions.getSortKeyDefinition(n2).makeComparator(xPathContext);
                }
                objectArray[n2] = atomicComparer;
            }
        }
        return objectArray;
    }

    private SequenceIterator a(SequenceIterator sequenceIterator, AtomicComparer[] atomicComparerArray, MergeSource mergeSource, ContextMappingIterator<ExternalObject<ItemWithMergeKeys>> contextMappingIterator) {
        sequenceIterator = sequenceIterator == null || sequenceIterator instanceof EmptyIterator ? contextMappingIterator : new MergeIterator(sequenceIterator, contextMappingIterator, this.getComparer(mergeSource.mergeKeyDefinitions, atomicComparerArray));
        return sequenceIterator;
    }

    @Override
    public Iterable<Operand> operands() {
        ArrayList<Operand> arrayList = new ArrayList<Operand>(6);
        arrayList.add(this.a);
        if (this.mergeSources != null) {
            MergeSource[] mergeSourceArray = this.mergeSources;
            int n2 = this.mergeSources.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                MergeSource mergeSource = mergeSourceArray[i2];
                if (mergeSource.b != null) {
                    arrayList.add(mergeSource.b);
                }
                if (mergeSource.c != null) {
                    arrayList.add(mergeSource.c);
                }
                if (mergeSource.d != null) {
                    arrayList.add(mergeSource.d);
                }
                arrayList.add(new Operand(this, mergeSource.mergeKeyDefinitions, OperandRole.SINGLE_ATOMIC));
            }
        }
        return arrayList;
    }

    public Expression getGroupingKey() {
        return this.mergeSources[0].mergeKeyDefinitions.getSortKeyDefinition(0).getSortKey();
    }

    public ItemOrderComparer getComparer(SortKeyDefinitionList sortKeyDefinitionList, AtomicComparer[] atomicComparerArray) {
        return (object, object2) -> {
            object = (ObjectValue)object;
            object2 = (ObjectValue)object2;
            object = (ItemWithMergeKeys)((ObjectValue)object).getObject();
            object2 = (ItemWithMergeKeys)((ObjectValue)object2).getObject();
            for (int i2 = 0; i2 < sortKeyDefinitionList.size(); ++i2) {
                int n2;
                try {
                    n2 = atomicComparerArray[i2].compareAtomicValues(((ItemWithMergeKeys)object).b.get(i2), ((ItemWithMergeKeys)object2).b.get(i2));
                }
                catch (NoDynamicContextException noDynamicContextException) {
                    throw new IllegalStateException(noDynamicContextException);
                }
                if (n2 == 0) continue;
                return n2;
            }
            return 0;
        };
    }

    @Override
    public Expression copy(RebindingMap rebindingMap) {
        MergeInstr mergeInstr = new MergeInstr();
        MergeSource[] mergeSourceArray = new MergeSource[this.mergeSources.length];
        Expression expression = this.getAction().copy(rebindingMap);
        for (int i2 = 0; i2 < this.mergeSources.length; ++i2) {
            mergeSourceArray[i2] = this.mergeSources[i2].copyMergeSource(mergeInstr, rebindingMap);
        }
        return mergeInstr.init(mergeSourceArray, expression);
    }

    @Override
    public void export(ExpressionPresenter expressionPresenter) {
        expressionPresenter.startElement("merge", this);
        MergeSource[] mergeSourceArray = this.mergeSources;
        int n2 = this.mergeSources.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Object object;
            MergeSource mergeSource = mergeSourceArray[i2];
            expressionPresenter.startSubsidiaryElement("mergeSrc");
            if (mergeSource.sourceName != null && !mergeSource.sourceName.startsWith("saxon-merge-source-")) {
                expressionPresenter.emitAttribute("name", mergeSource.sourceName);
            }
            if (mergeSource.validation != 4 && mergeSource.validation != 8) {
                expressionPresenter.emitAttribute("validation", Validation.toString(mergeSource.validation));
            }
            if (mergeSource.validation == 8 && (object = mergeSource.schemaType) != null) {
                expressionPresenter.emitAttribute("type", object.getStructuredQName());
            }
            if (mergeSource.accumulators != null && !mergeSource.accumulators.isEmpty()) {
                object = new FastStringBuffer(256);
                for (Accumulator accumulator : mergeSource.accumulators) {
                    if (!((FastStringBuffer)object).isEmpty()) {
                        ((FastStringBuffer)object).append(" ");
                    }
                    ((FastStringBuffer)object).append(accumulator.getAccumulatorName().getEQName());
                }
                expressionPresenter.emitAttribute("accum", ((FastStringBuffer)object).toString());
            }
            if (mergeSource.streamable) {
                expressionPresenter.emitAttribute("flags", "s");
            }
            if (mergeSource.getForEachItem() != null) {
                expressionPresenter.setChildRole("forEachItem");
                mergeSource.getForEachItem().export(expressionPresenter);
            }
            if (mergeSource.getForEachSource() != null) {
                expressionPresenter.setChildRole("forEachStream");
                mergeSource.getForEachSource().export(expressionPresenter);
            }
            expressionPresenter.setChildRole("selectRows");
            mergeSource.getRowSelect().export(expressionPresenter);
            ((Expression)mergeSource.getMergeKeyDefinitionSet()).export(expressionPresenter);
            expressionPresenter.endSubsidiaryElement();
        }
        expressionPresenter.setChildRole("action");
        this.getAction().export(expressionPresenter);
        expressionPresenter.endElement();
    }

    @Override
    public TailCall processLeavingTail(XPathContext xPathContext) {
        Object object = xPathContext.getReceiver();
        try {
            SequenceIterator<?> sequenceIterator = ((Expression)this).iterate(xPathContext);
            Throwable throwable = null;
            try {
                sequenceIterator.forEachOrFail(arg_0 -> this.a((Receiver)object, arg_0));
                if (sequenceIterator != null) {
                    sequenceIterator.close();
                }
            }
            catch (Throwable throwable2) {
                try {
                    object = throwable2;
                    throwable = throwable2;
                    throw object;
                }
                catch (Throwable throwable3) {
                    if (sequenceIterator != null) {
                        if (throwable != null) {
                            try {
                                sequenceIterator.close();
                            }
                            catch (Throwable throwable4) {
                                throwable.addSuppressed(throwable4);
                            }
                        } else {
                            sequenceIterator.close();
                        }
                    }
                    throw throwable3;
                }
            }
        }
        catch (XPathException xPathException) {
            XPathException xPathException2 = xPathException;
            xPathException.maybeSetLocation(this.getLocation());
            xPathException2.maybeSetContext(xPathContext);
            throw xPathException2;
        }
        return null;
    }

    @Override
    public String getStreamerName() {
        return "MergeInstr";
    }

    private /* synthetic */ void a(Receiver receiver, Item item) {
        receiver.append(item, this.getLocation(), 524288);
    }

    private /* synthetic */ NodeInfo a(ParseOptions object, XPathContextMajor xPathContextMajor, AccumulatorManager accumulatorManager, MergeSource mergeSource, Item object2) {
        object2 = object2.getStringValue();
        object = DocumentFn.makeDoc((String)object2, this.getRetainedStaticContext().getStaticBaseUriString(), this.getPackageData(), (ParseOptions)object, xPathContextMajor, this.getLocation(), true);
        accumulatorManager.setApplicableAccumulators(object.getTreeInfo(), mergeSource.accumulators);
        return object;
    }

    public static class MergeKeyMappingFunction
    implements ContextMappingFunction<ExternalObject<ItemWithMergeKeys>> {
        private MergeSource a;
        private XPathContext b;
        private XPathContextMinor c;
        private ManualIterator<Item<?>> d;

        public MergeKeyMappingFunction(XPathContext xPathContext, MergeSource mergeSource) {
            this.b = xPathContext;
            this.a = mergeSource;
            this.c = xPathContext.newMinorContext();
            this.c.setTemporaryOutputState(171);
            this.d = new ManualIterator();
            this.d.setPosition(1);
            this.c.setCurrentIterator(this.d);
        }

        @Override
        public SequenceIterator<ExternalObject<ItemWithMergeKeys>> map(XPathContext object) {
            object = object.getContextItem();
            this.d.setContextItem((Item<?>)object);
            object = new ItemWithMergeKeys((Item)object, this.a.mergeKeyDefinitions, this.a.sourceName, this.c);
            return SingletonIterator.makeIterator(new ObjectValue<Object>(object));
        }
    }

    public static class MergeSource {
        private MergeInstr a;
        public Location location;
        private Operand b = null;
        private Operand c = null;
        private Operand d = null;
        public String sourceName = null;
        public SortKeyDefinitionList mergeKeyDefinitions = null;
        public String baseURI = null;
        public int validation;
        public SchemaType schemaType;
        public boolean streamable;
        public Set<Accumulator> accumulators;
        public Object invertedAction;

        public MergeSource(MergeInstr mergeInstr) {
            this.a = mergeInstr;
        }

        public MergeSource(MergeInstr mergeInstr, Expression expression, Expression expression2, Expression expression3, String string, SortKeyDefinitionList sortKeyDefinitionList, String string2) {
            this.a = mergeInstr;
            if (expression != null) {
                this.initForEachItem(mergeInstr, expression);
            }
            if (expression2 != null) {
                this.initForEachStream(mergeInstr, expression2);
            }
            if (expression3 != null) {
                this.initRowSelect(mergeInstr, expression3);
            }
            this.sourceName = string;
            this.mergeKeyDefinitions = sortKeyDefinitionList;
            this.baseURI = string2;
        }

        public void initForEachItem(MergeInstr mergeInstr, Expression expression) {
            this.b = new Operand(mergeInstr, expression, OperandRole.INSPECT);
        }

        public void initForEachStream(MergeInstr mergeInstr, Expression expression) {
            this.c = new Operand(mergeInstr, expression, OperandRole.INSPECT);
        }

        public void initRowSelect(MergeInstr mergeInstr, Expression expression) {
            this.d = new Operand(mergeInstr, expression, b);
        }

        public void setStreamable(boolean bl2) {
            this.streamable = bl2;
            if (bl2 && this.a.getConfiguration().getBooleanProperty(Feature.STREAMING_FALLBACK)) {
                this.streamable = false;
                Expression expression = this.d.getChildExpression();
                this.d.setChildExpression(SystemFunction.makeCall("snapshot", expression.getRetainedStaticContext(), expression));
            }
        }

        public MergeSource copyMergeSource(MergeInstr mergeInstr, RebindingMap rebindingMap) {
            SortKeyDefinition[] sortKeyDefinitionArray = new SortKeyDefinition[this.mergeKeyDefinitions.size()];
            for (int i2 = 0; i2 < this.mergeKeyDefinitions.size(); ++i2) {
                sortKeyDefinitionArray[i2] = this.mergeKeyDefinitions.getSortKeyDefinition(i2).copy(rebindingMap);
            }
            MergeSource mergeSource = new MergeSource(mergeInstr, MergeSource.a(this.getForEachItem(), rebindingMap), MergeSource.a(this.getForEachSource(), rebindingMap), MergeSource.a(this.getRowSelect(), rebindingMap), this.sourceName, new SortKeyDefinitionList(sortKeyDefinitionArray), this.baseURI);
            new MergeSource(mergeInstr, MergeSource.a(this.getForEachItem(), rebindingMap), MergeSource.a(this.getForEachSource(), rebindingMap), MergeSource.a(this.getRowSelect(), rebindingMap), this.sourceName, new SortKeyDefinitionList(sortKeyDefinitionArray), this.baseURI).validation = this.validation;
            mergeSource.schemaType = this.schemaType;
            mergeSource.streamable = this.streamable;
            mergeSource.location = this.location;
            return mergeSource;
        }

        private static Expression a(Expression expression, RebindingMap rebindingMap) {
            if (expression == null) {
                return null;
            }
            return expression.copy(rebindingMap);
        }

        public Expression getForEachItem() {
            if (this.b == null) {
                return null;
            }
            return this.b.getChildExpression();
        }

        public void setForEachItem(Expression expression) {
            if (expression != null) {
                this.b.setChildExpression(expression);
            }
        }

        public Expression getForEachSource() {
            if (this.c == null) {
                return null;
            }
            return this.c.getChildExpression();
        }

        public void setForEachStream(Expression expression) {
            if (expression != null) {
                this.c.setChildExpression(expression);
            }
        }

        public Expression getRowSelect() {
            return this.d.getChildExpression();
        }

        public void setRowSelect(Expression expression) {
            this.d.setChildExpression(expression);
        }

        public SortKeyDefinitionList getMergeKeyDefinitionSet() {
            return this.mergeKeyDefinitions;
        }

        public void setMergeKeyDefinitionSet(SortKeyDefinitionList sortKeyDefinitionList) {
            this.mergeKeyDefinitions = sortKeyDefinitionList;
        }

        public void prepareForStreaming() {
        }
    }
}

