/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.sort;

import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.sort.AtomicComparer;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.type.StringToDouble;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.NumericValue;

public class NumericComparer
implements AtomicComparer {
    private static NumericComparer a = new NumericComparer();
    protected StringToDouble converter = StringToDouble.getInstance();

    public static NumericComparer getInstance() {
        return a;
    }

    protected NumericComparer() {
    }

    @Override
    public StringCollator getCollator() {
        return null;
    }

    @Override
    public AtomicComparer provideContext(XPathContext xPathContext) {
        return this;
    }

    @Override
    public int compareAtomicValues(AtomicValue atomicValue, AtomicValue atomicValue2) {
        double d2;
        double d3;
        if (atomicValue instanceof NumericValue) {
            d3 = ((NumericValue)atomicValue).getDoubleValue();
        } else if (atomicValue == null) {
            d3 = Double.NaN;
        } else {
            try {
                d3 = this.converter.stringToNumber(atomicValue.getStringValueCS());
            }
            catch (NumberFormatException numberFormatException) {
                d3 = Double.NaN;
            }
        }
        if (atomicValue2 instanceof NumericValue) {
            d2 = ((NumericValue)atomicValue2).getDoubleValue();
        } else if (atomicValue2 == null) {
            d2 = Double.NaN;
        } else {
            try {
                d2 = this.converter.stringToNumber(atomicValue2.getStringValueCS());
            }
            catch (NumberFormatException numberFormatException) {
                d2 = Double.NaN;
            }
        }
        if (Double.isNaN(d3)) {
            if (Double.isNaN(d2)) {
                return 0;
            }
            return -1;
        }
        if (Double.isNaN(d2)) {
            return 1;
        }
        if (d3 < d2) {
            return -1;
        }
        if (d3 > d2) {
            return 1;
        }
        return 0;
    }

    @Override
    public boolean comparesEqual(AtomicValue atomicValue, AtomicValue atomicValue2) {
        return this.compareAtomicValues(atomicValue, atomicValue2) == 0;
    }

    @Override
    public String save() {
        return "NC";
    }
}

