/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.sort;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.FirstItemExpression;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.OperandUsage;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.PathMap;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.expr.parser.TypeChecker;
import net.sf.saxon.expr.sort.AtomicComparer;
import net.sf.saxon.expr.sort.SortKeyDefinition;
import net.sf.saxon.expr.sort.SortKeyDefinitionList;
import net.sf.saxon.expr.sort.SortKeyEvaluator;
import net.sf.saxon.expr.sort.SortedIterator;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.SequenceType;

public class SortExpression
extends Expression
implements SortKeyEvaluator {
    private Operand a;
    private Operand b;
    private transient AtomicComparer[] c = null;

    public SortExpression(Expression expression, SortKeyDefinitionList sortKeyDefinitionList) {
        this.a = new Operand(this, expression, OperandRole.FOCUS_CONTROLLING_SELECT);
        this.b = new Operand(this, sortKeyDefinitionList, OperandRole.ATOMIC_SEQUENCE);
        this.adoptChildExpression(expression);
        this.adoptChildExpression(sortKeyDefinitionList);
    }

    @Override
    public String getExpressionName() {
        return "sort";
    }

    public Operand getBaseOperand() {
        return this.a;
    }

    public Expression getBaseExpression() {
        return this.getSelect();
    }

    public AtomicComparer[] getComparators() {
        return this.c;
    }

    @Override
    public Iterable<Operand> operands() {
        return this.operandList(this.a, this.b);
    }

    @Override
    public PathMap.PathMapNodeSet addToPathMap(PathMap pathMap, PathMap.PathMapNodeSet pathMapNodeSet) {
        PathMap.PathMapNodeSet pathMapNodeSet2 = this.getSelect().addToPathMap(pathMap, pathMapNodeSet);
        for (SortKeyDefinition sortKeyDefinition : this.getSortKeyDefinitionList()) {
            if (sortKeyDefinition.isSetContextForSortKey()) {
                sortKeyDefinition.getSortKey().addToPathMap(pathMap, pathMapNodeSet2);
            } else {
                sortKeyDefinition.getSortKey().addToPathMap(pathMap, pathMapNodeSet);
            }
            Expression expression = sortKeyDefinition.getOrder();
            if (expression != null) {
                expression.addToPathMap(pathMap, pathMapNodeSet);
            }
            if ((expression = sortKeyDefinition.getCaseOrder()) != null) {
                expression.addToPathMap(pathMap, pathMapNodeSet);
            }
            if ((expression = sortKeyDefinition.getDataTypeExpression()) != null) {
                expression.addToPathMap(pathMap, pathMapNodeSet);
            }
            if ((expression = sortKeyDefinition.getLanguage()) != null) {
                expression.addToPathMap(pathMap, pathMapNodeSet);
            }
            if ((expression = sortKeyDefinition.getCollationNameExpression()) == null) continue;
            expression.addToPathMap(pathMap, pathMapNodeSet);
        }
        return pathMapNodeSet2;
    }

    @Override
    public Expression typeCheck(ExpressionVisitor expressionVisitor, ContextItemStaticInfo contextItemStaticInfo) {
        this.a.typeCheck(expressionVisitor, contextItemStaticInfo);
        Object object = this.getSelect();
        if (object != this.getSelect()) {
            this.adoptChildExpression((Expression)object);
            this.setSelect((Expression)object);
        }
        if (!Cardinality.allowsMany(((Expression)object).getCardinality())) {
            return object;
        }
        object = this.getSelect().getItemType();
        boolean bl2 = true;
        for (SortKeyDefinition sortKeyDefinition : this.getSortKeyDefinitionList()) {
            if (sortKeyDefinition.isFixed()) continue;
            bl2 = false;
            break;
        }
        if (bl2) {
            this.c = new AtomicComparer[this.getSortKeyDefinitionList().size()];
        }
        TypeChecker typeChecker = expressionVisitor.getConfiguration().getTypeChecker(false);
        for (int i2 = 0; i2 < this.getSortKeyDefinitionList().size(); ++i2) {
            Object object2;
            SortKeyDefinition sortKeyDefinition = this.getSortKeyDefinition(i2);
            Expression expression = sortKeyDefinition.getSortKey();
            if (sortKeyDefinition.isSetContextForSortKey()) {
                object2 = expressionVisitor.getConfiguration().makeContextItemStaticInfo((ItemType)object, false);
                expression = expression.typeCheck(expressionVisitor, (ContextItemStaticInfo)object2);
            } else {
                expression = expression.typeCheck(expressionVisitor, contextItemStaticInfo);
            }
            if (sortKeyDefinition.isBackwardsCompatible()) {
                expression = FirstItemExpression.makeFirstItemExpression(expression);
            } else {
                object2 = new RoleDiagnostic(4, "xsl:sort/select", 0);
                ((RoleDiagnostic)object2).setErrorCode("XTTE1020");
                expression = typeChecker.staticTypeCheck(expression, SequenceType.OPTIONAL_ATOMIC, (RoleDiagnostic)object2, expressionVisitor);
            }
            sortKeyDefinition.setSortKey(expression, sortKeyDefinition.isSetContextForSortKey());
            sortKeyDefinition.typeCheck(expressionVisitor, contextItemStaticInfo);
            if (sortKeyDefinition.isFixed()) {
                object2 = sortKeyDefinition.makeComparator(expressionVisitor.getStaticContext().makeEarlyEvaluationContext());
                sortKeyDefinition.setFinalComparator((AtomicComparer)object2);
                if (bl2) {
                    this.c[i2] = object2;
                }
            }
            if (!sortKeyDefinition.isSetContextForSortKey() || ExpressionTool.dependsOnFocus(expression)) continue;
            expressionVisitor.getStaticContext().issueWarning("Sort key will have no effect because its value does not depend on the context item", expression.getLocation());
        }
        return this;
    }

    @Override
    public Expression optimize(ExpressionVisitor expressionVisitor, ContextItemStaticInfo contextItemStaticInfo) {
        this.a.optimize(expressionVisitor, contextItemStaticInfo);
        if (this.getSortKeyDefinition(0).isSetContextForSortKey()) {
            ItemType itemType = this.getSelect().getItemType();
            contextItemStaticInfo = expressionVisitor.getConfiguration().makeContextItemStaticInfo(itemType, false);
        }
        for (SortKeyDefinition sortKeyDefinition : this.getSortKeyDefinitionList()) {
            Expression expression = sortKeyDefinition.getSortKey();
            expression = expression.optimize(expressionVisitor, contextItemStaticInfo);
            sortKeyDefinition.setSortKey(expression, true);
        }
        if (Cardinality.allowsMany(this.getSelect().getCardinality())) {
            return this;
        }
        return this.getSelect();
    }

    @Override
    public Expression copy(RebindingMap rebindingMap) {
        int n2 = this.getSortKeyDefinitionList().size();
        SortKeyDefinition[] sortKeyDefinitionArray = new SortKeyDefinition[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            sortKeyDefinitionArray[i2] = this.getSortKeyDefinition(i2).copy(rebindingMap);
        }
        SortExpression sortExpression = new SortExpression(this.getSelect().copy(rebindingMap), new SortKeyDefinitionList(sortKeyDefinitionArray));
        ExpressionTool.copyLocationInfo(this, sortExpression);
        sortExpression.c = this.c;
        return sortExpression;
    }

    public boolean isSortKey(Expression expression) {
        for (Expression expression2 : this.getSortKeyDefinitionList()) {
            if ((expression2 = expression2.getSortKey()) != expression) continue;
            return true;
        }
        return false;
    }

    @Override
    public int computeCardinality() {
        return this.getSelect().getCardinality();
    }

    @Override
    public ItemType getItemType() {
        return this.getSelect().getItemType();
    }

    @Override
    public int computeSpecialProperties() {
        int n2 = 0;
        if (this.getSelect().hasSpecialProperty(65536)) {
            n2 = 65536;
        }
        if (this.getSelect().hasSpecialProperty(0x1000000)) {
            n2 |= 0x1000000;
        }
        if (this.getSelect().hasSpecialProperty(0x800000)) {
            n2 |= 0x800000;
        }
        return n2;
    }

    @Override
    public int getImplementationMethod() {
        return 2;
    }

    @Override
    public SequenceIterator<?> iterate(XPathContext xPathContext) {
        SortedIterator sortedIterator = this.getSelect().iterate(xPathContext);
        if (sortedIterator instanceof EmptyIterator) {
            return sortedIterator;
        }
        AtomicComparer[] atomicComparerArray = this.c;
        if (this.c == null) {
            int n2 = this.getSortKeyDefinitionList().size();
            atomicComparerArray = new AtomicComparer[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                AtomicComparer atomicComparer = this.getSortKeyDefinition(i2).getFinalComparator();
                if (atomicComparer == null) {
                    atomicComparer = this.getSortKeyDefinition(i2).makeComparator(xPathContext);
                }
                atomicComparerArray[i2] = atomicComparer;
            }
        }
        sortedIterator = new SortedIterator(xPathContext, sortedIterator, this, atomicComparerArray, this.getSortKeyDefinition(0).isSetContextForSortKey());
        sortedIterator.setHostLanguage(this.getPackageData().getHostLanguage());
        return sortedIterator;
    }

    @Override
    public AtomicValue evaluateSortKey(int n2, XPathContext xPathContext) {
        return (AtomicValue)this.getSortKeyDefinition(n2).getSortKey().evaluateItem(xPathContext);
    }

    @Override
    public String toShortString() {
        return "sort(" + this.getBaseExpression().toShortString() + ")";
    }

    @Override
    public String getStreamerName() {
        return "SortExpression";
    }

    @Override
    public void export(ExpressionPresenter expressionPresenter) {
        expressionPresenter.startElement("sort", this);
        expressionPresenter.setChildRole("select");
        this.getSelect().export(expressionPresenter);
        ((Expression)this.getSortKeyDefinitionList()).export(expressionPresenter);
        expressionPresenter.endElement();
    }

    public Expression getSelect() {
        return this.a.getChildExpression();
    }

    public void setSelect(Expression expression) {
        this.a.setChildExpression(expression);
    }

    public SortKeyDefinitionList getSortKeyDefinitionList() {
        return (SortKeyDefinitionList)this.b.getChildExpression();
    }

    public SortKeyDefinition getSortKeyDefinition(int n2) {
        return this.getSortKeyDefinitionList().getSortKeyDefinition(n2);
    }

    public void setSortKeyDefinitionList(SortKeyDefinitionList sortKeyDefinitionList) {
        this.b.setChildExpression(sortKeyDefinitionList);
    }

    static {
        new OperandRole(4, OperandUsage.ABSORPTION, SequenceType.OPTIONAL_ATOMIC);
        new OperandRole(6, OperandUsage.ABSORPTION, SequenceType.OPTIONAL_ATOMIC);
    }
}

