/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.sort;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Properties;
import net.sf.saxon.Configuration;
import net.sf.saxon.Version;
import net.sf.saxon.expr.ContextItemExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.OperandUsage;
import net.sf.saxon.expr.PseudoExpression;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.expr.sort.AtomicComparer;
import net.sf.saxon.expr.sort.AtomicSortComparer;
import net.sf.saxon.expr.sort.DescendingComparer;
import net.sf.saxon.expr.sort.EmptyGreatestComparer;
import net.sf.saxon.expr.sort.NumericComparer;
import net.sf.saxon.expr.sort.NumericComparer11;
import net.sf.saxon.expr.sort.TextComparer;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.StringConverter;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Whitespace;

public class SortKeyDefinition
extends PseudoExpression {
    protected Operand sortKey;
    protected Operand order = new Operand(this, new StringLiteral("ascending"), OperandRole.SINGLE_ATOMIC);
    protected Operand dataTypeExpression = null;
    protected Operand caseOrder = new Operand(this, new StringLiteral("#default"), OperandRole.SINGLE_ATOMIC);
    protected Operand language = new Operand(this, new StringLiteral(StringValue.EMPTY_STRING), OperandRole.SINGLE_ATOMIC);
    protected Operand collationName = null;
    protected Operand stable = null;
    protected StringCollator collation;
    protected String baseURI;
    protected boolean emptyLeast = true;
    protected boolean backwardsCompatible = false;
    protected boolean setContextForSortKey = false;
    private transient AtomicComparer a = null;

    @Override
    public boolean isLiftable(boolean bl2) {
        return false;
    }

    public void setSortKey(Expression expression, boolean bl2) {
        OperandRole operandRole = bl2 ? new OperandRole(68, OperandUsage.TRANSMISSION, SequenceType.ANY_SEQUENCE) : OperandRole.ATOMIC_SEQUENCE;
        this.sortKey = new Operand(this, expression, operandRole);
        this.setContextForSortKey = bl2;
    }

    public Expression getSortKey() {
        return this.sortKey.getChildExpression();
    }

    public Operand getSortKeyOperand() {
        return this.sortKey;
    }

    public boolean isSetContextForSortKey() {
        return this.setContextForSortKey;
    }

    public void setOrder(Expression expression) {
        this.order.setChildExpression(expression);
    }

    public Expression getOrder() {
        return this.order.getChildExpression();
    }

    public void setDataTypeExpression(Expression expression) {
        if (expression == null) {
            this.dataTypeExpression = null;
            return;
        }
        if (this.dataTypeExpression == null) {
            this.dataTypeExpression = new Operand(this, expression, OperandRole.SINGLE_ATOMIC);
        }
        this.dataTypeExpression.setChildExpression(expression);
    }

    public Expression getDataTypeExpression() {
        if (this.dataTypeExpression == null) {
            return null;
        }
        return this.dataTypeExpression.getChildExpression();
    }

    public void setCaseOrder(Expression expression) {
        this.caseOrder.setChildExpression(expression);
    }

    public Expression getCaseOrder() {
        return this.caseOrder.getChildExpression();
    }

    public void setLanguage(Expression expression) {
        this.language.setChildExpression(expression);
    }

    public Expression getLanguage() {
        return this.language.getChildExpression();
    }

    public void setCollationNameExpression(Expression expression) {
        if (expression == null) {
            this.collationName = null;
            return;
        }
        if (this.collationName == null) {
            this.collationName = new Operand(this, expression, OperandRole.SINGLE_ATOMIC);
        }
        this.collationName.setChildExpression(expression);
    }

    public Expression getCollationNameExpression() {
        if (this.collationName == null) {
            return null;
        }
        return this.collationName.getChildExpression();
    }

    public void setCollation(StringCollator stringCollator) {
        this.collation = stringCollator;
    }

    public StringCollator getCollation() {
        return this.collation;
    }

    public void setBaseURI(String string) {
        this.baseURI = string;
    }

    public String getBaseURI() {
        return this.baseURI;
    }

    public void setStable(Expression expression) {
        if (expression == null) {
            expression = new StringLiteral("yes");
        }
        if (this.stable == null) {
            this.stable = new Operand(this, expression, OperandRole.SINGLE_ATOMIC);
        }
        this.stable.setChildExpression(expression);
    }

    public Expression getStable() {
        return this.stable.getChildExpression();
    }

    public void setBackwardsCompatible(boolean bl2) {
        this.backwardsCompatible = bl2;
    }

    public boolean isBackwardsCompatible() {
        return this.backwardsCompatible;
    }

    public void setEmptyLeast(boolean bl2) {
        this.emptyLeast = bl2;
    }

    public boolean getEmptyLeast() {
        return this.emptyLeast;
    }

    public boolean isFixed() {
        return !(!(this.order.getChildExpression() instanceof Literal) || this.dataTypeExpression != null && !(this.dataTypeExpression.getChildExpression() instanceof Literal) || !(this.caseOrder.getChildExpression() instanceof Literal) || !(this.language.getChildExpression() instanceof Literal) || this.stable != null && !(this.stable.getChildExpression() instanceof Literal) || this.collationName != null && !(this.collationName.getChildExpression() instanceof Literal));
    }

    @Override
    public SortKeyDefinition copy(RebindingMap rebindingMap) {
        SortKeyDefinition sortKeyDefinition = new SortKeyDefinition();
        sortKeyDefinition.setSortKey(SortKeyDefinition.a(this.sortKey.getChildExpression(), rebindingMap), true);
        sortKeyDefinition.setOrder(SortKeyDefinition.a(this.order.getChildExpression(), rebindingMap));
        sortKeyDefinition.setDataTypeExpression(this.dataTypeExpression == null ? null : SortKeyDefinition.a(this.dataTypeExpression.getChildExpression(), rebindingMap));
        sortKeyDefinition.setCaseOrder(SortKeyDefinition.a(this.caseOrder.getChildExpression(), rebindingMap));
        sortKeyDefinition.setLanguage(SortKeyDefinition.a(this.language.getChildExpression(), rebindingMap));
        sortKeyDefinition.setStable(SortKeyDefinition.a(this.stable == null ? null : this.stable.getChildExpression(), rebindingMap));
        sortKeyDefinition.setCollationNameExpression(this.collationName == null ? null : SortKeyDefinition.a(this.collationName.getChildExpression(), rebindingMap));
        sortKeyDefinition.collation = this.collation;
        sortKeyDefinition.emptyLeast = this.emptyLeast;
        sortKeyDefinition.baseURI = this.baseURI;
        sortKeyDefinition.backwardsCompatible = this.backwardsCompatible;
        sortKeyDefinition.a = this.a;
        sortKeyDefinition.setContextForSortKey = this.setContextForSortKey;
        return sortKeyDefinition;
    }

    private static Expression a(Expression expression, RebindingMap rebindingMap) {
        if (expression == null) {
            return null;
        }
        return expression.copy(rebindingMap);
    }

    @Override
    public SortKeyDefinition typeCheck(ExpressionVisitor expressionVisitor, ContextItemStaticInfo contextItemStaticInfo) {
        ValidationFailure validationFailure;
        for (Operand object2 : this.checkedOperands()) {
            if (!object2.hasSameFocus()) continue;
            object2.typeCheck(expressionVisitor, contextItemStaticInfo);
        }
        Expression expression = this.getLanguage();
        if (expression instanceof StringLiteral && !((StringLiteral)expression).getStringValue().isEmpty() && (validationFailure = ((StringConverter)StringConverter.StringToLanguage.INSTANCE).validate(((StringLiteral)expression).getStringValue())) != null) {
            throw new XPathException("The lang attribute of xsl:sort must be a valid language code", "XTDE0030");
        }
        return this;
    }

    @Override
    public Iterable<Operand> operands() {
        ArrayList<Operand> arrayList = new ArrayList<Operand>(8);
        arrayList.add(this.sortKey);
        arrayList.add(this.order);
        if (this.dataTypeExpression != null) {
            arrayList.add(this.dataTypeExpression);
        }
        arrayList.add(this.caseOrder);
        arrayList.add(this.language);
        if (this.stable != null) {
            arrayList.add(this.stable);
        }
        if (this.collationName != null) {
            arrayList.add(this.collationName);
        }
        return arrayList;
    }

    @Override
    public int getImplementationMethod() {
        return 0;
    }

    public AtomicComparer makeComparator(XPathContext xPathContext) {
        Object object;
        Object object2;
        Object object3;
        String string = this.order.getChildExpression().evaluateAsString(xPathContext).toString();
        Object object4 = xPathContext.getConfiguration();
        if (this.collation != null) {
            object4 = this.collation;
        } else if (this.collationName != null) {
            object3 = this.collationName.getChildExpression().evaluateAsString(xPathContext).toString();
            try {
                object2 = new URI((String)object3);
                if (!((URI)object2).isAbsolute()) {
                    if (this.baseURI == null) {
                        throw new XPathException("Collation URI is relative, and base URI is unknown");
                    }
                    object = new URI(this.baseURI);
                    object2 = ((URI)object).resolve((URI)object2);
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new XPathException("Collation name " + (String)object3 + " is not a valid URI: " + uRISyntaxException);
            }
            object4 = xPathContext.getConfiguration().getCollation(((URI)object2).toString());
            if (object4 == null) {
                throw new XPathException("Unknown collation " + object2, "XTDE1035");
            }
        } else {
            object3 = this.caseOrder.getChildExpression().evaluateAsString(xPathContext).toString();
            object2 = this.language.getChildExpression().evaluateAsString(xPathContext).toString();
            object = "http://saxon.sf.net/collation";
            boolean bl2 = true;
            Properties properties = new Properties();
            if (!((String)object2).isEmpty()) {
                ValidationFailure validationFailure = ((StringConverter)StringConverter.StringToLanguage.INSTANCE).validate((CharSequence)object2);
                if (validationFailure != null) {
                    throw new XPathException("The lang attribute of xsl:sort must be a valid language code", "XTDE0030");
                }
                properties.setProperty("lang", (String)object2);
                object = (String)object + "?lang=" + (String)object2;
                bl2 = false;
            }
            if (!((String)object3).equals("#default")) {
                properties.setProperty("case-order", (String)object3);
                object = (String)object + (bl2 ? "?" : ";") + "case-order=" + (String)object3;
            }
            object4 = Version.platform.makeCollation((Configuration)object4, properties, (String)object);
        }
        if (this.dataTypeExpression == null) {
            object4 = AtomicSortComparer.makeSortComparer((StringCollator)object4, this.sortKey.getChildExpression().getItemType().getAtomizedItemType().getPrimitiveType(), xPathContext);
            if (!this.emptyLeast) {
                object4 = new EmptyGreatestComparer((AtomicComparer)object4);
            }
        } else {
            switch (object3 = this.dataTypeExpression.getChildExpression().evaluateAsString(xPathContext).toString()) {
                case "text": {
                    object4 = AtomicSortComparer.makeSortComparer((StringCollator)object4, 513, xPathContext);
                    object4 = new TextComparer((AtomicComparer)object4);
                    break;
                }
                case "number": {
                    object4 = xPathContext.getConfiguration().getXsdVersion() == 10 ? NumericComparer.getInstance() : NumericComparer11.getInstance();
                    break;
                }
                default: {
                    XPathException xPathException = new XPathException("data-type on xsl:sort must be 'text' or 'number'");
                    xPathException.setErrorCode("XTDE0030");
                    throw xPathException;
                }
            }
        }
        if (!(this.stable == null || ((String)(object2 = Whitespace.trim(((AtomicValue)(object3 = (StringValue)this.stable.getChildExpression().evaluateItem(xPathContext))).getStringValue()))).equals("yes") || ((String)object2).equals("no") || ((String)object2).equals("true") || ((String)object2).equals("false") || ((String)object2).equals("1") || ((String)object2).equals("0"))) {
            XPathException xPathException = new XPathException("Value of 'stable' on xsl:sort must be yes|no|true|false|1|0");
            xPathException.setErrorCode("XTDE0030");
            throw xPathException;
        }
        switch (string) {
            case "ascending": {
                return object4;
            }
            case "descending": {
                return new DescendingComparer((AtomicComparer)object4);
            }
        }
        XPathException xPathException = new XPathException("order must be 'ascending' or 'descending'");
        xPathException.setErrorCode("XTDE0030");
        throw xPathException;
    }

    public void setFinalComparator(AtomicComparer atomicComparer) {
        this.a = atomicComparer;
    }

    public AtomicComparer getFinalComparator() {
        return this.a;
    }

    public SortKeyDefinition fix(XPathContext xPathContext) {
        SortKeyDefinition sortKeyDefinition = this.copy(new RebindingMap());
        sortKeyDefinition.setLanguage(new StringLiteral(this.getLanguage().evaluateAsString(xPathContext)));
        sortKeyDefinition.setOrder(new StringLiteral(this.getOrder().evaluateAsString(xPathContext)));
        if (this.collationName != null) {
            sortKeyDefinition.setCollationNameExpression(new StringLiteral(this.getCollationNameExpression().evaluateAsString(xPathContext)));
        }
        sortKeyDefinition.setCaseOrder(new StringLiteral(this.getCaseOrder().evaluateAsString(xPathContext)));
        if (this.dataTypeExpression != null) {
            sortKeyDefinition.setDataTypeExpression(new StringLiteral(this.getDataTypeExpression().evaluateAsString(xPathContext)));
        }
        sortKeyDefinition.setSortKey(new ContextItemExpression(), true);
        return sortKeyDefinition;
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof SortKeyDefinition) {
            object = (SortKeyDefinition)object;
            return Objects.equals(this.getSortKey(), ((SortKeyDefinition)object).getSortKey()) && Objects.equals(this.getOrder(), ((SortKeyDefinition)object).getOrder()) && Objects.equals(this.getLanguage(), ((SortKeyDefinition)object).getLanguage()) && Objects.equals(this.getDataTypeExpression(), ((SortKeyDefinition)object).getDataTypeExpression()) && Objects.equals(this.getStable(), ((SortKeyDefinition)object).getStable()) && Objects.equals(this.getCollationNameExpression(), ((SortKeyDefinition)object).getCollationNameExpression());
        }
        return false;
    }

    @Override
    public int computeHashCode() {
        int n2 = 0 ^ this.getOrder().hashCode();
        n2 ^= this.getCaseOrder().hashCode();
        n2 ^= this.getLanguage().hashCode();
        if (this.getDataTypeExpression() != null) {
            n2 ^= this.getDataTypeExpression().hashCode();
        }
        if (this.getStable() != null) {
            n2 ^= this.getStable().hashCode();
        }
        if (this.getCollationNameExpression() != null) {
            n2 ^= this.getCollationNameExpression().hashCode();
        }
        return n2;
    }

    @Override
    public void export(ExpressionPresenter expressionPresenter) {
        expressionPresenter.startElement("sortKey", this);
        if (this.a != null) {
            expressionPresenter.emitAttribute("comp", this.a.save());
        }
        expressionPresenter.setChildRole("select");
        this.sortKey.getChildExpression().export(expressionPresenter);
        expressionPresenter.setChildRole("order");
        this.order.getChildExpression().export(expressionPresenter);
        if (this.dataTypeExpression != null) {
            expressionPresenter.setChildRole("dataType");
            this.dataTypeExpression.getChildExpression().export(expressionPresenter);
        }
        expressionPresenter.setChildRole("lang");
        this.language.getChildExpression().export(expressionPresenter);
        expressionPresenter.setChildRole("caseOrder");
        this.caseOrder.getChildExpression().export(expressionPresenter);
        if (this.stable != null) {
            expressionPresenter.setChildRole("stable");
            this.stable.getChildExpression().export(expressionPresenter);
        }
        if (this.collationName != null) {
            expressionPresenter.setChildRole("collation");
            this.collationName.getChildExpression().export(expressionPresenter);
        }
        expressionPresenter.endElement();
    }
}

