/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.sort;

import java.util.Arrays;
import net.sf.saxon.expr.LastPositionFinder;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.sort.AtomicComparer;
import net.sf.saxon.expr.sort.GroupIterator;
import net.sf.saxon.expr.sort.GroupToBeSorted;
import net.sf.saxon.expr.sort.SortKeyEvaluator;
import net.sf.saxon.expr.sort.SortedIterator;
import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.om.FocusIterator;
import net.sf.saxon.om.FocusTrackingIterator;
import net.sf.saxon.om.MemoSequence;
import net.sf.saxon.om.SequenceIterator;

public class SortedGroupIterator
extends SortedIterator
implements GroupIterator {
    public SortedGroupIterator(XPathContext xPathContext, GroupIterator groupIterator, SortKeyEvaluator sortKeyEvaluator, AtomicComparer[] atomicComparerArray) {
        super(xPathContext, groupIterator, sortKeyEvaluator, atomicComparerArray, true);
        this.setHostLanguage(50);
    }

    @Override
    protected void buildArray() {
        Object obj;
        int n2 = (this.base.getProperties() & 2) != 0 ? ((LastPositionFinder)((Object)this.base)).getLength() : 100;
        this.values = new GroupToBeSorted[n2];
        this.count = 0;
        XPathContextMajor xPathContextMajor = this.context.newContext();
        xPathContextMajor.setCurrentIterator((FocusIterator)this.base);
        GroupIterator groupIterator = (GroupIterator)((FocusTrackingIterator)this.base).getUnderlyingIterator();
        xPathContextMajor.setCurrentGroupIterator(groupIterator);
        while ((obj = this.base.next()) != null) {
            if (this.count == n2) {
                this.values = Arrays.copyOf(this.values, n2 <<= 1);
            }
            GroupToBeSorted groupToBeSorted = new GroupToBeSorted(this.comparators.length);
            this.values[this.count] = groupToBeSorted;
            groupToBeSorted.value = obj;
            for (int i2 = 0; i2 < this.comparators.length; ++i2) {
                groupToBeSorted.sortKeyValues[i2] = this.sortKeyEvaluator.evaluateSortKey(i2, xPathContextMajor);
            }
            ++this.count;
            groupToBeSorted.originalPosition = groupToBeSorted.originalPosition;
            groupToBeSorted.currentGroupingKey = groupIterator.getCurrentGroupingKey();
            groupToBeSorted.currentGroup = new MemoSequence(groupIterator.iterateCurrentGroup());
        }
    }

    @Override
    public AtomicSequence getCurrentGroupingKey() {
        return ((GroupToBeSorted)this.values[this.position - 1]).currentGroupingKey;
    }

    @Override
    public SequenceIterator<?> iterateCurrentGroup() {
        return ((GroupToBeSorted)this.values[this.position - 1]).currentGroup.iterate();
    }
}

