/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.sort;

import net.sf.saxon.expr.ErrorIterator;
import net.sf.saxon.expr.LastPositionFinder;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.sort.AtomicComparer;
import net.sf.saxon.expr.sort.GenericSorter;
import net.sf.saxon.expr.sort.ItemToBeSorted;
import net.sf.saxon.expr.sort.ObjectToBeSorted;
import net.sf.saxon.expr.sort.SortKeyEvaluator;
import net.sf.saxon.expr.sort.Sortable;
import net.sf.saxon.om.FocusTrackingIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.NoDynamicContextException;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.LookaheadIterator;

public class SortedIterator
implements LastPositionFinder,
Sortable,
SequenceIterator<Item<?>>,
LookaheadIterator<Item<?>> {
    protected SequenceIterator<?> base;
    protected SortKeyEvaluator sortKeyEvaluator;
    protected AtomicComparer[] comparators;
    protected ObjectToBeSorted[] values;
    protected int count = -1;
    protected int position = 0;
    protected XPathContext context;
    private int a;

    protected SortedIterator() {
    }

    public SortedIterator(XPathContext xPathContext, SequenceIterator<?> sequenceIterator, SortKeyEvaluator sortKeyEvaluator, AtomicComparer[] atomicComparerArray, boolean bl2) {
        if (bl2) {
            this.context = xPathContext.newMinorContext();
            this.base = this.context.trackFocus(sequenceIterator);
            this.context.setTemporaryOutputState(195);
        } else {
            this.base = sequenceIterator;
            this.context = xPathContext;
        }
        this.sortKeyEvaluator = sortKeyEvaluator;
        this.comparators = new AtomicComparer[atomicComparerArray.length];
        for (int i2 = 0; i2 < atomicComparerArray.length; ++i2) {
            this.comparators[i2] = atomicComparerArray[i2].provideContext(xPathContext);
        }
    }

    public void setHostLanguage(int n2) {
        this.a = n2;
    }

    @Override
    public boolean hasNext() {
        if (this.position < 0) {
            return false;
        }
        if (this.count < 0) {
            if (this.base instanceof LookaheadIterator) {
                return ((LookaheadIterator)this.base).hasNext();
            }
            try {
                this.a();
                return this.count > 0;
            }
            catch (XPathException xPathException) {
                this.count = -1;
                this.base = new FocusTrackingIterator(new ErrorIterator(xPathException));
                return true;
            }
        }
        return this.position < this.count;
    }

    @Override
    public Item next() {
        if (this.position < 0) {
            return null;
        }
        if (this.count < 0) {
            this.a();
        }
        if (this.position < this.count) {
            return (Item)this.values[this.position++].value;
        }
        this.position = -1;
        return null;
    }

    @Override
    public int getLength() {
        if (this.count < 0) {
            this.a();
        }
        return this.count;
    }

    @Override
    public void close() {
    }

    @Override
    public int getProperties() {
        return 2;
    }

    protected void buildArray() {
        Object object;
        Object obj;
        int n2 = (this.base.getProperties() & 2) != 0 ? ((LastPositionFinder)((Object)this.base)).getLength() : 100;
        this.values = new ItemToBeSorted[n2];
        this.count = 0;
        while ((obj = this.base.next()) != null) {
            if (this.count == n2) {
                object = new ObjectToBeSorted[n2 <<= 1];
                System.arraycopy(this.values, 0, object, 0, this.count);
                this.values = object;
            }
            this.values[this.count] = object = new ItemToBeSorted(this.comparators.length);
            object.value = obj;
            for (int i2 = 0; i2 < this.comparators.length; ++i2) {
                object.sortKeyValues[i2] = this.sortKeyEvaluator.evaluateSortKey(i2, this.context);
            }
            ++this.count;
            object.originalPosition = object.originalPosition;
        }
        if (n2 << 1 < this.count || n2 - this.count > 2000) {
            object = new ObjectToBeSorted[this.count];
            System.arraycopy(this.values, 0, object, 0, this.count);
            this.values = object;
        }
    }

    private void a() {
        this.buildArray();
        if (this.count < 2) {
            return;
        }
        try {
            GenericSorter.quickSort(0, this.count, this);
            return;
        }
        catch (ClassCastException classCastException) {
            XPathException xPathException = new XPathException("Non-comparable types found while sorting: " + classCastException.getMessage());
            if (this.a == 50) {
                xPathException.setErrorCode("XTDE1030");
            } else {
                xPathException.setErrorCode("XPTY0004");
            }
            throw xPathException;
        }
    }

    @Override
    public int compare(int n2, int n3) {
        try {
            for (int i2 = 0; i2 < this.comparators.length; ++i2) {
                int n4 = this.comparators[i2].compareAtomicValues(this.values[n2].sortKeyValues[i2], this.values[n3].sortKeyValues[i2]);
                if (n4 == 0) continue;
                return n4;
            }
        }
        catch (NoDynamicContextException noDynamicContextException) {
            throw new AssertionError((Object)("Sorting without dynamic context: " + noDynamicContextException.getMessage()));
        }
        return this.values[n2].originalPosition - this.values[n3].originalPosition;
    }

    @Override
    public void swap(int n2, int n3) {
        ObjectToBeSorted objectToBeSorted = this.values[n2];
        this.values[n2] = this.values[n3];
        this.values[n3] = objectToBeSorted;
    }
}

