/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.sort;

import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.sort.AtomicComparer;
import net.sf.saxon.expr.sort.ComparisonException;
import net.sf.saxon.lib.ConversionRules;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.value.Whitespace;

public class UntypedNumericComparer
implements AtomicComparer {
    private ConversionRules a = ConversionRules.DEFAULT;
    private static double[][] b = new double[][]{{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {1.0, 1.0, 10.0, 100.0, 1000.0, 10000.0, 100000.0, 1000000.0, 1.0E7, 1.0E8, 1.0E9, 1.0E10}, {1.0, 2.0, 20.0, 200.0, 2000.0, 20000.0, 200000.0, 2000000.0, 2.0E7, 2.0E8, 2.0E9, 2.0E10}, {1.0, 3.0, 30.0, 300.0, 3000.0, 30000.0, 300000.0, 3000000.0, 3.0E7, 3.0E8, 3.0E9, 3.0E10}, {1.0, 4.0, 40.0, 400.0, 4000.0, 40000.0, 400000.0, 4000000.0, 4.0E7, 4.0E8, 4.0E9, 4.0E10}, {1.0, 5.0, 50.0, 500.0, 5000.0, 50000.0, 500000.0, 5000000.0, 5.0E7, 5.0E8, 5.0E9, 5.0E10}, {1.0, 6.0, 60.0, 600.0, 6000.0, 60000.0, 600000.0, 6000000.0, 6.0E7, 6.0E8, 6.0E9, 6.0E10}, {1.0, 7.0, 70.0, 700.0, 7000.0, 70000.0, 700000.0, 7000000.0, 7.0E7, 7.0E8, 7.0E9, 7.0E10}, {1.0, 8.0, 80.0, 800.0, 8000.0, 80000.0, 800000.0, 8000000.0, 8.0E7, 8.0E8, 8.0E9, 8.0E10}, {1.0, 9.0, 90.0, 900.0, 9000.0, 90000.0, 900000.0, 9000000.0, 9.0E7, 9.0E8, 9.0E9, 9.0E10}, {1.0, 10.0, 100.0, 1000.0, 10000.0, 100000.0, 1000000.0, 1.0E7, 1.0E8, 1.0E9, 1.0E10, 1.0E11}};

    public static boolean quickCompare(UntypedAtomicValue untypedAtomicValue, NumericValue numericValue, int n2, ConversionRules conversionRules) {
        int n3 = UntypedNumericComparer.quickComparison(untypedAtomicValue, numericValue, conversionRules);
        switch (n2) {
            case 50: {
                return n3 == 0;
            }
            case 55: {
                return n3 <= 0;
            }
            case 53: {
                return n3 < 0;
            }
            case 54: {
                return n3 >= 0;
            }
            case 52: {
                return n3 > 0;
            }
        }
        return n3 != 0;
    }

    public static int quickComparison(UntypedAtomicValue untypedAtomicValue, NumericValue numericValue, ConversionRules conversionRules) {
        double d2 = numericValue.getDoubleValue();
        Object object = untypedAtomicValue.getConversionResultIfKnown(517);
        object = object == null ? null : (DoubleValue)object.asAtomic();
        if (object != null) {
            double d3 = ((NumericValue)object).getDoubleValue();
            return Double.compare(d3, d2);
        }
        object = Whitespace.trimWhitespace(untypedAtomicValue.getStringValueCS());
        boolean bl2 = true;
        int n2 = 0;
        int n3 = -1;
        int n4 = 0;
        int n5 = 63;
        for (int i2 = 0; i2 < object.length(); ++i2) {
            char c2 = object.charAt(i2);
            if (c2 >= '0' && c2 <= '9') {
                if (n3 < 0) {
                    n3 = c2 - 48;
                }
                if (n4 != 0) continue;
                ++n2;
                continue;
            }
            if (c2 == '-') {
                if (n5 != 63 || n2 > 0 || n4 > 0) {
                    bl2 = false;
                    break;
                }
                n5 = c2;
                continue;
            }
            if (c2 == '.') {
                if (n4 > 0) {
                    bl2 = false;
                    break;
                }
                n4 = 1;
                continue;
            }
            bl2 = false;
            break;
        }
        if (n3 < 0) {
            bl2 = false;
        }
        if (bl2 && n2 > 0 && n2 <= 10) {
            double d4 = b[n3][n2];
            double d5 = b[n3 + 1][n2];
            if (n5 == 45) {
                double d6 = d4;
                d4 = -d5;
                d5 = -d6;
            }
            if (d5 < d2) {
                return -1;
            }
            if (d4 > d2) {
                return 1;
            }
        }
        if (bl2 && n4 == 0 && n2 <= 15 && numericValue instanceof Int64Value) {
            long l2 = Long.parseLong(object.toString());
            untypedAtomicValue.setConversionResult(533, Int64Value.makeIntegerValue(l2));
            return Long.compare(l2, numericValue.longValue());
        }
        AtomicValue atomicValue = untypedAtomicValue.obtainConversionResult(517, BuiltInAtomicType.DOUBLE.getStringConverter(conversionRules)).asAtomic();
        return Double.compare(((NumericValue)((DoubleValue)atomicValue)).getDoubleValue(), d2);
    }

    @Override
    public int compareAtomicValues(AtomicValue atomicValue, AtomicValue atomicValue2) {
        try {
            return UntypedNumericComparer.quickComparison((UntypedAtomicValue)atomicValue, (NumericValue)atomicValue2, this.a);
        }
        catch (XPathException xPathException) {
            throw new ComparisonException(xPathException);
        }
    }

    @Override
    public StringCollator getCollator() {
        return null;
    }

    @Override
    public AtomicComparer provideContext(XPathContext xPathContext) {
        this.a = xPathContext.getConfiguration().getConversionRules();
        return this;
    }

    @Override
    public boolean comparesEqual(AtomicValue atomicValue, AtomicValue atomicValue2) {
        return this.compareAtomicValues(atomicValue, atomicValue2) == 0;
    }

    @Override
    public String save() {
        return "QUNC";
    }
}

